/**
 * 文字资料
 */

import { ARTICLEPOSITION } from "../../../config/enum";
import { ERRORENUM } from "../../../config/errorEnum";
import { addManyData } from "../../../data/add";
import { TABLEENUM } from "../../../data/models/model";
import { find, findOnce } from "../../../data/select";
import { updateOneData } from "../../../data/update";
import { generateSystemId, successResult } from "../../../tools/system";
import { BizError } from "../../../util/bizError";
import { extractData } from "../../../util/piecemeal";
import { changeEnumValue, eccEnumValue } from "../../../util/verificationEnum";


/**
 * 列表
 * @param param0 
 * @returns 
 */
export async function list({userId, type}) {
    let dbList = await find(TABLEENUM.文字资料, {type});

    let dataList = [];
    if ( !dbList || !dbList.length) {
        let addList = [];
        for (let i = 1; i <= 8; i++) {
            let id = generateSystemId(TABLEENUM.文字资料, userId);
            addList.push({id, rank:i, title:'', articleUrl:'', type, imgUrl:"", position:0, articleTitle:'', updateTime:0});
            dataList.push({id, rank:i, title:'', articleUrl:'', type, imgUrl:"", position:0, articleTitle:'', updateTime:0});
        }
        await addManyData(TABLEENUM.文字资料, addList);
    }
    dataList.sort((a:any, b:any) => {return a.rank - b.rank });
    for (let i =0; i < dbList.length; i++) {
        let info= dbList[i];
        let item:any = extractData(info, ["id", "title", "rank", "position", "articleTitle" ]);
        if (!item.position) item.position = "未选择";
        else item.position = changeEnumValue(ARTICLEPOSITION, item.position);
        
        let articleInfo = await findOnce(TABLEENUM.文章管理, {id:item.articleTitle}, ["id", "title"]);
        item.articleTitle = articleInfo && articleInfo.id ? articleInfo.title : '';

        dataList.push(item);
    }

    return {dataList};
}


/**
 * 预览
 */
export async function preview({userId, type}) {
    let dbList = await find(TABLEENUM.文字资料, {type});

    let dataList = [];
    if (!dbList || !dbList.length) {
        let addList = [];
        for (let i = 1; i <= 8; i++) {
            let id = generateSystemId(TABLEENUM.文字资料, userId);
            addList.push({id, rank:i, title:'', articleUrl:'', type, imgUrl:"", position:0, articleTitle:'', updateTime:0});
            dataList.push({id, rank:i, title:'', articleUrl:'', type, imgUrl:"", position:0, articleTitle:'',  updateTime:0});
        }
        await addManyData(TABLEENUM.文字资料, addList);
    }
    dataList.sort((a:any, b:any) => {return a.rank - b.rank });
    dbList.forEach(info => {
        let item = extractData(info, ["id", "title", "rank", "imgUrl", "updateTime"]);
        dataList.push(item);
    });

    return {dataList};
}


/**
 * 修改
 * @param userId 
 * @param id 
 * @param updateParam 
 * @returns 
 */
export async function update({userId, id, title, imgUrl, position, articleTitle, articleUrl, updateTime}) {
    eccEnumValue('修改文字资料', '位置', ARTICLEPOSITION, position );
    let oldInfo = await findOnce(TABLEENUM.文字资料, {id});
    if (!oldInfo.id) throw new BizError(ERRORENUM.目标数据不存在);
    
    await updateOneData(TABLEENUM.文字资料, {id}, {title, imgUrl, position, articleTitle, articleUrl, updateTime});
    return successResult();
}


export async function del({userId, id}) {
    let dataInfo = await findOnce(TABLEENUM.文字资料, {id});
    if (!dataInfo || !dataInfo.id) throw new BizError(ERRORENUM.目标数据不存在);

    await updateOneData(TABLEENUM.文字资料, {id}, {title:'', imgUrl:'', position:0, articleTitle:'',  articleUrl:'', updateTime:0});
    return successResult();
}


/**
 * 回显
 * @param id 
 */
export async function info({id}) {
    let oldInfo = await findOnce(TABLEENUM.文字资料, {id});
    if (!oldInfo || !oldInfo.id) throw new BizError(ERRORENUM.目标数据不存在);
    let dataInfo = extractData(oldInfo, ["id", "title", "imgUrl", "position", "articleTitle", "articleUrl", "updateTime"]);
    return { dataInfo };
}