import * as orderBiz from "../../biz/member/order";
import * as costVerificationBiz from "../../biz/member/finance/costVerification";
import * as invoiceBiz from "../../biz/member/finance/invoice";

export const FirstName = '会费相关';
export const FirstRouter = '/manage/cost';
export const Config = {
    "审批管理":[
        // {
        //     apiName:"待支付列表",
        //     subUrl:'/order/fist/list', 
        //     param:[
        //         {key:"unitName", type:"String", desc:"单位名称", isNull:true},
        //         {key:"joinTime", type:"Number", desc:"入会时间 时间戳", isNull:true},
        //         {key:"memberType", type:"Number", desc:"会员类别 枚举参考公用组件", isNull:true},
        //         {key:"orderState", type:"Number", desc:"支付状态", isNull:true},
        //         {key:"pageNumber", type:"Number", desc:"分页-当前页面"}
        //     ],
        //     bindBiz:orderBiz.firstOrderList
        // },
        // {
        //     apiName:"确认待支付",
        //     subUrl:'/order/fist/pass', 
        //     param:[
        //         {key:"id", type:"String", desc:"订单标识"},
        //     ],
        //     bindBiz:orderBiz.checkOrder
        // },
        // {
        //     apiName:"待支付线下支付",
        //     subUrl:'/order/fist/offlinepayment',
        //     param:[
        //         {key:"orderId", type:"String", desc:"订单标识"},
        //         {key:"paymentNum", type:"String", desc:"转账单号"},
        //         {key:"offlinePaymentUrl", type:"String", desc:"转账截图"},
        //     ],
        //     bindBiz:orderBiz.offlinePayment
        // }
    ],
    "发票管理":[
        {
            apiName:"财务核对",
            subUrl:'/order/invoice/check/list', 
            param:[
                {key:"name", type:"String", desc:"名称", isNull:true},
                {key:"memberType", type:"[Number]", desc:"会员类别", isNull:true},
                {key:"documentId", type:"String", desc:"身份证", isNull:true},
                {key:"phone", type:"String", desc:"手机号", isNull:true},
                {key:"mail", type:"String", desc:"邮箱", isNull:true},
                {key:"joinStartTime", type:"Number", desc:"入会开始时间", isNull:true},
                {key:"joinEndTime", type:"Number", desc:"入会结束时间", isNull:true},
                {key:"memberLevel", type:"[Number]", desc:"个人级别职务", isNull:true},
                // {key:"paymentType", type:"Number", desc:"支付方式", isNull:true},2024年12月21日去掉
                {key:"examineState", type:"Number", desc:"审批状态 0是全部，1是待审批2是已审批", isNull:true},
                {key:"payType", type:"Number", desc:"支付方式 1是微信支付 2是线下支付 3全部"},
                {key:"paymentNum", type:"String", desc:"支付单号", isNull:true},
                {key:"pageNumber", type:"Number", desc:"分页-当前页面"},
                {key:"pageSize", type:"Number", desc:"分页-当前页大小"},
                {key:"session", type:"Number", desc:"届次", isNull:true},
            ],
            bindBiz:costVerificationBiz.paidList
        },
        {
            apiName:"待开发票",
            subUrl:'/order/invoice/list', 
            param:[
                {key:"name", type:"String", desc:"名称", isNull:true},
                {key:"memberType", type:"[Number]", desc:"会员类别", isNull:true},
                {key:"documentId", type:"String", desc:"身份证", isNull:true},
                {key:"phone", type:"String", desc:"手机号", isNull:true},
                {key:"mail", type:"String", desc:"邮箱", isNull:true},
                {key:"joinStartTime", type:"Number", desc:"入会开始时间", isNull:true},
                {key:"joinEndTime", type:"Number", desc:"入会结束时间", isNull:true},
                {key:"memberLevel", type:"[Number]", desc:"个人级别职务", isNull:true},
                {key:"paymentType", type:"Number", desc:"支付方式", isNull:true},
                {key:"payState", type:"Number", desc:"支付状态 1是已支付 2是未支付 3是全部"},
                {key:"invoiceState", type:"Number", desc:"发票状态 0是全部 1是已申请 2是未申请",  isNull:true},
                {key:"weChartPR", type:"String", desc:"微信支付单号", isNull:true},
                {key:"invoiceApplyMs", type:"Number", desc:"发票申请时间", isNull:true},
                {key:"pageNumber", type:"Number", desc:"分页-当前页面"},
                {key:"pageSize", type:"Number", desc:"分页-一页大小"}
            ],
            bindBiz:invoiceBiz.billStateList
        },
        {
            apiName:"财务核对-收款确认",
            subUrl:'/order/invoice/examine/pass', 
            param:[
                {key:"id", type:"String", desc:"订单id"}
            ],
            bindBiz:costVerificationBiz.confirmReceiptPass
        },
        {
            apiName:"财务核对-批量收款确认",
            subUrl:'/order/invoice/examine/manypass', 
            param:[
                {key:"idList", type:"[String]", desc:"订单id"}
            ],
            bindBiz:costVerificationBiz.confirmReceiptManyPass
        },
        {
            apiName:"财务核对-退回",
            subUrl:'/order/invoice/examine/out', 
            param:[
                {key:"id", type:"String", desc:"订单id"},
                {key:"isReceive", type:"Number", desc:"是否受到款项"},
                {key:"returnsReasons", type:"String", desc:"退回理由"}
            ],
            bindBiz:costVerificationBiz.confirmReceiptOut
        },
        {
            apiName:"财务核对-数据导出",
            subUrl:'/order/invoice/examine/outputconfirmreceipt', 
            param:[
                {key:"exportColumns", type:"[]", desc:"导出数据列"},
                {key:"examineState", type:"Number", desc:"审批状态 0是全部，1是待审批2是已审批", isNull:true},
                {key:"payType", type:"Number", desc:"支付方式 1是微信支付 2是线下支付 3全部"},
            ],
            bindBiz:costVerificationBiz.outPutConfirmReceipt
        },
        {
            apiName:"财务核对-审批历史",
            subUrl:'/order/invoice/examine/confirmreceipthistory', 
            param:[
                {key:"id", type:"String", desc:"订单id"},
            ],
            bindBiz:invoiceBiz.confirmReceiptHistory
        },
        {
            apiName:"待开发票-上传发票 已开发票-修改发票",
            subUrl:'/order/invoice/examine/upinvoice', 
            param:[
                {key:"id", type:"String", desc:"订单id"},
                // {key:"invoiceUrl", type:"String", desc:"发票地址"},
            ],
            bindBiz:invoiceBiz.upInvoice
        },
        // {
        //     apiName:"待开发票-退回发票", 弃用
        //     subUrl:'/order/invoice/examine/backinvoice', 
        //     param:[
        //         {key:"id", type:"String", desc:"订单id"}
        //     ],
        //     bindBiz:orderBiz.backInvoice
        // },
        {
            apiName:"待开发票-数据导出",
            subUrl:'/order/invoice/examine/outputbillstate', 
            param:[
                {key:"exportColumns", type:"[]", desc:"导出数据列"},
                {key:"payState", type:"Number", desc:"支付状态 1是已支付 2是未支付 3是全部"},
                {key:"invoiceState", type:"Number", desc:"发票状态 0是全部 1是已申请 2是未申请",  isNull:true},
            ],
            bindBiz:invoiceBiz.outPutBillState
        },
        {
            apiName:"待开发票-审批历史",
            subUrl:'/order/invoice/examine/billstatehistory', 
            param:[
                {key:"id", type:"String", desc:"订单id"},
            ],
            bindBiz:invoiceBiz.billStateHistory
        },
        {
            apiName:"待开发票-批量开票确认",
            subUrl:'/order/invoice/examine/billstatebatchadopt', 
            param:[
                {key:"idList", type:"[String]", desc:"批量通过的用户列表"},
            ],
            bindBiz:invoiceBiz.billStateBatchAdopt
        },
        {
            apiName:"发票管理-已开发票",
            subUrl:'/order/invoice/examine/invoicedlist', 
            param:[
                {key:"name", type:"String", desc:"名称", isNull:true},
                {key:"memberType", type:"[Number]", desc:"会员类别", isNull:true},
                {key:"documentId", type:"String", desc:"身份证", isNull:true},
                {key:"phone", type:"String", desc:"手机号", isNull:true},
                // {key:"mail", type:"String", desc:"邮箱", isNull:true},
                // {key:"joinStartTime", type:"Number", desc:"入会开始时间", isNull:true},
                // {key:"joinEndTime", type:"Number", desc:"入会结束时间", isNull:true},
                {key:"memberLevel", type:"[Number]", desc:"个人级别职务", isNull:true},
                {key:"paymentType", type:"Number", desc:"支付方式", isNull:true},
                {key:"isPay", type:"Number", desc:"是否支付", isNull:true},
                {key:"weChartPR", type:"String", desc:"微信支付单号", isNull:true},
                {key:"invoiceExamineTime", type:"Number", desc:"已开发票时间", isNull:true},
                {key:"state", type:"Number", desc:"状态", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页"},
            ],
            bindBiz:invoiceBiz.invoicedList
        },
        {
            apiName:"已开发票-数据导出",
            subUrl:'/order/invoice/examine/outputinvoiced', 
            param:[
                {key:"exportColumns", type:"[]", desc:"导出数据列"}
            ],
            bindBiz:invoiceBiz.outPutInvoiced
        },
        {
            apiName:"已开发票-审批历史",
            subUrl:'/order/invoice/examine/invoicedhistory', 
            param:[
                {key:"id", type:"String", desc:"订单id"},
            ],
            bindBiz:invoiceBiz.invoicedHistory
        },
        {
            apiName:"转账单号弹窗",
            subUrl:'/order/transferscreenshot',
            param:[
                {key:"id", type:"String", desc:"订单id"},
            ],
            bindBiz:orderBiz.transferScreenshot
        },
        {
            apiName:"转账发票弹窗",
            subUrl:'/order/invoicepop',
            param:[
                {key:"id", type:"String", desc:"订单id"},
            ],
            bindBiz:orderBiz.invoicePop
        },
        {
            apiName:"退款列表",
            subUrl:'/order/refundlist',
            param:[
                {key:"name", type:"String", desc:"名称", isNull:true},
                {key:"joinStartTime", type:"Number", desc:"入会开始时间", isNull:true},
                {key:"joinEndTime", type:"Number", desc:"入会结束时间", isNull:true},
                {key:"memberType", type:"[Number]", desc:"会员类别", isNull:true},
                {key:"isReceiveMoney", type:"Number", desc:"订单分类", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页"},
            ],
            bindBiz:orderBiz.refundList
        },
        {
            apiName:"退款确认",
            subUrl:'/order/refundapprove',
            param:[
                {key:"id", type:"String", desc:"订单id"},
                {key:"refundImgUrl", type:"String", desc:"订单id"},
            ],
            bindBiz:orderBiz.refundApprove
        },
        {
            apiName:"退款驳回",
            subUrl:'/order/refundout',
            param:[
                {key:"id", type:"String", desc:"订单id"},
                {key:"desc", type:"String", desc:"备注"},
            ],
            bindBiz:orderBiz.refundOut
        },
        {
            apiName:"退款列表-数据导出",
            subUrl:'/order/invoice/examine/outputrefund',
            param:[
                {key:"exportColumns", type:"[]", desc:"导出数据列"}
            ],
            bindBiz:orderBiz.outPutRefund
        },
        // {
        //     apiName:"审批历史",
        //     subUrl:'/order/approve/log',
        //     param:[
        //         {key:"id", type:"String", desc:"订单id"},
        //     ],
        //     bindBiz:orderBiz.
        // },
    ],
    "会员个人页":[
        {
            apiName:"会员缴费列表",
            subUrl:'/order/memberpayment',
            param:[
                {key:"type", type:"Number", desc:"缴费状态", isNull:true}
            ],
            bindBiz:orderBiz.orderList
        },
        {
            apiName:"查看原因",//会员列表->查看原因
            subUrl:'/order/reason',
            param:[
                {key:"id", type:"String", desc:"会员缴费列表返回id"},
            ],
            bindBiz:orderBiz.approveLog
        },
        {
            apiName:"查看原因的确定",//会员列表->查看原因->确定
            subUrl:'/order/reconfirm',
            param:[
                {key:"id", type:"String", desc:"会员缴费列表返回id"},
                {key:"weChartPR", type:"String", desc:"转账单号"},
                {key:"offlinePaymentUrl", type:"String", desc:"截图上传"},
                {key:"desc", type:"String", desc:"备注", isNull:true},
            ],
            bindBiz:orderBiz.reconfirm
        },
        // {
        //     apiName:"申请发票",  弃用统一成下面的
        //     subUrl:'/order/applicationinvoice',
        //     param:[
        //         {key:"id", type:"String", desc:"会员缴费列表返回id"},
        //         {key:"memberType", type:"Number", desc:"会员类型"},
        //         {key:"newUscc", type:"String", desc:"新的社会信用代码", isNull:true},
        //         {key:"newUnitName", type:"String", desc:"新的发票抬头", isNull:true}
        //     ],
        //     bindBiz:orderBiz.applicationInvoice
        // },
        {
            apiName:"开发票",
            subUrl:'/order/inadvance',
            param:[
                {key:"id", type:"String", desc:"会员缴费列表返回id"},
                {key:"mail", type:"String", desc:"会员邮箱"},
                {key:"desc", type:"String", desc:"描述", isNull:true}
            ],
            bindBiz:orderBiz.applicationInadvanceInvoice
        },
        {
            apiName:"开发票回显",
            subUrl:'/order/inadvanceinfo',
            param:[
                {key:"id", type:"String", desc:"会员缴费列表返回id"}
            ],
            bindBiz:orderBiz.applicationInadvanceInvoiceInfo
        },
        {
            apiName:"重新申请发票",
            subUrl:'/order/reapplyinvoice',
            param:[
                {key:"id", type:"String", desc:"会员缴费列表返回id"}
            ],
            bindBiz:orderBiz.reapplyInvoice
        },
        {
            apiName:"下载发票",
            subUrl:'/order/downinvoice',
            param:[
                {key:"id", type:"String", desc:"会员缴费列表返回id"}
            ],
            bindBiz:orderBiz.downInvoice
        },
        {
            apiName:"上传转账截图",//个人页面线下付款
            subUrl:'/order/uptransferimg',
            param:[
                {key:"id", type:"String", desc:"会员缴费列表返回id"},
                {key:"weChartPR", type:"String", desc:"转账单号"},
                {key:"offlinePaymentUrl", type:"String", desc:"截图上传"},
                {key:"invoiceMail", type:"String", desc:"邮箱"},
                {key:"desc", type:"String", desc:"备注", isNull:true},
            ],
            bindBiz:orderBiz.upTransferImg
        },
        {
            apiName:"发票审核进度",
            subUrl:'/order/getinvoicestatus',
            param:[
                {key:"id", type:"String", desc:"会员缴费列表返回id"},
            ],
            bindBiz:orderBiz.getInvoiceStatus
        },
        {
            apiName:"退款原因回显",
            subUrl:'/order/refund/reasoninfo',
            param:[
                {key:"id", type:"String", desc:"会员缴费列表返回id"},
            ],
            bindBiz:orderBiz.reasonInfo
        },
        {
            apiName:"退款信息",
            subUrl:'/order/refund/accountinfo',
            param:[
                {key:"id", type:"String", desc:"会员缴费列表返回id"},
                {key:"form", type:"Object", sub:
                    {
                        refundName:{type:"String", desc:"姓名"},
                        refundBankCarId:{typs:"String", desc:"银行账号"},
                        refundBankName:{type:"String", desc:"银行开户行"},
                        refundDesc:{type:"String", desc:"备注"},
                    },
                    desc:"表单"
                }
            ],
            bindBiz:orderBiz.accountInfo
        },
    ],
    
}
