/**
 * 网站编辑路由配置  
 *   {
            apiName:"接口名称",
            subUrl:'/xuehui/xuehuilingdao/add', //接口地址
            param:[//参数  isNull=false 或者 notMustHave = true 可以不填配置  isNull=false表示可以为空  notMustHave=false 表示不可以为空
                {
                    key:"form", type:"Object", sub:{
                        name:{typs:"String", notMustHave:false},
                    }
                },
                {key:"id", type:"String", isNull:false}
            ],
            bindBiz:xueHuiLingDaoBiz.create
        },
 */
import * as jiGouGuanLiBiz from '../../biz/portal/fenZhiJiGou/jiGouGuanLi';

import * as xueHuiLingDaoBiz from '../../biz/portal/xueHui/xueHuiLingDao';
import * as xueHuiGaikuoBiz from '../../biz/portal/xueHui/xueHuiGaikuo';
import * as xueHuiJiaGouBiz from '../../biz/portal/xueHui/xueHuiJiaGou';

import * as zhuanTiXiLieBiz from '../../biz/portal/shouYe/zhuanTiXiLie';

import * as xueShuYanJiuBiz from '../../biz/portal/pinPaiXiangMu/xueShuYanJiu';
import * as fangHuaBeiBiz from '../../biz/portal/pinPaiXiangMu/fangHuaBei';

import * as huiYiTongZhiBiz from '../../biz/portal/tongZhiGongGao/huiYiTongZhi';
import * as huoDongTongZhiBiz from '../../biz/portal/tongZhiGongGao/huoDongTongZhi';
import * as xiangMuGongGaoBiz from '../../biz/portal/tongZhiGongGao/xiangMuGongGao';

import * as bannerGuanLiBiz from '../../biz/portal/neiRongGuanLi/bannerGuanLi';
import * as shiPinGuanLiBiz from '../../biz/portal/neiRongGuanLi/shiPinGuanLi';
import * as wenZhangGuanLiBiz from '../../biz/portal/neiRongGuanLi/wenZhangGuanLi';

import * as xueXiYuanDiBiz from '../../biz/portal/dangJianGonZuo/xueXiYuanDi';
import * as zhuTiJiaoYuBiz from '../../biz/portal/dangJianGonZuo/zhuTiJiaoYu';
import * as wenZiZiLiaoBiz from '../../biz/portal/dangJianGonZuo/wenZiZiLiao';

import * as gongZuoDongTaiBiz from '../../biz/portal/fenZhiJiGou/gongZuoDongTai';
import * as weiYuanMingDanBiz from '../../biz/portal/fenZhiJiGou/weiYuanMingDan';
import * as xiaZaiZhuanQuBiz from '../../biz/portal/fenZhiJiGou/xiaZaiZhuanQu';


export const FirstName = '网站编辑';
export const FirstRouter = '/manage/portal';
export const Config = {
    "学会概况_学会概括":[
        {
            apiName:"修改",
            subUrl:'/xuehui/xuehuigaikuo/update', 
            param:[
                {key:"desc", type:"String", desc:"简介"},
                {key:"title", type:"String", desc:"标题"},
                {key:"imgList", type:"[String]", desc:"图片地址"},
            ],
            bindBiz:xueHuiGaikuoBiz.update
        },
        {
            apiName:"回显",
            subUrl:'/xuehui/xuehuigaikuo/info', 
            param:[],
            bindBiz:xueHuiGaikuoBiz.info
        }
    ],
    "学会概况_学会领导":[
        {
            apiName:"创建学会领导",
            subUrl:'/xuehui/xuehuilingdao/add', 
            param:[
                {key:"form", type:"Object", sub:
                    {
                        rank:{type:"Number", desc:"排序"},
                        name:{typs:"String", desc:"名称"},
                        position:{type:"Number", desc:"职位"},
                        imgUrl:{type:"String", desc:"大图地址"},
                        miniImgUrl:{type:"String", desc:"小图地址"},
                        desc:{type:"String", desc:"说明"},
                    },
                    desc:"表单"
                }
            ],
            bindBiz:xueHuiLingDaoBiz.create
        },
        {
            apiName:"修改",
            subUrl:'/xuehui/xuehuilingdao/update', 
            param:[
                {key:"form", type:"Object", sub:
                    {
                        rank:{type:"Number", desc:"排序"},
                        name:{typs:"String", desc:"名称"},
                        position:{type:"Number", desc:"职位"},
                        imgUrl:{type:"String", desc:"大图地址"},
                        miniImgUrl:{type:"String", desc:"小图地址"},
                        desc:{type:"String", desc:"说明"},
                    },
                    desc:"表单"
                },
                {key:"id", type:"String", desc:"标识"}
            ],
            bindBiz:xueHuiLingDaoBiz.update
        },
        {
            apiName:"删除",
            subUrl:'/xuehui/xuehuilingdao/del', 
            param:[
                {key:"id", type:"String", desc:"标识"}
            ],
            bindBiz:xueHuiLingDaoBiz.del
        },
        {
            apiName:"学会领导列表",
            subUrl:'/xuehui/xuehuilingdao/list', 
            param:[
                {key:"pageNumber", type:"Number",  desc:"当前页数"} 
            ],
            bindBiz:xueHuiLingDaoBiz.list
        },
        {
            apiName:"表单回显",
            subUrl:'/xuehui/xuehuilingdao/info', 
            param:[
                {key:"id", type:"String",  desc:"标识"} 
            ],
            bindBiz:xueHuiLingDaoBiz.info
        },
        {
            apiName:"编辑查看页面",
            subUrl:'/xuehui/xuehuilingdao/preview', 
            param:[],
            bindBiz:xueHuiLingDaoBiz.preview
        }
    ],
    "学会概况_学会架构":[
        // {
        //     apiName:"新建",
        //     subUrl:'/xuehui/xuehuijiagou/create', 
        //     param:[
        //         {key:"form", type:"Object", sub:
        //             {
        //                 departmentName:{type:"String", desc:"组织名称"},
        //                 desc:{typs:"String", desc:"组织介绍"}
        //             },
        //             desc:"表单"
        //         }
        //     ],
        //     bindBiz:xueHuiJiaGouBiz.create
        // },
        {
            apiName:"删除",
            subUrl:'/xuehui/xuehuijiagou/delete', 
            param:[
                {key:"id", type:"String", desc:"标识"}
            ],
            bindBiz:xueHuiJiaGouBiz.del
        },
        {
            apiName:"修改",
            subUrl:'/xuehui/xuehuijiagou/update', 
            param:[
                {key:"id", type:"String", desc:"标识"},
                {key:"form", type:"Object", sub:
                    {
                        departmentName:{type:"String", desc:"组织名称"},
                        desc:{typs:"String", desc:"组织介绍"}
                    },
                    desc:"表单"
                }
            ],
            bindBiz:xueHuiJiaGouBiz.update
        },
        {
            apiName:"列表",
            subUrl:'/xuehui/xuehuijiagou/list', 
            param:[],
            bindBiz:xueHuiJiaGouBiz.list
        },
        {
            apiName:"回显",
            subUrl:'/xuehui/xuehuijiagou/info', 
            param:[
                {key:"id", type:"String", desc:"标识"}
            ],
            bindBiz:xueHuiJiaGouBiz.info
        },
        {
            apiName:"改变显示状态",
            subUrl:'/xuehui/xuehuijiagou/updatedisplay', 
            param:[
                {key:"id", type:"String", desc:"标识"}
            ],
            bindBiz:xueHuiJiaGouBiz.updateDisplay
        },
    ],
    "首页_专题系列":[
        {
            apiName:"列表",
            subUrl:'/shouye/zhuantixilie/list', 
            param:[],
            bindBiz:zhuanTiXiLieBiz.list
        },
        {
            apiName:"编辑表单回显",
            subUrl:'/shouye/zhuantixilie/info', 
            param:[
                {key:"id", type:"String", desc:"标识"}
            ],
            bindBiz:zhuanTiXiLieBiz.info
        },
        {
            apiName:"删除",
            subUrl:'/shouye/zhuantixilie/del', 
            param:[
                {key:"id", type:"String", desc:"标识"}
            ],
            bindBiz:zhuanTiXiLieBiz.del
        },
        {
            apiName:"预览",
            subUrl:'/shouye/zhuantixilie/preview', 
            param:[],
            bindBiz:zhuanTiXiLieBiz.preview
        },
        {
            apiName:"修改",
            subUrl:'/shouye/zhuantixilie/update',
            param:[
                {key:"id", type:"String", desc:"标识"},
                {key:"title", type:"String", desc:"展示标题"}, 
                {key:"imgUrl", type:"String", desc:"图片地址"}, 
                {key:"articleUrl", type:"String", desc:"文字链接"},
                {key:"position", type:"Number", desc:"位置"},
                {key:"articleTitle", type:"String", desc:"文章标题"}
            ],
            bindBiz:zhuanTiXiLieBiz.update
        },
    ],
    "品牌项目_学术研究":[
        {
            apiName:"列表",
            subUrl:'/pinpai/xueshuyanjiu/list', 
            param:[],
            bindBiz:xueShuYanJiuBiz.list
        },
        {
            apiName:"回显",
            subUrl:'/pinpai/xueshuyanjiu/info', 
            param:[
                {key:"id", type:"String", desc:"标识"},
            ],
            bindBiz:xueShuYanJiuBiz.info
        },
        {
            apiName:"删除",
            subUrl:'/pinpai/xueshuyanjiu/del', 
            param:[
                {key:"id", type:"String", desc:"标识"},
            ],
            bindBiz:xueShuYanJiuBiz.del
        },
        {
            apiName:"修改",
            subUrl:'/pinpai/xueshuyanjiu/update', 
            param:[
                {key:"id", type:"String", desc:"标识"},
                {key:"imgUrl", type:"String", desc:"图片地址"},
                {key:"desc", type:"String", desc:"图片说明"},
            ],
            bindBiz:xueShuYanJiuBiz.update
        },
        {
            apiName:"预览",
            subUrl:'/pinpai/xueshuyanjiu/preview', 
            param:[],
            bindBiz:xueShuYanJiuBiz.preview
        }
    ],
    "品牌项目_芳华杯":[
        {
            apiName:"创建",
            subUrl:'/pinpai/fanghuabei/create', 
            param:[
                {
                    key:"form", type:"Object", desc:"表单", sub:{
                        name:{type:"String", desc:"获奖者"},
                        works:{type:"String", desc:"获奖作品"},
                        worksType:{type:"Number", desc:"作品类型"},
                        awardTime:{type:"Number", desc:"获奖时间"},
                        desc:{type:"String", desc:"说明"},
                    }
                }
            ],
            bindBiz:fangHuaBeiBiz.create
        },
        {
            apiName:"列表",
            subUrl:'/pinpai/fanghuabei/list', 
            param:[
                {key:"desc", type:"String", desc:"描述"},
                {key:"worksType", type:"Number", desc:"获奖类型 枚举"},
                {key:"year", type:"Number", desc:"获奖时间（年）"},
            ],
            bindBiz:fangHuaBeiBiz.list
        },
        {
            apiName:"回显",
            subUrl:'/pinpai/fanghuabei/info', 
            param:[
                {key:"id", type:"String", desc:"标识"}
            ],
            bindBiz:fangHuaBeiBiz.info
        },
        {
            apiName:"修改",
            subUrl:'/pinpai/fanghuabei/update', 
            param:[
                {
                    key:"form", type:"Object", desc:"表单", sub:{
                        name:{type:"String", desc:"获奖者"},
                        works:{type:"String", desc:"获奖作品"},
                        worksType:{type:"Number", desc:"作品类型"},
                        awardTime:{type:"Number", desc:"获奖时间"},
                        desc:{type:"String", desc:"说明"},
                    }
                },
                {key:"id", type:"String", desc:"标识"},
            ],
            bindBiz:fangHuaBeiBiz.update
        },
        {
            apiName:"删除",
            subUrl:'/pinpai/fanghuabei/del', 
            param:[
                {key:"id", type:"String", desc:"标识"}
            ],
            bindBiz:fangHuaBeiBiz.del
        },
    ],
    "分支机构_机构管理":[
        {
            apiName:"创建",
            subUrl:'/fenzhijigou/jigouguanli/add', 
            param:[
                {key:"form", type:"Object", sub:
                    {
                        name:{type:'String', desc:"名称"},
                        createTime:{type:'Number', desc:"创立时间"},
                        desc:{type:'String', desc:"描述"},
                        rank:{type:'Number', desc:"排序"},
                        logoUrl:{type:'String', desc:"logo图片地址"}
                    },
                    desc:"表单"
                }
            ],
            bindBiz:jiGouGuanLiBiz.create
        },
        {
            apiName:"修改",
            subUrl:'/fenzhijigou/jigouguanli/update', 
            param:[
                {key:"form", type:"Object", sub:
                    {
                        name:{type:'String', desc:"名称"},
                        createTime:{type:'Number', desc:"创立时间"},
                        desc:{type:'String', desc:"描述"},
                        rank:{type:'Number', desc:"排序"},
                        logoUrl:{type:'String', desc:"logo图片地址"}
                    },
                    desc:"表单"
                },
                {key:"id", type:"String", desc:"标识"}
            ],
            bindBiz:jiGouGuanLiBiz.update
        },
        {
            apiName:"删除",
            subUrl:'/fenzhijigou/jigouguanli/del', 
            param:[
                {key:"id", type:"String", desc:"标识"}
            ],
            bindBiz:jiGouGuanLiBiz.del
        },
        {
            apiName:"列表",
            subUrl:'/fenzhijigou/jigouguanli/list', 
            param:[
                {key:"pageNumber", type:"Number",  desc:"当前页"} 
            ],
            bindBiz:jiGouGuanLiBiz.list
        },
        {
            apiName:"表单回显",
            subUrl:'/fenzhijigou/jigouguanli/info', 
            param:[
                {key:"id", type:"String",  desc:"标识"} 
            ],
            bindBiz:jiGouGuanLiBiz.info
        }
    ],
    "通知公告_会议通知":[
        {
            apiName:"创建",
            subUrl:'/tongzhigonggao/huiyitongzhi/add', 
            param:[
                {key:"form", type:"Object", sub:
                    {
                        name:{type:'String', desc:"会议名称"},
                        st:{type:'Number', desc:"开始时间时间戳"},
                        addrest:{type:'String', desc:"地点"},
                        members:{type:'[Number]', desc:"参与人员"},
                        push:{type:'Number', desc:'推送0表示关1表示开'},
                        desc:{type:'String', desc:"说明"}
                    },
                    desc:"表单"
                }
            ],
            bindBiz:huiYiTongZhiBiz.create
        },
        {
            apiName:"修改",
            subUrl:'/tongzhigonggao/huiyitongzhi/update', 
            param:[
                {key:"form", type:"Object", sub:
                    {
                        name:{type:'String', desc:"会议名称"},
                        st:{type:'Number', desc:"开始时间时间戳"},
                        addrest:{type:'String', desc:"地点"},
                        members:{type:'[Number]', desc:"参与人员"},
                        push:{type:'Number', desc:'推送0表示关1表示开'},
                        desc:{type:'String', desc:"说明"}
                    },
                    desc:"表单"
                },
                {key:"id", type:"String", desc:"标识"}
            ],
            bindBiz:huiYiTongZhiBiz.update
        },
        {
            apiName:"删除",
            subUrl:'/tongzhigonggao/huiyitongzhi/del', 
            param:[
                {key:"id", type:"String", desc:"标识"}
            ],
            bindBiz:huiYiTongZhiBiz.del
        },
        {
            apiName:"列表",
            subUrl:'/tongzhigonggao/huiyitongzhi/list', 
            param:[
                {key:"desc", type:"String", desc:"内容关键字"},
                {key:"pageNumber", type:"Number",  desc:"当前页面"}
            ],
            bindBiz:huiYiTongZhiBiz.list
        },
        {
            apiName:"表单回显",
            subUrl:'/tongzhigonggao/huiyitongzhi/info',
            param:[
                {key:"id", type:"String",  desc:"标识"} 
            ],
            bindBiz:huiYiTongZhiBiz.info
        },
        {
            apiName:"更改推送状态",
            subUrl:'/tongzhigonggao/huiyitongzhi/changepush', 
            param:[
                {key:"id", type:"String",  desc:"标识"} 
            ],
            bindBiz:huiYiTongZhiBiz.changePush
        }
    ],
    "通知公告_活动通知":[
        {
            apiName:"创建",
            subUrl:'/tongzhigonggao/huodongtongzhi/add', 
            param:[
                {key:"form", type:"Object", sub:
                    {
                        name:{type:'String', desc:"活动名称"},
                        st:{type:'Number', desc:"开始时间"},
                        addrest:{type:'String', desc:"活动地点"},
                        push:{type:'Number', desc:'推送0表示关1表示开'},
                        members:{type:'[Number]', desc:"参与人员"},
                        desc:{type:'String', desc:"说明"}
                    },
                    desc:"表单"
                }
            ],
            bindBiz:huoDongTongZhiBiz.create
        },
        {
            apiName:"修改",
            subUrl:'/tongzhigonggao/huodongtongzhi/update', 
            param:[
                {key:"form", type:"Object", sub:
                    {
                        name:{type:'String', desc:"活动名称"},
                        st:{type:'Number', desc:"开始时间"},
                        addrest:{type:'String', desc:"地点"},
                        members:{type:'[Number]', desc:"参与人员"},
                        push:{type:'Number', desc:'推送0表示关1表示开'},
                        desc:{type:'String', desc:"说明"}
                    },
                    desc:"表单"
                },
                {key:"id", type:"String", desc:"标识"}
            ],
            bindBiz:huoDongTongZhiBiz.update
        },
        {
            apiName:"删除",
            subUrl:'/tongzhigonggao/huodongtongzhi/del', 
            param:[
                {key:"id", type:"String", desc:"标识"}
            ],
            bindBiz:huoDongTongZhiBiz.del
        },
        {
            apiName:"列表",
            subUrl:'/tongzhigonggao/huodongtongzhi/list', 
            param:[
                {key:"desc", type:"String", desc:"内容关键字"},
                {key:"pageNumber", type:"Number",  desc:"当前页面"}
            ],
            bindBiz:huoDongTongZhiBiz.list
        },
        {
            apiName:"表单回显",
            subUrl:'/tongzhigonggao/huodongtongzhi/info', 
            param:[
                {key:"id", type:"String",  desc:"标识"} 
            ],
            bindBiz:huoDongTongZhiBiz.info
        },
        {
            apiName:"更改推送状态",
            subUrl:'/tongzhigonggao/huodongtongzhi/changepush', 
            param:[
                {key:"id", type:"String",  desc:"标识"} 
            ],
            bindBiz:huoDongTongZhiBiz.changePush
        }
    ],
    "通知公告_项目公告":[
        {
            apiName:"创建",
            subUrl:'/tongzhigonggao/xiangmugonggao/add', 
            param:[
                {key:"form", type:"Object", sub:
                    {
                        name:{type:'String', desc:"公告名称"},
                        st:{type:'Number', desc:"开始时间"},
                        addrest:{type:'String', desc:"活动地点"},
                        push:{type:'Number', desc:'推送0表示关1表示开'},
                        members:{type:'[Number]', desc:"参与人员"},
                        desc:{type:'String', desc:"说明"}
                    },
                    desc:"表单"
                }
            ],
            bindBiz:xiangMuGongGaoBiz.create
        },
        {
            apiName:"修改",
            subUrl:'/tongzhigonggao/xiangmugonggao/update', 
            param:[
                {key:"form", type:"Object", sub:
                    {
                        name:{type:'String', desc:"公告名称"},
                        st:{type:'Number', desc:"开始时间"},
                        addrest:{type:'String', desc:"地点"},
                        push:{type:'Number', desc:'推送0表示关1表示开'},
                        members:{type:'[Number]', desc:"参与人员"},
                        desc:{type:'String', desc:"说明"}
                    },
                    desc:"表单"
                },
                {key:"id", type:"String", desc:"标识"}
            ],
            bindBiz:xiangMuGongGaoBiz.update
        },
        {
            apiName:"删除",
            subUrl:'/tongzhigonggao/xiangmugonggao/del', 
            param:[
                {key:"id", type:"String", desc:"标识"}
            ],
            bindBiz:xiangMuGongGaoBiz.del
        },
        {
            apiName:"列表",
            subUrl:'/tongzhigonggao/xiangmugonggao/list', 
            param:[
                {key:"desc", type:"String", desc:"内容关键字"},
                {key:"pageNumber", type:"Number",  desc:"当前页面"}
            ],
            bindBiz:xiangMuGongGaoBiz.list
        },
        {
            apiName:"表单回显",
            subUrl:'/tongzhigonggao/xiangmugonggao/info', 
            param:[
                {key:"id", type:"String",  desc:"标识"} 
            ],
            bindBiz:xiangMuGongGaoBiz.info
        },
        {
            apiName:"更改推送状态",
            subUrl:'/tongzhigonggao/xiangmugonggao/changepush', 
            param:[
                {key:"id", type:"String",  desc:"标识"} 
            ],
            bindBiz:xiangMuGongGaoBiz.changePush
        }
    ],
    "内容管理_banner管理":[
        {
            apiName:"创建",
            subUrl:'/neirongguanLi/bannerguanli/add', 
            param:[
                {key:"form", type:"Object", sub:
                    {
                        location:{type:'Number', desc:'所属位置枚举'},
                        position:{type:'Number', desc:'文章位置',  notMustHave:true},
                        articleTitle:{type:'String', desc:'文章大标题', notMustHave:true},
                        imgUrl:{type:'String', desc:'图片地址'},
                        articleUrl:{type:'String', desc:'文章链接', notMustHave:true},
                        desc:{type:'String', desc:'副标题'}
                    },
                    desc:"表单"
                }
            ],
            bindBiz:bannerGuanLiBiz.create
        },
        {
            apiName:"修改",
            subUrl:'/neirongguanLi/bannerguanli/update', 
            param:[
                {key:"form", type:"Object", sub:
                    {
                        location:{type:'Number', desc:'所属位置枚举'},
                        position:{type:'Number', desc:'文章位置',  notMustHave:true},
                        articleTitle:{type:'String', desc:'文章大标题',  notMustHave:true},
                        imgUrl:{type:'String', desc:'图片地址'},
                        articleUrl:{type:'String', desc:'文章链接', notMustHave:true},
                        desc:{type:'String', desc:'副标题'}
                    },
                    desc:"表单"
                },
                {key:"id", type:"String", desc:"标识"}
            ],
            bindBiz:bannerGuanLiBiz.update
        },
        {
            apiName:"删除",
            subUrl:'/neirongguanLi/bannerguanli/del', 
            param:[
                {key:"id", type:"String", desc:"标识"}
            ],
            bindBiz:bannerGuanLiBiz.del
        },
        {
            apiName:"列表",
            subUrl:'/neirongguanLi/bannerguanli/list', 
            param:[
                {key:"pageNumber", type:"Number", desc:"当前页面数"}
            ],
            bindBiz:bannerGuanLiBiz.list
        },
        {
            apiName:"表单回显",
            subUrl:'/neirongguanLi/bannerguanli/info', 
            param:[
                {key:"id", type:"String",  desc:"标识"} 
            ],
            bindBiz:bannerGuanLiBiz.info
        },
        {
            apiName:"修改状态",
            subUrl:'/neirongguanLi/bannerguanli/changeuse', 
            param:[
                {key:"id", type:"String",  desc:"标识"}
            ],
            bindBiz:bannerGuanLiBiz.changePush
        },
    ],
    "内容管理_视频管理":[
        {
            apiName:"创建",
            subUrl:'/neirongguanli/shipinguanli/add', 
            param:[
                {key:"form", type:"Object", sub:
                    {
                        title:{type:'String', desc:"大标题"},
                        videoType:{type:'Number', desc:"分类"},
                        videoUrl:{type:'String', desc:"视频地址"},
                        videoTime:{type:'Number', desc:"创建"},
                        desc:{type:'String', desc:"说明"},
                        coverUrl:{type:'String', desc:"封面图片地址"}
                    },
                    desc:"表单"
                }
            ],
            bindBiz:shiPinGuanLiBiz.create
        },
        {
            apiName:"修改",
            subUrl:'/neirongguanli/shipinguanli/update', 
            param:[
                {key:"form", type:"Object", sub:
                    {
                        title:{type:'String', desc:"大标题"},
                        videoType:{type:'Number', desc:"分类"},
                        videoUrl:{type:'String', desc:"视频地址"},
                        videoTime:{type:'Number', desc:"创建"},
                        coverUrl:{type:'String', desc:"封面图片地址"},
                        desc:{type:'String', desc:"说明"}
                    },
                    desc:"表单"
                },
                {key:"id", type:"String", desc:"标识"}
            ],
            bindBiz:shiPinGuanLiBiz.update
        },
        {
            apiName:"删除",
            subUrl:'/neirongguanli/shipinguanli/del', 
            param:[
                {key:"id", type:"String", desc:"标识"}
            ],
            bindBiz:shiPinGuanLiBiz.del
        },
        {
            apiName:"列表",
            subUrl:'/neirongguanli/shipinguanli/list', 
            param:[
                {key:"videoType", type:"Number", desc:"分类", isNull:true},
                {key:"title", type:"String", desc:"内容关键字", isNull:true},
                {key:"videoTime", type:"Number", desc:"创建时间", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页面数"}
            ],
            bindBiz:shiPinGuanLiBiz.list
        },
        {
            apiName:"表单回显",
            subUrl:'/neirongguanli/shipinguanli/info', 
            param:[
                {key:"id", type:"String",  desc:"标识"} 
            ],
            bindBiz:shiPinGuanLiBiz.info
        },
        {
            apiName:"修改状态",
            subUrl:'/neirongguanLi/shipinguanli/changeuse', 
            param:[
                {key:"id", type:"String",  desc:"标识"}
            ],
            bindBiz:shiPinGuanLiBiz.changePush
        },
    ],
    "内容管理_文章管理":[
        {
            apiName:"创建",
            subUrl:'/neirongguanli/wenzhangguanli/add', 
            param:[
                {key:"form", type:"Object", sub:
                    {
                        title:{type:'String', desc:"文章大标题"},
                        articleType:{type:'[Number]', desc:"文章类型"},
                        imgUrl:{type:'[String]', desc:"图片地址"},
                        articleTime:{type:'Number', desc:"文章时间"},
                        desc:{type:'String', desc:"内容"}
                    },  
                    desc:"表单"
                },
            ],
            bindBiz:wenZhangGuanLiBiz.create
        },
        {
            apiName:"修改",
            subUrl:'/neirongguanli/wenzhangguanli/update', 
            param:[
                {key:"form", type:"Object", sub:
                    {
                        title:{type:'String', desc:"文章大标题"},
                        articleType:{type:'[Number]', desc:"文章类型"},
                        imgUrl:{type:'[String]', desc:"图片地址"},
                        articleTime:{type:'Number', desc:"文章时间"},
                        desc:{type:'String', desc:"内容"}
                    },
                    desc:"表单"
                },
                {key:"id", type:"String", desc:"标识"}
            ],
            bindBiz:wenZhangGuanLiBiz.update
        },
        {
            apiName:"删除",
            subUrl:'/neirongguanli/wenzhangguanli/del', 
            param:[
                {key:"id", type:"String", desc:"标识"}
            ],
            bindBiz:wenZhangGuanLiBiz.del
        },
        {
            apiName:"列表",
            subUrl:'/neirongguanli/wenzhangguanli/list', 
            param:[
                {key:"articleType", type:"Number", desc:"分类", isNull:true},
                {key:"title", type:"String", desc:"内容关键字", isNull:true},
                {key:"articleTime", type:"Number", desc:"创建时间", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页面数"}
            ],
            bindBiz:wenZhangGuanLiBiz.list
        },
        {
            apiName:"表单回显",
            subUrl:'/neirongguanli/wenzhangguanli/info', 
            param:[
                {key:"id", type:"String",  desc:"标识"} 
            ],
            bindBiz:wenZhangGuanLiBiz.info
        },
        {
            apiName:"修改状态",
            subUrl:'/neirongguanLi/wenzhangguanli/changeuse', 
            param:[
                {key:"id", type:"String",  desc:"标识"}
            ],
            bindBiz:wenZhangGuanLiBiz.changePush
        },
        {
            apiName:"根据文章位置获取文章标题",
            subUrl:'/neirongguanLi/wenzhangguanli/gettitle', 
            param:[
                {key:"type", type:"Number",  desc:"文章位置"}
            ],
            bindBiz:wenZhangGuanLiBiz.getTitleList
        },
    ],
    "党建工作_学习园地":[
        // {
        //     apiName:"列表",
        //     subUrl:'/dangjiangonzuo/xuexiyuandi/list', 
        //     param:[
        //     ],
        //     bindBiz:xueXiYuanDiBiz.list
        // },
        // {
        //     apiName:"修改",
        //     subUrl:'/dangjiangonzuo/xuexiyuandi/update', 
        //     param:[
        //         {key:"id", type:"Number",  desc:"标识"},
        //         {key:"typeName", type:"String",  desc:"分类名称"}
        //     ],
        //     bindBiz:xueXiYuanDiBiz.update
        // },
        // {
        //     apiName:"修改状态",
        //     subUrl:'/dangjiangonzuo/xuexiyuandi/changestate', 
        //     param:[
        //         {key:"id", type:"Number",  desc:"标识"}
        //     ],
        //     bindBiz:xueXiYuanDiBiz.changeState
        // }
    ],
    "党建工作_主题教育":[
        {
            apiName:"列表",
            subUrl:'/dangjiangonzuo/zhutijiaoyu/list', 
            param:[
            ],
            bindBiz:zhuTiJiaoYuBiz.list
        },
        {
            apiName:"修改",
            subUrl:'/dangjiangonzuo/zhutijiaoyu/update', 
            param:[
                {key:"id", type:"Number",  desc:"标识"},
                {key:"typeName", type:"String",  desc:"分类名称"}
            ],
            bindBiz:zhuTiJiaoYuBiz.update
        },
        {
            apiName:"修改状态",
            subUrl:'/dangjiangonzuo/zhutijiaoyu/changestate', 
            param:[
                {key:"id", type:"Number",  desc:"标识"},
            ],
            bindBiz:zhuTiJiaoYuBiz.changeState
        }
    ],
    "党建工作_文字资料":[
        {
            apiName:"列表",
            subUrl:'/dangjiangonzuo/wenziziliao/list',
            param:[
                {key:"type", type:"Number", desc:"类型"}  
            ],
            bindBiz:wenZiZiLiaoBiz.list
        },
        {
            apiName:"编辑表单回显",
            subUrl:'/dangjiangonzuo/wenziziliao/info', 
            param:[
                {key:"id", type:"String", desc:"标识"}
            ],
            bindBiz:wenZiZiLiaoBiz.info
        },
        {
            apiName:"删除",
            subUrl:'/dangjiangonzuo/wenziziliao/del', 
            param:[
                {key:"id", type:"String", desc:"标识"}
            ],
            bindBiz:wenZiZiLiaoBiz.del
        },
        {
            apiName:"预览",
            subUrl:'/dangjiangonzuo/wenziziliao/preview', 
            param:[
            ],
            bindBiz:wenZiZiLiaoBiz.preview
        },
        {
            apiName:"修改",
            subUrl:'/dangjiangonzuo/wenziziliao/update',
            param:[
                {key:"id", type:"String", desc:"标识"},
                {key:"title", type:"String", desc:"展示标题"}, 
                {key:"imgUrl", type:"String", desc:"图片or视频地址"}, 
                {key:"type", type:"Number", desc:"类型 参考公用接口videoimgtype"},
                {key:"coverUrl", type:"String", desc:"视频封面地址 当类型为图片时可以不传", isNull:true},
            ],
            bindBiz:wenZiZiLiaoBiz.update
        },
    ],
    "分支机构_机构管理_工作动态":[
        {
            apiName:"列表",
            subUrl:'/fenzhijigou/jigouguanli/gongzuodongtai/list', 
            param:[
                {key:"agencyId", type:"String",  desc:"机构id"},
                {key:"pageNumber", type:"Number",  desc:"当前页面"}
            ],
            bindBiz:gongZuoDongTaiBiz.list
        },
        {
            apiName:"回显",
            subUrl:'/fenzhijigou/jigouguanli/gongzuodongtai/info', 
            param:[
                {key:"id", type:"String",  desc:"标识"}
            ],
            bindBiz:gongZuoDongTaiBiz.info
        },
        {
            apiName:"删除",
            subUrl:'/fenzhijigou/jigouguanli/gongzuodongtai/del', 
            param:[
                {key:"id", type:"String",  desc:"标识"}
            ],
            bindBiz:gongZuoDongTaiBiz.del
        },
        {
            apiName:"修改",
            subUrl:'/fenzhijigou/jigouguanli/gongzuodongtai/update', 
            param:[
                {key:"form", type:"Object", sub:
                    {
                        title:{type:'String', desc:"标题"},
                        activityTime:{type:'Number', desc:"创建时间"},
                        imgUrl:{type:'String', desc:"图片地址"},
                        desc:{type:'String', desc:"内容"},
                        isUse:{type:'Number', desc:"是否上架0表示不上架1表示上架"},
                    },
                    desc:"表单"
                },
                {key:"id", type:"String",  desc:"标识"}
            ],
            bindBiz:gongZuoDongTaiBiz.update
        },
        {
            apiName:"创建",
            subUrl:'/fenzhijigou/jigouguanli/gongzuodongtai/add', 
            param:[
                {key:"form", type:"Object", sub:
                    {
                        title:{type:'String', desc:"标题"},
                        activityTime:{type:'Number', desc:"创建时间"},
                        imgUrl:{type:'String', desc:"图片地址"},
                        desc:{type:'String', desc:"内容"},
                        isUse:{type:'Number', desc:"是否上架0表示不上架1表示上架"},
                    },
                    desc:"表单"
                },
                {key:"agencyId", type:"String",  desc:"机构id"}
            ],
            bindBiz:gongZuoDongTaiBiz.create
        },
        {
            apiName:"修改状态",
            subUrl:'/fenzhijigou/jigouguanli/gongzuodongtai/changeuse', 
            param:[
                {key:"id", type:"String",  desc:"标识"}
            ],
            bindBiz:gongZuoDongTaiBiz.changeUse
        },
        
    ],
    "分支机构_机构管理_委员名单":[
        {
            apiName:"列表",
            subUrl:'/fenzhijigou/jigouguanli/weiyuanmingdan/list', 
            param:[
                {key:"agencyId", type:"String",  desc:"机构id"},
                {key:"pageNumber", type:"Number",  desc:"当前页面"}
            ],
            bindBiz:weiYuanMingDanBiz.list
        },
        {
            apiName:"回显",
            subUrl:'/fenzhijigou/jigouguanli/weiyuanmingdan/info', 
            param:[
                {key:"id", type:"String",  desc:"标识"}
            ],
            bindBiz:weiYuanMingDanBiz.info
        },
        {
            apiName:"删除",
            subUrl:'/fenzhijigou/jigouguanli/weiyuanmingdan/del', 
            param:[
                {key:"id", type:"String",  desc:"标识"}
            ],
            bindBiz:weiYuanMingDanBiz.del
        },
        {
            apiName:"修改",
            subUrl:'/fenzhijigou/jigouguanli/weiyuanmingdan/update', 
            param:[
                {key:"form", type:"Object", sub:
                    {
                        name:{type:'String', desc:"姓名"},
                        branchDuties:{type:'Number', desc:"分会职务"},
                        unit:{type:'String', desc:"单位"},
                        unitDuties:{type:'String', desc:"单位职务"}
                    },
                    desc:"表单"
                },
                {key:"id", type:"String",  desc:"标识"}
            ],
            bindBiz:weiYuanMingDanBiz.update
        },
        {
            apiName:"创建",
            subUrl:'/fenzhijigou/jigouguanli/weiyuanmingdan/add', 
            param:[
                {key:"form", type:"Object", sub:
                    {
                        name:{type:'String', desc:"姓名"},
                        branchDuties:{type:'Number', desc:"分会职务"},
                        unit:{type:'String', desc:"单位"},
                        unitDuties:{type:'String', desc:"单位职务"}
                    },
                    desc:"表单"
                },
                {key:"agencyId", type:"String",  desc:"机构id"}
            ],
            bindBiz:weiYuanMingDanBiz.create
        }
    ],
    "分支机构_机构管理_下载管理":[
        {
            apiName:"列表",
            subUrl:'/fenzhijigou/jigouguanli/xiazaizhuanqu/list', 
            param:[
                {key:"agencyId", type:"String",  desc:"机构id"},
                {key:"pageNumber", type:"Number",  desc:"当前页面"}
            ],
            bindBiz:xiaZaiZhuanQuBiz.list
        },
        {
            apiName:"回显",
            subUrl:'/fenzhijigou/jigouguanli/xiazaizhuanqu/info', 
            param:[
                {key:"id", type:"String",  desc:"标识"}
            ],
            bindBiz:xiaZaiZhuanQuBiz.info
        },
        {
            apiName:"删除",
            subUrl:'/fenzhijigou/jigouguanli/xiazaizhuanqu/del', 
            param:[
                {key:"id", type:"String",  desc:"标识"}
            ],
            bindBiz:xiaZaiZhuanQuBiz.del
        },
        {
            apiName:"修改",
            subUrl:'/fenzhijigou/jigouguanli/xiazaizhuanqu/update', 
            param:[
                {key:"form", type:"Object", sub:
                    {
                        name:{type:'String', desc:"文件名称"},
                        type:{type:'Number', desc:"文件类型"},
                        fileUrl:{type:'String', desc:"文件地址"}
                    },
                    desc:"表单"
                },
                {key:"id", type:"String",  desc:"标识"}
            ],
            bindBiz:xiaZaiZhuanQuBiz.update
        },
        {
            apiName:"创建",
            subUrl:'/fenzhijigou/jigouguanli/xiazaizhuanqu/add', 
            param:[
                {key:"form", type:"Object", sub:
                    {
                        name:{type:'String', desc:"文件名称"},
                        type:{type:'Number', desc:"文件类型"},
                        fileUrl:{type:'String', desc:"文件地址"}
                    },
                    desc:"表单"
                },
                {key:"agencyId", type:"String",  desc:"机构id"}
            ],
            bindBiz:xiaZaiZhuanQuBiz.create
        }
    ]
}