/**
 * 文章管理
 */


import { STATE } from "../../../config/enum";
import { ERRORENUM } from "../../../config/errorEnum";
import { addOneData } from "../../../data/add";
import { deleteOneData } from "../../../data/delete";
import { TABLEENUM } from "../../../data/models/model";
import { find, findCount, findOnce, findToPage, findToSortToPage } from "../../../data/select";
import { updateOneData } from "../../../data/update";
import { changeArticleName, generateSystemId, successResult } from "../../../tools/system";
import { BizError } from "../../../util/bizError";
import { extractData } from "../../../util/piecemeal";


/**
 * 创建文章
 * @param userId 
 * @param param 
 * @returns 
 */
export async function create(secureArgs) {
    let {userId, form} = secureArgs;
    form.ct = new Date().valueOf();
    form.id = generateSystemId(TABLEENUM.文章管理, userId);
    await addOneData(TABLEENUM.文章管理, form);

    return successResult();
}


/**
 * 修改
 * @param userId 
 * @param id 
 * @param updateParam 
 * @returns 
 */
export async function update(secureArgs:any) {
    let {userId, id, form} = secureArgs;
    let oldInfo = await findOnce(TABLEENUM.文章管理, {id});
    if (!oldInfo || !oldInfo.id) throw new BizError(ERRORENUM.目标数据不存在);
   
    await updateOneData(TABLEENUM.文章管理, {id}, form);
    
    return successResult();
}


export async function del(secureArgs:any) {
    let {userId, id} = secureArgs;
    let dataInfo = await findOnce(TABLEENUM.文章管理, {id});
    if (!dataInfo || !dataInfo.id) throw new BizError(ERRORENUM.目标数据不存在);
    await deleteOneData(TABLEENUM.文章管理, {id});
    return successResult();
}


export async function list(secureArgs:any) {
    let {userId, articleType, title, articleTime, pageNumber} = secureArgs;
    
    let selectParam:any = {};
    if (articleType) selectParam.articleType = articleType;
    if (title) selectParam.title = {"$regex":title};
    if (articleTime) {
        selectParam["$and"] = [
            {articleTime:{"$gt":articleTime}},
            {articleTime:{"$lt":articleTime+(24*3600*1000)}}
        ];
    }

    let dbList = await findToSortToPage(TABLEENUM.文章管理, selectParam, [ "id", "title", "articleType", "imgUrl", "articleTime", "desc", "display"], {articleTime:-1}, pageNumber);
    let dataCount = await findCount(TABLEENUM.文章管理, selectParam);
    let dataList = [];
    dbList.forEach(info => {
        let item:any = extractData(info, [ "id", "title", "articleType", "imgUrl", "articleTime", "desc", "display"]);
        item.articleType = changeArticleName( item.articleType);
        dataList.push(item);
    });

    return {dataList, dataCount};
}

/**
 * 回显
 * @param id 
 */
export async function info(secureArgs:any) {
    let {id} = secureArgs;
    let oldInfo = await findOnce(TABLEENUM.文章管理, {id});
    if (!oldInfo || !oldInfo.id) throw new BizError(ERRORENUM.目标数据不存在);
    let dataInfo = extractData(oldInfo, ["id", "title", "articleType", "imgUrl", "articleTime", "desc"]);

    return { dataInfo };
}


export async function changePush({id}) {
    let oldInfo = await findOnce(TABLEENUM.文章管理, {id});
    if (!oldInfo.id) throw new BizError(ERRORENUM.目标数据不存在);

    let newPush = oldInfo.display == 1 ? 0 : 1;
    await updateOneData(TABLEENUM.文章管理, {id}, {display:newPush});

    return successResult();
}


export async function getTitleList({type}) {
    let selectParam = {articleType:{"$in":[type]}, display:STATE.是};
    let dbList = await find(TABLEENUM.文章管理, selectParam, ["id", "title"]);

    let dataList = [];
    dbList.forEach(info => {
        dataList.push({
            key:info.title,
            value:info.id
        });
    });
    return {dataList}
}


//todo
export async function statsWenZhangCount(type:number) {

}


