/**
 * 变更审批
 */
import * as applyBiz from "../../biz/member/apply";
import { ADMINLV } from "../../config/enum";


export const FirstName = '变更审批';
export const FirstRouter = '/manage/apply';
export const Config = {
    "变更审批管理":[
        {
            apiName:"变更审批列表",
            subUrl:'/applydb/applylist',
            param:[ // name, joinStartTime, joinEndTime, beforeChange, memberLevel, pageNumber
                {key:"name", type:"String", desc:"单位/个人名称", isNull:true},
                {key:"memberType", type:"[Number]", desc:"会员类别", isNull:true},
                // {key:"unitMemberType", type:"Number", desc:"会员类别", isNull:true},
                // {key:"joinStartTime", type:"Number", desc:"入会开始时间", isNull:true},
                // {key:"joinEndTime", type:"Number", desc:"入会结束时间", isNull:true},
                // {key:"beforeChange", type:"[Number]", desc:"变更前会员等级职务", isNull:true},
                // {key:"memberLevel", type:"[Number]", desc:"变更后会员等级职务", isNull:true},
                // {key:"memberCategory", type:"Number", desc:"会员类别", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页"},
                {key:"pageSize", type:"Number", desc:"一页大小"}
            ],
            bindBiz:applyBiz.applyList
        },
        {
            apiName:"变更审批通过",
            subUrl:'/applydb/applyadopt',
            param:[
                {key:"id", type:"String", desc:"用户id"},
                {key:"takeeffectType", type:"Number", desc:"生效类型"},
            ],
            bindBiz:applyBiz.applyAdopt
        },
        {
            apiName:"批量通过",
            subUrl:'/applydb/applybatchadopt',
            param:[
                {key:"idList", type:"[String]", desc:"批量通过的用户列表"},
            ],
            bindBiz:applyBiz.applyBatchAdopt
        },
        {
            apiName:"驳回",
            subUrl:'/applydb/applyreject',
            param:[
                {key:"id", type:"String", desc:"用户id"},
                {key:"remarks", type:"String", desc:"驳回理由"}
            ],
            bindBiz:applyBiz.applyReject
        },
        {
            apiName:"数据导出",
            subUrl:'/applydb/outputapply',
            param:[
            ],
            bindBiz:applyBiz.outPutApply
        },
        {
            apiName:"理事审批历史",
            subUrl:'/applydb/applyhistorylist', 
            param:[
                {key:"id", type:"String", desc:"用户id"},
            ],
            bindBiz:applyBiz.applyHistoryList
        },
        //=========================资料变更
        {
            apiName:"资料变更列表",
            subUrl:'/applydb/infomationchange/list', 
            param:[
                {key:"name", type:"String", desc:"关键字搜索", isNull:true},
                {key:"changeState", type:"Number", desc:"筛选状态 0是全部 1是通过 2是待审批 3是驳回修改 4是驳回提交", isNull:true},
                {key:"unitMemberType", type:"[Number]", desc:"会员类别", isNull:true},
                {key:"uscc", type:"String", desc:"统一信用代码", isNull:true},
                {key:"legalPerson", type:"String", desc:"法人代表", isNull:true},
                {key:"legalPersonPhone", type:"String", desc:"法人联系电话", isNull:true},
                {key:"legalPersonMail", type:"String", desc:"法人邮箱", isNull:true},
                {key:"pageNumber", type:"Number", desc:"分页"},
                {key:"pageSize", type:"Number", desc:"一页显示大小"},
            ],
            bindBiz:applyBiz.infomationChangeList
        },
        {
            apiName:"资料变更通过",
            subUrl:'/applydb/infomationchange/pass', 
            param:[
                {key:"infoChangeId", type:"String", desc:"标识"},
            ],
            bindBiz:applyBiz.infomationChangePass
        },
        {
            apiName:"资料变更批量通过",
            subUrl:'/applydb/infomationchange/manypass', 
            param:[
                {key:"infoChangeIdList", type:"[String]", desc:"标识"},
            ],
            bindBiz:applyBiz.infomationChangeManyPass
        },
        {
            apiName:"资料变更导出",
            subUrl:'/applydb/infomationchange/outputlist', 
            param:[
                {key:"name", type:"String", desc:"关键字搜索", isNull:true},
                {key:"changeState", type:"Number", desc:"筛选状态 0是全部 1是通过 2是待审批 3是驳回修改", isNull:true},
                {key:"exportColumns", type:"[Object]", desc:"导出字段"}
            ],
            bindBiz:applyBiz.outPutInfomationChangeList
        },
        {
            apiName:"资料变更审批历史",
            subUrl:'/applydb/infomationchange/log', 
            param:[
                {key:"infoChangeId", type:"String", desc:"标识"},
            ],
            bindBiz:applyBiz.infomationChangeLog
        },
        {
            apiName:"资料变更审批历史单个信息",
            subUrl:'/applydb/infomationchange/logbykeystr', 
            param:[
                {key:"infoChangeId", type:"String", desc:"标识"},
                {key:"keyStr", type:"String", desc:"变更字段"},
            ],
            bindBiz:applyBiz.infomationChangeKeyStr
        },
        {
            apiName:"资料变更审批驳回",
            subUrl:'/applydb/infomationchange/out', 
            param:[
                {key:"infoChangeId", type:"String", desc:"标识"},
                {key:"rejectRemarks", type:"String", desc:"驳回理由"},
            ],
            bindBiz:applyBiz.infomationChangeOut
        }
    ],
    "理事名单":[
        {
            apiName:"理事会员列表",
            subUrl:'/lishi/list',
            param:[
                {key:"name", type:"String", desc:"单位/个人名称", isNull:true},
                {key:"memberType", type:"Number", desc:"会员类别", isNull:true},
                {key:"phone", type:"String", desc:"当前页", isNull:true},
                {key:"memberLevel", type:"Number", desc:"一页大小", isNull:true},
                {key:"memberState", type:"Number", desc:"一页大小", isNull:true},
                {key:"year", type:"Number", desc:"一页大小", isNull:true},
                {key:"pageNumber", type:"Number", desc:"一页大小"},
                {key:"pageSize", type:"Number", desc:"一页大小"},
            ],
            bindBiz:applyBiz.liShiList
        },
    ]
}
 
 
 
 
 
 
 
 