// This file is auto-generated, don't edit it

import { MAILTYPE, MSGTYPE } from "../config/enum";
import { ERRORENUM } from "../config/errorEnum";
import { BizError } from "../util/bizError";
import { logError } from "../util/log";
import { changeEnumValue } from "../util/verificationEnum";

// 依赖的模块可通过下载工程中的模块依赖文件或右上角的获取 SDK 依赖信息查看
const Dysmsapi20170525 = require('@alicloud/dysmsapi20170525');
const OpenApi = require('@alicloud/openapi-client');
const Util = require('@alicloud/tea-util');
const Credential = require('@alicloud/credentials');
const Tea = require('@alicloud/tea-typescript');


let smsClient;

export async function initSMS() {
    // // 工程代码泄露可能会导致 AccessKey 泄露，并威胁账号下所有资源的安全性。以下代码示例仅供参考。
    // // 建议使用更安全的 STS 方式，更多鉴权访问方式请参见：https://help.aliyun.com/document_detail/378664.html。
    // let config = new OpenApi.Config({
    //     // 必填，请确保代码运行环境设置了环境变量 ALIBABA_CLOUD_ACCESS_KEY_ID。
    //     accessKeyId: 'LTAI5tD7Finu3fxFMCi3415S',
    //     // 必填，请确保代码运行环境设置了环境变量 ALIBABA_CLOUD_ACCESS_KEY_SECRET。
    //     accessKeySecret: 'sbPR0AdDPfjm7v2NSffk5apPm6UClV',
    // });
    // // Endpoint 请参考 https://api.aliyun.com/product/Dypnsapi
    // config.endpoint = `dypnsapi.aliyuncs.com`;
    // smsClient =  new Dypnsapi20170525.default(config);

    const credentialsConfig = new Credential.Config({
        // 凭证类型。
        type: 'access_key',
        // 设置accessKeyId值，此处已从环境变量中获取accessKeyId为例。
        accessKeyId: 'LTAI5tD7Finu3fxFMCi3415S',
        // 设置accessKeySecret值，此处已从环境变量中获取accessKeySecret为例。
        accessKeySecret: 'sbPR0AdDPfjm7v2NSffk5apPm6UClV',
    });
    let credentialClient = new Credential.default(credentialsConfig);
    const ecsConfig = new OpenApi.Config();
    ecsConfig.endpoint = 'dysmsapi.aliyuncs.com'; // 配置云产品服务接入地址（endpoint）。
    ecsConfig.credential = credentialClient; // 使用Credentials配置凭证。
    smsClient = new Dysmsapi20170525.default(ecsConfig);
}


export async function sendALSMS(code:string, phone:string ) {
    let sendSmsRequest = new Dysmsapi20170525.SendSmsRequest({
        phoneNumbers: phone,
        signName: '中国艺术职业教育学会',
        templateCode: 'SMS_296230597',
        templateParam: `{"code":"${code}"}`,
    });
    let runtime = new Util.RuntimeOptions({ });
    try {
        // 复制代码运行请自行打印 API 的返回值
        await smsClient.sendSmsWithOptions(sendSmsRequest, runtime);
    } catch (error) {
        // 此处仅做打印展示，请谨慎对待异常处理，在工程项目中切勿直接忽略异常。
        // 错误 message
        console.log(error.message);
        // 诊断地址
        console.log(error.data["Recommend"]);
        Util.default.assertAsString(error.message);
    }    
  
  return 
    // try {
    //     /**先生成request */
    //     let requstParam = new Dypnsapi20170525.SendSmsRequest({
    //         phoneNumber: phone,
    //         signName: '中国艺术职业教育学会',
    //         templateCode: 'SMS_468140012',//老的 SMS_296230597
    //         templateParam: `{"code":"${code}"}`,
    //         // templateParam:code
    //     });
    //     //发起调用+
    //     let runtime = new Util.RuntimeOptions({});
    //     const resp = await smsClient.sendSmsWithOptions(requstParam, runtime);
    //     console.log(resp)
    // } catch(err) {
    //     throw new BizError(ERRORENUM.短信验证码发送失败, err);
    // }
}


export async function sendPassNotice(phone:string, name:string) {
     let sendSmsRequest = new Dysmsapi20170525.SendSmsRequest({
        phoneNumbers: phone,
        signName: '中国艺术职业教育学会',
        templateCode: 'SMS_467160001',
        templateParam: `{"name":"${name}"}`,
    });
    let runtime = new Util.RuntimeOptions({ });
    try {
        // 复制代码运行请自行打印 API 的返回值
        await smsClient.sendSmsWithOptions(sendSmsRequest, runtime);
    } catch (error) {
        // 此处仅做打印展示，请谨慎对待异常处理，在工程项目中切勿直接忽略异常。
        // 错误 message
        console.log(error.message);
        // 诊断地址
        console.log(error.data["Recommend"]);
        Util.default.assertAsString(error.message);
    }    

}



// export async function test() {
//     // await check();
//     let phone1 = "18711017326";//17274689187
//     await sendALSMS("3321", phone1);
//     // let phone2 = "16621071125";
//     // await sendALSMS("1234", phone2);
//     // let phone3 = "18120935727";
//     // await sendALSMS("1234", phone3);
//     // let param = {name:"测试测试1"};
//     // await sendMessage(phone, param, MSGTYPE.审核期间驳回通知, 1);
//     // await sendMessage(phone, param, MSGTYPE.审核期间驳回通知, 2);
//     // await sendMessage(phone, param, MSGTYPE.审核通过以及缴费通知);
//     // await sendMessage(phone, param, MSGTYPE.会员缴费财务驳回无需退款);
//     // await sendMessage(phone, param, MSGTYPE.会员缴费财务驳回需退款);
//     // await sendMessage(phone, param, MSGTYPE.会员缴费成功后针对线下汇款财务审核通过的时候发送);
//     // await sendMessage(phone, param, MSGTYPE.会员会费到期缴费通知);
//     // await sendMessage(phone, param, MSGTYPE.会员催缴通知提前开发票);
//     // await sendMessage(phone, param, MSGTYPE.会员宽限期最后一天);
//     // await sendMessage(phone, param, MSGTYPE.往期欠费通知);
//     // await sendMessage(phone, param, MSGTYPE.变更驳回);
//     // await sendMessage(phone, param, MSGTYPE.变更已通过);
//     // await sendMessage(phone, param, MSGTYPE.会员活动or会议通知);
//     // await sendMessage(phone, param, MSGTYPE.会员活动or会议催促未报名人员通知);
//     // await sendMessage(phone, param, MSGTYPE.财务退款通知);

//     console.log("验证码测试完成");
// }


export async function sendMessage(phone, param, type, subType?) {
    let templateCode = "";
    let templateParam = JSON.stringify(param);
    switch (type) {
        case MSGTYPE.审核期间驳回通知:
            if (subType == 1) templateCode = "SMS_488195065";//重新提交
            else templateCode = "SMS_488280139";//不提示重新提交
        break;
        case MSGTYPE.审核通过以及缴费通知:
            templateCode = "SMS_488270030";
        break;
        case MSGTYPE.会员缴费财务驳回无需退款:
            templateCode = "SMS_488035070";
        break;
        case MSGTYPE.会员缴费财务驳回需退款:
            templateCode = "SMS_488035070";
        break;
        case MSGTYPE.会员缴费成功后针对线下汇款财务审核通过的时候发送:
            templateCode = "SMS_488060068";
        break;
        case MSGTYPE.会员会费到期缴费通知://这里还没做
            templateCode = "SMS_488040064";
        break;
        case MSGTYPE.会员催缴通知提前开发票:
            templateCode = "SMS_488135059";
        break;
        case MSGTYPE.会员宽限期最后一天:
            templateCode = "SMS_488040064";
        break;
        case MSGTYPE.往期欠费通知:
            templateCode = "SMS_488285027";
        break;
        case MSGTYPE.变更驳回:
            templateCode = "SMS_488285032";
        break;
        case MSGTYPE.变更已通过:
            templateCode = "SMS_488155068";
        break;
        case MSGTYPE.会员活动or会议通知:
            templateCode = "SMS_488295010";
        break;
        case MSGTYPE.会员活动or会议催促未报名人员通知:
            templateCode = "SMS_488205063";
        break;
        case MSGTYPE.财务退款通知:
            templateCode = "SMS_488180065";
        break;
    }

    try {
         let sendSmsRequest = new Dysmsapi20170525.SendSmsRequest({
            phoneNumbers: phone,
            signName: '中国艺术职业教育学会',
            templateCode,
            templateParam,
        });
        let runtime = new Util.RuntimeOptions({ });
         await smsClient.sendSmsWithOptions(sendSmsRequest, runtime);

    } catch(err) {
        logError("发送通知短信失败", phone, err);
        console.log("发送通知短信失败",phone, err);
    }

}