//数据导入

import { getCityCodeByName } from "../config/cityConfig";
import { DOCUMENTTYPE, NATION, SEX, PROFCATEGORY, MEMBERTYPE, STATE, INDIVIDUALMEMBERTYPE, REGISTERFLOW, CERTIFICATETYPE, USERREGISTERSTATE, UNITMEMBERTYPE } from "../config/enum";
import { addManyData } from "../data/add";
import { TABLEENUM } from "../data/models/model";
import { generateToken, generateUserId } from "../tools/system";
import { onceSheetBecomeOfblockData } from "../util/analysisExcel";


export async function inputData() {

    let data:any = await onceSheetBecomeOfblockData('20240517.xlsx', 'Sheet1');

    let changeMap = {
        "2":"name",
        "3":{value:"sex", enumConf:SEX},
        "4":{value:"documentType", enumConf:DOCUMENTTYPE},
        "5":"documentId",
        "7":"unitName",
        "9":{value:"nation", enumConf:NATION},
        "10":"duties",
        "11":{value:"sheng", addConf:"sheng"},
        "12":{value:"shi", addConf:"shi"},
        "13":{value:"qu", addConf:"qu"},
        "15":"addres",
        // "16":"phone",//电话有缺失
        "18":"mail",
        "19":{value:"askForTime", ms:true},
        "27":"workTitle",
        "28":{value:"profCategory", enumConfs:PROFCATEGORY},
        "29":"studyResume",
        "30":"workResume",
        "31":"profAchievement",
        "32":"otherEMP",
        "33":"otherPROF",
        "44":"phone",
        "42":"loginId"
    };

    let phoneDistinctMap = {};//电话去重
    let loginIdDistinctMap = {};//登录号去重

    let addList = [];
    data[0].blockData.forEach((subList, index) => {
        if (!index) return;
        let addInfo:any = {};

        for (let key in changeMap) {
            let changeIndex = parseInt(key);
            let dataKeyInfo = changeMap[key];
            let dataKey = "";
            let dataValue = subList[changeIndex];
            if (typeof dataKeyInfo == "string") {
                dataKey = dataKeyInfo;
                dataValue = subList[changeIndex] || "";
            }
            else {
                dataKey = dataKeyInfo.value;
                if (dataKeyInfo.enumConf) {
                    let itemdataValue = dataKeyInfo.enumConf[dataValue];
                    if (!itemdataValue) console.log("异常，001", subList[2], key,dataKey, dataValue);
                    else dataValue = itemdataValue;
                }
                if (dataKeyInfo.addConf) {
                    let itemdataValue = getCityCodeByName(dataValue);
                    if (!itemdataValue) console.log("异常，002", subList[2], key, dataKey,dataValue);
                    else dataValue = itemdataValue;
                }
                if (dataKeyInfo.enumConfs) {
                    let itemdataValue = dataValue.split(",");
                    let itemList = [];
                    itemdataValue.forEach(item => {
                        if (item && item != " ") {
                            let itemdataValue = dataKeyInfo.enumConfs[item];
                            if (!itemdataValue) console.log("异常，003",  subList[2], key, dataKey, item);
                            else itemList.push(itemdataValue);
                        }
                    });
                    dataValue = itemList;
                }
                if (dataKeyInfo.ms) {
                    dataValue = new Date(dataValue).valueOf();
                }

            }
            addInfo[dataKey] = dataValue;
        }
        //**固定字段 */
        addInfo.userId = generateUserId(addInfo.phone);
        addInfo.memberType = MEMBERTYPE.个人会员;
        addInfo.isAdmin = STATE.否;
        addInfo.pwd = "asdfasdfasdfsa";
        addInfo.token = generateToken( addInfo.userId);
        addInfo.individualMemberType = INDIVIDUALMEMBERTYPE.普通会员;
        addInfo.registerFlow = REGISTERFLOW.完成第二步;
        addInfo.isInput = true;
        addInfo.userRegisterState = USERREGISTERSTATE.待审核;
        addInfo.certificateType = CERTIFICATETYPE.普通会员证书
        addInfo.isFirstPay = false;

        if (phoneDistinctMap[addInfo.phone]) {
            console.log("重复号码", phoneDistinctMap[addInfo.phone]);
        } 
        if (phoneDistinctMap[addInfo.loginId]) {
            console.log("重复loginId", phoneDistinctMap[addInfo.loginId]);
        } 
        addList.push(addInfo);

    });

    await addManyData(TABLEENUM.用户表, addList);


    console.log("数据导入成功");
}




























export async function inputUnitData() {

    let data:any = await onceSheetBecomeOfblockData('ass_company.xls', 'Sheet1');

    let changeMap = {
        "2":"name",
        "3":{value:"sex", enumConf:SEX},
        "4":{value:"documentType", enumConf:DOCUMENTTYPE},
        "5":"documentId",
        "7":"unitName",
        "9":{value:"nation", enumConf:NATION},
        "10":"duties",
        "11":{value:"sheng", addConf:"sheng"},
        "12":{value:"shi", addConf:"shi"},
        "13":{value:"qu", addConf:"qu"},
        "15":"addres",
        // "16":"phone",//电话有缺失
        "18":"mail",
        "19":{value:"askForTime", ms:true},
        "27":"workTitle",
        "28":{value:"profCategory", enumConfs:PROFCATEGORY},
        "29":"studyResume",
        "30":"workResume",
        "31":"profAchievement",
        "32":"otherEMP",
        "33":"otherPROF",
        "44":"phone",
        "42":"loginId"
    };

    let phoneDistinctMap = {};//电话去重
    let loginIdDistinctMap = {};//登录号去重

    let addList = [];
    data[0].blockData.forEach((subList, index) => {
        if (!index) return;
        let addInfo:any = {};

        for (let key in changeMap) {
            let changeIndex = parseInt(key);
            let dataKeyInfo = changeMap[key];
            let dataKey = "";
            let dataValue = subList[changeIndex];
            if (typeof dataKeyInfo == "string") {
                dataKey = dataKeyInfo;
                dataValue = subList[changeIndex] || "";
            }
            else {
                dataKey = dataKeyInfo.value;
                if (dataKeyInfo.enumConf) {
                    let itemdataValue = dataKeyInfo.enumConf[dataValue];
                    if (!itemdataValue) console.log("异常，001", subList[2], key,dataKey, dataValue);
                    else dataValue = itemdataValue;
                }
                if (dataKeyInfo.addConf) {
                    let itemdataValue = getCityCodeByName(dataValue);
                    if (!itemdataValue) console.log("异常，002", subList[2], key, dataKey,dataValue);
                    else dataValue = itemdataValue;
                }
                if (dataKeyInfo.enumConfs) {
                    let itemdataValue = dataValue.split(",");
                    let itemList = [];
                    itemdataValue.forEach(item => {
                        if (item && item != " ") {
                            let itemdataValue = dataKeyInfo.enumConfs[item];
                            if (!itemdataValue) console.log("异常，003",  subList[2], key, dataKey, item);
                            else itemList.push(itemdataValue);
                        }
                    });
                    dataValue = itemList;
                }
                if (dataKeyInfo.ms) {
                    dataValue = new Date(dataValue).valueOf();
                }

            }
            addInfo[dataKey] = dataValue;
        }
        //**固定字段 */
        addInfo.userId = generateUserId(addInfo.phone);
        addInfo.memberType = MEMBERTYPE.单位会员;
        addInfo.isAdmin = STATE.否;
        addInfo.pwd = "asdfasdfasdfsa";
        addInfo.token = generateToken( addInfo.userId);
        // addInfo.individualMemberType = UNITMEMBERTYPE.院校;
        addInfo.unitMemberType = UNITMEMBERTYPE.院校;
        addInfo.registerFlow = REGISTERFLOW.完成第三步;
        addInfo.isInput = true;
        addInfo.userRegisterState = USERREGISTERSTATE.待审核;
        addInfo.certificateType = CERTIFICATETYPE.常务理事证书
        addInfo.isFirstPay = false;

        addList.push(addInfo);

    });

    await addManyData(TABLEENUM.用户表, addList);

    console.log("数据导入成功");
}


























