import * as userBiz from "../../biz/member/user";
import * as memberBiz from "../../biz/member/member";
import * as examineBiz from "../../biz/member/examine";
import * as memberFeesBiz from "../../biz/member/memberFees";
import * as authorityBiz from "../../biz/member/authority";
import * as registerBiz from "../../biz/register";
import * as homePageBiz from "../../biz/member/homePage";

export const FirstName = '会员管理路由';
export const FirstRouter = '/manage/member';
export const Config = {
    "用户注册":[
        {
            apiName:"个人入会流程1",
            subUrl:'/memberdb/memberregister1',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        loginId:{type:'String', desc:'用户名'},
                        mail:{type:'String', desc:'邮箱'},
                        pwd:{type:'String', desc:'密码'},
                        confirmation:{type:'String', desc:'确认密码'},
                        phone:{type:'String', desc:'联系人手机号'},
                        codeNum:{type:'String', desc:'验证码'},
                    }
                }
            ],
            bindBiz:registerBiz.memberRegister1
        },
        {
            apiName:"个人入会流程2",
            subUrl:'/memberdb/memberregister2',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        name:{type:'String', desc:'真实姓名', notMustHave:false},
                        sex:{type:'Number', desc:'性别', notMustHave:false},
                        documentType:{type:'Number', desc:'证件类型', notMustHave:false},
                        documentId:{type:'String', desc:'证件号码', notMustHave:false},
                        birth:{type:'Number', desc:'出生年月', notMustHave:false},
                        nation:{type:'Number', desc:'民族', notMustHave:false},
                        sheng:{type:'String', desc:'省', notMustHave:false},
                        shi:{type:'String', desc:'市', notMustHave:false},
                        qu:{type:'String', desc:'区', notMustHave:false},
                        addres:{type:'String', desc:'通信地址', notMustHave:false},
                        education:{type:'Number', desc:'学历', notMustHave:false},
                        photoUrl:{type:'String', desc:'蓝底证件照', notMustHave:false},
                        workUnit:{type:'String', desc:'工作单位', notMustHave:false},
                        duties:{type:'String', desc:'职务', notMustHave:false},
                        workTitle:{type:'String', desc:'职称', notMustHave:false},
                        profCategory:{type:'Number', desc:'专业类别', notMustHave:false},
                        studyResume:{type:'String', desc:'学习简历', notMustHave:false},
                        workResume:{type:'String', desc:'工作简历', notMustHave:false},
                        profAchievement:{type:'String', desc:'专业成果', notMustHave:false},
                        otherEMP:{type:'String', desc:'在其他社会组织任职情况', notMustHave:false},
                        otherPROF:{type:'String', desc:'其他与本学会专业有关的情况', notMustHave:false},
                        cardUrl:{type:'[String]', desc:'个人身份证扫描件', notMustHave:false},
                        academicCERTUrl:{type:'String', desc:'个人学历证明扫描件', notMustHave:false},
                        professionalCERTUrl:{type:'String', desc:'个人工作证明扫描件', notMustHave:false},
                        auxiliaryMaterial:{type:'[String]', desc:'论文发表等证明工作成果或成绩的材料', notMustHave:false},
                    }
                },
                {
                    key:"userId", type:"String", desc:"用户id"
                }
            ],
            bindBiz:registerBiz.memberRegister2
        },
        {
            apiName:"单位入会流程1",
            subUrl:'/memberdb/unitmemberregister1',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        loginId:{type:'String', desc:'用户名', notMustHave:false},
                        mail:{type:'String', desc:'邮箱', notMustHave:false},
                        pwd:{type:'String', desc:'密码', notMustHave:false},
                        confirmation:{type:'String', desc:'确认密码', notMustHave:false},
                        phone:{type:'String', desc:'联系人手机号', notMustHave:false},
                        codeNum:{type:'String', desc:'验证码', notMustHave:false},
                    }
                }
            ],
            bindBiz:registerBiz.unitMemberRegister1
        },
        {
            apiName:"单位入会流程2",
            subUrl:'/memberdb/unitmemberregister2',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        unitName:{type:'String', desc:'单位名称', notMustHave:false},
                        sheng:{type:'String', desc:'省', notMustHave:false},
                        shi:{type:'String', desc:'市', notMustHave:false},
                        qu:{type:'String', desc:'区', notMustHave:false},
                        addres:{type:'String', desc:'通信地址', notMustHave:false},
                        uscc:{type:'String', desc:'单位信用代码', notMustHave:false},
                        legalPerson:{type:'String', desc:'法人代表', notMustHave:false},
                        legalPersonPhone:{type:'String', desc:'法人联系电话', notMustHave:false},
                        legalPersonMail:{type:'String', desc:'法人邮箱', notMustHave:false},
                        unitMail:{type:'String', desc:'单位电子邮箱', notMustHave:false},
                        contactPerson:{type:'String', desc:'日常联系人', notMustHave:false},
                        contactPersonDuties:{type:'String', desc:'日常联系人职务', notMustHave:false},
                        contactPersonPhone:{type:'String', desc:'日常联系人手机', notMustHave:false},
                        uusinessLicenseUrl:{type:'String', desc:'营业执照复印件', notMustHave:false},
                        /**单位信息 */
                        unitMemberType:{type:'Number', desc:'单位信息类型，枚举', notMustHave:false},
                        yuanXiaoBanXueLeiXing:{type:'Number', desc:'院校办学类型，枚举', notMustHave:false},
                        yuanXiaoZhuGuanBuMen:{type:'String', desc:'院校主管部门', notMustHave:false},
                        yuanXiaoFuZeRen:{type:'String', desc:'院校主要负责人', notMustHave:false},
                        yuanXiaoFuZeRenZhiWu:{type:'String', desc:'院校主要负责人职务', notMustHave:false},
                        yuanXiaoFuZeRenDianHua:{type:'String', desc:'院校主要负责人电话', notMustHave:false},
                        yuanXiaoBanGongFuZeRen:{type:'String', desc:'院校办公负责人', notMustHave:false},
                        yuanXiaoBanGongFuZeRenDianHua:{type:'String', desc:'院校办公负责人电话', notMustHave:false},
                        ZhuYaoFuZeRenYouXiang:{type:'String', desc:'主要负责人邮箱', notMustHave:false},
                        yuanXiaoKeYanFuZeRen:{type:'String', desc:'院校科研负责人', notMustHave:false},
                        yuanXiaoKeYanFuZeRenDianHua:{type:'String', desc:'院校科研负责人电话', notMustHave:false},
                        jiaoXueFuZeRenXinMing:{type:'String', desc:'教学负责人姓名', notMustHave:false},
                        yuanXiaoXueShengZongRenShu:{type:'String', desc:'院校学生总人数', notMustHave:false},
                        yuanXiaoJiaoZhiGongZongRenShu:{type:'String', desc:'院校教职工总人数', notMustHave:false},
                        jiaoXueFuZeRenDianHua:{type:'String', desc:'教学负责人电话', notMustHave:false},
                    }
                },
                {
                    key:"keyanForm", type:"[Object]", desc:"单位所获得科研成果表单"
                },
                {
                    key:"userId", type:"String", desc:"用户id"
                }
            ],
            bindBiz:registerBiz.unitMemberRegister2
        },
        {
            apiName:"单位入会流程3",
            subUrl:'/memberdb/unitmemberregister2',
            param:[
                {
                    key:"application", type:"String", desc:"入会申请表"
                },
                {
                    key:"userId", type:"String", desc:"用户id"
                }
            ],
            bindBiz:registerBiz.unitMemberRegister3
        },
        {
            apiName:"发送短信验证码",
            subUrl:'/memberdb/registersendcode',
            param:[
                {key:"loginId", type:"String", desc:"用户名"},
                {key:"phone", type:"String", desc:"联系人手机号"},
                {key:"codeType", type:"Number", desc:"验证码类型枚举"}
            ],
            bindBiz:registerBiz.memberRegisterSendCode
        },
        {
            apiName:"获取当前会员注册流程",
            subUrl:'/memberdb/registerflowtype',
            param:[
                {key:"userId", type:"String", desc:"用户id"},
            ],
            bindBiz:registerBiz.registerFlowType
        }
    ],
    "登陆相关":[
        {
            apiName:"登陆",
            subUrl:'/login', 
            param:[
                {key:"lolginId", type:"String", desc:"账号"},
                {key:"pwd", type:"String", desc:"密码"}
            ],
            bindBiz:userBiz.login
        },
        {
            apiName:"注销登陆",
            subUrl:'/logout',
            param:[
            ],
            bindBiz:userBiz.logout
        },
    ],
    "会员库":[
        {
            apiName:"单位会员列表",
            subUrl:'/memberdb/unitmemberlist',//路径全小写 
            param:[
                {key:"unitName", type:"String", desc:"单位名称", isNull:true},
                {key:"joinTime", type:"Number", desc:"入会时间", isNull:true},
                {key:"unitMemberType", type:"Number", desc:"单位会员类型", isNull:true},
                {key:"memberLevel", type:"Number", desc:"会员等级职务", isNull:true},
                {key:"session", type:"Number", desc:"届次时间戳", isNull:true},
                {key:"sheng", type:"String", desc:"省", isNull:true},
                {key:"shi", type:"String", desc:"市", isNull:true},
                {key:"qu", type:"String", desc:"区", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页"}
            ],
            bindBiz:memberBiz.unitMemberList
        },
        {
            apiName:"个人会员列表",
            subUrl:'/memberdb/individualmemberlist',
            param:[
                {key:"name", type:"String", desc:"姓名", isNull:true},
                {key:"documentId", type:"String", desc:"身份证", isNull:true},
                {key:"phone", type:"String", desc:"手机号", isNull:true},
                {key:"individualMemberType", type:"Number", desc:"级别、会员类型", isNull:true},
                {key:"memberLevel", type:"Number", desc:"会员等级", isNull:true},
                {key:"session", type:"Number", desc:"届次时间戳", isNull:true},
                {key:"joinTime", type:"Number", desc:"入会时间", isNull:true},
                {key:"auditTime", type:"Number", desc:"审核时间", isNull:true},
                {key:"memberState", type:"Number", desc:"状态", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页"}
            ],
            bindBiz:memberBiz.individualMemberList
        },
        {
            apiName:"单位会员详情",
            subUrl:'/memberdb/unitmemberdetails',
            param:[
                {key:"id", type:"String", desc:"用户id"}
            ],
            bindBiz:memberBiz.unitMemberDetails
        },
        {
            apiName:"个人会员详情",
            subUrl:'/memberdb/individualmemberdetails',
            param:[
                {key:"id", type:"String", desc:"用户id"}
            ],
            bindBiz:memberBiz.individualMemberDetails
        },
        {
            apiName:"删除单位所获得科研成果",
            subUrl:'/memberdb/delresearch',
            param:[
                {key:"id", type:"String", desc:"单位会员列表下发的标识"}
            ],
            bindBiz:memberBiz.delResearch
        },
        {
            apiName:"单位会员修改",
            subUrl:'/memberdb/unitmemberupdate',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        /**基本信息 */
                        unitName:{type:'String', desc:'单位名称'},
                        addres:{type:'String', desc:'通信地址'},
                        uscc:{type:'String', desc:'单位信用代码'},
                        legalPerson:{type:'String', desc:'法人代表'},
                        legalPersonPhone:{type:'String', desc:'法人联系电话'},
                        contactPerson:{type:'String', desc:'日常联系人'},
                        contactPersonDuties:{type:'String', desc:'日常联系人职务'},
                        sheng:{type:'String', desc:'省'},
                        shi:{type:'String', desc:'市'},
                        qu:{type:'String', desc:'区'},
                        uusinessLicenseUrl:{type:'String', desc:'营业执照'},
                        /**单位信息 */
                        unitMemberType:{type:'Number', desc:'单位信息类型'},
                        yuanXiaoBanXueLeiXing:{type:'String', desc:'院校办学类型'},
                        yuanXiaoZhuGuanBuMen:{type:'String', desc:'院校主管部门'},
                        yuanXiaoFuZeRen:{type:'String', desc:'院校主要负责人'},
                        yuanXiaoFuZeRenZhiWu:{type:'String', desc:'院校主要负责人职位'},
                        yuanXiaoFuZeRenDianHua:{type:'String', desc:'院校主要负责人电话'},
                        yuanXiaoBanGongFuZeRen:{type:'String', desc:'院校办公负责人'},
                        yuanXiaoBanGongFuZeRenZhiWu:{type:'String', desc:'院校办公负责人职位'},
                        yuanXiaoBanGongFuZeRenDianHua:{type:'String', desc:'院校办公负责人电话'},
                        yuanXiaoKeYanFuZeRen:{type:'String', desc:'院校科研负责人'},
                        yuanXiaoKeYanFuZeRenZhiWu:{type:'String', desc:'院校科研负责人职位'},
                        yuanXiaoKeYanFuZeRenDianHua:{type:'String', desc:'院校科研负责人电话'},
                        yuanXiaoXueShengZongRenShu:{type:'String', desc:'院校学生总数'},
                        yuanXiaoJiaoZhiGongZongRenShu:{type:'String', desc:'院校教职工总人数'},
                        yuanXiaoJianZhuMianJi:{type:'String', desc:'院校建筑总面积'},
                        yuanXiaoGaoJiZhiCheng:{type:'String', desc:'院校高级职称人数'},
                        yuanXiaoKaiSheZhuanYe:{type:'String', desc:'院校专业总数'},
                    },
                    desc:"表单"
                },
                {
                    key:"keyanForm", type:"Object", sub:
                    {
                        startTime:{type:'Number', desc:'开始时间'},
                        endTime:{type:'Number', desc:'结束时间'},
                        describe:{type:'String', desc:'科研描述'},
                    },
                    desc:"单位所获得科研成果表单"
                },
                {
                    key:"id", type:"String", desc:"用户id"
                }
            ],
            bindBiz:memberBiz.unitMemberUpdate
        },
        {
            apiName:"个人会员修改",
            subUrl:'/memberdb/memberupdate',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        /**基本信息 */
                        name:{type:'String', desc:'真实姓名'},
                        sex:{type:'Number', desc:'性别'},
                        nation:{type:'Number', desc:'民族'},
                        birth:{type:'Number', desc:'出身年月'},
                        documentType:{type:'Number', desc:'证件类型'},
                        documentId:{type:'String', desc:'证件号码'},
                        sheng:{type:'String', desc:'省'},
                        shi:{type:'String', desc:'市'},
                        qu:{type:'String', desc:'区'},
                        addres:{type:'String', desc:'通信地址'},
                        photoUrl:{type:'String', desc:'蓝底证件照'},
                        /**专业信息 */
                        workUnit:{type:'String', desc:'工作单位'},
                        memberLevel:{type:'Number', desc:'会员等级职务'},
                        workTitle:{type:'String', desc:'职称'},
                        profCategory:{type:'Number', desc:'专业类别'},
                        studyResume:{type:'String', desc:'学习简历'},
                        workResume:{type:'String', desc:'工作简历'},
                        profAchievement:{type:'String', desc:'教研成果'},
                        otherEMP:{type:'String', desc:'其他组织任职情况'},
                        otherPROF:{type:'String', desc:'其他情况'},
                        /**其他附件 */
                        cardUrl:{type:'[String]', desc:'个人身份扫描件'},
                        academicCERTUrl:{type:'String', desc:'个人学历证明扫描件'},
                        professionalCERTUrl:{type:'String', desc:'个人工作证明扫描件'},
                        auxiliaryMaterial:{type:'[String]', desc:'论文发表或成绩材料'},
                    }
                },
                {
                    key:"id", type:"String", desc:"用户id"
                }
            ],
            bindBiz:memberBiz.individualMemberUpdate
        }
    ],
    "审批管理":[
        {
            apiName:"待审核列表",
            subUrl:'/examine/pendingreview', 
            param:[
                {key:"unitName", type:"String", desc:"单位名称", isNull:true},
                {key:"joinTime", type:"Number", desc:"入会时间", isNull:true},
                {key:"memberType", type:"Number", desc:"会员类别", isNull:true},
                {key:"sheng", type:"String", desc:"省", isNull:true},
                {key:"shi", type:"String", desc:"市", isNull:true},
                {key:"qu", type:"String", desc:"区", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页"}
            ],
            bindBiz:examineBiz.pendingReviewList
        },
        {
            apiName:"通过审批",
            subUrl:'/examine/adopt', 
            param:[
                {key:"userId", type:"String", desc:"待审核列表返回的用户id"}
            ],
            bindBiz:examineBiz.adopt
        },
        {
            apiName:"驳回审批",
            subUrl:'/examine/pendingreview', 
            param:[
                {key:"userId", type:"String", desc:"待审核列表返回的用户id"},
                {key:"remarks", type:"String", desc:"驳回理由"}
            ],
            bindBiz:examineBiz.reject
        },
        {
            apiName:"审批历史",
            subUrl:'/examine/approvalhistorylist', 
            param:[
                {key:"userId", type:"String", desc:"待审核列表返回的用户id"},
            ],
            bindBiz:examineBiz.approvalHistoryList
        },
    ],
    "会费管理":[
        {
            apiName:"已交费名单列表",
            subUrl:'/memberfees/paid', 
            param:[
                {key:"unitName", type:"String", desc:"单位名称", isNull:true},
                {key:"joinStartTime", type:"Number", desc:"入会开始时间", isNull:true},
                {key:"joinEndTime", type:"Number", desc:"入会结束时间", isNull:true},
                {key:"memberType", type:"Number", desc:"会员类别", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页"}
            ],
            bindBiz:memberFeesBiz.getPaid
        },
        {
            apiName:"已缴费列表的订单日志",
            subUrl:'/memberfees/paidorderlist', 
            param:[
                {key:"userId", type:"String", desc:"用户id"},
            ],
            bindBiz:memberFeesBiz.paidOrderList
        },
        {
            apiName:"待缴费列表",
            subUrl:'/memberfees/unpaidlist', 
            param:[
                {key:"unitName", type:"String", desc:"单位名称", isNull:true},
                {key:"joinTime", type:"Number", desc:"入会时间", isNull:true},
                {key:"memberType", type:"Number", desc:"会员类别", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页"}
            ],
            bindBiz:memberFeesBiz.unpaidList
        },
        {
            apiName:"欠费名单列表",
            subUrl:'/memberfees/getrenewalperiod', 
            param:[
                {key:"unitName", type:"String", desc:"单位名称", isNull:true},
                {key:"joinTime", type:"Number", desc:"入会时间", isNull:true},
                {key:"memberType", type:"Number", desc:"会员类别", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页"}
            ],
            bindBiz:memberFeesBiz.getRenewalPeriod
        },
        {
            apiName:"线下付款",
            subUrl:'/memberfees/offlinepayment', 
            param:[
                {key:"orderId", type:"String", desc:"订单id", isNull:true},
                {key:"paymentNum", type:"Number", desc:"支付单号", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页"}
            ],
            bindBiz:memberFeesBiz.offlinePayment
        },
        {
            apiName:"多比订单时选择线下付款页面的选择缴费周期页",
            subUrl:'/memberfees/selectmanyorder', 
            param:[
                {key:"id", type:"String", desc:"会员id", isNull:true},
            ],
            bindBiz:memberFeesBiz.selectManyOrderForUser
        },
        {
            apiName:"设置宽限期",
            subUrl:'/memberfees/setgraceperiod', 
            param:[
                {key:"id", type:"String", desc:"列表返回id", isNull:true},
                {key:"gracePeriodEndTime", type:"String", desc:"宽限期到期时间", isNull:true},
            ],
            bindBiz:memberFeesBiz.setGracePeriod
        },
        {
            apiName:"宽限期名单列表",
            subUrl:'/memberfees/getgraceperiod', 
            param:[
                {key:"unitName", type:"String", desc:"单位名称", isNull:true},
                {key:"joinTime", type:"Number", desc:"入会时间", isNull:true},
                {key:"memberType", type:"Number", desc:"会员类别", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页"}
            ],
            bindBiz:memberFeesBiz.getGracePeriod
        },
        {
            apiName:"移除宽限期",
            subUrl:'/memberfees/delgraceperiod', 
            param:[
                {key:"id", type:"String", desc:"列表返回id", isNull:true},
            ],
            bindBiz:memberFeesBiz.delGracePeriod
        },

    ],
    "会员管理":[
        {
            apiName:"会员权限列表",
            subUrl:'/authority/list',
            param:[
                {key:"unitName", type:"String", desc:"单位名称", isNull:true},
                {key:"memberLevel", type:"Number", desc:"会员等级", isNull:true},
                {key:"memberCategory", type:"Number", desc:"单位、个人会员类别", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页"}
            ],
            bindBiz:authorityBiz.getAuthority
        },
        {
            apiName:"变更权限",
            subUrl:'/authority/update',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        memberLevel:{type:'Number', desc:'等级、职务'},
                        memberCategory:{type:'Number', desc:'单位、个人会员类别、级别'},
                    }
                },
                {
                    key:"userId", type:"String", desc:"用户id"
                }
            ],
            bindBiz:authorityBiz.updateAuthority
        },
        {
            apiName:"冻结",
            subUrl:'/authority/freeze',
            param:[
                {
                    key:"userId", type:"String", desc:"用户id"
                }
            ],
            bindBiz:authorityBiz.freeze
        },
        {
            apiName:"变更权限回显",
            subUrl:'/authority/authorityecho',
            param:[
                {
                    key:"id", type:"String", desc:"列表返回的userId"
                }
            ],
            bindBiz:authorityBiz.authorityEcho
        }
    ],
    "个人首页展示":[
        {
            apiName:"会员信息展示",
            subUrl:'/homepage/list',
            param:[
                {key:"userId", type:"String", desc:"用户id"}
            ],
            bindBiz:homePageBiz.getMemberData
        },
        {
            apiName:"单位会员修改",
            subUrl:'/homePage/unitmemberupdate',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        /**基本信息 */
                        unitName:{type:'String', desc:'单位名称'},
                        addres:{type:'String', desc:'通信地址'},
                        uscc:{type:'String', desc:'单位信用代码'},
                        legalPerson:{type:'String', desc:'法人代表'},
                        legalPersonPhone:{type:'String', desc:'法人联系电话'},
                        contactPerson:{type:'String', desc:'日常联系人'},
                        contactPersonDuties:{type:'String', desc:'日常联系人职务'},
                        sheng:{type:'String', desc:'省'},
                        shi:{type:'String', desc:'市'},
                        qu:{type:'String', desc:'区'},
                        uusinessLicenseUrl:{type:'String', desc:'营业执照'},
                        /**单位信息 */
                        unitMemberType:{type:'Number', desc:'单位信息类型'},
                        yuanXiaoBanXueLeiXing:{type:'String', desc:'院校办学类型'},
                        yuanXiaoZhuGuanBuMen:{type:'String', desc:'院校主管部门'},
                        yuanXiaoFuZeRen:{type:'String', desc:'院校主要负责人'},
                        yuanXiaoFuZeRenZhiWu:{type:'String', desc:'院校主要负责人职位'},
                        yuanXiaoFuZeRenDianHua:{type:'String', desc:'院校主要负责人电话'},
                        yuanXiaoBanGongFuZeRen:{type:'String', desc:'院校办公负责人'},
                        yuanXiaoBanGongFuZeRenZhiWu:{type:'String', desc:'院校办公负责人职位'},
                        yuanXiaoBanGongFuZeRenDianHua:{type:'String', desc:'院校办公负责人电话'},
                        yuanXiaoKeYanFuZeRen:{type:'String', desc:'院校科研负责人'},
                        yuanXiaoKeYanFuZeRenZhiWu:{type:'String', desc:'院校科研负责人职位'},
                        yuanXiaoKeYanFuZeRenDianHua:{type:'String', desc:'院校科研负责人电话'},
                        yuanXiaoXueShengZongRenShu:{type:'String', desc:'院校学生总数'},
                        yuanXiaoJiaoZhiGongZongRenShu:{type:'String', desc:'院校教职工总人数'},
                        yuanXiaoJianZhuMianJi:{type:'String', desc:'院校建筑总面积'},
                        yuanXiaoGaoJiZhiCheng:{type:'String', desc:'院校高级职称人数'},
                        yuanXiaoKaiSheZhuanYe:{type:'String', desc:'院校专业总数'},
                    },
                    desc:"表单"
                },
                {
                    key:"keyanForm", type:"Object", sub:
                    {
                        startTime:{type:'Number', desc:'开始时间'},
                        endTime:{type:'Number', desc:'结束时间'},
                        describe:{type:'String', desc:'科研描述'},
                    },
                    desc:"单位所获得科研成果表单"
                },
                {
                    key:"userId", type:"String", desc:"用户id"
                }
            ],
            bindBiz:homePageBiz.unitMemberUpdate
        },
        {
            apiName:"个人会员修改",
            subUrl:'/homePage/memberupdate',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        /**基本信息 */
                        name:{type:'String', desc:'真实姓名'},
                        sex:{type:'Number', desc:'性别'},
                        nation:{type:'Number', desc:'民族'},
                        birth:{type:'Number', desc:'出身年月'},
                        documentType:{type:'Number', desc:'证件类型'},
                        documentId:{type:'String', desc:'证件号码'},
                        sheng:{type:'String', desc:'省'},
                        shi:{type:'String', desc:'市'},
                        qu:{type:'String', desc:'区'},
                        addres:{type:'String', desc:'通信地址'},
                        photoUrl:{type:'String', desc:'蓝底证件照'},
                        /**专业信息 */
                        workUnit:{type:'String', desc:'工作单位'},
                        memberLevel:{type:'Number', desc:'会员等级职务'},
                        workTitle:{type:'String', desc:'职称'},
                        profCategory:{type:'Number', desc:'专业类别'},
                        studyResume:{type:'String', desc:'学习简历'},
                        workResume:{type:'String', desc:'工作简历'},
                        profAchievement:{type:'String', desc:'教研成果'},
                        otherEMP:{type:'String', desc:'其他组织任职情况'},
                        otherPROF:{type:'String', desc:'其他情况'},
                        /**其他附件 */
                        cardUrl:{type:'[String]', desc:'个人身份扫描件'},
                        academicCERTUrl:{type:'String', desc:'个人学历证明扫描件'},
                        professionalCERTUrl:{type:'String', desc:'个人工作证明扫描件'},
                        auxiliaryMaterial:{type:'[String]', desc:'论文发表或成绩材料'},
                    }
                },
                {
                    key:"userId", type:"String", desc:"用户id"
                }
            ],
            bindBiz:homePageBiz.individualMemberUpdate
        },
        {
            apiName:"消息中心列表",
            subUrl:'/homepage/huodongtongzhi',
            param:[
                {}
            ],
            bindBiz:homePageBiz.getHuoDongTongZhi
        },
        {
            apiName:"地图信息",
            subUrl:'/homepage/mapsheng',
            param:[
                {key:"userId", type:"String", desc:"用户id"}
            ],
            bindBiz:homePageBiz.getSheng
        },
        {
            apiName:"会员缴费列表",
            subUrl:'/homepage/memberpayment',
            param:[
                {key:"userId", type:"String", desc:"用户id"},
                {key:"state", type:"Number", desc:"缴费状态", isNull:true}
            ],
            bindBiz:homePageBiz.memberPayment
        },
        {
            apiName:"申请发票",
            subUrl:'/homepage/applicationinvoice',
            param:[
                {key:"id", type:"String", desc:"缴费列表返回id"}
            ],
            bindBiz:homePageBiz.applicationInvoice
        },
        {
            apiName:"下载发票",
            subUrl:'/homepage/downinvoice',
            param:[
                {key:"id", type:"String", desc:"缴费列表返回id"}
            ],
            bindBiz:homePageBiz.downInvoice
        },

    ]
}

