/**
 * 收费
 */

import { ORDERSTATE, PAYMENTTYPE } from "../../config/enum";
import { TABLEENUM } from "../../data/models/model";
import { findOnce } from "../../data/select";
import { eccEnumValue } from "../../util/verificationEnum";
import { update } from "../portal/fenZhiJiGou/jiGouGuanLi";
import * as path from "path";
const WxPay = require('wechatpay-node-v3');
import * as fs from 'fs';
import { BizError } from "../../util/bizError";
import { ERRORENUM } from "../../config/errorEnum";
import { generateWXOrderId } from "../../tools/system";
import { updateOneData } from "../../data/update";
import moment = require("moment");

const AppId = 'wx96c0cf11b3babcf6';
const MchId = '1614605859';
const pay = new WxPay({
    appid: AppId,
    mchid: MchId,
    publicKey: fs.readFileSync( path.join(__dirname.substring(0,__dirname.indexOf("out")), "keys", 'apiclient_cert.pem'  ) ), // 公钥
    privateKey: fs.readFileSync(  path.join(__dirname.substring(0,__dirname.indexOf("out")), "keys", 'apiclient_key.pem'  ) ), // 秘钥
});


/**
 * native下单接口【前端调用】
 * @param param0 {id订单列表的id}
 * @returns 
 */
export async function placeAnOrder({id}) {
    let orderInfo = await findOnce(TABLEENUM.订单表, {id}, ["id", "loginId", "userId", "memberCategory", "money", "orderCycleStart", "orderCycleEnd"]);
    if (!orderInfo || !orderInfo.id) throw new BizError(ERRORENUM.订单不存在);
    if (orderInfo.state != ORDERSTATE.已支付) throw new BizError(ERRORENUM.该订单已支付);

    /**生成 out_trade_no */
    let out_trade_no = generateWXOrderId(orderInfo.memberCategory, orderInfo.userId);
    let desc = `${orderInfo.loginId}_${moment(orderInfo.orderCycleStart).format("YYYY-MM-DD")}至${moment(orderInfo.orderCycleEnd).format("YYYY-MM-DD")}`;

    await updateOneData(TABLEENUM.订单表, {id}, {weChartPR:out_trade_no, paymentMethod:PAYMENTTYPE.微信支付});
    /**请求参数 */
    const Param = {
        appid: AppId,
        mchid: MchId,
        description:desc,
        out_trade_no,//订单号
        amount:{//金额
            total:orderInfo.money
        },
        notify_url:'',//测试时先设置白名单地址
    };
    const result = await pay.transactions_native(Param);
    if (result.status != 200) throw new BizError(ERRORENUM.调起微信支付失败);
    return {code_url:result.code_url};
}


/**
 * 订单查询状态【前端调用】
 */
export async function orderState({orderId}) {
    const result = await pay.query({out_trade_no: '1609914303237'});
}


/**
 * 关闭订单【前端调用】
 */
export async function orderClose() {

}


// var initConfig = {
// partnerKey: "<partnerkey>",
// appId: "<appid>",
// mchId: "<mchid>",
// notifyUrl: "<notifyurl>",
// pfx: fs.readFileSync("<location-of-your-apiclient-cert.p12>")
// };
// var payment = new Payment(initConfig);

// /**
//  * 订单列表
//  * @param param0 
//  */
// export async function orderList({userId}) {
    

// }
// /**发起支付接口 */
// /**支付状态更新接口 给微信用 */
// /**订单状态查询 */


/**
 * 发起支付
 * @param param0 
 */
export async function initiationPay({userId, id, paymentType}) {
    eccEnumValue("发起支付", "支付方式", PAYMENTTYPE, paymentType);

    if (id == PAYMENTTYPE.线下支付) {

    } else {//线上支付
        let orderInfo = await findOnce(TABLEENUM.订单表, {id});
        /**清除微信支付订单 */
        // await update(TABLEENUM);
    }
    

}