import * as publicBiz  from '../../biz/public';
import * as enumConfig from '../../config/enum';
import * as outPutConfig from '../../config/outPutConfig';
import * as msgActivityBiz from "../../biz/member/msgActivity";

export const FirstName = '公共接口';
export const FirstRouter = '/public';
export const Config = {
    "下拉框数据":[
        {
            apiName:"性别",
            subUrl:'/sex', 
            param:[],
            defaultParam:enumConfig.SEX,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"会员类型",
            subUrl:'/membertype', 
            param:[],
            defaultParam:enumConfig.MEMBERTYPE,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"专业类别",
            subUrl:'/profcategory', 
            param:[],
            defaultParam:enumConfig.PROFCATEGORY,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"内容管理banner位置",
            subUrl:'/position', 
            param:[],
            defaultParam:enumConfig.BANNERPOSITION,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"内容管理文章位置",
            subUrl:'/articleposition', 
            param:[],
            bindBiz:publicBiz.filePosition
        },
        {
            apiName:"内容管理视频位置",
            subUrl:'/videoposition', 
            param:[],
            defaultParam:enumConfig.VIDEOPOSITION,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"年筛选",
            subUrl:'/years',
            param:[],
            defaultParam:enumConfig.YEARENUM,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"参会人员",
            subUrl:'/codparticipant', 
            param:[],
            defaultParam:enumConfig.CODPARTICIPANT,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"分委会职务",
            subUrl:'/branchposition', 
            param:[],
            defaultParam:enumConfig.BRANCHPOSITION,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"下载专区分类",
            subUrl:'/dwtype', 
            param:[],
            defaultParam:enumConfig.DWTYPE,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"民族",
            subUrl:'/nation', 
            param:[],
            defaultParam:enumConfig.NATION,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"证件类型",
            subUrl:'/documenttype', 
            param:[],
            defaultParam:enumConfig.DOCUMENTTYPE,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"动态资讯类型列表",
            subUrl:'/dongtaizixuntype', 
            param:[],
            bindBiz:publicBiz.zhengCeZiXunLeiXing
        },
        {
            apiName:"通知公告类型",
            subUrl:'/tongzhigonggaotype', 
            param:[],
            defaultParam:enumConfig.TONGZHIGONGGAO,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"验证码类型", 
            subUrl:'/codetype', 
            param:[],
            defaultParam:enumConfig.CODETYPE,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"会员缴费列表类型",
            subUrl:'/ispay', 
            param:[],
            defaultParam:enumConfig.ISPAYENUM,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"支付方式",
            subUrl:'/paytype', 
            param:[],
            defaultParam:enumConfig.PAYMENTTYPE,
            bindBiz:publicBiz.setEnumInterface  
        },
        {
            apiName:"发票状态",
            subUrl:'/invoicestate', 
            param:[],
            defaultParam:enumConfig.INVOICESTATUSCLIENT,
            bindBiz:publicBiz.setEnumInterface  
        },
        {
            apiName:"会费类别",
            subUrl:'/costtype', 
            param:[],
            defaultParam:enumConfig.COSTTYPE,
            bindBiz:publicBiz.setEnumInterface  
        },
        {
            apiName:"订单状态",
            subUrl:'/orderstate', 
            param:[],
            defaultParam:enumConfig.ORDERSTATE,
            bindBiz:publicBiz.setEnumInterface
        },
        {    
            apiName:"单位会员类别", 
            subUrl:'/unitmembertype', 
            param:[],
            defaultParam:enumConfig.UNITMEMBERTYPE,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"个人会员类别", 
            subUrl:'/individualnembertype', 
            param:[],
            defaultParam:enumConfig.INDIVIDUALMEMBERTYPE,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"个人会员会员级别", 
            subUrl:'/clientmembertype', 
            param:[],
            defaultParam:enumConfig.CLIENTMEMBERTYPE,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"会员职务", 
            subUrl:'/memberlevel', 
            param:[],
            defaultParam:enumConfig.MEMBERLEVEL,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"会员类别",  //前端用
            subUrl:'/membertypeecc', 
            param:[],
            defaultParam:enumConfig.MEMBERTYPEECCENUM,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"管理员类别",
            subUrl:'/admintype', 
            param:[],
            defaultParam:enumConfig.ADMINTYPE,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"学历",
            subUrl:'/education', 
            param:[],
            defaultParam:enumConfig.EDUCATION,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"是否支付",
            subUrl:'/ispayment', 
            param:[],
            defaultParam:enumConfig.STATE,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"会员状态",
            subUrl:'/memberstate', 
            param:[],
            defaultParam:enumConfig.MEMBERSTATE,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"下拉框选择届次",
            subUrl:'/session',
            param:[],
            bindBiz:publicBiz.getSession
        },
        {
            apiName:"院校办学类型",
            subUrl:'/banxueleixing',
            param:[],
            defaultParam:enumConfig.BANXUELEIXING,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"学会领导职务",
            subUrl:'/xuehuilingdaolv',
            param:[],
            defaultParam:enumConfig.XUEHUILINGDAOZHIWEI,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"上传文件类别",
            subUrl:'/uptype',
            param:[],
            defaultParam:enumConfig.OOSCODE,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"视频图片类型",
            subUrl:'/videoimgtype',
            param:[],
            defaultParam:enumConfig.VIDEOANDIMGTYPEENUM,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"导出审核单位会员数据列",
            subUrl:'/unitauditingcolumns',
            param:[],
            defaultParam:outPutConfig.UNITAUDITINGCOLUMNS,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"导出审核个人会员数据列",
            subUrl:'/auditingcolumns',
            param:[],
            defaultParam:outPutConfig.AUDITINGCOLUMNS,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"获取所有标签id",
            subUrl:'/lable',
            param:[],
            bindBiz:publicBiz.getLable
        },
        {
            apiName:"消息对象固定类型",
            subUrl:'/msglabletype',
            param:[],
            bindBiz:publicBiz.getMsgNoticeObject
        },
        {
            apiName:"活动对象固定类型",
            subUrl:'/activitylabletype',
            param:[],
            bindBiz:publicBiz.getNoticeObject
        },
        {
            apiName:"是否弹窗",
            subUrl:'/ispop', 
            param:[],
            defaultParam:enumConfig.STATE,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"是否置顶",
            subUrl:'/istopup', 
            param:[],
            defaultParam:enumConfig.STATE,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"活动状态",
            subUrl:'/activitystate', 
            param:[],
            defaultParam:enumConfig.CLIENTACTIVITYSTATE,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"活动类型",
            subUrl:'/activitytype', 
            param:[],
            defaultParam:enumConfig.ACTIVITYTYPE,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"是否受到款项",
            subUrl:'/isreceive', 
            param:[],
            defaultParam:enumConfig.ISRECEIVE,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"变更理事",
            subUrl:'/memberlevelchange', 
            param:[],
            defaultParam:enumConfig.MEMBERLEVELCHANGE,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"发票管理-费用核对导出列",
            subUrl:'/confirmreceiptcolumns',
            param:[],
            defaultParam:outPutConfig.CONFIRMRECEIPTCOLUMNS,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"发票管理-待开发票导出列",
            subUrl:'/billstatecolumns',
            param:[],
            defaultParam:outPutConfig.BILLSTATECOLUMNS,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"发票管理-已开发票导出列",
            subUrl:'/invoicedcolumns',
            param:[],
            defaultParam:outPutConfig.INVOICEDCOLUMNS,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"发票管理-退款列表导出列",
            subUrl:'/refundcolumns',
            param:[],
            defaultParam:outPutConfig.REFUNDCOLUMNS,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"会费管理-列表导出",
            subUrl:'/memberfeesdcolumns',
            param:[],
            defaultParam:outPutConfig.MEMBERFEESDCOLUMNS,
            bindBiz:publicBiz.setEnumInterface
        },
        {
            apiName:"会费管理-列表导出",
            subUrl:'/memberpaymentcolumns',
            param:[],
            defaultParam:outPutConfig.MEMBERPAYMENTCOLUMNS,
            bindBiz:publicBiz.setEnumInterface
        }
    ],
    
}
