import { requestConfig } from "../../serverConfig";
import { BizError } from "../../util/bizError";
import { get, post, postForm } from "../../util/request";
import { getUrl, urlEnum } from "./url";


let token = "";
let tokenTime = 0;//有效时间
let lastTime = 0;//上一次时间
const timeOutTime = 50;//超时时间s

async function get获取token() {
    let time = new Date().valueOf();

    if ( (Math.ceil((time - lastTime)/1000 ) + timeOutTime )> tokenTime ) {
        let url = getUrl(urlEnum.获取token);
        let head = {};
        let body = {client_id:requestConfig.client_id, client_secret:requestConfig.client_secret};
        let result:any = await postForm(url, body, head );
        if (!result || !result.access_token || !result.expires_in) {
            throw new BizError(`获取token 失败： ${JSON.stringify(result)}`, );
        }
    
        
        token = result.access_token;
        tokenTime = result.expires_in;
        lastTime = time;
        console.log("获取一次token",`token${token}, lastTime ${lastTime}, time ${time}, tokenTime ${tokenTime}, `);
    }
    
}

//数据治理体系
export async function getSzjltxData() {
    await get获取token();

    let body = {
        client_id:requestConfig.client_id,
        access_token:token,
    };

    let sjzl = await post(getUrl(urlEnum.数据治理), body, {} ); 
    let sjzc = await post(getUrl(urlEnum.数据资产), body, {} );

    let departmentList = [
        {name:"信息管理部", str:"xxglb"},
        {name:"师训部", str:"sxb"},
        {name:"体育活动部", str:"tyhdb"},
        {name:"健康教育部", str:"jkjyb"},
        {name:"艺术教育部", str:"ysjyb"},
        {name:"科技教育部", str:"kjjyb"},
        {name:"综合办公室", str:"zhbgs"}
    ];
    let sjlyInfo = {};
    for (let i = 0; i < departmentList.length; i++) {
        let {name, str} = departmentList[i];
        let thisBody = {department:str, client_id:requestConfig.client_id, access_token:token }
        let onceSjly:any = await post(getUrl(urlEnum.数据来源), thisBody, {});
        if (!sjlyInfo[name]) sjlyInfo[name] = [];
        onceSjly.forEach(onceItem => {
            if (onceItem.system != "/") sjlyInfo[name].push(onceItem.system);
        });
    }
   

    return { sjzl, sjzc, sjlyInfo };
}
//整体运行态势
export async function getZtyxtsData() {
    await get获取token();

    let body = {
        client_id:requestConfig.client_id,
        access_token:token,
    };

    let dqjxzhd = await post(getUrl(urlEnum.当前进行中活动), body, {});
    let dqhdrs = await post(getUrl(urlEnum.当前活动人数), body, {});
    let bndhds:any = await post(getUrl(urlEnum.本年度活动数), body, {});
    bndhds.forEach(info => {
        info.month = `${info.month}月`
    });
    let cyhdrs:any = await post(getUrl(urlEnum.参与活动人数), body, {});
    cyhdrs.forEach(info => {
        info.month = `${info.month}月`
    });
    let ztyxtszjdt = await post(getUrl(urlEnum.整体运行地图数据), body, {});
    let zcyh = await post(getUrl(urlEnum.注册用户), body, {} );

    let dqhds = await post(getUrl(urlEnum.整体运行态势当前活动数), body, {} );


    let xxaqfx = await post(getUrl(urlEnum.信息安全风险), body, {} );
    let zybs:any = await post(getUrl(urlEnum.资源部署), body, {} );
    let zysylqsData = {};
    let zymcMap = {"zwy":"政务云", "jyy":"教育云", "yfy":"有孚云"};
    for (let engName in zymcMap) {
        let thisBody:any = JSON.parse(JSON.stringify(body));
        thisBody.zymc = engName;
        let thisZymcZykyx:any = await post(getUrl(urlEnum.资源可用性), thisBody, {} );
        
        let nameList = ["cpu", "nc", "cc"];
        let thisZymcSylqs = {};
        for (let j = 0; j < nameList.length; j++) {
            let name = nameList[j];
            thisBody.name = name;
            let onceList = await post(getUrl(urlEnum.资源使用率趋势), thisBody, {} );
            thisZymcSylqs[name] = onceList;

        }
        let chName = zymcMap[engName];
        zysylqsData[chName] = {zykyx:listMappingObject(thisZymcZykyx, {cc:"存储", nc:"内存", cpu:"cpu"}), sylqs:thisZymcSylqs }
    }

    return { dqjxzhd,dqhdrs,bndhds,cyhdrs, ztyxtszjdt, zcyh:listMappingObject(zcyh, {zcyh:"注册用户"}), 
        dqhds:listMappingObject(dqhds, {num_dqhds:"num_dqhds", num_ndhds:"num_ndhds", num_cyhdrc:"num_cyhdrc" }),
        xxaqfx:listMappingObject(xxaqfx, {fxld:"发现漏洞", yxf:"已修复", wxf:"未修复"}),
        xtbgsj:listMappingObject(xxaqfx, {ts:"提示"}),
        zybs,zysylqsData
    };
}

//重要活动保障
export async function getZyhdbzData() {
    await get获取token();

    let body = {
        client_id:requestConfig.client_id,
        access_token:token,
    };

    let zcyh = await post(getUrl(urlEnum.注册用户), body, {} );
    let yjbzya = await post(getUrl(urlEnum.应急保障预案), body, {} );
    let bzry = await post(getUrl(urlEnum.保障人员), body, {} );
    let hdcyd = await post(getUrl(urlEnum.活动参与度), body, {} );
    let yhtsl = await post(getUrl(urlEnum.用户投诉量), body, {} );

    let zyhdbzzjdt = await post(getUrl(urlEnum.重要活动地图数据), body, {} );

    let rlzb = await post(getUrl(urlEnum.容量指标), body, {});


    let nameList = ["cpu", "nc", "cc"];
    let rlzbsylqs = {};
    for (let j = 0; j < nameList.length; j++) {
        let name = nameList[j];
        let thisBody:any = JSON.parse(JSON.stringify(body));
        thisBody.name = name;
        let onceRlzbsylqs = await post(getUrl(urlEnum.容量指标使用率趋势), thisBody, {} );
        rlzbsylqs[name] = onceRlzbsylqs;

    }
  
    return { 
        zcyh: listMappingObject(zcyh, {zcyh:"注册用户"}), 
        yjbzya: listMappingObject(yjbzya, {hdmc:"活动名称", bzdx:"保障对象", bzsj:"保障时间", bzyq:"保障要求"}), 
        bzry, hdcyd, zyhdbzzjdt,
        yhtsl: listMappingObject(yhtsl, { zcdl:"注册登录", wzdbk:"网站打不开", sfzcw:"身份证填写错误", qt:"其他"}),
        yhtslzs: listMappingObject(yhtsl, {yhts:"用户投诉总数"}),
        rlzb:listMappingObject(rlzb, {cc:"存储", nc:"内存", cpu:"cpu"}) , rlzbsylqs
    };
}
function listMappingObject(dataList, mappingInfo) {
    let map = {};
    dataList.forEach(info => {
        for (let key in info) {
            map[key] = info[key];
        }
    });
    let result = {};
    for (let key in mappingInfo) {
        let mappingKey = mappingInfo[key];
        let value = map[key];
        if (value) result[mappingKey] = value;
        else console.log(`${JSON.stringify(mappingInfo)}的 ${key} 在数据中找不到映射`); 
    }

    return result
}

