import moment = require("moment");
import { post } from "../../util/request";

function statsDataFormat() {
    let dayStartTime = moment().add(-6, 'days');
    let monthStart = moment().add(-5, 'months');
    return {
        thisMonthStartTime:moment(dayStartTime).format('YYYYMMDD'), 
        startTime: moment(monthStart).format('YYYYMMDD'),  
        endTime:moment().format('YYYYMMDD'), 
    };
}

export async function getBaiduStats() {
    const site_id = 17390867;
    let {startTime, endTime, thisMonthStartTime} = statsDataFormat();
    let url = "https://api.baidu.com/json/tongji/v1/ReportService/getData";
    let header = {
        "username": "shkyzx",
        "password": "Support01",
        "token": "2444afaabacc40a0819a15815d7ec10f",
        "account_type": 1
    };
    let body = {
        "site_id": `${site_id}`,
        "start_date": startTime,
        "end_date": endTime,
        "metrics": "pv_count",
        "method": "trend/time/a",
        "gran": "month",
        "area": "china"
    }

    let monthResult:any = await post(url, {body, header}, {});

    let monthStatsData = [];
    let dayStatsData = [];

    if ( !(!monthResult || !monthResult.body || !monthResult.body.data[0] || !monthResult.body.data[0].result || !monthResult.body.data[0].result.items) ) {
        
        let titleLis = monthResult.body.data[0].result.items[0];
        let valueList = monthResult.body.data[0].result.items[1];
        titleLis.forEach((info, index) => {
            let key = info[0] || "";
            key = key.substring(0, 11);
            let value = 0; 
            if (valueList[index] && valueList[index][0] && typeof  valueList[index][0] == 'number' ) value = valueList[index][0];
            monthStatsData.push({key, value});
        });
    }

    body.gran = "day";
    body.start_date = thisMonthStartTime;
    let dayResult:any = await post(url,{body, header}, {});

    if ( !(!dayResult || !dayResult.body || !dayResult.body.data[0] || !dayResult.body.data[0].result || !dayResult.body.data[0].result.items) ) {
        let titleLis = dayResult.body.data[0].result.items[0];
        let valueList = dayResult.body.data[0].result.items[1];
        titleLis.forEach((info, index) => {
            let key = info[0] || "";
            let value = 0; 
            if (valueList[index] && valueList[index][0] && typeof  valueList[index][0] == 'number' ) value = valueList[index][0];
            dayStatsData.push({key, value});
           
        });
    }
    dayStatsData.sort((a, b) => {return new Date(a.key).valueOf() - new Date(b.key).valueOf() });
    monthStatsData.sort((a, b) => {return new Date(a.key).valueOf() - new Date(b.key).valueOf() });

    dayStatsData.forEach(info => {
        info.key = parseInt(info.key.substring(5,7)) +'/'+ parseInt(info.key.substring(8,10));
    });
    monthStatsData.forEach(info => {
        info.key = parseInt(info.key.substring(5,7))+"月";
    });

    return{monthStatsData, dayStatsData};
		
}

function uvDataFormat() {
    let time = new Date();
    let month = (time.getMonth() + 1) <= 9 ? `0${time.getMonth() + 1}` : `${time.getMonth() + 1}`;
    let day = time.getDate() <= 9 ? `0${time.getDate()}` : `${time.getDate()}`;
    return {startTime:`${time.getFullYear()}0101`, endTime:`${time.getFullYear()}${month}${day}`};
}

export async function getUV() {
    const site_id = 17390867;
    let {startTime, endTime} = uvDataFormat();
    let url = "https://api.baidu.com/json/tongji/v1/ReportService/getData";
    let header = {
        "username": "shkyzx",
        "password": "Support01",
        "token": "2444afaabacc40a0819a15815d7ec10f",
        "account_type": 1
    };
    let body = {
        "site_id": `${site_id}`,
        "start_date": startTime,
        "end_date": endTime,
        "metrics": "pv_count",
		"method": "visit/toppage/a"
    }
    let uvResult:any = await post(url, {body, header}, {});
    let uv = 0;
    if ( !(!uvResult || !uvResult.body || !uvResult.body.data[0] || !uvResult.body.data[0].result || !uvResult.body.data[0].result.items) ) {
        let valueList = uvResult.body.data[0].result.items[1] || [];
        valueList.forEach( info => {
            if (info[0] && typeof info[0] == 'number' ) uv += info[0];
        });
    }
    return uv;
}

export async function getBaiduSiteList() {
    let url = "https://api.baidu.com/json/tongji/v1/ReportService/getSiteList";
    let header = {
        "username": "shkyzx",
        "password": "Support01",
        "token": "2444afaabacc40a0819a15815d7ec10f",
        "account_type": 1
    };
    let body = {}
    let uvResult:any = await post(url, {body, header}, {});
    
    if (!uvResult.body || !uvResult.body.data || !uvResult.body.data[0] || !uvResult.body.data[0].list) return [];
    return uvResult.body.data[0].list;
}

export async function getPVCountBySiteId(siteId) {
    let url = "https://api.baidu.com/json/tongji/v1/ReportService/getData";
    let header = {
		"username": "shkyzx",
		"password": "Support01",
		"token": "2444afaabacc40a0819a15815d7ec10f",
		"account_type": 1
	};
	let body = {
		"site_id": `${siteId}`,
		"start_date": moment().format("YYYYMMDD"),
		"end_date": moment().add(1, 'days').format("YYYYMMDD"),//这里改成了当日的
		"metrics": "pv_count",
        "method": "overview/getTimeTrendRpt",
        "area": "china"
	}
    let uvResult:any = await post(url, {body, header}, {});
    
    if (!uvResult.body || !uvResult.body.data || !uvResult.body.data[0] || !uvResult.body.data[0].result || !uvResult.body.data[0].result.items || !uvResult.body.data[0].result.items[1]) return 0;
    let count = 0;
    uvResult.body.data[0].result.items[1].forEach(info => {
        if (!info || info == "--" || isNaN(info)) return;
        count += parseInt(info);
    });

    return count;
}