import moment = require("moment");

const Core = require('@alicloud/pop-core');


export async function getALYStats(isFirst) {
    let nowTime = new Date().valueOf();
    let startTime = new Date(moment().format("YYYY-MM-DD 00:00:00")).valueOf();
    let alyData:any = await getAL("Availability", startTime, nowTime, 3600 );
    if (isFirst) console.log("初始化进度 10%");
    let timeData:any = await getAL("ResponseTime", startTime, nowTime, 3600);
    if (isFirst) console.log("初始化进度 20%");
    if (alyData.Code != "200" || timeData.Code != "200") {
        return "timeOut";
    }
    let availabilityData = JSON.parse(alyData.Datapoints);
    let resTimeData = JSON.parse(timeData.Datapoints);

    let alyStatsData = taskCountAvg(availabilityData, resTimeData);

    let taskIdList = Object.keys(alyStatsData);

    let taskInfoList = [];
    for (let i = 0; i < taskIdList.length; i++) {
        let onceTaskId = taskIdList[i];
        let info = await getTaskInfo(onceTaskId);
        if (info) taskInfoList.push(info);
    }
    // let todayTime = new Date(moment().format("YYYY-MM-DD 00:00:00")).valueOf();

    // let todayAlyData:any = await getAL("Availability", todayTime, nowTime, 3600);
    // if (isFirst) console.log("初始化进度 30%");
    // let todayTimeData:any = await getAL("ResponseTime", todayTime, nowTime, 3600);
    // if (isFirst) console.log("初始化进度 40%");
    // let todayAvailabilityData = JSON.parse(todayAlyData.Datapoints);
    // let todayResTimeData = JSON.parse(todayTimeData.Datapoints);
    // let todayStatsData = taskCountAvg(todayAvailabilityData, todayResTimeData);

    //董老师说这里留个坑 2021-12-22 下午 15:09 这里暂时留 日常体育成绩  0dcce666-691b-422f-9e1d-7301b9d5164e  需要更换添加或者全部，就替换checkKeyList即可
    //公元2022年1月20日 下午15点29分40秒 改成了  "2cec1889-29a5-49b5-8a82-c83663b34aec"  =>  这个是 玑脉大平台 域名是  shsunshine-zp.shec.edu.cn/
    let checkKeyList = ["2cec1889-29a5-49b5-8a82-c83663b34aec"];

    let alyDataCount = 0;
    let alyDataNumber = 0;
    let timeDataCount = 0;
    let timeDataNumber = 0;
    for (let key in alyStatsData) {
        if (checkKeyList.indexOf(key) == -1) continue;
        let {ab, rt} = alyStatsData[key];
        alyDataCount += 1;
        alyDataNumber += parseFloat(ab);
        timeDataCount += 1;
        timeDataNumber += parseFloat(rt);
    }
    let todayAlyStatsData = {ab:Math.ceil(alyDataNumber/alyDataCount * 100)/100, rt:Math.ceil(timeDataNumber/timeDataCount * 100)/100}

    let todayAvailabilityList = [];

    availabilityData.forEach(info => {
        let {timestamp, taskId, Availability} = info;
        if (checkKeyList.indexOf(taskId) == -1 ) return;
        todayAvailabilityList.push({value:Availability, key:parseInt(timestamp)});
    });

    todayAvailabilityList.sort((a, b) => {return a-b});

    todayAvailabilityList.forEach(info => {info.key = moment(info.key).format("HH:mm")});
    return {taskInfoList, alyStatsData, todayAlyStatsData, todayAvailabilityList };
}

//求总和的平均
function taskCountAvg(availabilityData, resTimeData) {
    let taskMap = {};

    availabilityData.forEach(info => {
        let taskId = info.taskId;
        let timestamp = info.timestamp;
        if (!timestamp) return;
        if (!taskMap[taskId]) taskMap[taskId] = {count:0, availability:0, resCount:0, resTime:0 };
        taskMap[taskId].count += 1;
        taskMap[taskId].availability += parseFloat(info.Availability || 0);
    });

    resTimeData.forEach(info => {
        let taskId = info.taskId;
        if (!taskMap[taskId]) return;
        taskMap[taskId].resCount += 1;
        taskMap[taskId].resTime += parseFloat(info.Average);
    });
    let alyStatsData = {};
    for (let key in taskMap) {
        let {count, availability, resCount, resTime} = taskMap[key];
        alyStatsData[key] = {
            ab:Math.ceil(availability/count * 100)/100,
            rt:Math.ceil(resTime/resCount * 100)/100,
        }
    }
    return alyStatsData
}

const accessKeyId = 'LTAI4Fp5YFFscbiMjsMXcvsP';
const accessKeySecret = 'Lfj458KmSQJ4s63xqugtLfL9Fgah9d';
async function getAL(MetricName, startTime, endTime, period) {
    let params = {
        "Namespace": "acs_networkmonitor",
        "MetricName":MetricName,
        "Period": period,
        "StartTime": startTime+'',
        "EndTime": endTime+''
    }
    return await alyPost(params, 'DescribeMetricList');
}

async function getTaskInfo(taskId) {
    let params = {
        "TaskId": taskId
    };
    let result:any = await alyPost(params, 'DescribeSiteMonitorAttribute');
    if (result["Code"] != "200") return null;
    return result.SiteMonitors;
}

function alyPost(params, path) {
    return new Promise((res, rej) => {
        var client = new Core({
            accessKeyId,
            accessKeySecret,
            endpoint: 'https://metrics.cn-hangzhou.aliyuncs.com',
            apiVersion: '2019-01-01'
        });
        var requestOption = {
            method: 'POST'
        };
        
        client.request(path, params, requestOption).then((result) => {
            res(result);
        }, (ex) => {
            res(ex);
        });
    });
}