import { getBaiduStats, getUV } from "../data/interface/baiduStats";
import { getZyhdbzData } from "../data/interface/data";
import { statsQueue } from "../data/interface/queueData";
import { getKeyValueListData, getReflectionData } from "./out";


export async function getData(req, res) {
    let ret:any = {};

    let {zcyh, yjbzya, bzry, hdcyd, yhtsl, zyhdbzzjdt, yhtslzs, rlzb, rlzbsylqs} = await getZyhdbzData();

    ret["zcyh"] = getKeyValueListData("注册用户", zcyh);
    ret["yjbzya"] = getKeyValueListData("应急保障预案", yjbzya);
    ret["bzry"] = getReflectionData("保障人员",bzry, {name:"key", info:"value"});
    ret["hdcyd"] = getReflectionData("活动参与度", hdcyd, {district:"key", hdcyd:"value"});
    ret["yhtsl"] = getKeyValueListData("用户投诉量", yhtsl); 
    ret["zyhdbzzjdt"] = getReflectionData("中间地图数据", zyhdbzzjdt, {num:"value", district:"key"});  

    let {monthStatsData, dayStatsData} = statsQueue["日活月活"];
    ret["dau"] = getReflectionData("日活", dayStatsData, {}); 
    ret["mau"] = getReflectionData("月活", monthStatsData, {});

    ret["yhtslzs"] = {title:"用户投诉总数", data:parseInt(yhtslzs["用户投诉总数"] || 0)};

    let uv = statsQueue["uv"];
    ret["hdzfwrs"] = {title:"活动总访问人数", data:uv || 0};

    //应用系统监控
    ret["yyxtjk"] = {
        title:"页面系统监控",
        data:statsQueue["应用系统监控"]
    };
    ret["ymcglqs"] = {
        title:"页面成功率趋势",
        data:statsQueue["应用系统监控趋势"]
    }

    ret["rlzb"] = getKeyValueListData("容量指标", rlzb);

    ret["sylqs"] = {title:"使用率趋势", data:[
        {title:"cpu", list:rlzbsylqs['cpu']},
        {title:"内存", list:rlzbsylqs['nc']},
        {title:"存储", list:rlzbsylqs['cc']}
    ]};

    //重要活动
    res.send(ret);
}