import { getZtyxtsData } from "../data/interface/data";
import { statsQueue } from "../data/interface/queueData";
import { getKeyValueListData, getReflectionData } from "./out";


export async function getData(req, res) {
    let ret:any = {};

    let {dqjxzhd, dqhdrs, bndhds, cyhdrs, ztyxtszjdt, zcyh, dqhds, xxaqfx, zybs, zysylqsData, xtbgsj } = await getZtyxtsData();

    ret["zcyh"] = getKeyValueListData("注册用户", zcyh);
    ret["dqjxzhd"] = getReflectionData("当前进行中活动", dqjxzhd, { hdmc:"key", num:"value"});
    ret["dqhdrs"] = getReflectionData("当前活动人数", dqhdrs, { district:"key", num:"value"});
    ret["bndhds"] = getReflectionData("本年度活动数", bndhds, { month:"key", hd_num:"value"});
    ret["cyhdrs"] = getReflectionData("参与活动人数", cyhdrs, { month:"key",r_num:"value"});
    ret["ztyxtszjdt"] = getReflectionData("中间地图数据", ztyxtszjdt, {num:"value", district:"key" });

    ret["dqhds"] = {title:"当前活动数", data: parseInt(dqhds["num_dqhds"] || 0) };
    ret["ndhds"] = {title:"年度活动数", data: parseInt(dqhds["num_ndhds"] || 0) };
    ret["cyhdrc"] = {title:"参与活动人次", data: parseInt(dqhds["num_cyhdrc"] || 0) };

    ret["yyjk"] = {
        title:"应用监控",
        data:statsQueue["应用监控"]
    };
    ret["yyxt"] = {
        title:"应用系统",
        data:statsQueue["应用系统数"]
    }

    ret["xxaqfx"] = getKeyValueListData("信息安全风险", xxaqfx );

    ret["xtbgsj"] = getKeyValueListData("系统变更升级", xtbgsj );

    ret["zybs"] = {title:"资源部署", dataList:zybs};

    let zykyxInfo = [];
    for (let name in zysylqsData) {
        let {sylqs, zykyx} = zysylqsData[name];
        let addInfo:any = {zysyqk:getKeyValueListData(name, zykyx)};
        addInfo["cpu"] = {name:"cpu", data:sylqs["cpu"]};
        addInfo["nc"] = {name:"内存", data:sylqs["nc"]};
        addInfo["cc"] = {name:"存储", data:sylqs["cc"]};
        zykyxInfo.push(addInfo);
    }
    ret["zykyx"] = {title:"资源可用性", data:zykyxInfo};

    
    res.send(ret);
}