import { TYPEENUM } from "../config/enum";

//对象判空
export function objectKeyIsNull(obj, ...keyNames) {
    let isNull = false;
    for (let i = 0; i < keyNames.length; i++) {
        let keyStr = keyNames[i];
        let moreKeyList = keyStr.split(".");
        let lastObj;
        for (let j = 0; j < moreKeyList.length; j++) {
            lastObj = obj[moreKeyList[j]];
            if (!lastObj) {
                isNull = true;
                break;
            }
        }
        if (isNull) break;
    }
    return isNull;
}

/**
 * 校验类型
 * @param target 目标值
 * @param type TYPEENUM枚举值
 * @returns 通过 = true   不通过 = false
 */
export function checkType(target, type) {
    if (target == undefined || target == null) return false;
    switch (type) {
        case TYPEENUM.string:
            if (typeof target == 'string') {
                return true;
            }
        break;
        case TYPEENUM.number:
            if (typeof target == 'number') {
                return true;
            }
        break;
        case TYPEENUM.object:
            if (typeof target == 'object' && !Array.isArray(target) ) {
                return true;
            }
        break;
        case TYPEENUM.array:
            if (typeof target == 'object' && Array.isArray(target) ) {
                return true;
            }
        break;
        case TYPEENUM.boolean:
            if (typeof target == 'boolean') {
                return true;
            }
        break;
    };
    return false;
}

export function checkStrLeng(str) {
    return str.length < 40;
}