import * as asyncHandler from 'express-async-handler'
import * as sjzltxBiz from '../biz/sjzltx';
import * as ztyxtsBiz from '../biz/ztyxts';
import * as zyhdbzBiz from '../biz/zyhdbz';
import * as glptlb from '../biz/glptlb';

export function setRouter(httpServer){
    httpServer.get('/sjzltx', asyncHandler(sjzltxBiz.getData));
    httpServer.post('/sjzltx', asyncHandler(sjzltxBiz.getData));

    httpServer.get('/ztyxts', asyncHandler(ztyxtsBiz.getData));
    httpServer.post('/ztyxts', asyncHandler(ztyxtsBiz.getData));

    httpServer.get('/zyhdbz', asyncHandler(zyhdbzBiz.getData));
    httpServer.post('/zyhdbz', asyncHandler(zyhdbzBiz.getData));

    httpServer.get('/zyhdbzpop', asyncHandler(zyhdbzBiz.getPopData));
    httpServer.post('/zyhdbzpop', asyncHandler(zyhdbzBiz.getPopData));

    httpServer.get('/glptlb', asyncHandler(glptlb.getData));
    httpServer.post('/glptlb', asyncHandler(glptlb.getData));

    httpServer.get('/glptlb/update', asyncHandler(glptlb.update));
    httpServer.post('/glptlb/update', asyncHandler(glptlb.update));
}