//以下要涉及到百度和阿里的关联 双方用域名关联
import moment = require("moment");
import { getALYStats } from "./aliyunStats";
import { getBaiduSiteList, getBaiduStats, getPVCountBySiteId, getUV } from "./baiduStats";

const bdyAndAlyConfig = {
    "科创实践工作站": {alyName:"正汇实践工作站", alyUrl:"secsa.shec.edu.cn/kc/", baiduUrl:"" },
    "青少年科学研究院": {alyName:"正汇青少年研究院", alyUrl:"secsa.shec.edu.cn/qsnkxyjy/", baiduUrl:"" },
    "体育日常成绩": {alyName:"正汇日常体育成绩", alyUrl:"secsa.shec.edu.cn/tyjs/", baiduUrl:"" },
    "学生体育网": {alyName:"正汇学生体育网", alyUrl:"secsa.shec.edu.cn/xstyw/", baiduUrl:"" },
    "综评": {alyName:"正汇综评系统", alyUrl:"shsunshine-zp.shec.edu.cn/shjw/", baiduUrl:"shsunshine-zp.shec.edu.cn/shjw" },
    "上海市学生体育艺术科技教育活动": {alyName:"玑脉大平台", alyUrl:"shsunshine-zp.shec.edu.cn/", baiduUrl:"shsunshine-zp.shec.edu.cn" },
    "因病缺课缺勤网络直报系统": {alyName:"玑脉直报系统", alyUrl:"shxxybqq.shec.edu.cn/", baiduUrl:"shxxybqq.shec.edu.cn" },
    "OA办事管理系统":{baiduUrl:'secsagl.shec.edu.cn'},
    "教软子系统":{baiduUrl:'shsunshine1-zp.shec.edu.cn'},
    "精英足球训练营":{baiduUrl:''},
    "明日科技之星":{baiduUrl:''},
    "学生活动网及教软负责子系统":{baiduUrl:''},
};

export let statsQueue = {};

async function getSiteInfoStats(isFirst) {
    let alyData:any = await getALYStats(isFirst);
    if (alyData == "timeOut") {
        return false;
    }
    let alySiteUrlAndNameMap = {};
    alyData.taskInfoList.forEach(info => {
        let checkStr = info.Address.replace(/http:\/\//,'')
        checkStr = checkStr.replace(/https:\/\//,'')
        alySiteUrlAndNameMap[checkStr] = info['TaskId'];
    });
    let siteList = await getBaiduSiteList();
    let baiduSiteUrlAndSiteIdMap = {};
    siteList.forEach(info => {
        let str = info.domain;
        baiduSiteUrlAndSiteIdMap[str] = info.site_id;
        if (info.sub_dir_list.length) {
            info.sub_dir_list.forEach(subInfo => {
                baiduSiteUrlAndSiteIdMap[subInfo.name] = subInfo.sub_dir_id;
            });
        }
    });

    let statsData = {};

    let rateOfProgress = Object.keys(bdyAndAlyConfig).length;
    let rateOfProgressIndex = 1;
    let onceRateOfProgressIndex = Math.ceil(30 / rateOfProgress);

    for (let siteName in bdyAndAlyConfig) {
        let info = bdyAndAlyConfig[siteName];
        let baiduSiteUrlAndIdMapKey = info.baiduUrl ? info.baiduUrl : siteName;
        if (!baiduSiteUrlAndIdMapKey) continue;
        let siteId = baiduSiteUrlAndSiteIdMap[baiduSiteUrlAndIdMapKey];
        let count = await getPVCountBySiteId(siteId);
        if (isFirst && !(rateOfProgressIndex % 3)) console.log(`初始化进度 ${50 + (rateOfProgressIndex * onceRateOfProgressIndex)}%`);
        rateOfProgressIndex += 1;
        let time = '0ms';
        let availability = '0%';

        if (info.alyUrl) {
            let taskId = alySiteUrlAndNameMap[info.alyUrl];
            let {ab, rt} = alyData.alyStatsData[taskId] || {ab:0, rt:0};
            availability = `${ab}%`;
            time = `${rt}ms`;
        }
        statsData[siteName] = {count, time, availability };
    }

    let statsList = [];
    for (let key in statsData) {
        let {count, time, availability } = statsData[key];
        statsList.push({key, count, time, availability });
    }
    statsList.sort( (a, b) => {return b.count - a.count});

    statsQueue["应用监控"] = statsList;
    statsQueue["应用系统数"] = statsList.length;
    statsQueue["应用系统监控趋势"] = alyData.todayAvailabilityList;
    let todayAlyStatsData = [
        {key:"页面响应时间", value:alyData.todayAlyStatsData.rt, unit:'ms'},
        {key:"成功率", value:alyData.todayAlyStatsData.ab, unit:'%'}
    ]
    statsQueue["应用系统监控"] = todayAlyStatsData;
    return true;
}

async function statsBaiduData(isFirst) {
    let uv = await getUV();
    if (isFirst) console.log("初始化进度 90%");
    statsQueue["uv"] = uv;
    let 日活月活 = await getBaiduStats();
    if (isFirst) console.log("初始化进度 100%");
    statsQueue["日活月活"] = 日活月活;
}

export async function initQueueData() {
    console.log("开始初始化阿里云与百度云数据");
    let result = await getSiteInfoStats(true);
    await statsBaiduData(true);
    if (result) {
        console.log("初始化缓存数据成功");
        //隔一个小时统计数据
        setInterval( async () => {
            let result = await getSiteInfoStats(false);
            await statsBaiduData(false);
            if (!result) console.log(moment().format("YYYY-MM-DD hh:mm:ss"), " 请求 阿里云超时 将在一小时后重试" );
        }, 600* 1000);
    }
    return result;
}