import { requestConfig } from "../../serverConfig";
import { BizError } from "../../util/bizError";
import { postForm } from "../../util/request";
import { getUrl, urlEnum } from "./url";

let token = "";
let tokenTime = 0;//有效时间
let lastTime = 0;//上一次时间
const timeOutTime = 50;//超时时间s

async function gettoken() {
    let time = new Date().valueOf();

    if ( (Math.ceil((time - lastTime)/1000 ) + timeOutTime )> tokenTime ) {
        let url = getUrl(urlEnum.获取token);
        let head = {};
        let body = {client_id:requestConfig.client_id, client_secret:requestConfig.client_secret};
        let result:any = await postForm(url, body, head);
        if (!result || !result.access_token || !result.expires_in) {
            throw new BizError(`获取token 失败： ${JSON.stringify(result)}`, );
        }

        token = result.access_token;
        tokenTime = result.expires_in;
        lastTime = time;
        console.log("获取一次token",`token${token}, lastTime ${lastTime}, time ${time}, tokenTime ${tokenTime}, `);
    }
    
}