import { activityStats, getRecentlyActivityStats } from "./baiduStats";
import { getActivityListData } from "./data";
import moment = require("moment");


export let lastActiveMap = {};
//第一次检测到有数据的时间 如果想要设定时间，把时间填这里
let haveDataTime = 0;

async function cacheActivityData() {
    let activityList = await getActivityListData();
    let haveUpdate = false;
    for (let i = 0; i < activityList.length; i++) {
        let {hdkssj, hdjssj, hdmc, hdxh, hdzt, hdztxh, yhtsl, zcrs} = activityList[i];
        if (!hdkssj || !hdjssj || !hdmc) continue;

        let {startTime, endTime} = getDateFormat(hdkssj, hdjssj);

        let oldItem = lastActiveMap[hdmc];

        let thisItemIsNew = false;
        if ( !oldItem ) thisItemIsNew = true;   
        else if (oldItem.startTime != startTime || oldItem.endTime != endTime ) thisItemIsNew = true;
        
        if ( thisItemIsNew ) {
            let dataList = await activityStats(startTime, endTime);
            lastActiveMap[hdmc] = {startTime, endTime, hdxh, hdzt, hdztxh, yhtsl, zcrs, dataList, hdkssj, hdjssj};
        }
    }
    return haveUpdate;
}

function getDateFormat(startTime:number, endTime:number) {
    return {
        startTime:moment(startTime).format('YYYYMMDD'), 
        endTime: moment(endTime).format('YYYYMMDD'),  
    };
}


let startScopeTime = 0;
let endScopeTime= 0;
//这里放活动缓存机制
export function initActivityQueue() {
    cacheActivityData();//活动数据
    setInterval( async () => {
        let thisTime = new Date().valueOf();
        
        //历史数据
        if ( !haveDataTime ) {//当不设置活动更像时间的时候
            let haveUpdate = cacheActivityData();
            if (haveUpdate) {//如果发现了活动列表更新
                haveDataTime = thisTime.valueOf();
                //向上向下取10s
                let startScopeM = parseInt(moment(thisTime-(10 * 1000)).format("m"));
                let startScopeS = parseInt(moment(thisTime-(10 * 1000) ).format("s"));
                let endScopeM = parseInt(moment(thisTime+(10 * 1000)).format("m"));
                let endScopeS = parseInt(moment(thisTime+(10 * 1000) ).format("s"));
                startScopeTime = (startScopeM * 60)+ startScopeS;
                endScopeTime= (endScopeM * 60)+ endScopeS;
            }
        } else {//设置了活动更新时间 或者 系统第一次发现数据更新的时间
            let thisM = parseInt(moment(thisTime).format("m"));
            let thisS = parseInt(moment(thisTime).format("s"));
            let thisMS = (thisM * 60) + thisS;

            if (endScopeTime < startScopeTime) {//结束范围小于开始范围
                if (thisMS >= startScopeTime || thisM <= endScopeTime) cacheActivityData();
            } else {//正常时间轴
                if ( thisMS >= startScopeTime && thisMS <= endScopeTime ) cacheActivityData();
            }
        }
        //当天数据


        
    }, 10* 1000);
    //今日数据
    cacheTowData();
    setInterval( async () => {
        cacheTowData();
    }, 600 * 1000);
}

//缓存近7个小时的数据
export let sevenHourActivity = [];
async function cacheTowData() {
    let nowTime = moment();
    let startTime = moment().subtract(7, 'hours');
    let startDay = startTime.get('date');
    let today = nowTime.get('date');


    let onceDayData = await getRecentlyActivityStats(nowTime.format('YYYYMMDD'), nowTime.add(1,'days').format('YYYYMMDD'));

    let queueList = [];
    let count = 0;
    for (let i = 0; i < onceDayData.length; i++) {
        if (count >= 7) break;
        let {key, value} = onceDayData[i];
        let name = key.split(":")[0];
        queueList.push({key:name, value});
        count += 1;
    }
    
    if (startDay != today) {
        let lastDayData = await activityStats( startTime.format('YYYYMMDD'), nowTime.format('YYYYMMDD'));
        for (let i = 0; i < lastDayData.length; i++) {
            if (count >= 8) break;
            let {key, value} = lastDayData[i];
            let name = key.split(":")[0];
            queueList.push({key:name, value});
            count += 1;
        }
    }

    sevenHourActivity = queueList;
}

