const fs = require("fs");
const path = require("path");

/**
 * 对json文件进行添加的操作
 * @param fileUrl 文件路径
 * @param params 添加的数据
 * @returns 
 */
export async function addJson(fileUrl, params) {
    let url = path.join(__dirname.substring(0,__dirname.indexOf("out")), fileUrl);
    try {
        let data = fs.readFileSync(url);
        let person = data.toString();//二进制转化为字符串
        person = JSON.parse(person);//将字符串转换为json对象
        let paramsId = params.id;//获取新增数据的id

        for (let i = 0; i < person.data.length; i++) {
            if (paramsId == person.data[i].id) {//判断是否重复
                return {"ok": "id不能重复"};
            }
        }
        person.data.push(params);

        let str = JSON.stringify(person);

        let write = fs.writeFileSync(url, str);
        if(write != null) {
            console.log('-----------新增失败-----------');
            return {"ok": false};
        } else {
            console.log('-----------新增成功-----------');
            return {"ok": true};
        }
    } catch (err) {
        if (err.code === 'ENOENT') { 
            console.log('File not found!'); 
        } else { 
            // console.log("失败！");
            console.error(err);
            throw err; 
        }
    }
    
}

/**
 * 对json文件进行删除的操作
 * @param fileUrl 文件路径
 * @param id 删除的id
 */
export async function delJson(fileUrl, id) {
    let result;
    let url = path.join(__dirname.substring(0,__dirname.indexOf("out")), fileUrl);
    try {
        let data = fs.readFileSync(url);
        let person = data.toString();
        person = JSON.parse(person);

        let isok = false;
        for (let i = 0; i < person.data.length; i++) {
            if (id == person.data[i].id) {
                person.data.splice(i, 1);
                // result = JSON.stringify({
                //     "ok": true
                // });
                isok = true;
            } else {
                // return JSON.stringify({"ok": "id不存在"});
                isok = false;
            }
        }
        if (isok) {
            let str = JSON.stringify(person);
            let write = fs.writeFileSync(url, str);
            if(write != null) {
                return {"ok": false};
            }
            return {"ok": true};
        } else {
            return {"ok": "id不存在"};
        }
        
    } catch (err) {
        if (err.code === 'ENOENT') { 
            console.log('File not found!'); 
        } else { 
            // console.log("失败！");
            console.error(err);
            throw err; 
        }
    }
    
}

/**
 * 对json文件进行修改的操作
 * @param fileUrl 文件路径
 * @param id 修改的id
 * @param params 修改的数据
 */
export async function updataJson(fileUrl, id, params) {
    let url = path.join(__dirname.substring(0,__dirname.indexOf("out")), fileUrl);
    try {
        let data = fs.readFileSync(url);
        let person = data.toString();
        person = JSON.parse(person);

        for (let i = 0; i < person.data.length; i++) {
            if (id == person.data[i].id) {
                person.data[i] = params;
            }
            // for (let key in person.data[i]) {
            //     if (id == key) {
            //         for (let paramsKey in params) {
            //             if (person.data[i][paramsKey]) {
            //                 person.data[i][paramsKey] = params[paramsKey];
            //             }
            //         }
            //     }
            // }
        }

        let str = JSON.stringify(person);

        let write = fs.writeFileSync(url, str);
        if(write != null) {
            console.log('-----------修改失败-----------');
        }
        console.log('-----------修改成功-----------');
    } catch (err) {
        if (err.code === 'ENOENT') { 
            console.log('File not found!'); 
        } else { 
            // console.log("失败！");
            console.error(err);
            throw err; 
        }
    }
    
}

export async function selectJson(fileUrl) {
    let result;
    let url = path.join(__dirname.substring(0,__dirname.indexOf("out")), fileUrl);
    try {
        let data = fs.readFileSync(url);
        let person = data.toString();
        person = JSON.parse(person);
        result = person.data;
        if (person.data == null) {
            return JSON.stringify({
                "ok": false
            });
            // console.log('-----------查询失败-----------');
        } else {
            return result;
        }
        // console.log('-----------查询成功-----------');
    } catch (err) {
        if (err.code === 'ENOENT') { 
            console.log('File not found!'); 
        } else { 
            // console.log("失败！");
            console.error(err);
            throw err; 
        }
    }
}