import * as crod from "../crod";

const roleUrl = './mock/role.json';
const permitUrl = './mock/permit.json';

/**
 * 创建角色
 * @param roleName 角色名称
 * @param permission 角色权限
 * {"id":1,"name":"角色1","permit":[2,3]}
 */
export async function createRole(roleName, permitId?) {
    let result;
    let roleId = Date.now();
    let roleParams = {"id":roleId, "name":roleName, "permit": permitId}
    if (roleName != null) {
        result = await crod.addJson(roleUrl, roleParams);
        if (result.ok) {
            console.log('-----------删除成功-----------');
        } else {
            console.log('-----------删除失败-----------'); 
        }
    }

    console.log(result);
    return result;
    
}

/**
 * 查询角色权限
 * @param permitUrl json路径
 * @returns 
 */
export async function getPermit(permitUrl) {
    let result = await crod.selectJson(permitUrl);
    if (result == null) {
        console.log('-----------查询失败-----------');
    } else {
        console.log('-----------查询成功-----------');
    }
    console.log(result);
    return result;
}

/**
 * 删除角色
 * @param id 角色id
 * @returns 
 */
export async function deleteRole(id) {
    let result = await crod.delJson(roleUrl, id);
    
    if (result.ok) {
        console.log('-----------删除成功-----------');
    } else {
        console.log('-----------删除失败-----------'); 
    }

    console.log(result);
    return result;
}