import { lastActiveMap, sevenHourActivity } from "../data/interface/activeQueueData";
import { getBaiduStats, getUV } from "../data/interface/baiduStats";
import { getZyhdbzData } from "../data/interface/data";
import { statsQueue } from "../data/interface/queueData";
import { getKeyValueListData, getReflectionData } from "./out";
import moment = require("moment");


export async function getData(req, res) {
    let ret:any = {};

    let {zcyh, yjbzya, bzry, hdcyd, yhtsl, zyhdbzzjdt, yhtslzs, rlzb, rlzbsylqs} = await getZyhdbzData();

    ret["zcyh"] = getKeyValueListData("注册用户", zcyh);
    ret["yjbzya"] = getKeyValueListData("应急保障预案", yjbzya);
    ret["bzry"] = getReflectionData("保障人员",bzry, {name:"key", info:"value"});
    ret["hdcyd"] = getReflectionData("活动参与度", hdcyd, {district:"key", hdcyd:"value"});
    ret["yhtsl"] = getKeyValueListData("用户投诉量", yhtsl); 
    ret["zyhdbzzjdt"] = getReflectionData("中间地图数据", zyhdbzzjdt, {num:"value", district:"key"});  

    let {monthStatsData, dayStatsData} = statsQueue["日活月活"];//百度云数据
    ret["dau"] = getReflectionData("日活", dayStatsData, {}); 
    ret["mau"] = getReflectionData("月活", monthStatsData, {});

    ret["yhtslzs"] = {title:"用户投诉总数", data:parseInt(yhtslzs["用户投诉总数"] || 0)};

    let uv = statsQueue["uv"];//百度云数据
    ret["hdzfwrs"] = {title:"活动总访问人数", data:uv || 0};

    //应用系统监控
    ret["yyxtjk"] = {
        title:"页面系统监控",
        data:statsQueue["应用系统监控"]
    };
    ret["ymcglqs"] = {
        title:"页面成功率趋势",
        data:statsQueue["应用系统监控趋势"]
    }

    ret["rlzb"] = getKeyValueListData("容量指标", rlzb);

    ret["sylqs"] = {title:"使用率趋势", data:[
        {title:"cpu", list:rlzbsylqs['cpu']},
        {title:"内存", list:rlzbsylqs['nc']},
        {title:"存储", list:rlzbsylqs['cc']}
    ]};

    //重要活动
    res.send(ret);
}

function getViewShowDateFormat(startTime:number, endTime:number) {
    return `${moment(startTime).format('YYYY/MM/DD')}~${moment(endTime).format('MM/DD')}`;
}

export async function getPopData(req, res) {
    //访问人数和访问趋势获取阿里云 玑脉大平台 数据

    let result = [];
    
    let timeMs = new Date().valueOf();

    for (let key in lastActiveMap) {
        let {hdxh, yhtsl, zcrs, dataList, hdkssj, hdjssj} = lastActiveMap[key];

        let state = "活动预告";
        if (hdxh == "1") state = "活动进行中";
        else if (hdxh == "2")  state = "活动结束";

        let access = 0;
        let trend = [];
        if (hdkssj <= timeMs ) {
            dataList.forEach(info => {
                let {key, value} = info;
                access += value;
            });

            if (hdkssj + (7*3600*1000) >= timeMs ) {
                trend = sevenHourActivity;
            } else {
                trend = dataList;
            }
        }

        let onceData = {
            title:key,
            time:getViewShowDateFormat(hdkssj, hdjssj),
            state,
            registered:parseInt(zcrs),//注册人数
            complaints:parseInt(yhtsl),//投诉量
            access,
            trend
        };
        result.push(onceData);
    }


    res.send({dataList:result});
}


