
import { planarArrDecollateForIndex, planarArrDeconstruct, planarArrForObjectList } from "../../dataPackage/planaryArrayAnalysis";
import { onceSheetBecomeOfblockData } from "../../util/analysisExcel";

function packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList) {
    let result = {};

    for (let i = 0; i < blockDataList.length; i++) {
        let {blockData, blockTitle} = blockDataList[i];
        if (keyValueOrTitleList.indexOf(blockTitle) > -1) {
            let titleList = titltListConfig[blockTitle] || [];
            result[blockTitle] = planarArrForObjectList(blockData, 0, titleList);
        }
        else if (barChartList.indexOf(blockTitle) > -1) {
            result[blockTitle] = planarArrDeconstruct(blockData);
        }
        else if (stringList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrForObjectList(blockData);
        else if (decollatePlanarList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrDecollateForIndex(blockData);
    }

    return result;
}


export function ztbxTableData() {
    let blockDataList = onceSheetBecomeOfblockData('对内.xlsx', '整体办学');

    let keyValueOrTitleList = ['教学常规', '作业批改情况', '迟到类型', '食堂检测', '食堂其他信息']; //适配 饼图 键值以及需要多个Key的
    let barChartList = []; //适配 柱状图 折线图
    let stringList = [];
    let decollatePlanarList = []; //适配 表格
    let titleListConfig = {};

    let result = packageDataProcess(blockDataList, titleListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


/**
 * 弃用，改为接口
 * @returns 
 */
export function xxgzapTableData() {
    let blockDataList = onceSheetBecomeOfblockData('对内.xlsx', '学校工作安排');

    let keyValueOrTitleList = ['一', '二', '三', '四', '五', '六', '日']; //适配 饼图 键值以及需要多个Key的
    let barChartList = []; //适配 柱状图 折线图
    let stringList = [];
    let decollatePlanarList = []; //适配 表格
    let titleListConfig = {};

    let result = packageDataProcess(blockDataList, titleListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function xxzdhdTableData() {
    let blockDataList = onceSheetBecomeOfblockData('对内.xlsx', '学校重大活动');

    let keyValueOrTitleList = ['一', '二', '三', '四', '五', '六', '日']; //适配 饼图 键值以及需要多个Key的
    let barChartList = []; //适配 柱状图 折线图
    let stringList = [];
    let decollatePlanarList = []; //适配 表格
    let titleListConfig = {};

    let result = packageDataProcess(blockDataList, titleListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function jshxTableData() {
    let blockDataList = onceSheetBecomeOfblockData('对内.xlsx', '教师画像');

    let keyValueOrTitleList = ['男女人数', '学历分布', '教龄分布', '年龄分布', '教师政治面貌', '职称分布', '师资结构', '学科导师团队', 
    '教师学分获取汇总数据', '教师学分获取', '1-4年级总课时量', '5-9年级总课时量', '高中部总课时量']; //适配 饼图 键值以及需要多个Key的
    let barChartList = []; //适配 柱状图 折线图
    let stringList = [];
    let decollatePlanarList = ['校本课程', '拓展课程', '选修课程', '进修课程数据']; //适配 表格
    let titleListConfig = {};

    let result = packageDataProcess(blockDataList, titleListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function njzjshxTableData(sheetName) {
    let blockDataList = onceSheetBecomeOfblockData('年级组教师信息.xlsx', sheetName);

    let keyValueOrTitleList = ['教师资源', '学科导师占比', '满工作量的人数', '不满工作量的人数', '超工作量的人数', '听评课情况', '出勤考核-日', '出勤考核-周', '出勤考核-月', 
    '整体出勤率-日', '整体出勤率-周', '整体出勤率-月', '会议出勤情况-日', '会议出勤情况-周', '会议出勤情况-月', '请假情况-日', '请假情况-周', '请假情况-月', 
    '请假原因占比分析-日', '请假原因占比分析-周', '请假原因占比分析-月', '教研活动', '教研活动详细', '课题参与次数', '公开课参与次数', '教师进修培训情况', 
    '大学听课', '名师工作室', '基地学习', '校本研修', '奖项数量', '教学比赛参与情况', '教学满意度反馈一至四', '教学满意度反馈五至九', '教学满意度反馈高中', 
    '工作坊活动参与情况']; //适配 饼图 键值以及需要多个Key的
    let barChartList = []; //适配 柱状图 折线图
    let stringList = [];
    let decollatePlanarList = ['优秀班主任导师', '课题参与', '公开课参与', '教学比赛参与情况详细']; //适配 表格
    let titleListConfig = {};

    let result = packageDataProcess(blockDataList, titleListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function jsgrfzTableData() {
    let blockDataList = onceSheetBecomeOfblockData('对内.xlsx', '教师画像个人');

    let keyValueOrTitleList = ['学生评价', '学生平均评价', '同行评价', '同行平均评价', '参与创建特色课程', '教师研修学分获取', '学分', '课程', '填报学期', '上学期', '下学期', '历年满勤统计']; //适配 饼图 键值以及需要多个Key的
    let barChartList = []; //适配 柱状图 折线图
    let stringList = [];
    let decollatePlanarList = ['参与创建特色课程详细', '教师研修学分获取详细']; //适配 表格
    let titleListConfig = {};

    let result = packageDataProcess(blockDataList, titleListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function xshxnjzTableData(sheetName) {
    let blockDataList = onceSheetBecomeOfblockData('年级组学生信息.xlsx', sheetName);

    let keyValueOrTitleList = ['品德发展与公民素养', '综合评价', '修业课程与学业成绩-优秀', '修业课程与学业成绩-良好', '修业课程与学业成绩-合格', '创新精神与实践能力', 
    '科技素养-基础数据', '人文素养-基础数据', '艺术素养-基础数据', '健康素养-基础数据', 
    '科技素养-年级课题列表明细', '人文素养-年级课题列表明细', '艺术素养-年级课题列表明细', '健康素养-年级课题列表明细', 
    '科技素养-各班级创新情况', '人文素养-各班级创新情况', '艺术素养-各班级创新情况', '健康素养-各班级创新情况', 
    '各级各类活动', '获奖成果展示']; //适配 饼图 键值以及需要多个Key的
    let barChartList = []; //适配 柱状图 折线图
    let stringList = [];
    let decollatePlanarList = ['科技素养-年级课题列表明细表格', '人文素养-年级课题列表明细表格', '艺术素养-年级课题列表明细表格', '健康素养-年级课题列表明细表格', 
    '各级各类活动-科技素养', '各级各类活动-人才素养', '各级各类活动-艺术素养', '各级各类活动-健康素养']; //适配 表格
    let titleListConfig = {};

    let result = packageDataProcess(blockDataList, titleListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function xshxgrTableData() {
    let blockDataList = onceSheetBecomeOfblockData('对内.xlsx', '学生画像个人');

    let keyValueOrTitleList = ['科技素养', '人文素养', '艺术素养', '健康素养']; //适配 饼图 键值以及需要多个Key的
    let barChartList = []; //适配 柱状图 折线图
    let stringList = [];
    let decollatePlanarList = []; //适配 表格
    let titleListConfig = {};

    let result = packageDataProcess(blockDataList, titleListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function xycjTableData() {
    let blockDataList = onceSheetBecomeOfblockData('对内.xlsx', '学业成绩');

    let keyValueOrTitleList = ['学业成绩']; //适配 饼图 键值以及需要多个Key的
    let barChartList = []; //适配 柱状图 折线图
    let stringList = [];
    let decollatePlanarList = []; //适配 表格
    let titleListConfig = {};

    let result = packageDataProcess(blockDataList, titleListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}



