import moment = require("moment");
import { ERRORENUM } from "../../config/errorEnum";
import { systemConfig } from "../../config/serverConfig";
import { BizError } from "../../util/bizError";
import { get, post, postForm } from "../../util/request";
const CryptoJS = require('crypto-js');
const Crypto = require('crypto');

let token = "";//post 请求凭证


/**
 * 封装get请求
 */
export async function getReqApiData(url:string, body:object, mothod?, dataNotInList?, jkmc?) {
    let ms = new Date().valueOf();
    let appSecret = systemConfig.appSecret;
    let appKey = systemConfig.appKey;
    if (!mothod) mothod = "GET";
    let stage = "1";

    let auths = `${systemConfig.appKey}&${mothod}&${stage}&${ms}`;
    let hash = CryptoJS.HmacSHA256(auths, CryptoJS.enc.Base64.parse(appSecret));
    let hashInBase64 = CryptoJS.enc.Base64.stringify(hash);

    const headers = {
        "TY-Stage": stage,
        "TY-AppKey": systemConfig.appKey,
        "TY-Timestamp": ms,
        "TY-Signature": hashInBase64
    }

    let query:any = Object.assign(body, {client_id:appKey});
    if (jkmc == "jsfz") query = Object.assign(body, {app_key:appKey});
    if (jkmc == "platform") query = Object.assign(body, {platformCode:999999});
    //todo 没有找到对应接口，数据直接返回0
    if (!url) return 0;

    let res:any = await get(`${systemConfig.url}${url}`, query, headers );

    if (dataNotInList) return res[dataNotInList];
    if (res.page) return res.page; 
    if (res.list) return res.list;
    // else return res.body;
    else return res;
}



/**
 * 封装的post请求
 * @param url 请求路由
 * @param body 请求参数
 * @returns 
 */
export async function postReqApiData(url:string, body:object) {
    let ms = new Date().valueOf();
    const AppKey = systemConfig.appKey;
    const SignatureStr = `${AppKey}&POST&1&${ms}`;
    const Hash = CryptoJS.HmacSHA256(SignatureStr, CryptoJS.enc.Base64.parse(systemConfig.appSecret));
    const Base64Str = CryptoJS.enc.Base64.stringify(Hash);
    let headers = {
        "TY-Stage":"1",
        "TY-AppKey":AppKey,
        "TY-Timestamp":ms,
        "TY-Signature":Base64Str
    };

    let query = { accessToken:token };

    let res:any = await postForm(`${systemConfig.url}${url}?accessToken=${token}`, query, body,  headers );
    // let res:any = await post(`${systemConfig.url}${url}?accessToken=${token}`, query, body,  headers );
    
    if (res.retCode != "000000") {
        /**更新token */
        await updateToken();
        res = await postForm(`${systemConfig.url}${url}?accessToken=${token}`, query, body,  headers );
    }

    return res;
}



/**
 * 更新token
 */
export async function updateToken() {
    let timeStamp = new Date().valueOf();
    let appId = 'F3D05D1E729B366ABDEFBD5380815DA7';
    // let appId = 'AD0CB88FD07BAB073EFEEE64ECD17B4D';
    let appKey = '376f898f9ba7432f90c640d5485c194c';
    let data = `${appId}${appKey}${timeStamp}`;

    const AppKey = systemConfig.appKey;
    const SignatureStr = `${AppKey}&GET&1&${timeStamp}`;
    const Hash = CryptoJS.HmacSHA256(SignatureStr, CryptoJS.enc.Base64.parse(systemConfig.appSecret));
    const Base64Str = CryptoJS.enc.Base64.stringify(Hash);
    let headers = {
        "TY-Stage":"1",
        "TY-AppKey":AppKey,
        "TY-Timestamp":timeStamp,
        "TY-Signature":Base64Str
    };
    let reqBody = {
        appId,
        timeStamp,
        keyInfo:hmacSHA1(data, appKey),
        platformCode:"999999"
    }

    let res:any = await post(`https://api-gateway.sasu.shanghaitech.edu.cn/getAccessToken`, {}, reqBody, headers);

    if (res.retCode == '000000') {
        let {accessToken} = res.tokenInfo;
        console.log("token 更新=>", accessToken);
        if (accessToken) token = accessToken;
        else throw new BizError(ERRORENUM.TOKEN获取失败);
    } else {
        throw new BizError(ERRORENUM.TOKEN更新失败);
    }
}


function hmacSHA1(data, key) {  
    let mac = Crypto.createHmac('sha1', Buffer.from(key, 'UTF-8'));
    mac.update(Buffer.from(data, 'UTF-8'));
    return mac.digest('hex');
}  


/**
 * 加密
 */
export async function getBase64Str() {
    let timeStamp = new Date().valueOf();
    let appId = 'F3D05D1E729B366ABDEFBD5380815DA7';
    let appKey = '376f898f9ba7432f90c640d5485c194c';
    let data = `${appId}${appKey}${timeStamp}`;

    const AppKey = systemConfig.appKey;
    const SignatureStr = `${AppKey}&GET&1&${timeStamp}`;
    const Hash = CryptoJS.HmacSHA256(SignatureStr, CryptoJS.enc.Base64.parse(systemConfig.appSecret));
    const Base64Str = CryptoJS.enc.Base64.stringify(Hash);

    return Base64Str;
}


/**
 * 获取token
 */
export async function getAppToken() {
    let timeStamp = new Date().valueOf();
    let appId = 'F3D05D1E729B366ABDEFBD5380815DA7';
    // let appId = 'AD0CB88FD07BAB073EFEEE64ECD17B4D';
    let appKey = '376f898f9ba7432f90c640d5485c194c';
    let data = `${appId}${appKey}${timeStamp}`;

    const AppKey = systemConfig.appKey;
    const SignatureStr = `${AppKey}&GET&1&${timeStamp}`;
    const Hash = CryptoJS.HmacSHA256(SignatureStr, CryptoJS.enc.Base64.parse(systemConfig.appSecret));
    const Base64Str = CryptoJS.enc.Base64.stringify(Hash);
    let headers = {
        "TY-Stage":"1",
        "TY-AppKey":AppKey,
        "TY-Timestamp":timeStamp,
        "TY-Signature":Base64Str
    };
    let reqBody = {
        appId,
        timeStamp,
        keyInfo:hmacSHA1(data, appKey),
        platformCode:"999999"
    }

    let res:any = await post(`https://api-gateway.sasu.shanghaitech.edu.cn/getAccessToken`, {}, reqBody, headers);
    let validTime = parseInt(res.tokenInfo.validTime);
    console.log(moment(validTime).format("YYYY-MM-DD HH:mm:ss"));

    if (res.retCode == '000000') {
        let {accessToken} = res.tokenInfo;
        console.log("token 更新=>", accessToken);
        if (accessToken) {
            token = accessToken;
            return token;
        }
        else throw new BizError(ERRORENUM.TOKEN获取失败);
    } else {
        throw new BizError(ERRORENUM.TOKEN更新失败);
    }
}


/**
 * 获取ticket
 */
 export async function getAppTicket(ticket) {
    let ms = new Date().valueOf();
    let appSecret = systemConfig.appSecret;
    let appKey = systemConfig.appKey;
    let mothod = "GET";
    let stage = "1";

    let auths = `${systemConfig.appKey}&${mothod}&${stage}&${ms}`;
    let hash = CryptoJS.HmacSHA256(auths, CryptoJS.enc.Base64.parse(appSecret));
    let hashInBase64 = CryptoJS.enc.Base64.stringify(hash);

    const headers = {
        "TY-Stage": stage,
        "TY-AppKey": systemConfig.appKey,
        "TY-Timestamp": ms,
        "TY-Signature": hashInBase64
    }

    let query = Object.assign({}, {client_id:appKey});
    //todo 没有找到对应接口，数据直接返回0
    let accessToken = await getAppToken();
    let res:any = await get(`${systemConfig.url}/getTicket?ticket=${ticket}&accessToken=${accessToken}`, query, headers);

    return res;
}










