import { systemConfig } from "../config/serverConfig";

const fs = require("fs");
const path = require('path');
// 图片文件的扩展名数组
const imageExtensions = ['.jpg', '.jpeg', '.png', '.gif', '.bmp', '.tiff', '.svg'];
 
export function getKeyValue(data) {
    let result = [];
    data.forEach( info => {
        let {count, type} = info;
        result.push({
            key:type,
            value:count
        })
    })

    return result;
}


/**
 * 获取教师画像图片
 * @param dirPath 文件地址
 * @param filesList 存放数据数组
 * @param ext 文件类型
 * @returns 
 */
export function readFileList(dirPath, filesList, ext) {
    let files = fs.readdirSync(dirPath);
    // console.log(files);
    for (let i = 0; i < files.length; i++) { 
        let itm = files[i];
        let stat = fs.statSync(dirPath + itm);
        if (stat.isDirectory()) { //判断文件是否是目录
            //递归读取文件
            readFileList(dirPath + itm + "/", filesList, ext)
        } else if (path.extname(itm).toLowerCase() === `.${ext}`) {
            let filePath = `${dirPath}${itm}`;
            /**截取掉地址前面的pdf/ */
            let pdfToRemove = filePath.replace(new RegExp(`^img/`), "");
            let fileStr = `${systemConfig.ipUrl}${pdfToRemove}`;
            filesList.push(fileStr);
        }
    }

    return filesList;
}


/**
 * 获取指定路径下的所有图片
 * @param dirPath 
 * @param filesList 
 * @param ext 
 * @returns 
 */

export function getImagesInDir(dirPath) {
    let files = fs.readdirSync(dirPath);
    let images = [];
    
    files.forEach(file => {
        let filePath = `${dirPath}${file}`;
        /**截取掉地址前面的pdf/ */
        let pdfToRemove = filePath.replace(new RegExp(`^img/`), "");
        let fileStr = `${systemConfig.ipUrl}${pdfToRemove}`;
        // let fullPath = path.join(dirPath, file);
        let ext = path.extname(file).toLowerCase();
    
        if (imageExtensions.includes(ext)) {
            let nameWithoutExt = path.basename(file, ext);
            // 如果是图片文件，则添加到结果数组中
            images.push({
                name:nameWithoutExt,
                img:fileStr
            });
        }
        // 注意：这里没有递归调用，所以不会检查子文件夹
    });
 
    return images;
}


/**
 * 检查文件夹内是否有指定名称的图片文件
 * @param dirPath 文件夹路径
 * @param fileName 文件名称
 * @returns 
 */
export function hasImages(dirPath, fileName) {
    let filePath = path.join(dirPath, fileName);
    let has = fs.existsSync(filePath);

    return has;
}




// 检查文件是否为图片文件的函数
function isImageFile(file) {
    let ext = path.extname(file).toLowerCase();
    return imageExtensions.includes(ext);
}





