/**
 * 整体办学（对外）
 */

import { ztbxWENUM } from "../../config/interficeEnum";
import { getReqApiData } from "../../data/interface/url";
import moment = require("moment");
import { getKeyValue, hasImages } from "../outData";
import { jyzjshxTableData, tysjyTableData, xshxTableData, ztbxTableData } from "../../data/table/duiwai";
import { keyValuePackage, onceYBarChartPackage } from "../../dataPackage/inFrontOut";
import { systemConfig } from "../../config/serverConfig";
import { jshxTableData } from "../../data/table/duinei";


export async function getData(req, res) {
    let ret:any = {};
    let excelData = ztbxTableData();
    let 统一excelData = tysjyTableData();
    let jshxexcelData = jshxTableData()
    let xxhxExcelData = xshxTableData();

    const NowTime = new Date();
    let startTime = moment("2024-01-01").format("YYYY-MM-DD 00:00:00")
    let endTime = moment(NowTime).format("YYYY-MM-DD HH:mm:ss")

    let xshbqkData = await getReqApiData(ztbxWENUM.各学段学生变化情况, {});
    let zsrs = 0;
    let xshbqk = {};
    xshbqkData.studentNum.forEach( info => {
        let {code, name, value} = info;
        zsrs += value;
        if(!xshbqk[code]) xshbqk[code] = []
        xshbqk[code].push({
            key:name,
            value,
        })
    });

    let nianji = ["小学", "初中", "高中"];
    let zsrstj = {};
    for(let sjd in xshbqk) {
        zsrstj[sjd] = {}
        for(let i = 0; i < nianji.length; i++) {
            zsrstj[sjd][nianji[i]] = 0;
        };
        let xshbqkList = xshbqk[sjd];
        for (let sj in zsrstj) {
            xshbqkList.forEach( info => {
                let {key, value} = info;
                zsrstj[sjd][key] = value;
            })
        };
    };

    let xssbhqk = {};
    for(let key in zsrstj) {
        if (!xssbhqk[key]) xssbhqk[key] = [];
        for(let name in zsrstj[key]) {
            xssbhqk[key].push({key:name, value:zsrstj[key][name]});
        }
    }

    ret["zsrs"] = {title:"招生人数", dataList:[{key:"招生人数", value:zsrs}]};
    ret["xshbqk"] = {title:"学生数变化情况", dataList:xssbhqk};

    let jszy = keyValuePackage(excelData["教师情况"].dataList);
    ret["jszy"] = {title:"教师资源", dataList:jszy};

    // let xlfbData = await getReqApiData(ztbxWENUM.学历分布, {type:"education"});
    // let xlfbConf = {"大学专科毕业":"大专", "大学本科毕业":"本科", "硕士研究生毕业":"硕士", "博士研究生毕业":"博士"};
    // let xlfbList = {};
    // xlfbData.forEach( info => {
    //     let count = parseInt(info.count) || 0;
    //     let type = info.type || "";
    //     for(let key in xlfbConf) {
    //         switch (type) {
    //             case key:
    //                 xlfbList[xlfbConf[key]] = count;
    //             break;
    //             default:
    //                 if (!xlfbList["其他"]) xlfbList["其他"] = count;
    //                 else xlfbList["其他"] += count;
    //             break;
    //         }
    //     }
    // });

    // let xlfb = [];
    // for (let key in xlfbList) {
    //     xlfb.push({key, value:xlfbList[key]});
    // };

    let xlfb = jshxexcelData["学历分布"].dataList;
    ret["xlfb"] = {title:"学历分布", dataList:xlfb};

    let nlfb = jshxexcelData["年龄分布"].dataList;
    ret["nlfb"] = {title:"年龄分布", dataList:nlfb};

    // let nlfbData = await getReqApiData(ztbxWENUM.年龄分布, {type:"age"});
    // let nlfb = getKeyValue(nlfbData);
    // ret["nlfb"] = {title:"年龄分布", dataList:nlfb};

    // let jyzdjData = await getReqApiData(ztbxWENUM.教研组搭建, {}); //todo

    let jyzjsConf = ["语文", "数学", "英语", "综理", "综文", "体育", "艺术"];
    let jyzjsCount = {};
    let jyzjs = {};
    for(let i = 0; i < jyzjsConf.length; i++) {
        let jyzExcelData = jyzjshxTableData(`${jyzjsConf[i]}组`);
        let jszyTableData = jyzExcelData["教师资源"].dataList;

        jyzjsCount[jyzjsConf[i]] = jszyTableData.length;
        if (!jyzjs[jyzjsConf[i]]) jyzjs[jyzjsConf[i]] = [];
        jszyTableData.forEach( info => {
            let {cy, xb, zzmm, nl, zc, xl} = info;
            jyzjs[jyzjsConf[i]].push(cy);
        });
    }
    
    // let jyzjs = {
    //     语文:["宋大轩", "唐秋芳", "卢彤", "涂紫璇", "孙彧"],
    //     数学:["姜涛", "刘林娜", "齐艳平", "沈众辰", "刘璐"],
    //     英语:["周小彦", "吴楚珺", "田泉月", "钱雨青", "何仰东"],
    //     综理:["段婷婷", "柴园园", "姜晏", "徐子平", "周杨"],
    //     综文:["龚思毓", "陈柏松", "朱倢", "刘艳丽", "王蕾"],
    //     体育:["王梵", "李钰", "陈昀端", "张雪莲", "高超"],
    //     艺术:["王康", "宋楚莹", "陈斐成", "冯琪涵", "刘陆"],
    // };
    // let jyzjsCount = {
    //     语文:37, 数学:25, 英语:22, 综理:15, 综文:8, 体育:14, 艺术:9,
    // };

    let jyzdj = [];
    for(let key in jyzjs){
        let dataList = [];
        for(let i = 0; i < jyzjs[key].length; i++) {
            let has = hasImages(`./img/对外/整体办学教研组/${key}/`, `${jyzjs[key][i]}.png`);
            let img = "";
            if (has) img = `${systemConfig.ipUrl}对外/整体办学教研组/${key}/${jyzjs[key][i]}.png`;
            else img = `${systemConfig.ipUrl}对外/整体办学教研组/默认.png`
            dataList.push({
                key:jyzjs[key][i],
                value:img
            })
        }
        jyzdj.push({name:key, data:dataList, count:jyzjsCount[key]});
    }

    ret["jyzdj"] = {title:"教研组搭建", dataList:jyzdj};

    let kjss = keyValuePackage(excelData["空间设施"].dataList);
    ret["kjss"] = {title:"空间设施", dataList:kjss};

    let xsbjData = await getReqApiData(ztbxWENUM.学生人数班级数量, {})
    let bjsl = xsbjData.classNum;
    let xsrsData = xsbjData.studentNum;
    let xsrs = 0;
    xsrsData.forEach( info=> {
        let {code, name, value} = info;
        xsrs += value;
    })

    let baseDate = [
        {
            key:"学生人数",
            value: xsrs
        },
        {
            key:"班级数量",
            value: parseInt(bjsl)
        }
    ];
    //教师人数和教辅人员改为excel表格数据
    统一excelData["教师人员"].dataList.forEach(info => {
        baseDate.push(info);
    })
    
    ret["jcsj"] = {title:"基础数据", dataList:baseDate};

    let zhafData = await getReqApiData(ztbxWENUM.智慧安防出入人数, {startDate:startTime, endDate:endTime, pageSize:100, pageNum:1});
    let zhafCount = 0;
    let crrs = {chu:0, ru:0};
    if (zhafData) {
        if (zhafData.list.length > 0) {
            let zhafry = zhafData.list;
            zhafCount = zhafry.length;
            zhafry.forEach( info => {
                let enterOrExit = info.enterOrExit; //0:出、1:入
                if (enterOrExit == 0) crrs.chu += enterOrExit;
                else crrs.ru += enterOrExit;
            })
        }
    }

    let zhaf = [    
        {
            key:"人员总流量",
            value:zhafCount || 0 //todo
        },
        {
            key:"入",
            value:crrs.ru || 0 //todo
        },
        {
            key:"出",
            value:crrs.chu || 0 //todo
        },
    ];
    ret["zhafrll"] = {title:"智慧安防人流量", dataList:zhaf};

    let zhafQuery = {startDate:startTime, endDate:endTime, pageSize:100, pageNum:1, type:"alarm"};
    let zhafyjlbData =await getReqApiData(ztbxWENUM.智慧安防预警列表, zhafQuery); // todo
    

    let zhafyjlb = {
        titleList: ["预警时间", "预警名称", "等级", "状态"],
        dataList:[
            ["2024.04.09", "闸机故障", "二级", "处理中"],
            ["2024.04.09", "未知人员XXX", "一级", "已处理"],
            ["2024.04.09", "车辆堵塞", "四级", "已处理"],
        ]
    }
    ret["zhafyjlb"] = {title:"预警列表", dataList:zhafyjlb};

    // let tshdData = await getReqApiData(ztbxWENUM.特色活动, {}); //todo

    let xyhdData = excelData["校园活动"].dataList;
    let xyhd = [];
    xyhdData.forEach( info => {
        let hdData = [];
        let {hdtp, hdmc, hdsj, hddd, hdxs} = info;
        hdData.push(
            { key:"活动照片", value:[`${systemConfig.ipUrl}对外/整体办学校园活动/${hdtp}.png`] },
            { key:"活动名称", value:hdmc },
            { key:"活动时间", value:hdsj },
            { key:"活动地点", value:hddd },
            { key:"活动形式", value:hdxs }
        );

        xyhd.push(hdData);
    })
    ret["xyhd"] = {title:"校园活动", dataList:xyhd};

    let kjsyExcelData = onceYBarChartPackage(excelData["办学特色-科技素养"], '', '');
    let kjsyData = getBxtsData(kjsyExcelData.dataInfo);
    let kjsy = {
        "baseData": kjsyData.keyValueResult,
        "trendData": kjsyData.chartResult
    }
    ret["kjsy"] = {title:"科技素养", dataList:kjsy};

    let rwsyExcelData = onceYBarChartPackage(excelData["办学特色-人文素养"], '', '');
    let rwsyData = getBxtsData(rwsyExcelData.dataInfo);
    let rwsy = {
        "baseData": rwsyData.keyValueResult,
        "trendData": rwsyData.chartResult
    }
    ret["rwsy"] = {title:"人文素养", dataList:rwsy};

    let yssyExcelData = onceYBarChartPackage(excelData["办学特色-艺术素养"], '', '');
    let yssyData = getBxtsData(yssyExcelData.dataInfo);
    let yssy = {
        "baseData": yssyData.keyValueResult,
        "trendData": yssyData.chartResult
    }
    ret["yssy"] = {title:"艺术素养", dataList:yssy};

    let jksyExcelData = onceYBarChartPackage(excelData["办学特色-健康素养"], '', '');
    let jksyData = getBxtsData(jksyExcelData.dataInfo);
    let jksy = {
        "baseData": jksyData.keyValueResult,
        "trendData": jksyData.chartResult
    }
    ret["jksy"] = {title:"健康素养", dataList:jksy};

    // let jsczjcsjData = await getReqApiData(ztbxWENUM.教师成长基础数据, {}); //todo
    let tsstjcsj = keyValuePackage(xxhxExcelData["特色社团基础数据"].dataList);
    let jsczjcsj = [
        {
            key:"参与教师总数",
            value:tsstjcsj[0].value
        },
        {
            key:"特色课程创建次数",
            value:tsstjcsj[0].value
        }
    ];
    
    ret["jsczjcsj"] = {title:"教师成长", dataList:jsczjcsj};

    // let jsczData = await getReqApiData(ztbxWENUM.教师成长饼图数据, {}); //todo
    // let jscz = [
    //     {
    //         key:"艺术素养",
    //         value:21
    //     },
    //     {
    //         key:"健康素养",
    //         value:37
    //     },
    //     {
    //         key:"科技素养",
    //         value:24
    //     },
    //     {
    //         key:"人文素养",
    //         value:17
    //     }
    // ];
    let jscz = keyValuePackage(xxhxExcelData["特色社团课程数"].dataList);
    ret["jscz"] = {title:"教师成长饼图", dataList:jscz};

    // let xscz9个1 = {
    //     project:"每个学期完成一个课题研究",
    //     speak:"每个学段进行一次公开演讲",
    //     visitTechnology:"每个假期参观一个科技场馆",
    //     communityServices:"每个假期参加一次社区服务",
    //     readClassicBook:"每个月阅读一本经典书籍",
    //     sportsHobby:"每位学生拥有一项运动爱好",
    //     readingReport:"每个学期举办一场读书报告",
    //     instrumental:"每位学生掌握一门乐器演奏",
    //     performance:"每个学段参加一次公开表演",
    //     write:"每位学生能写一手好字"
    // };
    // for(let key in xscz9个1) {
    //     let name = xscz9个1[key];
    //     let value = parseFloat(xsczData[key]) || 0;
    //     xscz.push({key:name, value});
    // }

    let xsczData = await getReqApiData(ztbxWENUM.统计学生九个一完成情况, {type:"school"});
    let xscz = [];
    for(let key in xsczData) {
        let value = parseFloat(xsczData[key]) || 0;
        xscz.push({key, value});
    }

    let maxValue = getObjectMaxValue(xsczData);
    
    ret["xscz"] = {title:"学生成长", dataList:xscz, max:maxValue};

    // let ryjxxsData = await getReqApiData(ztbxWENUM.荣誉奖项学生, {}); //todo
    // let ryjxjsData = await getReqApiData(ztbxWENUM.荣誉奖项教师, {}); //todo
    // let ryjxxxData = await getReqApiData(ztbxWENUM.荣誉奖项学校, {}); //todo

    let ryjxxs = {
        "baseData": [
            {
                key:"国家级",
                value: 184
            },
            {
                key:"市级",
                value: 109
            },
            {
                key:"区级",
                value: 40
            },
            {
                key:"校级",
                value: 518
            },
        ],
        "trendData": [
            {
                key:"2019",
                value: 30
            },
            {
                key:"2020",
                value: 15
            },
            {
                key:"2021",
                value: 20
            },
            {
                key:"2022",
                value: 50
            },
            {
                key:"2023",
                value: 20
            },
            {
                key:"2024",
                value: 10
            },
        ]
    }
    ret["ryjxxs"] = {title:"荣誉奖项学生", dataList:ryjxxs};
    
    let ryjxjs = {
        "baseData": [
            {
                key:"国家级",
                value: 6
            },
            {
                key:"市级",
                value: 114
            },
            {
                key:"区级",
                value: 35
            },
            {
                key:"校级",
                value: 0
            },
        ],
        "trendData": [
            {
                key:"2019",
                value: 30
            },
            {
                key:"2020",
                value: 15
            },
            {
                key:"2021",
                value: 20
            },
            {
                key:"2022",
                value: 50
            },
            {
                key:"2023",
                value: 20
            },
            {
                key:"2024",
                value: 10
            },
        ]
    }
    ret["ryjxjs"] = {title:"荣誉奖项教师", dataList:ryjxjs};
    
    let ryjxxx = {
        "baseData": excelData["办学成果-学校"].dataList,
        "trendData": excelData["办学成果趋势-学校"].dataList,
    }
    ret["ryjxxx"] = {title:"荣誉奖项学校", dataList:ryjxxx};
    
    let bysqx = keyValuePackage(excelData["毕业生去向"].dataList);
    let bysqxqst = onceYBarChartPackage(excelData["毕业生去向趋势图"], "", "");

    ret["bysqx"] = {title:"毕业生去向", dataList:bysqx};
    ret["bysqxqst"] = {title:"毕业生去向趋势图", dataList:bysqxqst};


    /**查看目标、查看明细弹窗 todo */
    // let ckmb = [
    //     {key:"九个一完成情况", value:""}
    // ];
    
    let ckmb = keyValuePackage(excelData["九个一完成情况文本介绍"].dataList);
    ret["ckmb"] = {title:"查看目标", dataList:ckmb};

    let ckmx = {
        titleList:excelData["特色课程创新明细"].headerList[0],
        dataList:excelData["特色课程创新明细"].bodyList
    };

    ret["ckmx"] = {title:"特色课程创新明细", dataList:ckmx};

    res.send(ret);
}


/**
 * 获取最大数
 * @param obj 
 * @returns 
 */
function getObjectMaxValue(obj) {
    let maxValue = -Infinity;
    for (let key in obj) {
        let num = parseFloat(obj[key]);
      if (obj.hasOwnProperty(key) && typeof num === 'number' && num > maxValue) {
        maxValue = num;
      }
    }
    return maxValue === -Infinity ? null : maxValue;
}



function getBxtsData(data) {
    let keyValueResult = [];
    let chartResult = [];

    let bxts = {};
    let bxtsChart = {};
    for(let type in data) {
        /**计算key,value */
        if(!bxts[type]) bxts[type] = 0;
        let kjsyInfo = data[type];
        kjsyInfo.forEach( info => {
            bxts[type] += info.value;
        });

        /**计算chart */
        data[type].forEach( info => {
            let {key, value, unit} = info;
            if (!bxtsChart[key]) bxtsChart[key] = 0;
            bxtsChart[key] += value;
        });
    };

    for(let key in bxts) {
        keyValueResult.push({key, value:bxts[key]});
    };

    for(let key in bxtsChart) {
        chartResult.push({key, value:bxtsChart[key]});
    }

    return {keyValueResult, chartResult};
}





