/**
 * 水平分析弹窗
 */

import { getReqApiData } from "../../data/interface/url";
import { spfxWENUM } from "../../config/interficeEnum";

const ImgUrl = "img/对外/水平分析弹窗/";


export async function getData(req, res) {
    let ret: any = {};
    let studentId = req.body.studentId || "733f97c4425a11ee98a202031519086a";

    let xyspfx = [
        {
            key:"综合水平",
            value:"A"
        },
        {
            key:"同比",
            value:0.23
        }
    ];
    ret["xyspfx"] = {title:"学业水平分析", dataList:xyspfx};

    let dbfxsj = [
		{
			"subject":"数学",
			"result":"优秀",
			"contrastAnalysis": [
				{
					"ageScore":"97",
					"dataList":[
						{
							"key":"2021上",
							"value":"86"
						},
						{
							"key":"2021下",
							"value":"86"
						},
						{
							"key":"2022上",
							"value":"86"
						},
						{
							"key":"2022下",
							"value":"86"
						},
						{
							"key":"2023上",
							"value":"86"
						},
					]
				}
			],
			"classComparison": {
				"ageScore":"97",
				"dataList":[
					{
						"key":"2021上",
						"value":"86"
					},
					{
						"key":"2021下",
						"value":"76"
					},
					{
						"key":"2022上",
						"value":"89"
					},
					{
						"key":"2022下",
						"value":"93"
					},
					{
						"key":"2023上",
						"value":"90"
					},
				]
			},
			"sdyssydbfx":[
				{
					key:"科技素养",
					person:76,
					grade:80
				},
				{
					key:"艺术素养",
					person:83,
					grade:80
				},
				{
					key:"健康素养",
					person:55,
					grade:80
				},
				{
					key:"人文素养",
					person:91,
					grade:80
				},
			]
		},
		{
			"subject":"语文",
			"result":"优秀",
			"contrastAnalysis": [
				{
					"ageScore":"97",
					"dataList":[
						{
							"key":"2021上",
							"value":"86"
						},
						{
							"key":"2021下",
							"value":"76"
						},
						{
							"key":"2022上",
							"value":"89"
						},
						{
							"key":"2022下",
							"value":"93"
						},
						{
							"key":"2023上",
							"value":"90"
						},
					]
				}
			],
			"classComparison": {
				"ageScore":"97",
				"dataList":[
					{
						"key":"2021上",
						"value":"83"
					},
					{
						"key":"2021下",
						"value":"86"
					},
					{
						"key":"2022上",
						"value":"81"
					},
					{
						"key":"2022下",
						"value":"89"
					},
					{
						"key":"2023上",
						"value":"91"
					},
				]
			},
			"sdyssydbfx":[
				{
					key:"科技素养",
					person:76,
					grade:80
				},
				{
					key:"艺术素养",
					person:83,
					grade:80
				},
				{
					key:"健康素养",
					person:55,
					grade:80
				},
				{
					key:"人文素养",
					person:91,
					grade:80
				},
			]
		},
	];
    ret["dbfxsj"] = {title:"对比分析数据", dataList:dbfxsj};

    // let xspjfx = [
    //     {
    //         key:"学生评价分析",
    //         value:"分析中"
    //     }
    // ];
    // ret["xspjfx"] = {title:"学生评价分析", dataList:xspjfx};

	// let sdyssydbfx = [
	// 	{
	// 		key:"科技素养",
	// 		person:76,
	// 		grade:80
	// 	},
	// 	{
	// 		key:"艺术素养",
	// 		person:83,
	// 		grade:80
	// 	},
	// 	{
	// 		key:"健康素养",
	// 		person:55,
	// 		grade:80
	// 	},
	// 	{
	// 		key:"人文素养",
	// 		person:91,
	// 		grade:80
	// 	},
	// ];
	// ret["sdyssydbfx"] = {title:"四大素养对比分析", dataList:sdyssydbfx};

    let sg = [
        {
            key:"身高",
            value:157.8
        }
    ];
    ret["sg"] = {title:"身高", dataList:sg};

    let sgczfx = [
		{
			"key":"2021上",
			"value":"120",
			"age":"130"
		},
		{
			"key":"2021下",
			"value":"125",
			"age":"130"
		},
		{
			"key":"2022上",
			"value":"120",
			"age":"130"
		},
		{
			"key":"2022下",
			"value":"125",
			"age":"130"
		},
		{
			"key":"2023上",
			"value":"120",
			"age":"130"
		},
	];
    ret["xgczfx"] = {title:"身高成长分析", dataList:sgczfx};

    let tzBMI = [
        {
            key:"体重",
            value:46.9
        },
        {
            key:"BMI",
            value:"待评价"
        }
    ];
    ret["tzBMI"] = {title:"体重BMI", dataList:tzBMI};

    let tzczfx = [
		{
			"key":"2021上",
			"value":"32.5 ",
			"age":"30"
		},
		{
			"key":"2021下",
			"value":"35.2",
			"age":"35"
		},
		{
			"key":"2022上",
			"value":"32.5 ",
			"age":"30"
		},
		{
			"key":"2022下",
			"value":"35.2",
			"age":"35"
		},
		{
			"key":"2023上",
			"value":"32.5 ",
			"age":"30"
		},
		{
			"key":"2023下",
			"value":"35.2",
			"age":"35"
		},
	];
    ret["tzczfx"] = {title:"体重成长分析", dataList:tzczfx};

    let BMIfx = [
		{
			"key":"2021上",
			"value":"21",
			"age":"20.7"
		},
		{
			"key":"2021下",
			"value":"21.5",
			"age":"21.3"
		},
		{
			"key":"2022上",
			"value":"21",
			"age":"20.7"
		},
		{
			"key":"2022下",
			"value":"21.5",
			"age":"21.3"
		},
		{
			"key":"2023上",
			"value":"21",
			"age":"20.7"
		},
		{
			"key":"2023下",
			"value":"21.5",
			"age":"21.3"
		},
	];
    ret["BMIfx"] = {title:"BMI分析", dataList:BMIfx};

    let sl = [
        {
            key:"左",
            value:5.0
        },
        {
            key:"右",
            value:5.1
        },
    ];
    ret["sl"] = {title:"视力", dataList:sl};

    let slfx = [
		{
			"key":"2021上",
			"value":"5.2",
			"age":"4.9"
		},
		{
			"key":"2021下",
			"value":"5.0",
			"age":"4.7"
		},
		{
			"key":"2022上",
			"value":"5.2",
			"age":"4.9"
		},
		{
			"key":"2022下",
			"value":"5.0",
			"age":"4.7"
		},
		{
			"key":"2023上",
			"value":"5.2",
			"age":"4.9"
		},
		{
			"key":"2023下",
			"value":"5.0",
			"age":"4.7"
		},
	];
    ret["slfx"] = {title:"视力分析", dataList:slfx};

    let xgfx = {
		"evaluateTotalScore":"0",
		"ageScore":"98",
		"maximumcore":[
			{
				"key":"2022下",
				"value":"97"
			},
			{
				"key":"2023上",
				"value":"93"
			},
			{
				"key":"2023下",
				"value":"97"
			},
			{
				"key":"2024上",
				"value":"93"
			},
		]
	}
    ret["xgfx"] = {title:"行为表现", dataList:xgfx};

    let wcqkdb9个1 = [
		{
			key:"年级完成学生数",
			value:"84"
		},
		{
			key:"班级完成学生数",
			value:"21"
		},
    ];
    ret["wcqkdb"] = {title:"九+一完成情况对比", dataList:wcqkdb9个1};

    let wcqkData = await getReqApiData(spfxWENUM.九加一完成情况, {studentId});
    let wcqk9加1 = {
        project:"每个学期完成一个课题研究",
        speak:"每个学段进行一次公开演讲",
        visitTechnology:"每个假期参观一个科技场馆",
        communityServices:"每个假期参加一次社区服务",
        readClassicBook:"每个月阅读一本经典书籍",
        sportsHobby:"每位学生拥有一项运动爱好",
        readingReport:"每个学期举办一场读书报告",
        instrumental:"每位学生掌握一门乐器演奏",
        performance:"每个学段参加一次公开表演",
        write:"每位学生能写一手好字"
    };

    let wcqk = [];
    for(let key in wcqk9加1) {
        let name = wcqk9加1[key];
        let value = parseFloat(wcqkData[key]) || 0;
        wcqk.push({key:name, value});
    }
    ret["wcqk"] = {title:"九+一完成情况", dataList:wcqk};

    let tytctj = [
		{
			"key":"体育体侧总分",
			"value":"80"
		}
	];
    ret["tytctj"] = {title:"体育体侧统计", dataList:tytctj};

    let jqtccyqk = [
		{
			"key":"肺活量（ml）",
			"value":2087
		},
		{
			"key":"50米跑（秒）",
			"value":8.34
		},
		{
			"key":"坐位体前屈（cm）",
			"value":16.5
		},
		{
			"key":"一分钟跳绳（次）",
			"value":135
		},
		{
			"key":"一分钟仰卧起坐（次）",
			"value":50
		},
	];
    ret["jqtccyqk"] = {title:"当前学期体质测试结果", dataList:jqtccyqk};

    let bjcjtj = [
		{
			"key":"优良率",
			"value":"0.0%"
		},
		{
			"key":"及格率",
			"value":"0.0%"
		}
	];
    ret["bjcjtj"] = {title:"班级成绩统计", dataList:bjcjtj};

    let njcjtj = [
		{
			"key":"优良率",
			"value":"0.0%"
		},
		{
			"key":"及格率",
			"value":"0.0%"
		}
	];
    ret["njcjtj"] = {title:"年级成绩统计", dataList:njcjtj};

    let hjcs = [
        {
            key:"获奖次数",
            value:4
        }
    ];
    ret["hjcs"] = {title:"获奖次数", dataList:hjcs};

    let hjfx = [
		{
			"key":"国家级",
			"value":"3",
			"age":"11"
		},
		{
			"key":"市级",
			"value":"1",
			"age":"10"
		},
		{
			"key":"区级",
			"value":"3",
			"age":"11"
		},
		{
			"key":"校级",
			"value":"1",
			"age":"10"
		},
	];
    ret["hjfx"] = {title:"获奖分析", dataList:hjfx};


    res.send(ret);
}

































