import { systemConfig } from "../../config/serverConfig";
import { getBase64Str, getAppToken, getReqApiData, getAppTicket } from "../../data/interface/url";
import { BizError } from "../../util/bizError";
import { get } from "../../util/request";



export async function getHashStr(req, res) {
    let ret:any = {};
    ret["hashstr"] = await getBase64Str();

    res.send(ret);
}


export async function getToken(req, res) {
    let ret:any = {};
    ret["token"] = await getAppToken();

    res.send(ret);
}


export async function getTicket(req, res) {
    let ticket = req.query.ticket;
    if (!ticket) new BizError("缺少必要参数ticket");

    let ret:any = {};
    // let accessToken = await getAppToken();
    // ret["ticket"] = await getReqApiData("/getTicket", {ticket, accessToken});
    // ret["ticket"] = await get(`${systemConfig.url}/getTicket?ticket=${ticket}&accessToken=${accessToken}`, {}, {});
    ret["ticket"] = await getAppTicket(ticket);
    // console.log(ret["ticket"]);
    res.send(ret);
}




