/**
 * 学生画像年级（对内）
 */

import { xshxNENUM } from "../../config/interficeEnum";
import { getReqApiData } from "../../data/interface/url";
import { getKeyValue, readFileList } from "../outData";
import { jshxTableData } from "../../data/table/duiwai";
import { keyValuePackage, tablePackage } from "../../dataPackage/inFrontOut";
import { systemConfig } from "../../config/serverConfig";
import { xshxnjzTableData } from "../../data/table/duinei";

const ImgUrl = `img/对内/学生画像/`;

const Grade = {
    1:"一年级组",
    2:"二年级组",
    3:"三年级组",
    4:"四年级组",
    5:"五年级组",
    6:"六年级组",
    7:"七年级组",
    8:"八年级组",
    9:"九年级组",
    10:"高中组",
    // 10:"高一年级组",
    // 11:"高二年级组",
    // 12:"高三年级组",
}

const GradeChange = {
    1:"一年级",
    2:"二年级",
    3:"三年级",
    4:"四年级",
    5:"五年级",
    6:"六年级",
    7:"七年级",
    8:"八年级",
    9:"九年级",
    10:"高中",
    // 10:"高一",
    // 11:"高二",
    // 12:"高三",
}

export async function getData(req, res) {
    let grade = req.body.grade || 1; //【一年级：1、二年级：2、三年级：3、四年级：4】
    let ret:any = {};

    let excelData = xshxnjzTableData(Grade[grade]);

    let tzjcData = await getReqApiData(xshxNENUM.体质监测各年级合格率优良率, {gradeId:grade});
    
    let tzjc = [
        {
            key:"优良率",
            value:parseInt(tzjcData.gradeFine[GradeChange[grade]])
        },
        {
            key:"合格率",
            value:parseInt(tzjcData.gradePass[GradeChange[grade]])
        },
    ];

    ret["tzjc"] = {title:"体质监测", dataList:tzjc};

    // let BMIData = await getReqApiData(xshxNENUM.查询各年级BMI, {gradeId:grade});
    let BMIbjData = await getReqApiData(xshxNENUM.查询各班级BMI, {gradeId:grade});
    let njtzjc = {};
    BMIbjData.forEach( info => {
        let {code, name, value} = info;
        if (!njtzjc[code]) njtzjc[code] = [];
        njtzjc[code].push({key:name, value})
    })
    
    let njtzjcInfo = {};
    for(let key in njtzjc) {
        let after = key.slice(-2);
        njtzjcInfo[after] = njtzjc[key];
    }

    ret["tzjcqs"] = {title:"体质检测趋势", dataList:njtzjcInfo};

    let sljc = [];
    let sljcnjData = await getReqApiData(xshxNENUM.查询各年级视力不良率, {});
    sljcnjData.forEach( info => {
        let {code, name, value} = info;
        sljc.push({key:name, value});
    })
    ret["sljc"] = {title:"视力监测", dataList:sljc};

    let sljcData = await getReqApiData(xshxNENUM.查询年级各班级视力不良率, {gradeId:grade});
    let sljcqs = [];
    sljcData.forEach( info => {
        let {code, name, value} = info;
        sljcqs.push({key:name, value});
    })
    // let sljcqs = {
    //     左眼:[
    //         {
    //             key:"一班",
    //             value:0
    //         },
    //         {
    //             key:"二班",
    //             value:0
    //         },
    //         {
    //             key:"三班",
    //             value:0
    //         },
    //         {
    //             key:"四班",
    //             value:0
    //         },
    //     ],
    //     右眼:[
    //         {
    //             key:"一班",
    //             value:0
    //         },
    //         {
    //             key:"二班",
    //             value:0
    //         },
    //         {
    //             key:"三班",
    //             value:0
    //         },
    //         {
    //             key:"四班",
    //             value:0
    //         },
    //     ],
    // };
    ret["sljcqs"] = {title:"视力检测趋势", dataList:sljcqs};
    
    /**社会实践活动情况 */
    // let shsjhdqkData = await getReqApiData(xshxNENUM.社会实践活动情况, {grade}); //todo
    let shsjhdqkData = excelData["品德发展与公民素养"].dataList;
    // [
    //     {
    //         name:"社会考察",
    //         wcks:8,
    //         zks:8
    //     },
    //     {
    //         name:"公益劳动",
    //         wcks:2,
    //         zks:2
    //     },
    //     {
    //         name:"职业体验",
    //         wcks:2,
    //         zks:2
    //     },
    //     {
    //         name:"安全实训",
    //         wcks:0,
    //         zks:0
    //     },
    // ];
    let shsjhdqk = [];
    shsjhdqkData.forEach( info => {
        let {name, wcks, zks} = info;
        shsjhdqk.push({name, wcks:parseInt(wcks), zks:parseInt(zks)});
    })
    ret["shsjhdqk"] = {title:"社会实践活动情况", dataList:shsjhdqk};

    /**团队德育活动 */
    // let cyksData = await getReqApiData(xshxNENUM.团队德育活动, {grade}) //todo
    let cyks = [
        {
            key:"参与课时",
            value:6
        }
    ];
    ret["cyks"] = {title:"参与课时", dataList:cyks};

    // let tddyhdData = await getReqApiData(xshxNENUM.团队德育活动, {grade}) //todo
    let tddyhd = [
        {
            key:"仪式活动",
            value:6
        },
        {
            key:"主题教育",
            value:11
        }
    ];
    ret["tddyhd"] = {title:"团队德育活动", dataList:tddyhd};

    /**综合评价（统计等第） */
    // let zhpjData = await getReqApiData(xshxNENUM.综合统计, {grade}) //todo
    let zhpj = excelData["综合评价"].dataList;
    ret["zhpj"] = {title:"综合评价", dataList:zhpj};

    let xykcyxycj = {
        优秀: excelData["修业课程与学业成绩-优秀"].dataList,
        良好: excelData["修业课程与学业成绩-良好"].dataList,
        合格: excelData["修业课程与学业成绩-合格"].dataList,
    };
    ret["xykcyxycj"] = {title:"修业课程与学业成绩", dataList:xykcyxycj};

    let xsbjrsData = await getReqApiData(xshxNENUM.获取班级数学生数, {});
    let bjsl = xsbjrsData.classNum;
    let xsrsData = xsbjrsData.studentNum;
    let xsrs = 0;
    xsrsData.forEach( info=> {
        let {code, name, value} = info;
        xsrs += value;
    })
    let jcsj = [
        {
            key:"总学生数",
            value:xsrs
        },
        {
            key:"班级数",
            value:parseInt(bjsl)
        }
    ];
    ret["jcsj"] = {title:"基础数据", dataList:jcsj};

    let jgyzhwcl = [
        {
            key:"九+一综合完成率",
            value:0
        }
    ];
    ret["jgyzhwcl"] = {title:"九+一综合完成率", dataList:jgyzhwcl};

    // let jgyxxwcqk = [
    //     {
    //         key:"阅读一本经典书籍",
    //         value:32,
    //         rate:40
    //     },
    //     {
    //         key:"参观一个科技场馆",
    //         value:14,
    //         rate:17.5
    //     },
    //     {
    //         key:"完成一个课题研究",
    //         value:34,
    //         rate:42.5
    //     },
    //     {
    //         key:"举办一场读书报告",
    //         value:31,
    //         rate:38.75
    //     },
    //     {
    //         key:"进行一次公开演讲",
    //         value:0,
    //         rate:0
    //     },
    //     {
    //         key:"拥有一项运动爱好",
    //         value:11,
    //         rate:13.75
    //     },
    //     {
    //         key:"参加一次公开表演",
    //         value:15,
    //         rate:18.75
    //     },
    //     {
    //         key:"参加一次社区服务",
    //         value:22,
    //         rate:27.5
    //     },
    //     {
    //         key:"掌握一门乐器演奏",
    //         value:33,
    //         rate:41.25
    //     }
    // ];
    
    let xsczData = await getReqApiData(xshxNENUM.学生九个一完成情况, {type:"grade", gradeId:grade});
    let jgyxxwcqk = [];
    let stuCount = 0;
    for (let key in xsczData.grade) {
        stuCount += parseInt(xsczData.grade[key]);
    }
    let rate = 0;
    for (let key in xsczData.grade) {
        if (stuCount || xsrs) rate = Math.round(stuCount / xsrs) || 0;
        jgyxxwcqk.push({key, value:parseInt(xsczData.grade[key]), rate});
    }
    ret["jgyxxwcqk"] = {title:"九+一详细完成情况", dataList:jgyxxwcqk};

    // let bjwcl = [];
    // let classCount = 0;
    // for (let key in xsczData.className) {
    //     for (let jgy in xsczData.className[key]) {
    //         classCount += parseInt(xsczData.className[key][jgy]);
    //     }
    // }
    // let classrate = 0;
    // for (let key in xsczData.className) {
    //     if (classCount || xsrs) classrate = Math.round(classCount / xsrs) || 0;
    //     // let thisCount = 0;
        
    //     bjwcl.push({key, value:parseInt(xsczData.className[key]), rate:classrate});
    // }
    let bjwcl = [
        {
            key:"1班",
            value:0,
            rate:0
        },
        {
            key:"2班",
            value:0,
            rate:0
        },
        {
            key:"3班",
            value:0,
            rate:0
        },
        {
            key:"4班",
            value:0,
            rate:0
        },
        {
            key:"5班",
            value:0,
            rate:0
        },
    ];
    
    ret["bjwcl"] = {title:"班级完成率", dataList:bjwcl};

    let njtshd = {
        titleList:["活动种类", "活动名称", "时间", "地点", "参与人数"],
        dataList:[
            ["-", "-", "-", "-", "-"],
            ["-", "-", "-", "-", "-"],
            ["-", "-", "-", "-", "-"],
            ["-", "-", "-", "-", "-"],
        ]
    };
    ret["njtshd"] = {title:"年级特色活动", dataList:njtshd};

    let hdly = readFileList(`${ImgUrl}活动掠影/`, [], "png");
    ret["hdly"] = {title:"活动掠影", dataList:hdly};

    // let yjxy = [
    //     {
    //         key:"莫熙湖",
    //         value:`${ImgUrl}预警/学业/`
    //     },
    //     {
    //         key:"杨均文",
    //         value:`${ImgUrl}预警/学业/`
    //     },
    // ];
    // ret["yjxy"] = {title:"预警-学业", dataList:yjxy};

    let yjcq = [
        {
            key:"请假人数",
            value:3
        },
        {
            key:"请假天数",
            value:4
        }
    ];
    ret["yjcq"] = {title:"预警-出勤", dataList:yjcq};

    let yjcqxx = [
        {
            key:"莫熙湖",
            class:"六年级(2)班",
            value:"病假",
            time:"2024.04.22第六节~2024.04.22第十节",
            img:`${systemConfig.ipUrl}对内/学生画像/预警/出勤/莫熙湖.png`
        },
        {
            key:"杨均文",
            class:"六年级(4)班",
            value:"事假",
            time:"2024.04.19第六节~2024.04.19第十节",
            img:`${systemConfig.ipUrl}对内/学生画像/预警/出勤/杨均文.png`
        },
    ];
    ret["yjcqxx"] = {title:"预警-出勤详细", dataList:yjcqxx};

    // let yjxw = [];
    // ret["yjxw"] = {title:"预警-行为", dataList:yjxw};

    // let yjqt = [];
    // ret["yjqt"] = {title:"预警-其他", dataList:yjqt};

    let cxjsysjnl = excelData["创新精神与实践能力"].dataList;
    ret["cxjsysjnl"] = {title:"创新精神与实践能力", dataList:cxjsysjnl};

    let kjsyJcsj = excelData["科技素养-基础数据"].dataList;
    ret["kjsyJcsj"] = {title:"科技素养-基础数据", dataList:kjsyJcsj};
    let kjsyNjktlb = excelData["科技素养-年级课题列表明细"].dataList;
    ret["kjsyNjktlb"] = {title:"科技素养-年级课题列表明细", dataList:kjsyNjktlb};
    let kjsyNjktlbmx = {
        titleList: excelData['科技素养-年级课题列表明细表格'].headerList[0], 
        dataList: excelData['科技素养-年级课题列表明细表格'].bodyList
    };
    ret["kjsyNjktlbmx"] = {title:"科技素养-年级课题列表明细表格", dataList:kjsyNjktlbmx};
    let kjsyGbjcxqk = excelData["科技素养-各班级创新情况"].dataList;
    ret["kjsyGbjcxqk"] = {title:"科技素养-各班级创新情况", dataList:kjsyGbjcxqk};

    let rwsyJcsj = excelData["人文素养-基础数据"].dataList;
    ret["rwsyJcsj"] = {title:"人文素养-基础数据", dataList:rwsyJcsj};
    let rwsyNjktlb = excelData["人文素养-年级课题列表明细"].dataList;
    ret["rwsyNjktlb"] = {title:"人文素养-年级课题列表明细", dataList:rwsyNjktlb};
    let rwsyNjktlbmx = {
        titleList: excelData['人文素养-年级课题列表明细表格'].headerList[0], 
        dataList: excelData['人文素养-年级课题列表明细表格'].bodyList
    };
    ret["rwsyNjktlbmx"] = {title:"人文素养-年级课题列表明细表格", dataList:rwsyNjktlbmx};
    let rwsyGbjcxqk = excelData["人文素养-各班级创新情况"].dataList;
    ret["rwsyGbjcxqk"] = {title:"人文素养-各班级创新情况", dataList:rwsyGbjcxqk};

    let yssyJcsj = excelData["艺术素养-基础数据"].dataList;
    ret["yssyJcsj"] = {title:"艺术素养-基础数据", dataList:yssyJcsj};
    let yssyNjktlb = excelData["艺术素养-年级课题列表明细"].dataList;
    ret["yssyNjktlb"] = {title:"艺术素养-年级课题列表明细", dataList:yssyNjktlb};
    let yssyNjktlbmx = {
        titleList: excelData['艺术素养-年级课题列表明细表格'].headerList[0], 
        dataList: excelData['艺术素养-年级课题列表明细表格'].bodyList
    };
    ret["yssyNjktlbmx"] = {title:"艺术素养-年级课题列表明细表格", dataList:yssyNjktlbmx};
    let yssyGbjcxqk = excelData["艺术素养-各班级创新情况"].dataList;
    ret["yssyGnjcxqk"] = {title:"艺术素养-各班级创新情况", dataList:yssyGbjcxqk};

    let jksyJcsj = excelData["健康素养-基础数据"].dataList;
    ret["jksyJcsj"] = {title:"健康素养-基础数据", dataList:jksyJcsj};
    let jksyNjktlb = excelData["健康素养-年级课题列表明细"].dataList;
    ret["jksyNjktlb"] = {title:"健康素养-年级课题列表明细", dataList:jksyNjktlb};
    let jksyNjktlbmx = {
        titleList: excelData['健康素养-年级课题列表明细表格'].headerList[0], 
        dataList: excelData['健康素养-年级课题列表明细表格'].bodyList
    };
    ret["jksyNjktlbmx"] = {title:"健康素养-年级课题列表明细表格", dataList:jksyNjktlbmx};
    let jksyGbjcxqk = excelData["健康素养-各班级创新情况"].dataList;
    ret["jksyGbjcxqk"] = {title:"健康素养-各班级创新情况", dataList:jksyGbjcxqk};

    let gjglhd = excelData["各级各类活动"].dataList;
    ret["gjglhd"] = {title:"各级各类活动", dataList:gjglhd};

    let gjglhdxx = {
        科技素养:{
            titleList: excelData['各级各类活动-科技素养'].headerList[0], 
            dataList: excelData['各级各类活动-科技素养'].bodyList
        },
        人文素养:{
            titleList: excelData['各级各类活动-人才素养'].headerList[0], 
            dataList: excelData['各级各类活动-人才素养'].bodyList
        },
        艺术素养:{
            titleList: excelData['各级各类活动-艺术素养'].headerList[0], 
            dataList: excelData['各级各类活动-艺术素养'].bodyList
        },
        健康素养:{
            titleList: excelData['各级各类活动-健康素养'].headerList[0], 
            dataList: excelData['各级各类活动-健康素养'].bodyList
        },
    };
    ret["gjglhdxx"] = {title:"各级各类活动详细", dataList:gjglhdxx};

    // let hjcgzsData = await getReqApiData(xshxNENUM.获奖成果展示, {}); //todo
    // let hjcgzs = [
    //     {
    //         img:`${systemConfig.ipUrl}对内/学生画像/获奖成果展示/1.png`,
    //         name:"荣誉奖项图"
    //     },
    //     {
    //         img:`${systemConfig.ipUrl}对内/学生画像/获奖成果展示/2.png`,
    //         name:"荣誉奖项图"
    //     },
    //     {
    //         img:`${systemConfig.ipUrl}对内/学生画像/获奖成果展示/3.png`,
    //         name:"荣誉奖项图"
    //     },
    //     {
    //         img:`${systemConfig.ipUrl}对内/学生画像/获奖成果展示/4.png`,
    //         name:"荣誉奖项图"
    //     },
    //     {
    //         img:`${systemConfig.ipUrl}对内/学生画像/获奖成果展示/5.png`,
    //         name:"荣誉奖项图"
    //     }
    // ]
    // ret["hjcgzs"] = {title:"获奖成果展示", dataList:hjcgzs};

    let hjcgzsData = excelData["获奖成果展示"].dataList;
    let hjcgzs = [];
    hjcgzsData.forEach( info => {
        let {key, value} = info;
        hjcgzs.push({img:`${systemConfig.ipUrl}对内/学生画像/获奖成果展示/${key}`, name:value});
    });
    ret["hjcgzs"] = {title:"获奖成果展示", dataList:hjcgzs};

    res.send(ret);
}


/**学生画像筛选个人 */
export async function getStudent(req, res) {
    let grade = req.body.grade; //【一年级：1、二年级：2、三年级：3、四年级：4】
    let classNum = req.body.classNum;
    let name = req.body.name;
    let ret:any = {};

    let body = {};
    if(grade) body["gradeId"] = grade;
    if(classNum) body["classNum"] = classNum;
    if(name) body["studentName"] = name;

    let xsgrData = await getReqApiData(xshxNENUM.获取学生信息, body); //todo
    let xsgrConf = [
        {
            "studentId": "6abc38b8425b11ee98a202031519086a",
            "studentName": "吕**",
            "idNumber": null,
            "studentNum": null,
            "studentGnum": null,
            "ethnicCode": null,
            "birthday": null,
            "sex": "0",
            "schoolId": null,
            "gradeId": "1",
            "className": "一年级2班",
            "classId": "63c5ee96422411eeb5e0020315204705",
            "studentSort": null,
            "remark": null
        }
    ];
    let xsgr = [];
    if (xsgrData) xsgr = xsgrData;
    else xsgr = xsgrConf;
    ret["xsgr"] = {title:"学生筛选个人", dataList:xsgr};

    res.send(ret);
}










