/**
 * 年级组教师画像（对内）
 * 弃用，修改为jshxnjz.ts
 */

import { njzjshxNENUM } from "../../config/interficeEnum";
import { getReqApiData } from "../../data/interface/url";
import { getKeyValue, readFileList } from "../outData";
import { njzjshxTableData } from "../../data/table/duiwai";
import { keyValuePackage, tablePackage } from "../../dataPackage/inFrontOut";
import { systemConfig } from "../../config/serverConfig";

const ImgUrl = "img/对内/年级组教师画像/";

const Grade = {
    1:"一年级",
    2:"二年级",
    3:"三年级",
    4:"四年级",
    5:"五年级",
    6:"六年级",
    7:"初一",
    8:"初二",
    9:"初三",
    10:"高中组",
}

export async function getData(req, res) {
    let grade = req.body.grade || 10; //【一年级：1、二年级：2、三年级：3、四年级：4、5、6，初一：7、8、9，高一：10】
    grade = parseInt(grade);
    let ret:any = {};
    let excelData = njzjshxTableData(Grade[grade]);

    const NowTime = new Date();

    let jcxx = await getReqApiData(njzjshxNENUM.教师基本信息, {});

    let jszyData = excelData["教师资源"].dataList;
    if (excelData) jszyData
    // let jszyData = await getReqApiData(jshxNENUM.教师资源, {}); //todo
    let jszy = [
        {
            key:"教师数",
            value:jszyData.length,
            unit:""
        },
        {
            key:"教师资源达标率",
            value:"-",
            unit:""
        }
    ];
    ret["jszy"] = {title:"教师资源", dataList:jszy};
    
    //性别
    let nanshenNum = 0;
    let nvshenNum = 0;
    //学历
    let xlData = {};
    //年龄
    let nlData = {"0~35岁":0, "36~40岁":0, "41~45岁":0, "46~50岁":0, "51~55岁":0, "55岁以上":0};
    //政治面貌
    let zzmmData = {"共青团员":0, "中共团员":0, "群众":0, "民主党派":0};
    //职称分布
    let zcfbData = {"高级教师":0, "中教一级":0, "中教二级":0, "未评级":0};

    jszyData.forEach( info => {
        let {xb, zzmm, nl, zc, xl} = info;
        if(xb == "女") nvshenNum += 1;
        else nanshenNum += 1;
        if(xl) {
            if (!xlData[xl]) xlData[xl] = 1;
            else xlData[xl] += 1;
        }
        
        if(nl>=0 || nl<35) nlData["0~35岁"] += 1;
        else if(nl>=36 || nl<40) nlData["36~40岁"] += 1;
        else if(nl>=41 || nl<45) nlData["41~45岁"] += 1;
        else if(nl>=46 || nl<50) nlData["46~50岁"] += 1;
        else if(nl>=51 || nl<55) nlData["51~55岁"] += 1;
        else if(nl>=55) nlData["55岁以上"] += 1;

        for(let key in zzmmData) {
            if (key == zzmm) zzmmData[key] += 1;
        }

        for(let key in zcfbData) {
            if (key == zc) zcfbData[key] += 1;
        }
    })

    let nanshen = {
        key:"男生人数",
        value:nanshenNum,
        rate:""
    };
    let nvshen = {
        key:"女生人数",
        value:nvshenNum,
        rate:""
    };

    if(nanshen.value) nanshen.rate = Math.round(nanshen.value/jszyData.length*100 ) + "%";
    if(nvshen.value) nvshen.rate = Math.round(nvshen.value/jszyData.length*100 ) + "%";
    let nannvshen = [nanshen, nvshen];
    ret["jszyfb"] = {title:"男生人数女生人数", dataList:nannvshen};

    // let xlfbData = await getReqApiData(njzjshxNENUM.学历分布, {type:"education"});
    let xlfbData = [];
    for (let key in xlData) {
        xlfbData.push({type:key, count:xlData[key]});
    }
    let xlfbConf = {"大学专科毕业":"大专", "大学本科毕业":"本科", "硕士研究生毕业":"硕士", "博士研究生毕业":"博士"};
    let xlfbList = {};
    if (xlfbData) {
        xlfbData.forEach( info => {
            let count = parseInt(info.count) || 0;
            let type = info.type || "";
            for(let key in xlfbConf) {
                switch (type) {
                    case key:
                        xlfbList[xlfbConf[key]] = count;
                    break;
                    default:
                        if (!xlfbList["其他"]) xlfbList["其他"] = count;
                        else xlfbList["其他"] += count;
                    break;
                }
            }
        });
    }
    
    let xlfb = [];
    for (let key in xlfbList) {
        xlfb.push({key, value:xlfbList[key]});
    };

    ret["xlfb"] = {title:"学历分布", dataList:xlfb};

    let jlfbData = await getReqApiData(njzjshxNENUM.教龄分布, {type:"teachAge"});
    let jlfb = [];
    if(jlfbData) {
        jlfbData.forEach( info => {
            let type = info.type || "";
            if(!type) type = "其他";
            jlfb.push({key:type, value:info.count});
        });
    };
    ret["jlfb"] = {title:"教龄分布", dataList:jlfb};
    
    let nlfbData = [];
    for(let key in nlData) {
        nlfbData.push({type:key, count:nlData[key]});
    }
    let nlfb = getKeyValue(nlfbData);
    ret["nlfb"] = {title:"年龄分布", dataList:nlfb};

    // let zzmmData = await getReqApiData(njzjshxNENUM.教师政治面貌, {type:"political"});
    // let zzmm = getKeyValue(zzmmData);
    let zzmmList = [];
    for(let key in zzmmData) {
        zzmmList.push({key, value:zzmmData[key]});
    }
    ret["zzmm"] = {title:"政治面貌", dataList:zzmmList};

    // let zcfbData = await getReqApiData(njzjshxNENUM.职称分布, {type:title});
    let zcfb = [];
    for(let key in zcfbData) {
        zcfb.push({key, value:zcfbData[key]});
    }
    ret["zcfb"] = {title:"职称分布", dataList:zcfb};


    // let nanshenData = await getReqApiData(njzjshxNENUM.教师男女比例, {sex:1});
    // let nvshenData = await getReqApiData(njzjshxNENUM.教师男女比例, {sex:0});
    
    // let jsrs = nanshenData.length+nvshenData.length;

    // let nanshen = {
    //     key:"男生人数",
    //     value:nanshenData.length,
    //     rate:""
    // };
    // let nvshen = {
    //     key:"女生人数",
    //     value:nvshenData.length,
    //     rate:""
    // };

    // nanshen.rate = Math.round(nanshen.value/jsrs*100 ) + "%";
    // nvshen.rate = Math.round(nvshen.value/jsrs*100 ) + "%";
    // let nannvshen = [nanshen, nvshen];
    // ret["jszyfb"] = {title:"男生人数女生人数", dataList:nannvshen};

    // let xlfbData = await getReqApiData(njzjshxNENUM.学历分布, {type:"education"});
    // let xlfbConf = {"大学专科毕业":"大专", "大学本科毕业":"本科", "硕士研究生毕业":"硕士", "博士研究生毕业":"博士"};
    // let xlfbList = {};
    // xlfbData.forEach( info => {
    //     let count = parseInt(info.count) || 0;
    //     let type = info.type || "";
    //     for(let key in xlfbConf) {
    //         switch (type) {
    //             case key:
    //                 xlfbList[xlfbConf[key]] = count;
    //             break;
    //             default:
    //                 if (!xlfbList["其他"]) xlfbList["其他"] = count;
    //                 else xlfbList["其他"] += count;
    //             break;
    //         }
    //     }
    // });

    // let xlfb = [];
    // for (let key in xlfbList) {
    //     xlfb.push({key, value:xlfbList[key]});
    // };

    // ret["xlfb"] = {title:"学历分布", dataList:xlfb};

    // let jlfbData = await getReqApiData(njzjshxNENUM.教龄分布, {type:"teachAge"});
    // let jlfb = [];
    // jlfbData.forEach( info => {
    //     let type = info.type || "";
    //     if(!type) type = "其他";
    //     jlfb.push({key:type, value:info.count});
    // });
    // ret["jlfb"] = {title:"教龄分布", dataList:jlfb};

    // let nlfbData = await getReqApiData(njzjshxNENUM.年龄分布, {type:"age"});
    // let nlfb = getKeyValue(nlfbData);
    // ret["nlfb"] = {title:"年龄分布", dataList:nlfb};

    // let zzmmData = await getReqApiData(njzjshxNENUM.教师政治面貌, {type:"political"});
    // let zzmm = getKeyValue(zzmmData);
    // ret["zzmm"] = {title:"政治面貌", dataList:zzmm};

    // let zcfbData = await getReqApiData(njzjshxNENUM.职称分布, {type:title});
    // let zcfb = [];
    // zcfbData.forEach( info => {
    //     let {name, value} = info;
    //     zcfb.push({key:name, value});
    // })
    // ret["zcfb"] = {title:"职称分布", dataList:zcfb};

    let njznds = [
        {
            key:"导师数量",
            value:0
        }
    ];
    ret["dssl"] = {title:"年级组内导师", dataList:njznds};

    let yxbzrds = {
        titleList:["排名", "班主任", "班级", "导师评分"],
        dataList:[
            ["01", "-", "-", "-"],
            ["02", "-", "-", "-"],
            ["03", "-", "-", "-"],
            ["04", "-", "-", "-"],
            ["05", "-", "-", "-"],
            ["06", "-", "-", "-"],
            ["07", "-", "-", "-"],
            ["08", "-", "-", "-"],
            ["09", "-", "-", "-"],
            ["10", "-", "-", "-"],
        ]
    };
    ret["yxbzrds"] = {title:"优秀班主任导师", dataList:yxbzrds};

    let xkdszb = [
        {
            key:"语文",
            value:10
        },
        {
            key:"数学",
            value:14
        },
        {
            key:"英语",
            value:10
        },
        {
            key:"综理",
            value:21
        },
        {
            key:"综文",
            value:17
        },
        {
            key:"体育",
            value:10
        },
        {
            key:"艺术",
            value:10
        },
    ];
    ret["xkdszb"] = {title:"学科导师占比", dataList:xkdszb};

    let xkjcsj = [
        {
            key:"语文",
            value:0
        },
        {
            key:"数学",
            value:0
        },
        {
            key:"英语",
            value:0
        },
        {
            key:"综理",
            value:0
        },
        {
            key:"综文",
            value:0
        },
        {
            key:"体育",
            value:0
        },
        {
            key:"艺术",
            value:0
        },
    ];
    ret["xkjcsj"] = {title:"学科基础数据", dataList:xkjcsj};

    let njjsImg = readFileList(`${ImgUrl}${grade}/`, [], "png");
    ret["njjsImg"] = {title:"年级组教师画像", dataList:njjsImg};

    let jshjData = await getReqApiData(njzjshxNENUM.获奖统计, {pageNo:1, pageSize:100, gradeId:grade});
    let jshjCount = {gjj:0, sj:0, qj:0, xj:0};
    if (jshjData) {
        switch (jshjData.awardLevel) {
            case "国家级":
                jshjCount.gjj++;
            break;
            case "市级":
                jshjCount.sj++;
            break;
            case "区级":
                jshjCount.qj++;
            break;
            case "校级":
                jshjCount.xj++;
            break;
        }
    }
    
    let jshj = [
        {
            key:"国家级奖项",
            value:jshjCount.gjj || 6
        },
        {
            key:"市级奖项",
            value:jshjCount.sj || 35
        },
        {
            key:"区级奖项",
            value:jshjCount.qj || 114
        },
        {
            key:"校级奖项",
            value:jshjCount.xj || 0
        },
    ]
    ret["jshj"] = {title:"获奖统计", dataList:jshj};

    let jsgzlfx = {
        满工作量的人数:[
            {
                key:"教师1",
                value:0
            },
            {
                key:"教师2",
                value:0
            },
            {
                key:"教师3",
                value:0
            },
            {
                key:"教师4",
                value:0
            },
            {
                key:"教师5",
                value:0
            },
            {
                key:"教师6",
                value:0
            },
            {
                key:"教师7",
                value:0
            },
        ],
        不满工作量的人数:[
            {
                key:"教师1",
                value:0
            },
            {
                key:"教师2",
                value:0
            },
            {
                key:"教师3",
                value:0
            },
            {
                key:"教师4",
                value:0
            },
            {
                key:"教师5",
                value:0
            },
            {
                key:"教师6",
                value:0
            },
            {
                key:"教师7",
                value:0
            },
        ],
        超工作量的人数:[
            {
                key:"教师1",
                value:0
            },
            {
                key:"教师2",
                value:0
            },
            {
                key:"教师3",
                value:0
            },
            {
                key:"教师4",
                value:0
            },
            {
                key:"教师5",
                value:0
            },
            {
                key:"教师6",
                value:0
            },
            {
                key:"教师7",
                value:0
            },
        ],
    };
    ret["jsgzlfx"] = {title:"教师工作量分析", dataList:jsgzlfx};

    let tkqk = [
        {
            key:"推门听课情况",
            value:0
        },
        {
            key:"任务听评课情况",
            xn:0,
            xw:0
        }
    ];
    ret["tkqk"] = {title:"听课情况", dataList:tkqk};

    let cqkh = {
        ri:{
            rate:"100%",
            dataList:[
                {
                    key:"01",
                    value:"0"
                },
                {
                    key:"02",
                    value:"0"
                },
                {
                    key:"03",
                    value:"0"
                },
                {
                    key:"04",
                    value:"0"
                },
                {
                    key:"05",
                    value:"0"
                },
                {
                    key:"06",
                    value:"0"
                },
                {
                    key:"07",
                    value:"0"
                },
            ],
            meeting:[
                {
                    key:"升旗仪式",
                    value:0
                },
                {
                    key:"教工大会",
                    value:0
                }
            ]
        },
        zhou:{
            rate:"100%",
            dataList:[
                {
                    key:"01",
                    value:"0"
                },
                {
                    key:"02",
                    value:"0"
                },
                {
                    key:"03",
                    value:"0"
                },
                {
                    key:"04",
                    value:"0"
                },
                {
                    key:"05",
                    value:"0"
                },
                {
                    key:"06",
                    value:"0"
                },
                {
                    key:"07",
                    value:"0"
                },
            ],
            meeting:[
                {
                    key:"升旗仪式",
                    value:0
                },
                {
                    key:"教工大会",
                    value:0
                }
            ]
        },
        yue:{
            rate:"100%",
            dataList:[
                {
                    key:"01",
                    value:"0"
                },
                {
                    key:"02",
                    value:"0"
                },
                {
                    key:"03",
                    value:"0"
                },
                {
                    key:"04",
                    value:"0"
                },
                {
                    key:"05",
                    value:"0"
                },
                {
                    key:"06",
                    value:"0"
                },
                {
                    key:"07",
                    value:"0"
                },
            ],
            meeting:[
                {
                    key:"升旗仪式",
                    value:0
                },
                {
                    key:"教工大会",
                    value:0
                }
            ]
        },
    };
    ret["cqkh"] = {title:"出勤考核", dataList:cqkh};

    let qjqk = {
        ri:{
            baseData:[
                {
                    key:"请假",
                    value:0
                },
                {
                    key:"调休",
                    value:0
                },
            ],
            chartData:[
                {
                    key:"事假",
                    value:0
                },
                {
                    key:"病假",
                    value:0
                },
                {
                    key:"婚假",
                    value:0
                },
                {
                    key:"其他",
                    value:0
                },
            ]
        },
        zhou:{
            baseData:[
                {
                    key:"请假",
                    value:0
                },
                {
                    key:"调休",
                    value:0
                },
            ],
            chartData:[
                {
                    key:"事假",
                    value:0
                },
                {
                    key:"病假",
                    value:0
                },
                {
                    key:"婚假",
                    value:0
                },
                {
                    key:"其他",
                    value:0
                },
            ]
        },
        yue:{
            baseData:[
                {
                    key:"请假",
                    value:0
                },
                {
                    key:"调休",
                    value:0
                },
            ],
            chartData:[
                {
                    key:"事假",
                    value:0
                },
                {
                    key:"病假",
                    value:0
                },
                {
                    key:"婚假",
                    value:0
                },
                {
                    key:"其他",
                    value:0
                },
            ]
        },
    };
    ret["qjqk"] = {title:"请假情况", dataList:qjqk};

    let jyhdjcsj = [
        {
            key:"活动次数",
            value:0
        },
        {
            key:"参与总人数",
            value:0
        },
    ];
    ret["jyhdjcsj"] = {title:"教研活动", dataList:jyhdjcsj};

    let jyhd = [
        {
            name:"暂无",
            time:"暂无",
            peopleTotal:0,
            teacherTotal:0
        },
        {
            name:"暂无",
            time:"暂无",
            peopleTotal:0,
            teacherTotal:0
        },
    ];
    ret["jyhd"] = {title:"教研活动详细", dataList:jyhd};

    let ktcycs = [
        {
            key:"课题参与次数",
            value:3
        }
    ];
    ret["ktcycs"] = {title:"课题参与次数", dataList:ktcycs};

    let ktcy = {
        titleList:["教师姓名", "课程名称", "课程级别", "开课时间", "组织单位"],
        dataList:[
            ["-", "-", "-", "-", "-"],
            ["-", "-", "-", "-", "-"],
            ["-", "-", "-", "-", "-"],
            ["-", "-", "-", "-", "-"],
            ["-", "-", "-", "-", "-"],
        ]
    };
    ret["ktcy"] = {title:"课题参与", dataList:ktcy};

    let gkkcycs = [
        {
            key:"公开课参与次数",
            value:5
        }
    ];
    ret["gkkcycs"] = {title:"公开课参与次数", dataList:gkkcycs};

    let gkkcy = {
        titleList:["教师姓名", "课程名称", "课程级别", "开课时间", "组织单位"],
        dataList:[
            ["-", "-", "-", "-", "-"],
            ["-", "-", "-", "-", "-"],
            ["-", "-", "-", "-", "-"],
            ["-", "-", "-", "-", "-"],
            ["-", "-", "-", "-", "-"],
        ]
    };
    ret["gkkcy"] = {title:"公开课参与", dataList:gkkcy};

    let jsjxpxqk = [
        {
            key:"培训次数",
            value:0
        },
        {
            key:"参与率",
            value:"0%"
        },
    ];
    ret["jsjxpxqk"] = {title:"教师进修培训情况", dataList:jsjxpxqk};

    let glscycs = {
        大学听课:[
            {
                key:"李老师",
                value:12
            },
            {
                key:"李老师",
                value:12
            },
            {
                key:"李老师",
                value:12
            },
            {
                key:"李老师",
                value:12
            },
            {
                key:"李老师",
                value:12
            },
            {
                key:"李老师",
                value:12
            },
        ],
        名师工作室:[
            {
                key:"李老师",
                value:12
            },
            {
                key:"李老师",
                value:12
            },
            {
                key:"李老师",
                value:12
            },
            {
                key:"李老师",
                value:12
            },
            {
                key:"李老师",
                value:12
            },
            {
                key:"李老师",
                value:12
            },
        ],
        基地学习:[
            {
                key:"李老师",
                value:12
            },
            {
                key:"李老师",
                value:12
            },
            {
                key:"李老师",
                value:12
            },
            {
                key:"李老师",
                value:12
            },
            {
                key:"李老师",
                value:12
            },
            {
                key:"李老师",
                value:12
            },
        ],
        校本研修:[
            {
                key:"李老师",
                value:12
            },
            {
                key:"李老师",
                value:12
            },
            {
                key:"李老师",
                value:12
            },
            {
                key:"李老师",
                value:12
            },
            {
                key:"李老师",
                value:12
            },
            {
                key:"李老师",
                value:12
            },
        ]
    };
    ret["glscycs"] = {title:"各老师参与次数", dataList:glscycs};

    let jxsl = [
        {
            key:"奖项数量",
            value:31
        }
    ];
    ret["jxsl"] = {title:"奖项数量", dataList:jxsl};

    let jxbscyqk = [
        {
            key:"省/市级",
            value:21
        },
        {
            key:"区/县级",
            value:10
        }
    ];
    ret["jxbscyqk"] = {title:"教学比赛参与情况", dataList:jxbscyqk};

    let bsxxlb = [
        ["中小学心理...", "区/县级", "龚思疏"],
        ["浦东新区德...", "区/县级", "龚思疏"],
        ["浦东新区小...", "区/县级", "龚思疏"],
        ["浦东新区中...", "区/县级", "龚思疏"],
    ];
    ret["bsxxlb"] = {title:"教学比赛参与情况详情", dataList:bsxxlb};

    let jxmydfk = {
        一至四:[
            {
                key:"教师1",
                value:41
            },
            {
                key:"教师2",
                value:12
            },
            {
                key:"教师3",
                value:17
            },
            {
                key:"教师4",
                value:33
            },
            {
                key:"教师5",
                value:12
            },
            {
                key:"教师6",
                value:23
            },
        ],
        五至九:[
            {
                key:"教师1",
                value:41
            },
            {
                key:"教师2",
                value:12
            },
            {
                key:"教师3",
                value:17
            },
            {
                key:"教师4",
                value:33
            },
            {
                key:"教师5",
                value:12
            },
            {
                key:"教师6",
                value:23
            },
        ],
        高中:[
            {
                key:"教师1",
                value:41
            },
            {
                key:"教师2",
                value:12
            },
            {
                key:"教师3",
                value:17
            },
            {
                key:"教师4",
                value:33
            },
            {
                key:"教师5",
                value:12
            },
            {
                key:"教师6",
                value:23
            },
        ],
    };
    ret["jxmydfk"] = {title:"教学满意度反馈", dataList:jxmydfk};

    let hdcyqk = [
        {
            key:"总数量",
            value:0
        }
    ];
    ret["hdcyqk"] = {title:"工作坊活动参与情况", dataList:hdcyqk};

    res.send(ret);
}







