/**
 * 教师画像（对内）
 */

import { jshxNENUM, jshxWENUM, ztbxNENUM } from "../../config/interficeEnum";
import { getReqApiData } from "../../data/interface/url";
import { getImagesInDir, getKeyValue, readFileList } from "../outData";
import { jyzjshxTableData, tysjyTableData } from "../../data/table/duiwai";
import { keyValuePackage, tablePackage } from "../../dataPackage/inFrontOut";
import { systemConfig } from "../../config/serverConfig";
import { jshxTableData } from "../../data/table/duinei";
import * as duiwai from "../../data/table/duiwai";
import moment = require("moment");

const ImgUrl = "img/对外/教师画像/";

export async function getData(req, res) {
    let ret: any = {};
    // let excelData = jshxTableData();
    let excelData = jshxTableData()
    let 统一excelData = tysjyTableData();
    let excelDuiWaiData = duiwai.jshxTableData();

    const NowTime = new Date();

    // let jszyData = await getReqApiData(jshxNENUM.教师资源, {}); //todo

    let jszy = [];
    统一excelData["教师人员"].dataList.forEach(info => {
        if (info.key == "教师人数") jszy.push(info);
    });
    jszy.push({
        key: "教师资源达标率",
        value: "-",
        unit: ""
    });
    ret["jszy"] = { title: "教师资源", dataList: jszy };

    // let nanshenData = await getReqApiData(jshxNENUM.教师男女比例, {sex:1});
    // let nvshenData = await getReqApiData(jshxNENUM.教师男女比例, {sex:0});

    let nanshenData = 0;
    let nvshenData = 0;
    excelData['男女人数'].dataList.forEach(info => {
        if (info.key == "男") nanshenData = info.value;
        if (info.key == "女") nvshenData = info.value;
    })
    let jsrs = nanshenData + nvshenData;

    let nanshen = {
        key: "男生人数",
        value: nanshenData,
        rate: ""
    };
    let nvshen = {
        key: "女生人数",
        value: nvshenData,
        rate: ""
    };

    nanshen.rate = Math.round(nanshen.value / jsrs * 100) + "%";
    nvshen.rate = Math.round(nvshen.value / jsrs * 100) + "%";
    let nannvshen = [nanshen, nvshen];
    ret["jszyfb"] = { title: "男生人数女生人数", dataList: nannvshen };

    // let xlfbData = await getReqApiData(jshxNENUM.学历分布, {type:"education"});
    // let xlfbConf = {"大学专科毕业":"大专", "大学本科毕业":"本科", "硕士研究生毕业":"硕士", "博士研究生毕业":"博士"};
    // let xlfbList = {};
    // xlfbData.forEach( info => {
    //     let count = parseInt(info.count) || 0;
    //     let type = info.type || "";
    //     for(let key in xlfbConf) {
    //         switch (type) {
    //             case key:
    //                 xlfbList[xlfbConf[key]] = count;
    //             break;
    //             default:
    //                 if (!xlfbList["其他"]) xlfbList["其他"] = count;
    //                 else xlfbList["其他"] += count;
    //             break;
    //         }
    //     }
    // });

    // let xlfb = [];
    // for (let key in xlfbList) {
    //     xlfb.push({key, value:xlfbList[key]});
    // };

    let xlfb = excelData["学历分布"].dataList;
    ret["xlfb"] = { title: "学历分布", dataList: xlfb };

    // let jlfbData = await getReqApiData(jshxNENUM.教龄分布, {type:"teachAge"});
    // let jlfb = [];
    // jlfbData.forEach( info => {
    //     let type = info.type || "";
    //     if(!type) type = "其他";
    //     jlfb.push({key:type, value:info.count});
    // });
    let jlfb = excelData["教龄分布"].dataList;
    ret["jlfb"] = { title: "教龄分布", dataList: jlfb };

    // let nlfbData = await getReqApiData(jshxNENUM.年龄分布, {type:"age"});
    // let nlfb = getKeyValue(nlfbData);
    let nlfb = excelData["年龄分布"].dataList;
    ret["nlfb"] = { title: "年龄分布", dataList: nlfb };

    // let zzmmData = await getReqApiData(jshxNENUM.教师政治面貌, {type:"political"});
    // let zzmm = getKeyValue(zzmmData);
    let zzmm = excelData["教师政治面貌"].dataList;
    ret["zzmm"] = { title: "政治面貌", dataList: zzmm };

    // let zcfbData = await getReqApiData(jshxNENUM.职称分布, {type:"title"});
    // let zcfb = [];
    // zcfbData.forEach( info => {
    //     let {type, count} = info;
    //     zcfb.push({key:type, value:count});
    // })
    // if (!zcfb.length) {
    //     zcfb = [
    //         {key:"高级", value:3},
    //         {key:"一级", value:7},
    //         {key:"二级", value:22},
    //         {key:"未评级", value:5},
    //     ]
    // }
    let zcfb = excelData["职称分布"].dataList;
    ret["zcfb"] = { title: "职称分布", dataList: zcfb };

    // let jyzdjData = await getReqApiData(jshxWENUM.教研组搭建, {}); //todo
    let jyzjsConf = ["语文", "数学", "英语", "综理", "综文", "体育", "艺术"];
    let jyzdj = [];
    for (let i = 0; i < jyzjsConf.length; i++) {
        let jyzExcelData = jyzjshxTableData(`${jyzjsConf[i]}组`);
        let jszyTableData = jyzExcelData["教师资源"].dataList;
        jyzdj.push({ key: jyzjsConf[i], value: jszyTableData.length })
    }
    ret["jyzdj"] = { title: "教研组搭建", dataList: jyzdj };

    let szjg = excelData['师资结构'].dataList;
    ret["szjg"] = { title: "师资结构", dataList: szjg };

    let xbkc = {
        titleList: excelData['校本课程'].headerList[0],
        dataList: excelData['校本课程'].bodyList
    };
    ret["xbkc"] = { title: "校本课程", dataList: xbkc };

    let tzkc = {
        titleList: excelData['拓展课程'].headerList[0],
        dataList: excelData['拓展课程'].bodyList
    };
    ret["tzkc"] = { title: "拓展课程", dataList: tzkc };

    let xxkc = {
        titleList: excelData['选修课程'].headerList[0],
        dataList: excelData['选修课程'].bodyList
    };
    ret["xxkc"] = { title: "选修课程", dataList: xxkc };

    // let jshjData = await getReqApiData(jshxNENUM.教师获奖, {pageNo:1, pageSize:100});
    // let jshjData = await getReqApiData(jshxNENUM.获奖情况, { type: 1 }, null, "data", "jsfz");
    let jxtjDataList = { gjj: [], sj: [], qj: [], xj: [] };
    for (let i = 1; i <=3; i++) {
        let jshjData = await getReqApiData(jshxNENUM.教师获奖, {type:1, page:i, api_rpp:100}, null, "data", "jsfz");
    
        if (jshjData) {
            jshjData.list.data.forEach(info => {
                //todo 对应标准发给我之后修改
                if (info.level == "国家级及以上") jxtjDataList.gjj.push(info);
                if (info.level == "省/市级") jxtjDataList.sj.push(info);
                if (info.level == "区/县级") jxtjDataList.qj.push(info);
                if (info.level == "校级") jxtjDataList.xj.push(info);
            })
        }
    }
    
    let jshj = [
        {
            key: "国家级奖项",
            value: jxtjDataList.gjj.length || 0
        },
        {
            key: "市级奖项",
            value: jxtjDataList.sj.length || 0
        },
        {
            key: "区级奖项",
            value: jxtjDataList.qj.length || 0
        },
        {
            key: "校级奖项",
            value: jxtjDataList.xj.length || 0
        },
    ]
    ret["jshj"] = { title: "教师获奖", dataList: jshj };

    let tptdImg = getImagesInDir(`img/对内/教师画像/特聘团队/`);
    ret["tptd"] = { title: "特聘团队", dataList: tptdImg };

    let zjtdImg = getImagesInDir(`img/对内/教师画像/专家团队/`);
    ret["zjtd"] = {title:"专家团队", dataList:zjtdImg};

    let xkdstd = keyValuePackage(excelData['学科导师团队'].dataList);
    ret["xkdstd"] = { title: "学科导师团队", dataList: xkdstd };

    let tdxx = keyValuePackage(excelDuiWaiData['学科导师占比'].dataList);
    ret["tdxx"] = { title: "学科导师团队详细", dataList: tdxx };

    let jsxfhq = keyValuePackage(excelData['教师学分获取汇总数据'].dataList);
    ret["jsxfhq"] = { title: "教师学分获取", dataList: jsxfhq };

    let jsxfhqxx = keyValuePackage(excelData['教师学分获取'].dataList);
    ret["jsxfhqxx"] = { title: "教师学分获取详细", dataList: jsxfhqxx };

    let cycjjss = keyValuePackage(excelDuiWaiData["参与创建教师数"].dataList);
    ret["cycjjss"] = { title: "参与创建教师数", dataList: cycjjss };

    let dxyfxhpgy = keyValuePackage(excelDuiWaiData["大学与附校互聘共育"].dataList);
    ret["dxyfxhpgy"] = { title: "大学与附校互聘共育", dataList: dxyfxhpgy };

    let jxkczs = [
        {
            key: "进修课程总数",
            value: excelData['进修课程数据'].bodyList.length
        }
    ];
    ret["jxkczs"] = { title: "选修课程总数", dataList: jxkczs };

    let jxkcbg = {
        titleList: excelData['进修课程数据'].headerList[0],
        dataList: excelData['进修课程数据'].bodyList
    };
    ret["jxkcbg"] = { title: "进修课程表格", dataList: jxkcbg };

    let jskhdyxq = {
        师德考核: [
            {
                key: "优秀",
                value: 0
            },
            {
                key: "合格数量",
                value: 0
            },
            {
                key: "合格教师名单",
                value: "-"
            },
        ],
        年度考核: [
            {
                key: "优秀",
                value: 0
            },
            {
                key: "合格数量",
                value: 0
            },
            {
                key: "不合格",
                value: 0
            },
            {
                key: "基本合格",
                value: 0
            },
        ],
    };
    ret["jskhdyxq"] = { title: "第一学期（师德考核/年度考核）", dataList: jskhdyxq };

    let jskhdexq = {
        师德考核: [
            {
                key: "优秀",
                value: 0
            },
            {
                key: "合格数量",
                value: 0
            },
            {
                key: "合格教师名单",
                value: "-"
            },
        ],
        年度考核: [
            {
                key: "优秀",
                value: 0
            },
            {
                key: "合格数量",
                value: 0
            },
            {
                key: "不合格",
                value: 0
            },
            {
                key: "基本合格",
                value: 0
            },
        ],
    };
    ret["jskhdexq"] = { title: "第二学期（师德考核/年度考核）", dataList: jskhdexq };

    let ztcql = [
        {
            key: "整体出勤率",
            value: 98,
            unit: "%"
        }
    ];
    ret["ztcql"] = { title: "整体出勤率", dataList: ztcql };

    let cqkhqk = [
        // {
        //     key: "5.17",
        //     value: 46
        // },
        // {
        //     key: "5.18",
        //     value: 17
        // },
        // {
        //     key: "5.19",
        //     value: 11
        // },
        // {
        //     key: "5.20",
        //     value: 49
        // },
        // {
        //     key: "5.21",
        //     value: 20
        // },
        // {
        //     key: "5.22",
        //     value: 31
        // },
        // {
        //     key: "5.23",
        //     value: 66
        // }
    ];
    let startOfWeek = moment().subtract(7, 'days').format("YYYY-MM-DD HH:mm:ss");
    let endOfWeek = moment(NowTime).format("YYYY-MM-DD HH:mm:ss");
    let jqtcqData = await getReqApiData(jshxNENUM.教师考勤统计, { startDate: startOfWeek, endDate: endOfWeek, pageNum: 7, pageSize: 100 }, "GET", "data");
    //todo 接口字段没有说明
    // /getTeacherReport
    if (jqtcqData) {
        let thisDateKey = moment().format("YYYY-MM-DD");
        let dayMap = {};
        jqtcqData.list.forEach(info => {
            let  {every_date, num, clock_status} = info;
            if (!dayMap[every_date]) dayMap[every_date] = {count:0, successCount:0, ms:moment(every_date).valueOf() };
            if (clock_status == 1) {
                dayMap[every_date].successCount += parseInt(num);
            }
            dayMap[every_date].count += parseInt(num);
        });
        let dayList = Object.values(dayMap);
    
        dayList.forEach(info => {
            cqkhqk.push({
                key:moment(info["ms"]).format("M.D"),
                value:Math.round(info["successCount"]/info["count"]*100)
            });
        })
    }

    ret["cqkhqk"] = { title: "出勤考核情况", dataList: cqkhqk };

   
    let qjqk = [
        {
            key: "请假",
            value: 0,
            rate:`0%`
        },
        {
            key: "调休",
            value: 0,
            rate: `0%`
        },
    ];
    let qjData = await getReqApiData(ztbxNENUM.教师当天请假人数, { type:1 }, "GET", "list");
    let txData = await getReqApiData(ztbxNENUM.教师当天请假人数, { type:2 }, "GET", "list");
    
   
    if (qjData && txData) {
        let qjRate = 0;
        let txRate = 0;
        let thisCount = qjData[0].value + txData[0].value;
        if (thisCount) {
            if (qjData[0].value) qjRate = Math.round(qjData[0].value/thisCount*100);
            if (txData[0].value) txRate = Math.round(txData[0].value/thisCount*100);
        }
        qjqk[0].value = qjData[0].value;
        qjqk[0].rate = `${qjRate}%`;
        qjqk[1].value = txData[0].value;
        qjqk[1].rate = `${txRate}%`;
    }
   
    ret["qjqk"] = { title: "请假情况", dataList: qjqk };

    

    // let startOfWeek = moment().subtract(7, 'days').format("YYYY-MM-DD HH:mm:ss");
    // let endOfWeek = moment(NowTime).format("YYYY-MM-DD HH:mm:ss");
    //todo 接口返回数据不对
    let tdkqkData = await getReqApiData(jshxNENUM.教师调代课记录, { startDate: startOfWeek, endDate: endOfWeek }, "GET", "data");
    let tdkqk = [
        {
            key: "调代课次数",
            value: tdkqkData.count || 0
        }
    ];
    ret["tdkqk"] = { title: "调代课情况", dataList: tdkqk };

    let qjqkxx = [
        {
            key: "事假",
            value: 0
        },
        {
            key: "病假",
            value: 0
        },
        {
            key: "婚假",
            value: 0
        },
        {
            key: "丧假、产假",
            value: 0
        },
    ];
    ret["qjqkxx"] = { title: "请假情况", dataList: qjqkxx };

    let hycqqk = [
        {
            key: "升旗仪式",
            value: 0
        },
        {
            key: "代课次数",
            value: 0
        },
    ];
    ret["hycqqk"] = { title: "会议出勤情况", dataList: hycqqk };

    let jxmyd = [
        {
            key: "5.17",
            value: 0
        },
        {
            key: "5.18",
            value: 0
        },
        {
            key: "5.19",
            value: 0
        },
        {
            key: "5.20",
            value: 0
        },
        {
            key: "5.21",
            value: 0
        },
        {
            key: "5.22",
            value: 0
        },
        {
            key: "5.23",
            value: 0
        },
    ];
    ret["jxmyd"] = { title: "教学满意度", dataList: jxmyd };

    // let njzksl1 = [
    //     {
    //         key:"5.17",
    //         mgzlrs:0,
    //         bmgzlrs:0,
    //         cgzlrs:0
    //     },
    //     {
    //         key:"5.18",
    //         mgzlrs:0,
    //         bmgzlrs:0,
    //         cgzlrs:0
    //     },
    //     {
    //         key:"5.19",
    //         mgzlrs:0,
    //         bmgzlrs:0,
    //         cgzlrs:0
    //     },
    //     {
    //         key:"5.20",
    //         mgzlrs:0,
    //         bmgzlrs:0,
    //         cgzlrs:0
    //     },
    //     {
    //         key:"5.21",
    //         mgzlrs:0,
    //         bmgzlrs:0,
    //         cgzlrs:0
    //     },
    //     {
    //         key:"5.22",
    //         mgzlrs:0,
    //         bmgzlrs:0,
    //         cgzlrs:0
    //     },
    //     {
    //         key:"5.23",
    //         mgzlrs:0,
    //         bmgzlrs:0,
    //         cgzlrs:0
    //     },
    // ];

    let njzksl1 = excelData["1-4年级总课时量"].dataList;
    ret["njzksl1"] = { title: "1-4年级总课时量", dataList: njzksl1 };

    let njzksl2 = excelData["5-9年级总课时量"].dataList;
    ret["njzksl2"] = { title: "5-9年级总课时量", dataList: njzksl2 };

    let njzksl3 = excelData["高中部总课时量"].dataList;
    ret["njzksl3"] = { title: "高中部总课时量", dataList: njzksl3 };

    let tmtkqkData = await getReqApiData(jshxNENUM.听评课情况, {type:1}, null, "data", "jsfz");
    let tmtkqk = [
        {
            key: "校内（人次）",
            value: tmtkqkData.list.dailyCourseNum
        }
    ];
    ret["tmtkqk"] = { title: "推门听课情况", dataList: tmtkqk };

    let rwtpkqkData = await getReqApiData(jshxNENUM.任务听评课情况, {type:1}, null, "data", "jsfz");
    // const regex = /应聘老师/;
    let rwtpkqk = [];
    if (rwtpkqkData) {
        let xwCount = rwtpkqkData.list.data.filter(post => post.ratee.includes("应聘老师")).length;
        let xwRate = ((xwCount / tmtkqkData.list.courseNum)*100).toFixed(2);
        let xnCount = tmtkqkData.list.courseNum - xwCount;
        let xnRate = ((xnCount / tmtkqkData.list.courseNum)*100).toFixed(2);
        rwtpkqk = [
            {
                key: "校内（人次）",
                value: xnCount,
                rate: `${xnRate}%`
            },
            {
                key: "校外（人次）",
                value: xwCount,
                rate: `${xwRate}%`
            },
        ];
    }
    
    ret["rwtpkqk"] = { title: "任务听评课情况", dataList: rwtpkqk };

    // let zyfzcgData = await getReqApiData(jshxWENUM.专业发展成果, {}); //todo 

    let zyfzcgData = await getReqApiData(jshxWENUM.专业发展成果, {type:1}, null, "data", "jsfz");
    let lwfb = [
        {
            key:"论文论著发表",
            value:zyfzcgData.list.treatiseNum || 0
        }
    ];
    ret["zyfzcg"] = { title: "论文发表", dataList: lwfb };
    let lwfbImg = readFileList(`${ImgUrl}论文发表图片/`, [], "png");
    ret["lwfbImg"] = {title:"论文发表图片", dataList:lwfbImg};

    // let jyhj = keyValuePackage(excelData["教师获奖"].dataList);
    let jyhj = [
        {
            key:"指导学生获奖",
            value:zyfzcgData.list.studentNum || 0
        },
        {
            key:"教学评优",
            value:zyfzcgData.list.teachNum || 0
        },
        {
            key:"课题获奖",
            value:zyfzcgData.list.subjectNum || 0
        },
        {
            key:"论文获奖",
            value:zyfzcgData.list.thesisNum || 0
        },
    ]
    ret["jyhj"] = {title:"教研获奖", dataList:jyhj};

    // let cyzcgjpxData = await getReqApiData(jshxWENUM.参与主持人各级培训, {}); //todo
    let pxcs = [
        {
            key: "培训次数",
            value: 0
        }
    ];
    ret["pxcs"] = { title: "培训次数", dataList: pxcs };
    let cyzcgjpx = {
        titleList: ["活动名称", "类型", "时间", "主持人", "参与人数"],
        dataList: [
            ["-", "-", "-", "-", "-"],
            ["-", "-", "-", "-", "-"],
            ["-", "-", "-", "-", "-"],
            ["-", "-", "-", "-", "-"],
        ]
    };
    ret["cyzcgjpx"] = { title: "参与&主持各级培训", dataList: cyzcgjpx };

    // let hdlxcyqxfxData = await getReqApiData(jshxNENUM.活动类型参与趋势分析, {}); //todo
    let hdlxcyqxfx = [
        {
            key: "类型1",
            cy: 0,
            wcy: 0
        },
        {
            key: "类型2",
            cy: 0,
            wcy: 0
        },
        {
            key: "类型3",
            cy: 0,
            wcy: 0
        },
        {
            key: "类型4",
            cy: 0,
            wcy: 0
        },
        {
            key: "类型5",
            cy: 0,
            wcy: 0
        },
    ];
    ret["hdlxcyqxfx"] = { title: "活动类型参与趋势分析", dataList: hdlxcyqxfx };


    res.send(ret);
}



/**
 * 教学教研
 * @param req year：年份
 * @param res 
 */
export async function getKyqk(req, res) {
    let year = req.body.year;
    let ret:any = {};
    
    // let kyqkData = await getReqApiData(jshxWENUM.科研情况, {year}); //todo 参数 年份：2023
    
    let kyqk = []

    let kyqkData = await getReqApiData(jshxWENUM.参与科研情况, {type:year}, null, "data", "jsfz");
    if (kyqkData) {
        for (let key in kyqkData.list) {
            let count = 0;
            for (let info in kyqkData.list[key]) {
                let {num, name} = kyqkData.list[key][info];
                count += num;
            };
            
            let dataList = []
            for (let info in kyqkData.list[key]) {
                let {num, name} = kyqkData.list[key][info];
                let rate = 0;
                if (num != 0) rate = Math.round(num/count*100);
                dataList.push({name, rate:`${rate}%`, value:num});
            };
            
            if (key == "openClass") {
                kyqk.push({
                    key:"公开课",
                    dataList
                })
            } else if (key == "achievement") {
                kyqk.push({
                    key:"成果发表",
                    dataList
                })
            } else if (key == "lecture") {
                kyqk.push({
                    key:"讲座及报告（专家级）",
                    dataList
                })
            };
        }

    }

    ret["kyqk"] = {title:"教学教研", dataList:kyqk};
    res.send(ret);
}



/**教师画像筛选个人 */
export async function getTeacher(req, res) {
    let grade = req.body.grade || ""; //【一年级：1、二年级：2、三年级：3、四年级：4】
    // let className = req.body.className || "";
    let sex = req.body.sex || "";
    let name = req.body.name || "";
    let ret: any = {};

    let body = {};
    if (grade) body["gradeId"] = grade;
    // if(className) body["classNum"] = className;
    if (sex) body["sex"] = sex;
    if (name) body["studentName"] = name;

    let xsgrData = await getReqApiData(jshxNENUM.获取教师信息, body); //todo
    let xsgrConf = [
        {
            "studentId": "6abc38b8425b11ee98a202031519086a",
            "studentName": "吕**",
            "idNumber": null,
            "studentNum": null,
            "studentGnum": null,
            "ethnicCode": null,
            "birthday": null,
            "sex": "0",
            "schoolId": null,
            "gradeId": "1",
            "className": "一年级2班",
            "classId": "63c5ee96422411eeb5e0020315204705",
            "studentSort": null,
            "remark": null
        }
    ];
    let xsgr = [];
    if (xsgrData) xsgr = xsgrData.list;
    else xsgr = xsgrConf;
    ret["xsgr"] = { title: "教师筛选个人", dataList: xsgr };

    res.send(ret);
}



