/**
 * 教师个人发展（对内）
 */

import { jsgrfzNENUM, jshxNENUM, jshxWENUM } from "../../config/interficeEnum";
import { getReqApiData } from "../../data/interface/url";
import { getKeyValue, readFileList } from "../outData";
import { jsgrfzTableData } from "../../data/table/duinei";
import { keyValuePackage, tablePackage } from "../../dataPackage/inFrontOut";
import { systemConfig } from "../../config/serverConfig";
import moment = require("moment");

const ImgUrl = "img/对内/教师个人发展/";

export async function getData(req, res) {
    let teacherId = req.body.teacherId || "03e763eabb3011edbbac020315b3ff1e";
    let ret:any = {};
    let excelData = jsgrfzTableData();

    const NowTime = new Date();

    let jbxxData = await getReqApiData(jsgrfzNENUM.教师基本信息, {teacherId});
    let jsrjbjData = await getReqApiData(jsgrfzNENUM.教师任教班级, {teacherId});
    let jbxx = {
        img:`${systemConfig.ipUrl}对内/教师个人发展/默认头像.png`,
        state:"已认证",
        name: jbxxData[0].name,
        sex: jbxxData[0].sexName,
        subject: jsrjbjData[0].subjectNames,
        academic: jbxxData[0].title,
        period: jsrjbjData[0].className,
    };
    ret["jbxx"] = {title:"基本信息", dataList:jbxx};    

    // let jsjl = [
    //     {
    //         name:"上海科技大学附属学校",
    //         time:"2023第一学期",
    //         rkbj:"九年级(1)班、九年级(4)班",
    //         gzlx:"教学工作",
    //         rjxk:"语文"
    //     },
    //     {
    //         name:"上海******学校",
    //         time:"2022第二学期",
    //         rkbj:"九年级(1)班、九年级(4)班",
    //         gzlx:"教学工作",
    //         rjxk:"语文"
    //     },
    // ];
    let jsjl = [];
    let jshjData = await getReqApiData(jsgrfzNENUM.教师经历, {type:1, sso_user_id:teacherId}, null, "data", "jsfz");
    let name = "上海科技大学附属学校";
    if (jshjData) {
        jshjData.list.data.forEach( info => {
            jsjl.push({name, time:info.semester, rkbj:info.class, gzlx:info.type, rjxk:info.subject});
        })
    }
    
    ret["jsjl"] = {title:"教师经历", dataList:jsjl};

    let xspjfk = {
        学生评价: excelData["学生评价"].dataList,
        学生平均评价: excelData["学生平均评价"].dataList,
    };
    ret["xspjfk"] = {title:"学生评价反馈", dataList:xspjfk};

    let thpj = {
        同行评价: excelData["同行评价"].dataList,
        同行平均评价: excelData["同行平均评价"].dataList,
    };
    ret["thpj"] = {title:"同行评价", dataList:thpj};

    let tpkdf = {
        教师听评课打分:[
            {
                key:"备课",
                value:12
            },
            {
                key:"上课",
                value:31
            },
            {
                key:"作业",
                value:19
            },
            {
                key:"**",
                value:1
            },
            {
                key:"**",
                value:0
            },
            {
                key:"***",
                value:3
            },
            {
                key:"**",
                value:12
            },
        ],
        教师听评课平均打分:[
            {
                key:"备课",
                value:12
            },
            {
                key:"上课",
                value:31
            },
            {
                key:"作业",
                value:19
            },
            {
                key:"**",
                value:1
            },
            {
                key:"**",
                value:0
            },
            {
                key:"***",
                value:3
            },
            {
                key:"**",
                value:12
            },
        ],
    };
    ret["tpkdf"] = {title:"听评课打分", dataList:tpkdf};

    let jdxsslData = await getReqApiData(jshxNENUM.全员导师制, {type:1, sso_user_id:teacherId}, null, "data", "jsfz");
    let jdxssl = [];
    if (jdxsslData || jdxsslData.length != 0) {
        if(jdxsslData.list.data != 0) {
            jdxsslData.list.data.forEach( info => {
                let {semester, startTime, endTime, teacherName, studentNames} = info;
                jdxssl.push({semester, startTime, endTime, studentNames})
            })
        }
    }
    ret["qyds"] = {title:"全员导师", dataList:jdxssl};

    // let qyds = {
    //     titleList:["学生姓名", "班级", "年级"],
    //     dataList:[
    //         ["-", "-", "-"],
    //         ["-", "-", "-"],
    //         ["-", "-", "-"],
    //         ["-", "-", "-"],
    //     ]
    // };
    // ret["qyds"] = {title:"全员导师", dataList:qyds};

    let jshjrc = [
        {
            key:"学业优秀学生数",
            value:0
        },
        {
            key:"竞赛获奖学生数",
            value:0
        },
    ];
    ret["jshjrc"] = {title:"竞赛获奖人次", dataList:jshjrc};

    let xyyxxss = {
        titleList: ["优秀学生姓名", "学生班级", "获奖作品内容"],
        dataList: [
            ["-", "-", "-"],
            ["-", "-", "-"],
            ["-", "-", "-"],
        ]
    };
    ret["xyyxxss"] = {title:"学业优秀学生数", dataList:xyyxxss};

    let jshjxss = {
        titleList: ["优秀学生姓名", "学生班级", "获奖作品内容"],
        dataList: [
            ["-", "-", "-"],
            ["-", "-", "-"],
            ["-", "-", "-"],
        ]
    };
    ret["jshjxss"] = {title:"竞赛获奖学生数", dataList:jshjxss};

    // let grcg = [
    //     {
    //         key:"课题研究数",
    //         value:131,
    //         detailed:[
    //             ["-", "-"],
    //             ["-", "-"],
    //             ["-", "-"],
    //             ["-", "-"],
    //             ["-", "-"],
    //             ["-", "-"],
    //             ["-", "-"],
    //             ["-", "-"],
    //         ]
    //     },
    //     {
    //         key:"发表出版数",
    //         value:97,
    //         detailed:[
    //             ["-", "-"],
    //             ["-", "-"],
    //             ["-", "-"],
    //             ["-", "-"],
    //             ["-", "-"],
    //             ["-", "-"],
    //             ["-", "-"],
    //             ["-", "-"],
    //         ]
    //     },
    //     {
    //         key:"获得奖项",
    //         value:155,
    //         detailed:[
    //             ["-", "-"],
    //             ["-", "-"],
    //             ["-", "-"],
    //             ["-", "-"],
    //             ["-", "-"],
    //             ["-", "-"],
    //             ["-", "-"],
    //             ["-", "-"],
    //         ]
    //     },
    // ];
    let grcgData = {课题研究数:0, 发表出版数:0, 获得奖项:0};
    let zyfzcgData = await getReqApiData(jshxWENUM.专业发展成果, {type:1}, null, "data", "jsfz");
    if (zyfzcgData) {
        grcgData = {
            课题研究数:zyfzcgData.subjectNum, 
            发表出版数:zyfzcgData.treatiseNum, 
            获得奖项:zyfzcgData.studentNum + zyfzcgData.teachNum + zyfzcgData.thesisNum
        };
    }
    let grcg = [];
    for (let key in grcgData) {
        grcg.push({key, value:grcgData[key], detailed:[["-", "-"]]});
    }

    ret["grcg"] = {title:"个人成果", dataList:grcg};
    
    let jxtjData = await getReqApiData(jshxWENUM.获奖情况, {type:1, sso_user_id:teacherId}, null, "data", "jsfz");
    let cyjszs = [
        {
            key:"参与教师总数",
            value:jxtjData.list.total || 0
        }
    ];
    // let jxtjCount = {gjj:0, sj:0, qj:0, xj:0};
    ret["cyjszs"] = {title:"参与教师总数", dataList:cyjszs};

    let zyry = [
        ["-", "-", "-"],
        ["-", "-", "-"],
        ["-", "-", "-"],
        // ["学科带头人", "2016.06.30-2025.06.30", "****"],
        // ["区骨干", "2016.06.30-2025.06.30", "****"],
        // ["区骨干", "2016.06.30-2025.06.30", "****"],
        // ["市中心组成员", "2016.06.30-2025.06.30", "****"],
    ];
    ret["zyry"] = {title:"专业荣誉", dataList:zyry};

    let jssy = [
        {
            key:"教师学分获取",
            value:"***"
        },
        {
            key:"参与社会服务",
            value:"***"
        },
    ];
    ret["jssy"] = {title:"教师素养", dataList:jssy};

    let ryjx = readFileList(`${ImgUrl}荣誉奖项/`, [], "png");
    ret["ryjx"] = {title:"荣誉奖项", dataList:ryjx};

    let jskhdyxq = {
        师德考核:[
            {
                key:"优秀",
                value:0
            },
            {
                key:"合格数量",
                value:0
            },
            {
                key:"合格教师名单",
                value:"-"
            },
        ],
        年度考核:[
            {
                key:"优秀",
                value:0
            },
            {
                key:"合格数量",
                value:0
            },
            {
                key:"不合格",
                value:0
            },
            {
                key:"基本合格",
                value:0
            },
        ],
    };
    ret["jskhdyxq"] = {title:"第一学期（师德考核/年度考核）", dataList:jskhdyxq};

    let jxmyddyxq = [
        {
            key:"12.19",
            value:0
        },
        {
            key:"12.20",
            value:0
        },
        {
            key:"12.21",
            value:0
        },
        {
            key:"12.22",
            value:0
        },
        {
            key:"12.23",
            value:0
        },
        {
            key:"12.24",
            value:0
        },
        {
            key:"12.25",
            value:0
        }
    ];
    ret["jxmyddyxq"] = {title:"第一学期（教学满意度）", dataList:jxmyddyxq};

    let jskhdexq = {
        师德考核:[
            {
                key:"优秀",
                value:0
            },
            {
                key:"合格数量",
                value:0
            },
            {
                key:"合格教师名单",
                value:"-"
            },
        ],
        年度考核:[
            {
                key:"优秀",
                value:0
            },
            {
                key:"合格数量",
                value:0
            },
            {
                key:"不合格",
                value:0
            },
            {
                key:"基本合格",
                value:0
            },
        ],
    };
    ret["jskhdexq"] = {title:"第二学期（师德考核/年度考核）", dataList:jskhdexq};

    let jxmyddexq = [
        {
            key:"12.19",
            value:0
        },
        {
            key:"12.20",
            value:0
        },
        {
            key:"12.21",
            value:0
        },
        {
            key:"12.22",
            value:0
        },
        {
            key:"12.23",
            value:0
        },
        {
            key:"12.24",
            value:0
        },
        {
            key:"12.25",
            value:0
        }
    ];
    ret["jxmyddexq"] = {title:"第二学期（教学满意度）", dataList:jxmyddexq};
    
    let ztcql = [
        {
            key:"整体出勤率",
            value:98
        }
    ];
    ret["ztcql"] = {title:"整体出勤率", dataList:ztcql};

    let cqkhqk = [
        {
            key:"12.19",
            value:0
        },
        {
            key:"12.20",
            value:0
        },
        {
            key:"12.21",
            value:0
        },
        {
            key:"12.22",
            value:0
        },
        {
            key:"12.23",
            value:0
        },
        {
            key:"12.24",
            value:0
        },
        {
            key:"12.25",
            value:0
        }
    ];
    ret["cqkhqk"] = {title:"出勤考核情况", dataList:cqkhqk};

    let qjqk = [
        {
            key:"请假",
            value:0
        },
        {
            key:"调休",
            value:0
        },
    ];

    ret["qjqk"] = {title:"请假情况", dataList:qjqk};

    let tdkqk = [
        {
            key:"调代课情况",
            value:98
        },
        {
            key:"代课次数",
            value:98
        },
    ];


    ret["tdkqk"] = {title:"调代课情况", dataList:tdkqk};

    let qjqkxx = [
        {
            key:"调休",
            value:0
        },
        {
            key:"丧假",
            value:0
        },
    ];
    // let startOfWeek = moment().subtract(1, 'days').format("YYYY-MM-DD");
    // let endOfWeek = moment(NowTime).format("YYYY-MM-DD");
    // let jsbjrs = await getReqApiData(jshxWENUM.教师病假人数趋势, {beginDate:startOfWeek, endDate:endOfWeek});
    // let qjqkxx = [];

    ret["qjqkxx"] = {title:"请假情况", dataList:qjqkxx};

    let hycqqk = [
        {
            key:"升旗仪式",
            value:0
        },
        {
            key:"代课次数",
            value:0
        },
    ];
    ret["hycqqk"] = {title:"会议出勤情况", dataList:hycqqk};

    let jsgzlfx = {};
    let jsgzlfxData = excelData["填报学期"].dataList;
    jsgzlfxData.forEach( info => {
        jsgzlfx[info.value] = excelData[info.key].dataList;
    })
    jsgzlfx["历年满勤统计"] = excelData["历年满勤统计"].dataList;
    ret["jsgzlfx"] = {title:"教师工作量分析", dataList:jsgzlfx};

    let tmtkqkData = await getReqApiData(jshxNENUM.听评课情况, {type:1, sso_user_id:teacherId}, null, "data", "jsfz");
    let tmtkqk = [
        {
            key: "校内（人次）",
            value: tmtkqkData.list.dailyCourseNum
        }
    ];
    ret["tmtkqk"] = { title: "推门听课情况", dataList: tmtkqk };

    let rwtpkqkData = await getReqApiData(jshxNENUM.任务听评课情况, {type:1, sso_user_id:teacherId}, null, "data", "jsfz");
    // const regex = /应聘老师/;
    let rwtpkqk = [];
    if (rwtpkqkData) {
        let xwCount = rwtpkqkData.list.data.filter(post => post.ratee.includes("应聘老师")).length;
        let xwRate = ((xwCount / tmtkqkData.list.courseNum)*100).toFixed(2);
        let xnCount = tmtkqkData.list.courseNum - xwCount;
        let xnRate = ((xnCount / tmtkqkData.list.courseNum)*100).toFixed(2);
        rwtpkqk = [
            {
                key: "校内（人次）",
                value: xnCount,
                rate: `${xnRate}%`
            },
            {
                key: "校外（人次）",
                value: xwCount,
                rate: `${xwRate}%`
            },
        ];
    }
    
    ret["rwtpkqk"] = { title: "任务听评课情况", dataList: rwtpkqk };

    /**科研 */
    let kyCount = { "市级课题":0, "区级课题":0, "校本课题":0, "论文论著":0 };
    let kyTable = {
        titleList:["教师姓名", "课题级别", "课题名称", "课题开始时间"],
        dataList:[]
    };
    // let jyzktslData = await getReqApiData(jshxWENUM.市区校级课题, {type:1, sso_user_id:teacherId}, null, "data", "jsfz");
    let kyData = await getReqApiData(jshxWENUM.市区校级课题, {type:1, sso_user_id:teacherId}, null, "data", "jsfz");
    if (kyData.list) {
        kyData.list.data.forEach( info => {
            if (info.level == "国家级及以上") kyCount["论文论著"] += 1;
            if (info.level == "省/市级") kyCount["市级课题"] += 1;
            if (info.level == "区/县级") kyCount["区级课题"] += 1;
            if (info.level == "校级") kyCount["校本课题"] += 1;

            let kyTableData = [];
            for (let key in info) {
                kyTableData.push(info[key]);
            }
            kyTable.dataList.push(kyTableData);
        })
    }

    let ky = [];
    for (let key in kyCount) {
        ky.push({key, value:kyCount[key]});
    }
    ret["ky"] = {title:"科研(本学期)", dataList:ky};
    ret["kyxx"] = {title:"科研(本学期)表格", dataList:kyTable};

    /**教研 */
    let jyCount = { "市级课题":0, "区级课题":0, "校本课题":0, "论文论著":0 };
    let jyTable = {
        titleList:["课题名称", "课题开始时间", "教师姓名", "课题级别"],
        dataList:[]
    };
    let jyData = await getReqApiData(jshxWENUM.市区校级课题, {type:1, sso_user_id:teacherId}, null, "data", "jsfz");
    // let jyData = await getReqApiData(jshxWENUM.教研活动, {type:1}, null, "data", "jsfz");
    if (jyData.list) {
        jyData.list.data.forEach( info => {
            if (info.level == "国家级及以上") jyCount["论文论著"] += 1;
            if (info.level == "省/市级") jyCount["市级课题"] += 1;
            if (info.level == "区/县级") jyCount["区级课题"] += 1;
            if (info.level == "校级") jyCount["校本课题"] += 1;

            let jyTableData = [];
            for (let key in info) {
                jyTableData.push(info[key]);
            }
            jyTable.dataList.push(jyTableData);
        })
    }

    let jy = [];
    for (let key in jyCount) {
        jy.push({key, value:jyCount[key]});
    }
    ret["jy"] = {title:"科研(本学期)", dataList:ky};
    ret["jyxx"] = {title:"科研(本学期)表格", dataList:jyTable};

    let cycjtskc = excelData["参与创建特色课程"].dataList;
    ret["cycjtskc"] = {title:"参与&创建特色课程", dataList:cycjtskc};

    let cycjtskcxx = {
        titleList: excelData['参与创建特色课程详细'].headerList[0], 
        dataList: excelData['参与创建特色课程详细'].bodyList
    };
    ret["cycjtskcxx"] = {title:"参与&创建特色课程表格", dataList:cycjtskcxx};

    let jsyxxfhq = excelData["教师研修学分获取"].dataList;
    ret["jsyxxfhq"] = {title:"教师研修学分获取", dataList:jsyxxfhq};

    let jsyxxfhqxx = {
        titleList: excelData['教师研修学分获取详细'].headerList[0], 
        dataList: excelData['教师研修学分获取详细'].bodyList
    };
    ret["jsyxxfhqxx"] = {title:"教师研修学分获取表格", dataList:jsyxxfhqxx};
    
    let xfzb = excelData["学分"].dataList;
    ret["xfzb"] = {title:"学分占比", dataList:xfzb};

    let kczb = excelData["课程"].dataList;
    ret["kczb"] = {title:"课程占比", dataList:kczb};

    res.send(ret);
}