import * as request from 'request';
import { BizError } from './bizError';


export function get(url:string, query?, headers?) {
    if (!url || (url.search(/http:/) && url.search(/https:/)) ) throw new BizError(!url ? "请求地址为空" : "请求地址错误");
    return new Promise((resolve, reject)=>{
        let paramater:any = { url, json:true };
        if (query) paramater.qs = query;
        if (headers) paramater.headers = headers;
        request.get(paramater, function (err, r, body) {
            if (err) return reject(err);
            if (r && r.statusCode != 200) return reject(new Error('httpError:'+r.statusCode));
            resolve(body);
        });
    })
}


export function post(url, query, reqBody, headers) {
    if (!url || (url.search(/http:/) && url.search(/https:/)) ) throw new BizError(!url ? "请求地址为空" : "请求地址错误");
    let header = {"content-type": "application/json"};  
    return new Promise((resolve, reject)=>{
        request({
            url: url,
            method: "POST",
            json: true,
            headers: Object.assign(header, headers),
            body: reqBody,
            query:{}
        }, function(error, response, body) {
            if (!error && response.statusCode == 200) {
                resolve(body);
            }
            else {
                reject(error)
            }
        });
    })
}


export function postForm(url, query, body, headers) {
    if (!url || (url.search(/http:/) && url.search(/https:/)) ) throw new BizError(!url ? "请求地址为空" : "请求地址错误");
    let header = {"content-type": "application/json"};  
    return new Promise((resolve, reject)=>{
        request({
            url: url,
            method: "POST",
            json: true,
            headers: Object.assign(header, headers),
            body
        }, function(error, response, res) {
            if (!error) {
                resolve(res);
            }
            else {
                reject(error)
            }
        });
    })
}


















