
import { planarArrDecollateForIndex, planarArrDeconstruct, planarArrForObjectList } from "../../dataPackage/planaryArrayAnalysis";
import { onceSheetBecomeOfblockData } from "../../util/analysisExcel";

function packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList) {
    let result = {};

    for (let i = 0; i < blockDataList.length; i++) {
        let {blockData, blockTitle} = blockDataList[i];
        if (keyValueOrTitleList.indexOf(blockTitle) > -1) {
            let titleList = titltListConfig[blockTitle] || [];
            result[blockTitle] = planarArrForObjectList(blockData, 0, titleList);
        }
        else if (barChartList.indexOf(blockTitle) > -1) {
            result[blockTitle] = planarArrDeconstruct(blockData);
        }
        else if (stringList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrForObjectList(blockData);
        else if (decollatePlanarList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrDecollateForIndex(blockData);
    }

    return result;
}


export function tysjyTableData() {
    let blockDataList = onceSheetBecomeOfblockData('对外.xlsx', '统一数据源');

    let keyValueOrTitleList = ['教师人员']; //适配 饼图 键值以及需要多个Key的
    let barChartList = []; //适配 柱状图 折线图
    let stringList = [];
    let decollatePlanarList = []; //适配 表格
    let titleListConfig = {};

    let result = packageDataProcess(blockDataList, titleListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function ztbxTableData() {
    let blockDataList = onceSheetBecomeOfblockData('对外.xlsx', '整体办学');

    let keyValueOrTitleList = ['教师情况', '空间设施', '毕业生去向', '办学成果-学校', '办学成果趋势-学校', '九个一完成情况文本介绍', '校园活动']; //适配 饼图 键值以及需要多个Key的
    let barChartList = ['毕业生去向趋势图', '办学特色-科技素养', '办学特色-人文素养', '办学特色-艺术素养', '办学特色-健康素养']; //适配 柱状图 折线图
    let stringList = [];
    let decollatePlanarList = ["特色课程创新明细"]; //适配 表格
    let titleListConfig = {};

    let result = packageDataProcess(blockDataList, titleListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function jshxTableData() {
    let blockDataList = onceSheetBecomeOfblockData('对外.xlsx', '教师画像');

    let keyValueOrTitleList = ['校内导师', '基础数据', '学科导师占比', '大学与附校互聘共育', '参与创建教师数', '教师照片墙', '教师获奖', '项目化学习总数', '项目化学习']; //适配 饼图 键值以及需要多个Key的
    let barChartList = []; //适配 柱状图 折线图
    let stringList = [];
    let decollatePlanarList = ['班主任导师', '特色课程创建']; //适配 表格
    let titleListConfig = {};

    let result = packageDataProcess(blockDataList, titleListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function xshxTableData() {
    let blockDataList = onceSheetBecomeOfblockData('对外.xlsx', '学生画像');

    let keyValueOrTitleList = ['英才计划', '特色社团基础数据', '特色社团课程数', '健康素养', '科技素养', '艺术素养', '人文素养', '校园特色活动汇总', 
    '探究学习-基础数据', '探究学习-年级课题列表明细', '探究学习-各年级创新情况', '科学实验-基础数据', '科学实验-年级课题列表明细', '科学实验-各年级创新情况',
    '社会考究-基础数据', '社会考究-年级课题列表明细', '社会考究-各年级创新情况', '创新作品-基础数据', '创新作品-年级课题列表明细', '创新作品-各年级创新情况',
    '社会实践活动记录', '获奖成果展示']; //适配 饼图 键值以及需要多个Key的
    let barChartList = []; //适配 柱状图 折线图
    let stringList = [];
    let decollatePlanarList = ['学生干部小学部', '学生干部初中部', '学生会干部', '录取名单', '荣誉学生', '特色社团课程数表格', '热门社团TOP5', 
    '社会考察', '公益劳动', '职业体验', '安全实训', 
    '探究学习-年级课题列表明细弹窗', '科学实验-年级课题列表明细弹窗', '社会考究-年级课题列表明细弹窗', '创新作品-年级课题列表明细弹窗',]; //适配 表格
    let titleListConfig = {};

    let result = packageDataProcess(blockDataList, titleListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function xywhbsTableData() {
    let blockDataList = onceSheetBecomeOfblockData('对外.xlsx', '校园文化标识');

    let keyValueOrTitleList = ['校园新闻']; //适配 饼图 键值以及需要多个Key的
    let barChartList = []; //适配 柱状图 折线图
    let stringList = [];
    let decollatePlanarList = []; //适配 表格
    let titleListConfig = {};

    let result = packageDataProcess(blockDataList, titleListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function jyzjshxTableData(sheetName) {
    let blockDataList = onceSheetBecomeOfblockData('教研组教师信息.xlsx', sheetName);

    let keyValueOrTitleList = ['教师资源', '荣誉获得数', '教研活动', '教研活动详细', '满工作量的人数', '不满工作量的人数', '超工作量的人数', '听评课情况', '科研', '教研', 
    '参与创建特色课程', '学分', '教师研修学分获取', '教研组均分', '教学满意度反馈', '工作坊活动参与情况']; //适配 饼图 键值以及需要多个Key的
    let barChartList = []; //适配 柱状图 折线图
    let stringList = [];
    let decollatePlanarList = ['专业荣誉详细', '科研详细', '教研详细', '参与创建特色课程详细']; //适配 表格
    let titleListConfig = {};

    let result = packageDataProcess(blockDataList, titleListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function njzjshxTableData(sheetName) {
    let blockDataList = onceSheetBecomeOfblockData('年级组教师信息.xlsx', sheetName);

    let keyValueOrTitleList = ['教师资源']; //适配 饼图 键值以及需要多个Key的
    let barChartList = []; //适配 柱状图 折线图
    let stringList = [];
    let decollatePlanarList = []; //适配 表格
    let titleListConfig = {};

    let result = packageDataProcess(blockDataList, titleListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}

























