export enum ERRORENUM {
    未找到数据,
    数据操作失败,
    暂无对应数据,
    文件不存在,
    参数错误,
    地址数据不完整,
    请完善信息,
    接口数据获取失败,
    TOKEN获取失败,
    TOKEN更新失败
}


export enum SYSTEMERRORENUM {
    参数错误 = 1,
    请求参数错误,
    暂无对应数据,
    初始化配置失败
}


export enum INTERFACEERRORENUM {
    "系统错误" = 10001,
    "服务暂停" = 10002,
    "远程服务调用失败" = 10003,
    "IP地址受限，不能访问此接口" = 10004,
    "APP Key 不存在" = 10005,
    "签名错误" = 10006,
    "缺少 POST 参数" = 10007,
    "POST 参数错误" = 10008,
    "数据类别标识不存在" = 10009,
    "数据对象标识不存在" = 10010,
    "对数据对象没有写的权限" = 10011,
    "对数据对象没有读的权限" = 10012,
    "数据记录不存在" = 10013,
    "数据记录的 id 已存在" = 10014,
    "应用程序内部错误" = 10099,
}


let bizErrorMsgMap = {};
for (let key in ERRORENUM) {
    bizErrorMsgMap[ERRORENUM[key]] = key;
}

let systemErrorMsgMap = {};
for (let key in SYSTEMERRORENUM) {
    systemErrorMsgMap[SYSTEMERRORENUM[key]] = key;
}

export function getBizMsg(param) {
    return bizErrorMsgMap[param];
}

export function getSysMsg(param) {
    return systemErrorMsgMap[param];
}