/**
 * 学生成长档案弹窗
 */

import { getReqApiData } from "../../data/interface/url";
import { xsdaWENUM } from "../../config/interficeEnum";



export async function getData(req, res) {
    let ret:any = {};
    // let {studentId, grade} = req.body;
    let studentId = req.body.studentId || "733f97c4425a11ee98a202031519086a";
    // let grade = req.body.grade || "六年级下";
    let grade = req.body.grade || 6;

    //成长相册 todo
    // let czxcData = await getReqApiData(xsdaWENUM.学生照片, {studentId, gradeId:grade, type:2}); //type:类型（1：3D模型，2：照片）
    let czxcData = await getReqApiData(xsdaWENUM.学生照片, {studentId, grade, type:2}); //type:类型（1：3D模型，2：照片）
    ret["czxc"] = {title:"成长相册", dataList:czxcData || ""};
    
    //todo
    // let xssyData = await getReqApiData(xsdaWENUM.学生素养, {studentId, grade});
    let xssy = [
        {
            key:"科技素养",
            value:"70",
            rate:"16%"
        },
        {
            key:"艺术素养",
            value:"30",
            rate:"21%"
        },
        {
            key:"健康素养",
            value:"70",
            rate:"63%"
        },
        {
            key:"人文素养",
            value:"70",
            rate:"51%"
        },
    ];
    ret["xssy"] = {title:"学生素养", dataList:xssy};

    //todo
    let czjy = [
        {
            key:"老师成长寄语的原话",
            value:""
        }
    ];
    // let teacherMsg = await getReqApiData(xsdaWENUM.老师成长寄语, {studentId, grade});
    ret["czjy"] = {title:"成长寄语", dataList:czjy};

    let czjl = {
        sg:0,
        tz:0,
        BMI:"待评价",
        zuo:0,
        you:0
    };
    let tzjkData = await getReqApiData(xsdaWENUM.获取学生体质健康, {studentId, grade});
    if (tzjkData.length) {
        let item = tzjkData[0];
        czjl.sg = item.height || 0;
        czjl.tz = item.width || 0;
        czjl.BMI = item.bmi || "待评价";
    }
    let xsslData = await getReqApiData(xsdaWENUM.学生视力, {studentId, grade});
    if (xsslData.length) {
        let item = xsslData[0];
        czjl.zuo = item.nakedVisionLeft;
        czjl.you = item.nakedVisionRight;
    }
    ret["czjl"] = {title:"成长记录", dataList:czjl};

    // let sgczjlData = await getReqApiData(xsdaWENUM.身高成长记录, {studentId, grade});
    let sgczjl = [
        {
            key:"2021上", 
            value:120
        },
        {
            key:"2021下", 
            value:125
        },
        {
            key:"2022上", 
            value:133
        },
        {
            key:"2022下", 
            value:141
        },
        {
            key:"2023上", 
            value:150
        },
    ];
    ret["sgczjl"] = {title:"身高成长记录", dataList:sgczjl};

    // let tzczjlData = await getReqApiData(xsdaWENUM.体重成长记录, {studentId, grade});
    let tzczjl = [
		{
			key:"2021上",
			value:32.5,
			BMI:20.7
		},
		{
			key:"2021下",
			value:35.2,
			BMI:21.3
		},
        {
            key:"2022上", 
            value:133,
			BMI:21.3
        },
        {
            key:"2022下", 
            value:141,
			BMI:21.3
        },
        {
            key:"2023上", 
            value:150,
			BMI:21.3
        },
	];
    ret["tzczjl"] = {title:"体重成长记录", dataList:tzczjl};
    
    let sljlData = await getReqApiData(xsdaWENUM.视力记录, {studentId, grade});
    let sljl = [
        {
            key:"2021上", 
            value:5.2
        },
        {
            key:"2021下", 
            value:5.0
        },
        {
            key:"2022上", 
            value:5.0
        },
        {
            key:"2022下", 
            value:5.0
        },
        {
            key:"2023上", 
            value:4.9
        },
    ];
    ret["sljl"] = {title:"视力记录", dataList:sljl};

    let xkcjfbData = await getReqApiData(xsdaWENUM.学科成绩分布, {studentId, grade});
    let zhsp = [
        {
            key:"综合水平",
            value:"A"
        }
    ];
    ret["zhsp"] = {title:"综合水平", dataList:zhsp};
    let hqxsgkcj = await getReqApiData(xsdaWENUM.获取学生各科成绩, {studentId});
    let xkcjfb = [
		{
			"name":"语文",
			"dataList":[
				{
					"key":"2021上",
					"value":"91"
				},
				{
					"key":"2021下",
					"value":"89"
				},
			]
		},
		{
			"name":"数学",
			"dataList":[
				{
					"key":"2021上",
					"value":"91"
				},
				{
					"key":"2021下",
					"value":"89"
				},
			]
		},
		{
			"name":"英语",
			"dataList":[
				{
					"key":"2021上",
					"value":"91"
				},
				{
					"key":"2021下",
					"value":"89"
				},
			]
		},
	]
    ret["xkcjfb"] = {title:"学科成绩分布", dataList:xkcjfb};

    let cyzks = [
        {
            key:"参与总课时",
            value:124
        }
    ];
    ret["cyzks"] = {title:"参与总课时", dataList:cyzks};

    // let kccy = [
    //     {
    //         key:"拓展课参与课时",
    //         value:27,
    //         rate:"45%"
    //     },
    //     {
    //         key:"探究课参与课时",
    //         value:33,
    //         rate:"55%"
    //     },
    // ];
    // ret["kccy"] = {title:"课程参与", dataList:kccy};

    // let lscyksqs = [
    //     {
    //         key:"2021上", 
    //         value:120
    //     },
    //     {
    //         key:"2021下", 
    //         value:97
    //     },
    //     {
    //         key:"2022上", 
    //         value:151
    //     },
    //     {
    //         key:"2022下", 
    //         value:123
    //     },
    //     {
    //         key:"2023上", 
    //         value:150
    //     },
    // ];
    // ret["lscyksqs"] = {title:"历史参与课时趋势", dataList:lscyksqs};
    
    let kccyzks = [
        {
            key:"总课时",
            value:124
        }
    ];
    ret['kccyzks'] = {title:"课程参与总课时", dataList:kccyzks};

    let kccy = [
        {
            title:"拓展课课程",
            data:[
                {
                    key:"课程名称",
                    state:"已参与",
                    startTime:"2024.06.03 13:00:00",
                    name:"章老师"
                },
                {
                    key:"课程名称",
                    state:"未开始",
                    startTime:"2024.06.04 13:00:00",
                    name:"王老师"
                },
                {
                    key:"课程名称",
                    state:"已参与",
                    startTime:"2024.06.03 13:00:00",
                    name:"张老师"
                },
            ]
        },
        {
            title:"探究课课程",
            data:[
                {
                    key:"课程名称",
                    state:"已参与",
                    startTime:"2024.06.03 13:00:00",
                    name:"章老师"
                },
                {
                    key:"课程名称",
                    state:"已参与",
                    startTime:"2024.06.02 13:00:00",
                    name:"王老师"
                },
                {
                    key:"课程名称",
                    state:"未开始",
                    startTime:"2024.06.05 13:00:00",
                    name:"张老师"
                },
            ]
        },
        {
            title:"兴趣课课程",
            data:[
                {
                    key:"课程名称",
                    state:"已参与",
                    startTime:"2024.06.02 13:00:00",
                    name:"王老师"
                },
                {
                    key:"课程名称",
                    state:"已参与",
                    startTime:"2024.06.03 13:00:00",
                    name:"章老师"
                },
                {
                    key:"课程名称",
                    state:"未开始",
                    startTime:"2024.06.05 13:00:00",
                    name:"张老师"
                },
            ]
        }
    ];
    ret['kccy'] = {title:"课程参与", dataList:kccy};




// ------------------------------------------------------------------------------

    let jxtjData = await getReqApiData(xsdaWENUM.奖项统计, {pageNo:1, pageSize:100, gradeId:grade, studentId});
    let jxtjCount = {gjj:0, sj:0, qj:0, zj:0, xj:0};
    switch (jxtjData.list.awardLevel) {
        case "国家级":
            jxtjCount.gjj++;
        break;
        case "市级":
            jxtjCount.sj++;
        break;
        case "区级":
            jxtjCount.qj++;
        break;
        case "校级":
            jxtjCount.xj++;
        break;
    }
    let jxtj = [
        {
            key:"国家级奖项",
            value:jxtjCount.gjj
        },
        {
            key:"市级奖项",
            value:jxtjCount.sj
        },
        {
            key:"区级奖项",
            value:jxtjCount.qj
        },
        {
            key:"校级奖项",
            value:jxtjCount.xj
        },
    ]
    ret["jxtj"] = {title:"奖项统计", dataList:jxtj};






// ----------------------------------------------------------------------------------





    
    let hjcgData = await getReqApiData(xsdaWENUM.奖项统计, {studentId, pageNo:1, pageSize:100});
    // let hjcg = {
    //     gjj:[],
    //     sj:[],
    //     qj:[],
    //     xj:[]
    // };
    
    //调试数据
    let hjcg = {
        gjj:[],
        sj:[],
        qj:[],
        xj:[
            {
                time:"2023/11/4",
                name:"第五届秋季运动会六年级组男子组4分钟跳绳比赛第一"
            },
            {
                time:"2023/10/13",
                name:"第五届秋季运动会六年级男子组跳远比赛第二名"
            },
            {
                time:"2023/10/1",
                name:"9月月度之星"
            },
        ]
    };

    if (hjcgData.length) {
        hjcgData.forEach( info => {
            let {awardLevel, awardTime, awardName} = info;
            switch (awardLevel) {
                case "国家级":
                    hjcg.gjj.push({
                        time:awardTime,
                        name:awardName
                    })
                break;
                case "市级":
                    hjcg.sj.push({
                        time:awardTime,
                        name:awardName
                    })
                break;
                case "区级":
                    hjcg.qj.push({
                        time:awardTime,
                        name:awardName
                    })
                break;
                case "校级":
                    hjcg.xj.push({
                        time:awardTime,
                        name:awardName
                    })
                break;
            }
        })
    }
    
    let hjcgList = [
        {
            key:"国家级",
            value:hjcg.gjj
        },
        {
            key:"市级",
            value:hjcg.sj
        },
        {
            key:"区级",
            value:hjcg.qj
        },
        {
            key:"校级",
            value:hjcg.xj
        },
    ]
    ret["hjcg"] = {title:"获奖成果", dataList:hjcgList};


    let czzj = [
		{
			time:"2023-08-29",
			img:"http://******.jpg",
			name:"参与军训",
			evaluate:"表现优秀"
		},
		{
			time:"2023-09-01",
			img:"http://******.jpg",
			name:"英语学科《黑布林英语名著》读书小报",
			evaluate:"表现优秀"
		},
	];
    ret["czzj"] = {title:"成长足迹", dataList:czzj};

    res.send(ret);
}

















