/**
 * 教师画像（对外）
 */

import { jshxWENUM } from "../../config/interficeEnum";
import { getReqApiData } from "../../data/interface/url";
import { getKeyValue, readFileList } from "../outData";
import { jshxTableData, jyzjshxTableData, tysjyTableData, ztbxTableData } from "../../data/table/duiwai";
import { keyValuePackage, tablePackage } from "../../dataPackage/inFrontOut";

const ImgUrl = "img/对外/教师画像/";


export async function getData(req, res) {
    let ret:any = {};
    let excelData = jshxTableData();
    let 统一excelData = tysjyTableData();

    const NowTime = new Date();
    
    // let jszyData = await getReqApiData(jshxWENUM.教师资源, {}); //todo

    //教师人数和教辅人员改为excel表格数据
    let jszy = [];
    统一excelData["教师人员"].dataList.forEach(info => {
        if (info.key == "教师人数") jszy.push(info);
    })
    jszy.push({ key:"教师资源达标率", value:"-"});
    let jszyData = keyValuePackage(jszy);
    ret["jszy"] = {title:"教师资源", dataList:jszyData};

    let nlfbData = await getReqApiData(jshxWENUM.年龄分布, {type:"age"});
    let nlfb = getKeyValue(nlfbData);
    ret["nlfb"] = {title:"年龄分布", dataList:nlfb};

    let zzmmData = await getReqApiData(jshxWENUM.教师政治面貌, {type:"political"});
    let zzmm = getKeyValue(zzmmData);
    ret["zzmm"] = {title:"政治面貌", dataList:zzmm};

    // let jyzdjData = await getReqApiData(jshxWENUM.教研组搭建, {}); //todo
    let jyzjsConf = ["语文", "数学", "英语", "综理", "综文", "体育", "艺术"];
    let jyzdj = [];
    for(let i = 0; i < jyzjsConf.length; i++) {
        let jyzExcelData = jyzjshxTableData(`${jyzjsConf[i]}组`);
        let jszyTableData = jyzExcelData["教师资源"].dataList;
        jyzdj.push({key:jyzjsConf[i], value:jszyTableData.length})
    }
    ret["jyzdj"] = {title:"教研组搭建", dataList:jyzdj};

    // let zzgcData = await getReqApiData(jshxWENUM.组织构成, {}); //todo
    // let zzgc = [
    //     {
    //         key:"组长",
    //         value:30
    //     },
    //     {
    //         key:"副组长",
    //         value:30
    //     },
    //     {
    //         key:"组员",
    //         value:40
    //     },
    // ]
    // ret["zzgc"] = {title:"组织构成", dataList:zzgc};

    // let jymbData = await getReqApiData(jshxWENUM.教研目标, {}); //todo
    // let jymb = [
    //     {
    //         key:"目标1",
    //         value: 13,
    //         rate: "56%"
    //     },
    //     {
    //         key:"目标2",
    //         value: 19,
    //         rate: "26%"
    //     },
    //     {
    //         key:"目标3",
    //         value: 3,
    //         rate: "11%"
    //     },
    //     {
    //         key:"目标4",
    //         value: 13,
    //         rate: "56%"
    //     },
    //     {
    //         key:"目标5",
    //         value: 8,
    //         rate: "3%"
    //     },
    //     {
    //         key:"目标6",
    //         value: 21,
    //         rate: "21%"
    //     },
    //     {
    //         key:"目标7",
    //         value: 13,
    //         rate: "56%"
    //     },
    // ]
    // ret["jymb"] = {title:"教研目标", dataList:jymb};


    let dssl = keyValuePackage(excelData["校内导师"].dataList);
    ret["dssl"] = {title:"导师数量", dataList:dssl};

    let yxbzr = tablePackage(excelData["班主任导师"].headerList[0], excelData["班主任导师"].bodyList);
    ret['yxbzr'] = {title: '班主任导师', dataList: yxbzr};

    let xkdszb = keyValuePackage(excelData["学科导师占比"].dataList);
    ret["xkdszb"] = {title:"学科导师占比", dataList:xkdszb};

    let jcsj = keyValuePackage(excelData["基础数据"].dataList);
    ret["jcsj"] = {title:"基础数据", dataList:jcsj};

    // let jszpq = keyValuePackage(excelData["教师照片墙"].dataList);

    let jszpq = readFileList(`img/对外/教师照片/`, [], "png");   
    ret["jszpq"] = {title:"教师照片墙", dataList:jszpq};
    

    // let jxtjData = await getReqApiData(jshxWENUM.奖项统计, {pageNo:1, pageSize:100});
    let jxtjData = await getReqApiData(jshxWENUM.获奖情况, {type:1}, null, "data", "jsfz");
    // let jxtjCount = {gjj:0, sj:0, qj:0, xj:0};
    let jxtjDataList = {gjj:[], sj:[], qj:[], xj:[]};
    if (jxtjData) {
        jxtjData.list.data.forEach( info => {
            //todo 对应标准发给我之后修改
            if (info.level == "国家级及以上") jxtjDataList.gjj.push(info);
            if (info.level == "省/市级") jxtjDataList.sj.push(info);
            if (info.level == "区/县级") jxtjDataList.qj.push(info);
            if (info.level == "校级") jxtjDataList.xj.push(info);
        })

    }
    
    let jxtj = [
        {
            key:"国家级奖项",
            value:jxtjDataList.gjj.length || 0
        },
        {
            key:"市级奖项",
            value:jxtjDataList.sj.length || 0
        },
        {
            key:"区级奖项",
            value:jxtjDataList.qj.length || 0
        },
        {
            key:"校级奖项",
            value:jxtjDataList.xj.length || 0
        },
    ]
    ret["jxtj"] = {title:"奖项统计", dataList:jxtj};

    
    let cycjjss = keyValuePackage(excelData["参与创建教师数"].dataList);
    ret["cycjjss"] = {title:"参与创建教师数", dataList:cycjjss};

    let dxyfxhpgy = keyValuePackage(excelData["大学与附校互聘共育"].dataList);
    ret["dxyfxhpgy"] = {title:"大学与附校互聘共育", dataList:dxyfxhpgy};

    let tskccj = tablePackage(excelData["特色课程创建"].headerList[0], excelData["特色课程创建"].bodyList);
    let tskccjData = [];
    tskccj.dataList.forEach( info => {
        let item = [];
        for(let key in info) {
            item.push(info[key]);
        }
        tskccjData.push(item);
    })

    let tskccjDataList = {
        titleList:tskccj.titleList,
        dataList:tskccjData
    }
    ret["tskccj"] = {title:"特色课程创建", dataList:tskccjDataList};

    //todo
    let xmzs = excelData["项目化学习总数"].dataList;
    ret["xmzs"] = {title:"项目总数", dataList:xmzs};

    let xmhxx = excelData["项目化学习"].dataList;
    ret["xmhxx"] = {title:"项目化学习", dataList:xmhxx};

    // let zyfzcgData = await getReqApiData(jshxWENUM.专业发展成果, {}); //todo 
    let zyfzcgData = await getReqApiData(jshxWENUM.专业发展成果, {type:1}, null, "data", "jsfz");
    let lwfb = [
        {
            key:"论文论著发表",
            value:zyfzcgData.list.treatiseNum || 0
        }
    ];
    ret["zyfzcg"] = {title:"论文发表", dataList:lwfb};

    let lwfbImg = readFileList(`${ImgUrl}论文发表图片/`, [], "png");
    ret["lwfbImg"] = {title:"论文发表图片", dataList:lwfbImg};

    // let jyhj = keyValuePackage(excelData["教师获奖"].dataList);
    let jyhj = [
        {
            key:"指导学生获奖",
            value:zyfzcgData.list.studentNum || 0
        },
        {
            key:"教学评优",
            value:zyfzcgData.list.teachNum || 0
        },
        {
            key:"课题获奖",
            value:zyfzcgData.list.subjectNum || 0
        },
        {
            key:"论文获奖",
            value:zyfzcgData.list.thesisNum || 0
        },
    ]
    ret["jyhj"] = {title:"教研获奖", dataList:jyhj};

    // let cyzcgjpxData = await getReqApiData(jshxWENUM.参与主持人各级培训, {}); //todo
    let cyzcgjpxData = await getReqApiData(jshxWENUM.参与主持各级培训, {type:1}, null, "data", "jsfz");
    let pxcs = [
        {
            key:"培训次数",
            value:0
        }
    ];
    let cyzcgjpx = {
        titleList:["培训时间", "参与人数", "任务名称", "培训人", "培训类型"],
        dataList:[]
    };

    if (cyzcgjpxData) {
        pxcs[0].value = cyzcgjpxData.list.total;

        cyzcgjpxData.list.data.forEach( info => {
            let jyzkt = [];
            for (let key in info) {
                jyzkt.push(info[key]);
            }
            cyzcgjpx.dataList.push(jyzkt);
        })
    }

    ret["pxcs"] = {title:"培训次数", dataList:pxcs};
    ret["cyzcgjpx"] = {title:"参与&主持各级培训", dataList:cyzcgjpx};

    // let hdlxcyqxfxData = await getReqApiData(jshxWENUM.活动类型参与趋势分析, {}); //todo
    let hdlxcyqxfx = [
        {
            key:"2021下",
            xn:70,
            xw:106
        },
        {
            key:"2022上",
            xn:170,
            xw:163
        },
        {
            key:"2022下",
            xn:120,
            xw:97
        },
        {
            key:"2023上",
            xn:70,
            xw:106
        },
        {
            key:"2023下",
            xn:170,
            xw:163
        },
        {
            key:"2024上",
            xn:137,
            xw:63
        },
    ];
    ret["hdlxcyqxfx"] = {title:"活动类型参与趋势分析", dataList:hdlxcyqxfx};

    let lnqsdb = ["2020", "2021", "2021", "2022", "2023", "2024"];
    let lnqsdbData = [];
    for( let i = 0; i < lnqsdb.length; i++) {
        let kyqkData = await getReqApiData(jshxWENUM.参与科研情况, {type:lnqsdb[i]}, null, "data", "jsfz");
        let count = 0;
        if (kyqkData) {
            for (let key in kyqkData.list) {
                for (let info in kyqkData.list[key]) {
                    let {num, name} = kyqkData.list[key][info];
                    count += num;
                };
                
            }
        }
        lnqsdbData.push({key:lnqsdb[i], value:count});
    }
    ret["lnqsdb"] = {title:"历年获奖趋势对比", dataList:lnqsdbData};

    res.send(ret);
}


/**
 * 跨学科教学
 * 弃用
 * @param req time 时间段（近一周、近一月、近三月）
 * @param res 
 */
export async function getKxkjx(req, res) {
    let time = req.body.time || "近一周";
    let ret:any = {};
    
    // let kxkjxData = await getReqApiData(jshxWENUM.跨学科教学, {time}); //todo 参数：时间段【近一周、近一月、近三月】
    let kxkjxjcsj = [
        {
            key:"参与教师数",
            value:0
        },
        {
            key:"项目数",
            value:0
        }
    ] 
    let kxkjx = [
        {
            name:"项目名称1",
            rate:45,
            startTime:"2024.04.25"
        },
        {
            name:"项目名称2",
            rate:45,
            startTime:"2024.04.25"
        },
        {
            name:"项目名称3",
            rate:45,
            startTime:"2024.04.25"
        },
    ]
    ret["kxkjxjcsj"] = {title:"跨学科教学基础数据", dataList:kxkjxjcsj};
    ret["kxkjx"] = {title:"跨学科教学项目列表", dataList:kxkjx};

    res.send(ret);
}



/**
 * 教学教研 / 参与&科研情况
 * @param req year：年份
 * @param res 
 */
export async function getKyqk(req, res) {
    let year = req.body.year;
    let ret:any = {};
    
    // let kyqkData = await getReqApiData(jshxWENUM.科研情况, {year}); //todo 参数 年份：2023
    
    let kyqk = []

    let kyqkData = await getReqApiData(jshxWENUM.参与科研情况, {type:year}, null, "data", "jsfz");
    if (kyqkData) {
        for (let key in kyqkData.list) {
            let count = 0;
            for (let info in kyqkData.list[key]) {
                let {num, name} = kyqkData.list[key][info];
                count += num;
            };
            
            let dataList = []
            for (let info in kyqkData.list[key]) {
                let {num, name} = kyqkData.list[key][info];
                let rate = 0;
                if (num != 0) rate = Math.round(num/count*100);
                dataList.push({name, rate:`${rate}%`, value:num});
            };
            
            if (key == "openClass") {
                kyqk.push({
                    key:"公开课",
                    dataList
                })
            } else if (key == "achievement") {
                kyqk.push({
                    key:"成果发表",
                    dataList
                })
            } else if (key == "lecture") {
                kyqk.push({
                    key:"讲座及报告（专家级）",
                    dataList
                })
            };
        }

    }

    ret["kyqk"] = {title:"教学教研", dataList:kyqk};

    res.send(ret);
}


/**
 * 市区校级课题
 * @param req 
 * @param res 
 */
export async function getSqxjkt(req, res) {
    // let subject = req.body.subject || "语文"; //去掉下拉选择，课题数据没有这个字段
    let ret:any = {};
    
    let jyzkt = [
        {
            key:"课题数量",
            value: 0
        }
    ];
    

    let jyzktTable = {
        titleList:["课题名称", "课题开始时间", "教师姓名", "课题级别"],
        dataList:[]
    };

    let jyzktslData = await getReqApiData(jshxWENUM.市区校级课题, {type:1}, null, "data", "jsfz");
    if (jyzktslData.list) {
        jyzkt[0].value = jyzktslData.list.total;

        jyzktslData.list.data.forEach( info => {
            let jyzkt = [];
            for (let key in info) {
                jyzkt.push(info[key]);
            }
            jyzktTable.dataList.push(jyzkt);
        })
    }

    ret["jyzktsl"] = {title:"课题数量", dataList:jyzkt};
    ret["sqxjkt"] = {title:"市区校级课题", dataList:jyzktTable};
    
    res.send(ret);
}




