/**
 * 整体办学（对内）
 */

import { ztbxNENUM } from "../../config/interficeEnum";
import { getReqApiData } from "../../data/interface/url";
import moment = require("moment");
import { xxzdhdTableData, ztbxTableData } from "../../data/table/duinei";
import { tysjyTableData } from "../../data/table/duiwai";
import { get } from "../../util/request";

const ImgUrl = "img/对内/整体办学/";

export async function getData(req, res) {
    let ret:any = {};

    const NowTime = new Date();
    let excelData = ztbxTableData();
    let 统一excelData = tysjyTableData();
    
    let tqxxData:any = await get(`https://wis.qq.com/weather/common?source=pc&weather_type=observe|forecast_1h|forecast_24h|index|alarm|limit|tips|rise&province=上海&city=上海&county=浦东新区`, {}, {});
    let tqxx = {
      img:"",
      wendu: "",
      fengxiang: "",
      fengsu: "",
      wrcd: "中度污染",
      wrzb: 160,
      jkts: "儿童、老年人呼吸系统疾病患者避免高强度的户外锻炼，一般人群减少户外运动。"
    };
    if (tqxxData.data.observe) {
      let observe = tqxxData.data.observe;
      if (observe.weather_url) tqxx.img = observe.weather_url;
      if (observe.degree) tqxx.wendu = observe.degree + "℃";
      if (observe.wind_direction_name) tqxx.fengxiang = observe.wind_direction_name;
      if (observe.wind_power) tqxx.fengsu = "风力等级" + observe.wind_power;
    }
    if (tqxxData.data.index.airconditioner) {
      let airconditioner = tqxxData.data.index.airconditioner;
      if (airconditioner.detail) tqxx.jkts = airconditioner.detail;
    }
    ret["tqxx"] = {title:"天气预报&空气质量", dataList:tqxx};

    //今日出勤-学生=================
    let xsbjData = await getReqApiData(ztbxNENUM.学生人数班级数量, {})
    let bjsl = xsbjData.classNum;
    let xsrsData = xsbjData.studentNum;
    let xsrs = 0;
    if (xsrsData) {
      xsrsData.forEach( info=> {
        let {code, name, value} = info;
        xsrs += value;
      })
    }

    let startTime = moment(NowTime).format("YYYY-MM-DD 00:00:00");
    let endTime = moment(NowTime).format("YYYY-MM-DD 23:59:59");
    // {startDate:startTime, endDate:endTime}
    // let xscqData = await getReqApiData(ztbxNENUM.学生请假统计, {}, "POST");
    let xscqData事假 = await getReqApiData(ztbxNENUM.学生病假人数趋势, {type:1, beginDate:startTime, endDate:endTime});
    let xscqData病假 = await getReqApiData(ztbxNENUM.学生病假人数趋势, {type:2, beginDate:startTime, endDate:endTime});
    let xscqData其他 = await getReqApiData(ztbxNENUM.学生病假人数趋势, {type:3, beginDate:startTime, endDate:endTime});

    let qjrs = parseInt(xscqData事假.data.list[0].num) + parseInt(xscqData病假.data.list[0].num) + parseInt(xscqData其他.data.list[0].num);
    let xscql = 0;
    if (xsrs && qjrs) xscql = Math.floor((xsrs - qjrs) / xsrs * 100) / 100;
    let jrcq = {
      应到总人数:xsrs,
      请假人数:qjrs,
      出勤率:xscql,
    };
    ret["jrcq"] = {title:"今日出勤", dataList:jrcq};

    let qjqk = [
      {
        key:"事假",
        value:xscqData事假.data.list[0].num
      },
      {
        key:"病假",
        value:xscqData病假.data.list[0].num
      },
      {
        key:"其他",
        value:xscqData其他.data.list[0].num
      },
    ];
    ret["qjqk"] = {title:"请假情况", dataList:qjqk};

    let startOfWeek = moment().subtract(7, 'days').format("YYYY-MM");
    let weekDay = moment().subtract(7, 'days').format("DD");
    let endOfWeek = moment(NowTime).format("YYYY-MM-DD");
    let bjrsqs = [];
    for(let i = 1; i < 7; i++) {
      let thisStart = parseInt(weekDay) + i;
      let thisStartWeek = `${startOfWeek}-${thisStart} 00:00:00`;
      let thisEndWeek = `${startOfWeek}-${thisStart} 23:59:59`;
      let xsbjrsqsData = await getReqApiData(ztbxNENUM.学生病假人数趋势, {beginDate:thisStartWeek, endDate:thisEndWeek}, "GET", "data");
      bjrsqs.push({key:`${startOfWeek}-${thisStart}`, value:xsbjrsqsData.list[0].num})
    }

    // let bjrsqs = [
    //   { 
    //     key:"2024-4-15",
    //     value:30
    //   },
    //   {
    //     key:"2024-4-16",
    //     value:30
    //   },
    //   {
    //     key:"2024-4-17",
    //     value:30
    //   },
    //   {
    //     key:"2024-4-18",
    //     value:30
    //   },
    //   {
    //     key:"2024-4-19",
    //     value:30
    //   },
    // ];
    ret["bjrsqs"] = {title:"病假人数趋势", dataList:bjrsqs};

  
    //教师=================
    let kqCount = await getReqApiData(ztbxNENUM.参加考勤人员名单, {}, "GET", "data");
    let jsjrcqData = await getReqApiData(ztbxNENUM.教师当天请假人数, {type:1});
    let cql = "0";
    cql = (((parseInt(kqCount.count) - parseInt(jsjrcqData[0].value)) / parseInt(kqCount.count)) * 100).toFixed(2)//实到人数/应到人数
    let jsjrcq = {
      应到总人数:parseInt(kqCount.count),
      请假人数:parseInt(jsjrcqData[0].value),
      出勤率:`${cql}%`,
    };
    ret["jsjrcq"] = {title:"今日出勤_教师", dataList:jsjrcq};

    let jsqjqk = [
      {
        key:"感冒",
        value:"5"
      },
      {
        key:"流行病",
        value:"17"
      },
      {
        key:"事假",
        value:"3"
      },
    ];
    ret["jsqjqk"] = {title:"请假情况_教师", dataList:jsqjqk};

    let jsbjrsqsData = await getReqApiData(ztbxNENUM.教师病假人数趋势, {beginDate:startOfWeek, endDate:endOfWeek});
    let jsbjrsInfo = {};
    jsbjrsqsData.forEach( info => {
      let sj = moment(info.name).format("YYYY-MM-DD");
      if (!jsbjrsInfo[sj]) jsbjrsInfo[sj] = 0;
      jsbjrsInfo[sj] += parseInt(info.value);
    })

    let jsbjrsqs = [];
    for (let key in jsbjrsInfo) {
      jsbjrsqs.push({key, value:jsbjrsInfo[key]});
    }
    
    // let jsbjrsqs = [
    //   {
    //     key:"2024-4-15",
    //     value:30
    //   },
    //   {
    //     key:"2024-4-16",
    //     value:30
    //   },
    //   {
    //     key:"2024-4-17",
    //     value:30
    //   },
    //   {
    //     key:"2024-4-18",
    //     value:30
    //   },
    //   {
    //     key:"2024-4-19",
    //     value:30
    //   },
    // ];
    ret["jsbjrsqs"] = {title:"病假人数趋势", dataList:jsbjrsqs};

    //食堂&饮水安全
    let stjc = excelData['食堂检测'].dataList;
    ret["stjc"] = {title:"食堂检测", dataList:stjc};

    let mrspTime = moment(NowTime).format("YYYY-MM-DD");
    // 小学每日食谱
    let mrspQuery = {date_str:mrspTime, typeid:4};
    let xxmrsp = await getReqApiData(ztbxNENUM.每日食谱, mrspQuery, "GET", "data");
    let xx = [];
    if (xxmrsp) xx = getMrsp(xxmrsp.list);
    // 初中每日食谱
    let czmrsp = [];
    let czamrspQuery = {date_str:mrspTime, typeid:11};
    let czamrsp = await getReqApiData(ztbxNENUM.每日食谱, czamrspQuery, "GET", "data");
    let cza = [];
    if (czamrsp) cza = getMrsp(czamrsp.list);
    // cza = getMrsp(czamrsp.list);
    czmrsp = cza;
    // 初中B每日食谱
    // let czbmrspQuery = {date_str:mrspTime, typeid:8};
    // let czbmrsp = await getReqApiData(ztbxNENUM.每日食谱, czbmrspQuery, "GET", "data");
    // let czb = [];
    // if (czbmrsp) czb = getMrsp(czbmrsp.list);
    // czb.forEach( info => {
    //   czmrsp.push(info);
    // })
    // 住宿生每日食谱
    let zssmrspQuery = {date_str:mrspTime, typeid:10};
    let zssmrsp = await getReqApiData(ztbxNENUM.每日食谱, zssmrspQuery, "GET", "data");
    let zss = []
    if (zssmrsp) zss = getMrsp(zssmrsp.list);
    let mrsp = {
      "小学午餐":xx,
      "初中午餐":czmrsp,
      "住宿生晚餐":zss,
    };
    ret["mrsp"] = {title:"每日食谱", dataList:mrsp};

    let sthj = excelData['食堂其他信息'].dataList;
    ret["sthj"] = {title:"食堂环境", dataList:sthj};

    let startOfYys = moment().subtract(1, 'days').format("YYYY-MM-DD HH:mm:ss");
    let endOfYys = moment(NowTime).format("YYYY-MM-DD HH:mm:ss");
    let yysQuery = {samplingDate:startOfYys, samplingDateEnd:endOfYys}
    let yysjcData = await getReqApiData(ztbxNENUM.水质检测, {}, "GET", "list");

    let yysjcjcrq = [
      {
        key:"检测日期",
        value:moment(yysjcData[0].samplingDate).format("YYYY-MM-DD HH:mm:ss")
      }
    ];
    ret["yysjcjcrq"] = {title:"饮用水检测日期", dataList:yysjcjcrq};

    let yysjc = [
      {
        key:"总大肠菌群100ml",
        value:yysjcData[0].mpnResName
      },
      {
        key:"菌落总数100ml",
        value:yysjcData[0].cfuResName
      },
    ];
    ret["yysjc"] = {title:"饮用水检测", dataList:yysjc};

    let baseDate = [
        {
            key:"学生人数",
            value: xsrs
        },
        {
            key:"班级数量",
            value: parseInt(bjsl)
        }
    ]

    统一excelData["教师人员"].dataList.forEach(info => {
      baseDate.push(info);
    })
    ret["jcsj"] = {title:"基础数据", dataList:baseDate};

    let fxgj = [
      {
        key:"告警数量",
        value:10
      },
    ];
    ret["fxgj"] = {title:"风险告警", dataList:fxgj};

    let gjsl = [
      {
        key:"高",
        value:12
      },
      {
        key:"中",
        value:31
      },
      {
        key:"低",
        value:54
      }
    ];
    ret["gjsl"] = {title:"告警数量", dataList:gjsl};

    let gjlx = [
      {
        key:"类型一",
        value:25
      },
      {
        key:"类型二",
        value:25
      },
      {
        key:"类型三",
        value:25
      },
      {
        key:"类型四",
        value:25
      },
    ];
    ret["gjlx"] = {title:"告警类型", dataList:gjlx};

    let czqk = [
      {
        key:"已处置",
        value:5
      },
      {
        key:"待处置",
        value:8
      },
      {
        key:"处置中",
        value:6
      },
    ];
    ret["czqk"] = {title:"处置情况", dataList:czqk};

    let ryllData = await getReqApiData(ztbxNENUM.智慧安防出入人数, {startDate:startTime, endDate:endTime, pageSize:100, pageNum:1});
    let ryllCount = 0;
    let crrs = {chu:0, ru:0};
    if (ryllData) {
        if (ryllData.list.length > 0) {
            let zhafry = ryllData.list;
            ryllCount = zhafry.length;
            zhafry.forEach( info => {
                let enterOrExit = info.enterOrExit; //0:出、1:入
                if (enterOrExit == 0) crrs.chu += enterOrExit;
                else crrs.ru += enterOrExit;
            })
        }
    }

    let ryld = [
        {
            key:"人员总流量",
            value:ryllCount || 0 //todo
        },
        {
            key:"入",
            value:crrs.ru || 0 //todo
        },
        {
            key:"出",
            value:crrs.chu || 0 //todo
        },
    ];
    ret["ryld"] = {title:"人员流动", dataList:ryld};

    let jcmd = {
        titleList: ["姓名", "联系电话", "类型", "原因"],
        dataList:[
            ["-", "-", "-", "-"],
            ["-", "-", "-", "-"],
            ["-", "-", "-", "-"],
            ["-", "-", "-", "-"],
        ]
    }
    ret["jcmd"] = {title:"进出名单", dataList:jcmd};

    let jxcg = excelData["教学常规"].dataList;
    ret["jxcg"] = {title:"教学常规", dataList:jxcg};

    // todo 改为接调代课接口
    let cdlx = excelData["迟到类型"].dataList;
    let xsbjrsData = await getReqApiData(ztbxNENUM.调代课记录, {startDate:startTime, endDate:endTime});
    
    ret["cdlx"] = {title:"迟到类型", dataList:cdlx};

    let zypgqk =  excelData["作业批改情况"].dataList;
    ret["zypgqk"] = {title:"作业批改情况", dataList:zypgqk};

    // let grbzrc = [
    //   {
    //     key:"个人本周日常",
    //     value:10
    //   }
    // ];
    // ret["grbzrc"] = {title:"个人本周日常", dataList:grbzrc};

    // let xxgzapExcel = xxgzapTableData()
    // let xxgzap = [];
    // for (let key in xxgzapExcel) {
    //   let content = [];
    //   xxgzapExcel[key].dataList.forEach( info => {
    //     let {dz, hdms, jssj, kssj} = info;
    //     content.push({
    //       data:kssj,
    //       pop: { txt:hdms, time:`${kssj}-${jssj}`, add:dz}
    //     });
    //   })
    //   xxgzap.push({label:key, content});
    // }

    let weekStart = moment().startOf('week').format('YYYY-MM-DD');
    let weekEnd = moment().endOf('week').format('YYYY-MM-DD');
    let rcxx = await getReqApiData(ztbxNENUM.日程信息, {startTime:weekStart, endTime:weekEnd, calendarType:"CALENDAR_TYPE1"});
    let rcapConfig = {
      0:"七",
      1:"一",
      2:"二",
      3:"三",
      4:"四",
      5:"五",
      6:"六"
    };
    let rcapData = {};
    rcxx.forEach( info => {
      let {startTime, endTime, calendarContent, address} = info;
        let days = new Date(startTime).getDay();
        for (let key in rcapConfig) {
          if (!rcapData[rcapConfig[key]]) rcapData[rcapConfig[key]] = [];
        }
        rcapData[rcapConfig[days]].push({
          data:startTime, 
          pop:{
            txt:calendarContent, 
            time:`${startTime} - ${endTime}`, 
            add:address
          }
        });
    })

    let rcap = [];
    let rcapSort = ["一", "二", "三", "四", "五", "六", "七"];
    rcapSort.forEach( key => {
      rcap.push({label:key, content:rcapData[key]});
    })
    
    ret["xxgzap"] = {title:"学校工作安排", dataList:rcap, count:rcxx.length};

    let xxzdhdExcel = xxzdhdTableData()
    let xxzdhd = [];
    for (let key in xxzdhdExcel) {
      let content = [];
      xxzdhdExcel[key].dataList.forEach( info => {
        let {dz, hdms, jssj, kssj} = info;
        content.push({
          data:kssj,
          pop: { txt:hdms, time:`${kssj}-${jssj}`, add:dz}
        });
      })
      xxzdhd.push({label:key, content});
    }
    ret["xxzdhd"] = {title:"学校重大活动", dataList:xxzdhd, count:0};

    res.send(ret);
}


/**
 * 课程安排
 */
export async function getKcap(req, res) {
    let grade = req.body.grade || "一年级"; //【一年级：1、二年级：2、三年级：3、四年级：4】
    let className = req.body.className || "1班";
    let ret:any = {};

    const NowTime = new Date();
    let startDate = moment(NowTime).format("YYYY-MM-DD 00:00:00");
    let endDate = moment(NowTime).format("YYYY-MM-DD HH:mm:ss");
    let kbap = await getReqApiData(ztbxNENUM.课表安排, {startDate, endDate})
    
    let kcapData = {};
    kbap.data.list.forEach( info => {
      let class_name = "其他";
      if (info.class_name) class_name = info.class_name;
      if(!kcapData[class_name]) kcapData[class_name] = [];
      kcapData[class_name].push({key:info.section_name, value:info.subject_name});
    })

    let kcap = kcapData[`${grade}${className}`];
    ret["kcap"] = {title:"课程安排", dataList:kcap};
  
    res.send(ret);
}


/**课程安排下拉选择年级班级（根据年级选择班级） */
export async function getClass(req, res) {
    let ret:any = {};

    // let classData = await postReqApiData(ztbxNENUM.获取班级列表信息, {});
    let classData = {
      一年级:["1班", "2班", "3班", "4班", "5班"],
      二年级:["1班", "2班", "3班", "4班", "5班"],
      三年级:["1班", "2班", "3班", "4班", "5班", "6班"],
      四年级:["1班", "2班", "3班", "4班", "5班", "6班"],
      五年级:["1班", "2班", "3班", "4班", "5班", "6班"],
      六年级:["1班", "2班", "3班", "4班", "5班"],
      七年级:["1班", "2班", "3班", "4班"],
      八年级:["1班", "2班", "3班"],
      九年级:["1班", "2班", "3班", "4班", "5班"],
      高中一年级:["1班"],
      高中二年级:["1班"]
    };

    ret["kcapxl"] = {title:"课程安排下拉", dataList:classData};
  
    res.send(ret);
}




/**
 * 获取最大数
 * @param obj 
 * @returns 
 */
function getObjectMaxValue(obj) {
    let maxValue = -Infinity;
    for (let key in obj) {
        let num = parseFloat(obj[key]);
      if (obj.hasOwnProperty(key) && typeof num === 'number' && num > maxValue) {
        maxValue = num;
      }
    }
    return maxValue === -Infinity ? null : maxValue;
}


/**
 * 获取每日食谱的所有菜品
 * @param data 
 * @returns 
 */
function getMrsp(data) {
  let result = [];
  data.forEach( info => {
    result.push(info.food_name);
  })

  return result;
}



