/**
 * 学生画像个人
 */

import moment = require("moment");
import { GRADEENUM } from "../../config/enum";
import { xshxgrWENUM } from "../../config/interficeEnum";
import { getReqApiData, postReqApiData } from "../../data/interface/url";
import { xshxgrTableData, xycjTableData } from "../../data/table/duinei";
import { changeEnumValue } from "../../tools/eccEnum";


export async function getData(req, res) {
    let ret:any = {};
    // let studentId = req.body.studentId || "bdbb8be6417e11ee9ec102031519086a";
    // let studentId = req.body.studentId || "4ff589fcc6c411edb04a0203151c9658";
    // let studentId = req.body.studentId || "080c0e005eca11ef8f7a0a96d1b50e8f";
    // let studentId = req.body.studentId || '1d0308e4c6c411edb04a0203151c9658';
    let studentId = req.body.studentId || '23f5aa9ec6c411edb04a0203151c9658';
    
    let excelData = xshxgrTableData();
    let cjExcelData = xycjTableData();

    let name = "";
    let gradeClass = "";

    let schoolId = "559254528fc7421d9a4e25aaa1caaad3";
    let classId = "";

    let baseData = await getReqApiData(xshxgrWENUM.获取学生列表, {studentId});
    let imgData = await getReqApiData(xshxgrWENUM.学生照片, {studentId, type:2}); //type:类型（1：3D模型，2：照片）
    let stuInfo = await getReqApiData(xshxgrWENUM.获取学生成长档案个人信息, {studentId}, null, "data", "platform");
    let tzjkData = await getReqApiData(xshxgrWENUM.获取学生体质健康, {studentId});
    // let stuPersonality = await getReqApiData(xshxgrWENUM.获取学生个人特长, {studentId});
    
    /** 中间基础数据------------------------------------------------------------------- */
    let base = {
        img: imgData.url || "", //学生照片
        name:"", //姓名
        className:"", //班级
        nation:"", //民族
        studentId:"", //学籍号
        height:"", //身高
        weight:"", //体重
        dateOfBirth:"", //出生日期
        // politicalOutlook:"", //政治面貌

    };

    if (baseData) {
        if (baseData.length) {
            let item = baseData[0] || {};
            name = item.studentName;
            gradeClass = item.className;
            // schoolId = item.schoolId;
            classId = item.classId;
            base.name = item.studentName || '';
            base.className = item.className || '';
            base.studentId = item.studentSort || '';
        }
    }

    if (tzjkData.length) {
        let item = tzjkData[0];
        base.weight = item.weight || '';
        base.height = item.height || '';
    }

    if (stuInfo) {
        let stuBaseInfo = stuInfo.baseInfo || null;
        if (stuBaseInfo) {
            base.dateOfBirth = moment(stuBaseInfo.birthday).format("YYYY-MM-DD");
            base.nation = stuBaseInfo.nation;
        }
    }
    ret["jcsj"] = {title:"学生基础数据", dataList:base};

    let growthProfile = {
        xjgw : [], //校级岗位
        bjgw : [], //班级岗位
        xxjl : [],
        wdxq : "",
        zym : "",
        zwpj : "",
    };
    let growthProfileData = await getReqApiData(xshxgrWENUM.获取学生个人特长, {studentId});
    if (growthProfileData) {
        if (growthProfileData.list) {
            if (growthProfileData.list.length != 0) {
                // growthProfile.xxjl = [{time:"2015.09-2018.07", value:"上海交通大学闵行幼儿园"}]; // todo 学习经历
                growthProfile.wdxq = growthProfileData.list[0].hobby || "";
                growthProfile.zym = growthProfileData.list[0].motto || "";
                growthProfile.zwpj = growthProfileData.list[0].evaluation || "";
            }
        } 
    }
    
    //todo
    let sxgw = {
        reflection: "" //随想感悟
    };

    if (stuInfo) {
        let stuBaseInfo = stuInfo.baseInfo || null; //学生基础信息
        if (stuBaseInfo) {
            growthProfile.xjgw.push(stuBaseInfo.schoolPosition);
            growthProfile.bjgw.push(stuBaseInfo.classPosition);
            // growthProfile.zwpj = stuBaseInfo.selfAssessment;
            sxgw.reflection = stuBaseInfo.selfAssessment;
        }
        let stuXxjl = stuInfo.studyExperienceList || null; //学生学习经历
        if (stuXxjl) {
            stuXxjl.forEach( info => {
                let expTimeStart = moment(info.expTimeStart).format("YYYY-MM-DD");
                let expTimeEnd = moment(info.expTimeEnd).format("YYYY-MM-DD");
                growthProfile.xxjl.push({time:`${expTimeStart}-${expTimeEnd}`, value:info.schoolName});
            })
        }
    }
    ret["jcxx"] = {title:"基础信息", dataList:growthProfile};


    /**身心健康 -------------------------------------------------------------------------- */
    let sxjk = {
        zjyctj:"",
        yctz:"无", //异常体质
        jwbs:"无", //既往病史
    };
    let gmqkData = await getReqApiData(xshxgrWENUM.学生过敏情况, {studentId});
    if(gmqkData.length) {
        let item = gmqkData[0];
        sxjk.jwbs = item.allergy || '无';
    };
    let tytzData = await getReqApiData(xshxgrWENUM.获取学生特异体质, {studentId});
    if(tytzData.length) {
        let item = tytzData[0];
        sxjk.yctz = item.atopy || '无';
    };
    ret["sxjk"] = {title:"身心健康", dataList:sxjk};

    /**身心健康-体质监测 */
    let tzjc = {
        sg:0,
        tz:0,
        BMI:"待评价",
        BMIChart:[]
    };
    if (tzjkData.length) {
        let item = tzjkData[0];
        tzjc.sg = item.height || 0;
        tzjc.tz = item.weight || 0;
        tzjc.BMI = item.bmi || "待评价";
    }

    let BIMData = await getReqApiData(xshxgrWENUM.学生BMI趋势, {studentId});
    if(BIMData) {
        BIMData.forEach(info => {
            let {name, value} = info;
            tzjc.BMIChart.push({key:name, value});
        });
    }
    ret["tzjc"] = {title:"体质监测", dataList:tzjc};
   
    /**身心健康-视力监测 */
    let sljc = {
        zy:"",
        yy:"",
        slChart:[]
    };
    let sljcData = await getReqApiData(xshxgrWENUM.学生视力, {studentId});
    if (sljcData.length) {
        let item = sljcData[0];
        sljc.zy = item.nakedVisionLeft;
        sljc.yy = item.nakedVisionRight;
    }
    sljcData.forEach(info => {
        let {studentInfo, nakedVisionLeft, nakedVisionRight} = info;
        sljc.slChart.push({ key:studentInfo.gradeName, left:nakedVisionLeft, right:nakedVisionRight})
    })
    ret["sljc"] = {title:"视力监测", dataList:sljc};

    /**社会实践活动情况 */
    let shsjhdqkData = await getReqApiData(xshxgrWENUM.社会实践活动情况, {studentId}); //todo
    let shsjhdqk = [
        {
            name:"社会考察",
            wcks:8,
            zks:8
        },
        {
            name:"公益劳动",
            wcks:2,
            zks:2
        },
        {
            name:"职业体验",
            wcks:2,
            zks:2
        },
        {
            name:"安全实训",
            wcks:0,
            zks:0
        },
    ];
    ret["shsjhdqk"] = {title:"社会实践活动情况", dataList:shsjhdqk};

    /**团队德育活动 */
    // let cyksData = await getReqApiData(xshxgrWENUM.团队德育活动, {studentId}) //todo
    let cyks = [
        {
            key:"参与课时",
            value:0
        }
    ];
    ret["cyks"] = {title:"参与课时", dataList:cyks};

    // let tddyhdData = await getReqApiData(xshxgrWENUM.团队德育活动, {studentId}) //todo
    let tddyhd = [
        {
            key:"仪式活动",
            value:0
        },
        {
            key:"主题教育",
            value:0
        }
    ];
    ret["tddyhd"] = {title:"团队德育活动", dataList:tddyhd};

    /**综合评价（统计等第） */
    // let zhpjData = await getReqApiData(xshxgrWENUM.获取学生成绩综合信息, {studentId, type:"综合面试"}); //todo
    let zhpj = [
        {
            key:"学习态度",
            value:"待评价",
            rate:0
        },
        {
            key:"作业完成情况",
            value:"待评价",
            rate:0
        },
        {
            key:"课堂表现",
            value:"待评价",
            rate:0
        },
        {
            key:"日常行规",
            value:"待评价",
            rate:0
        }
    ];
    ret["zhpj"] = {title:"综合评价", dataList:zhpj};

    /**修业课程与学业成绩 */
    let xycjzfData = await getReqApiData(xshxgrWENUM.获取学生各科成绩, {studentId}); //todo
    let xycjzData = cjExcelData["学业成绩"].dataList;
    let stuXycjData = {};
    xycjzData.forEach(info => {
        for (let key in info) {
            if (typeof info[key] === 'string') info[key] = info[key].trim();
        }
        let {xq, xm, njbj, ywqz, sxqz, yyqz, qzzf, ywqm, sxqm, yyqm, dfqm, wlqm, hxqm, swqm, lsqm, dlqm, zzqm, qmzf, xqzhmscj, yyky, tyqm} = info;
        // let trimXm = xm.trim();
        // let trimNjbj = njbj.trim();
        stuXycjData[`${xm}_${njbj}`] = info;
    })
    let thisStuXycj = stuXycjData[`${name}_${gradeClass}`];
    if (!thisStuXycj) {
        thisStuXycj = {
            xq: "-",
            xm: "- ",
            njbj: "- ",
            ywqz: "-",
            sxqz: "-",
            yyqz: "-",
            qzzf: "-",
            ywqm: "-",
            sxqm: "-",
            yyqm: "-",
            dfqm: "-",
            wlqm: "-",
            hxqm: "-",
            swqm: "-",
            lsqm: "-",
            dlqm: "-",
            zzqm: "-",
            qmzf: "-",
            xqzhmscj: "-",
            yyky: "-",
            tyqm: "-",
          }
    }
    let xycjzf = [
        {
            key:"期中总分",
            value:thisStuXycj.qzzf
        },
        {
            key:"期末总分",
            value:thisStuXycj.qmzf
        }
    ];
    ret["xycjzf"] = {title:"修业课程与学业成绩", dataList:xycjzf};

    let gkcjData = await getReqApiData(xshxgrWENUM.获取学生各科成绩, {studentId});
    let gkcjMap = {};
    if (gkcjData.length) {
        gkcjData[0].score.forEach( info => {
            gkcjMap[info.subject] = {qz:info.score4, qm:info.score5};
        })
    }
    
    let gkcj = [];
    let xkConf = {"yw":"语文", "sx":"数学", "yy":"英语", "df":"道法", "wl":"物理", "hx":"化学", "sw":"生物", "ls":"历史", "dl":"地理", "zz":"政治", "ty":"体育"};
    for (let key in xkConf) {
        if (gkcjMap[xkConf[key]] && Object.keys(gkcjMap[xkConf[key]]).length) {
            gkcj.push({key:xkConf[key], midTerm:gkcjMap[xkConf[key]].qz, endTerm:gkcjMap[xkConf[key]].qm});
        } else {
            gkcj.push({key:xkConf[key], midTerm:'0', endTerm:'0'});
        }
        // let qm = `${key}qm`;
        // let qz = `${key}qz`;
        // let xkqm = thisStuXycj[qm] || "-";
        // let xkqz = thisStuXycj[qz] || "-";
        // gkcj.push({key:xkConf[key], midTerm:xkqz, endTerm:xkqm});
    }
    
    ret["gkcj"] = {title:"各科成绩", dataList:gkcj};
    
    // let xqzhmscjData = await getReqApiData(xshxgrWENUM.获取学生成绩综合信息, {studentId, type:"综合面试"}); //todo
    let xqzhmscj = [
        {
            key:"学期综合面试成绩",
            value:thisStuXycj.xqzhmscj
        }
    ];
    ret["xqzhmscj"] = {title:"学期综合面试成绩", dataList:xqzhmscj};

    /**科技素养课程、人文素养课程、艺术素养课程、健康素养课程 */
    let kjsy = getXykc(excelData["科技素养"].dataList, studentId, "xsid");
    let rwsy = getXykc(excelData["人文素养"].dataList, studentId, "xsid");
    let yssy = getXykc(excelData["艺术素养"].dataList, studentId, "xsid");
    let jksy = getXykc(excelData["健康素养"].dataList, studentId, "xsid");

    let xykc = [
        {title:"科技素养课程", count:kjsy.count, dataList:kjsy.data},
        {title:"人文素养课程", count:rwsy.count, dataList:rwsy.data},
        {title:"艺术素养课程", count:yssy.count, dataList:yssy.data},
        {title:"健康素养课程", count:jksy.count, dataList:jksy.data}
    ]
    ret["xykc"] = {title:"修业课程", dataList:xykc};
    
    let wcqkData = await getReqApiData(xshxgrWENUM.九加一完成情况, {studentId});
    
    let wcqk = [];
    for(let key in wcqkData) {
        let value = parseFloat(wcqkData[key]) || 0;
        wcqk.push({key, value});
    }

    ret["wcqk"] = {title:"九+一完成情况", dataList:wcqk};

    // let xssyData = await getReqApiData(xshxgrWENUM.学生素养, {studentId}); //todo
    let xssy = [
        {
            key:"科技素养",
            value:"0%"
        },
        {
            key:"艺术素养",
            value:"0%"
        },
        {
            key:"健康素养",
            value:"0%"
        },
        {
            key:"人文素养",
            value:"0%"
        },
    ];
    ret["xssy"] = {title:"学生素养", dataList:xssy};

    // let xydtData = getReqApiData(xshxgrWENUM.学业动态, {studentId}); // todo
    // let xydt = {
    //     rcdp:12,
    //     dataList:[
    //         {
    //             key:"思想品德",
    //             value:14,
    //             rate:"45%"
    //         },
    //         {
    //             key:"学业水平",
    //             value:4,
    //             rate:"15%"
    //         },
    //         {
    //             key:"社会实践",
    //             value:12,
    //             rate:"60%"
    //         },
    //     ]
    // };
    // ret["dtxy"] = {title:"动态-学业", dataList:xydt};

    // let jkdtData = getReqApiData(xshxgrWENUM.健康动态, {studentId}); // todo
    // let jkdt = {
    //     rcdp:12,
    //     dataList:[
    //         {
    //             key:"身体健康",
    //             value:14,
    //             rate:"45%"
    //         },
    //         {
    //             key:"学业水平",
    //             value:4,
    //             rate:"15%"
    //         },
    //         {
    //             key:"社会实践",
    //             value:12,
    //             rate:"60%"
    //         },
    //     ]
    // }; 
    // ret["dtjk"] = {title:"动态-健康", dataList:jkdt};

    /**todo 接口接入方式不一致，最后修改 */
    let dtData = await postReqApiData(xshxgrWENUM.学生日常行为规范, {personId:studentId, schoolId, classId, platformCode:"999999"});
    let dt = [
        {
            key:"思想品德",
            value:0
        },
        {
            key:"学业水平",
            value:0
        },
        {
            key:"艺术素养",
            value:0
        },
        {
            key:"身心健康",
            value:0
        },
        {
            key:"社会实践",
            value:0
        }
    ];
    ret["dt"] = {title:"动态", rcdp:12, dataList:dt};

    //todo
    let czjy = {
        teacher: "", //老师成长寄语
        parents: "", //家长成长寄语
    };
    // let teacherMsg = await getReqApiData(xshxgrWENUM.老师成长寄语, {studentId});
    // let parentsMsg = await getReqApiData(xshxgrWENUM.家长成长寄语, {studentId});
    ret["czjy"] = {title:"成长寄语", dataList:czjy}; 
    ret["sxgw"] = {title:"随想感悟", dataList:sxgw};

    //todo
    // let cxjsysjnlData = await getReqApiData(xshxgrWENUM.创新精神与实践能力, {studentId});
    let cxjsysjnl = [
        {
            key:"个人完成",
            value:0,
            rate:"0"
        },
        {
            key:"合作完成",
            value:0,
            rate:"0"
        }
    ];
    ret["cxjsysjnl"] = {title:"创新精神与实践能力", dataList:cxjsysjnl};

    let cxjsysjnlData = await getReqApiData(xshxgrWENUM.创新精神与实践能力, {studentId, pageNo:1, pageSize:100});
    let cxjsysjnlChart = {
        titleList:[
            "时间", "类型", "课题名称", "指导老师", "是否跨学科"
        ],
        dataList:[
            // [
            //     "2024-01-26",
            //     "探究学习报告",
            //     "*********",
            //     "李**",
            //     "是"
            // ],
        ]
    };
    ret["cxjsysjnlxxsj"] = {title:"创新精神与实践能力表格", dataList:cxjsysjnlChart};

    //调试数据
    let hjcg = {
        gjj:[],
        sj:[],
        qj:[],
        xj:[
            // {
            //     time:"2023/11/4",
            //     name:"第五届秋季运动会六年级组男子组4分钟跳绳比赛第一"
            // },
            // {
            //     time:"2023/10/13",
            //     name:"第五届秋季运动会六年级男子组跳远比赛第二名"
            // },
            // {
            //     time:"2023/10/1",
            //     name:"9月月度之星"
            // },
        ]
    };

    let hjcgData = stuInfo.honorList;
    if (hjcgData.length) {
        hjcgData.forEach( info => {
            // let {awardLevel, awardTime, awardName} = info;
            let {level, levelName, title, honorTime} = info;
            let hjcjTime = moment(honorTime).format("YYYY-MM-DD");
            switch (levelName) {
                // case 1:
                case "国家级":
                    hjcg.gjj.push({
                        time:hjcjTime,
                        name:title
                    })
                break;
                // case 3:
                case "市级":
                    hjcg.sj.push({
                        time:hjcjTime,
                        name:title
                    })
                break;
                // case 4:
                case "区级":
                    hjcg.qj.push({
                        time:hjcjTime,
                        name:title
                    })
                break;
                // case 5:
                case "校级":
                    hjcg.xj.push({
                        time:hjcjTime,
                        name:title
                    })
                break;
            }
        })
    }
    
    let hjcgList = [
        {
            key:"国家级",
            value:hjcg.gjj
        },
        {
            key:"市级",
            value:hjcg.sj
        },
        {
            key:"区级",
            value:hjcg.qj
        },
        {
            key:"校级",
            value:hjcg.xj
        },
    ]
    ret["hjcg"] = {title:"获奖成果", dataList:hjcgList};

    //todo
    let gjglhdcyData = await getReqApiData(xshxgrWENUM.各级各类活动参加, {studentId, pageNo:1, pageSize:100});
    let gjglhdcyCount = [
		{
			"key":"科技",
			"value":3
		},
		{
			"key":"人文",
			"value":6
		},
		{
			"key":"艺术",
			"value":3
		},
		{
			"key":"健康",
			"value":5
		},
	];
    ret["gjglhdcyCount"] = {title:"各级各类活动参与", dataList:gjglhdcyCount};

    let gjglhdcy = {
        "titleList":[
			"类型", "时间", "活动名称"
		],
		"dataList":[
			[
				"科技", //科技、人文、艺术、健康
				"2023/11/4",
				"中国科学院上海药物研究所研学活动",
			],
			[
				"人文",
				"2023/11/4",
				"中国科学院上海药物研究所研学活动",
            ],
			[
				"艺术",
				"2023/11/4",
				"中国科学院上海药物研究所研学活动",
            ],
			[
				"健康",
				"2023/11/4",
				"中国科学院上海药物研究所研学活动",
            ],
		]
    };
    ret["gjglhdcy"] = {title:"各级各类活动参与表格", dataList:gjglhdcy};

    let zpzs = [
        {
			"key":"活动瞬间",
			"value":"0"
		},
		{
			"key":"个人风采",
			"value":"0"
		}
    ];
    ret["zpzs"] = {title:"作品展示", dataList:zpzs};

    let zpzstp = [
        // {
		// 	"key":"活动瞬间",
		// 	"value":"http://*******.jpg"
		// },
		// {
		// 	"key":"个人风采",
		// 	"value":"http://*******.jpg"
		// },
        // {
		// 	"key":"科技活动",
		// 	"value":"http://*******.jpg"
		// },
		// {
		// 	"key":"个人风采",
		// 	"value":"http://*******.jpg"
		// },
    ];
    ret["zpzstp"] = {title:"作品展示图片", dataList:zpzstp};

    // todo
    let sjhdjl = {
        titleList:["时间", "实践主题", "场所", "课时"],
        dataList:[
            ["-", "-", "-", "-"]
            // ["2024-04-24", "这里是实践主题", "这里是场所", "18"],
        ]
    };
    ret["sjhdjl"] = {title:"实践活动记录", dataList:sjhdjl};

    res.send(ret);
}



/**
 * 获取学生列表
 * @param grade 年级id
 * @param classNum 班级 协定id 1就是1班
 * @param name 名称 模糊查询
 * @returns 
 */
 export async function selectStudentList( grade:number, classNum:number, name:string ) {
    let reqBody:any = {};
    if (grade) reqBody.gradeId = grade;
    if (classNum) reqBody.classNum = classNum;
    if (name) reqBody.studentName = name;
    let reqData:any = await getReqApiData(xshxgrWENUM.获取学生列表, reqBody, 'page');
    let dataList = [];

    if (reqData) {
        reqData.forEach(info => {
            let {studentId, studentName, className, gradeId, studentSort} = info;
            dataList.push({
                studentName,
                gradeName:changeEnumValue(GRADEENUM, parseInt(gradeId)),
                className,
                studentSort,
                studentId
            });
        });
    }
   
    
    return { dataList };
}


/**
 * 获取对应学生id的表格数据
 * @param oldConf 表格数据原本的key
 * @param newConf 需要修改成的中文key 
 * @param dataList 表格数据
 * @param name 匹配数据的参数
 * @param subName 参数匹配数据的字段key
 * @returns [{key:"", value:""}, {}]
 */
export function getOneChange(oldConf, newConf, dataList, name?, subName?){
    let reg = new RegExp(name);

    let data = [];
    dataList.forEach(info => {
        if (reg.test(info[subName])) {
            for(let i = 0; i < newConf.length; i++) {
                data.push({
                    key: newConf[i],
                    value: info[oldConf[i]] || ""
                })
            }
        }
    });

    return data;
}


/**
 * 修改统计修业课程
 * @param dataList 
 * @param name 
 * @param subName 
 * @returns 
 */
export function getXykc(dataList, name?, subName?){
    let reg = new RegExp(name);

    let data = [];
    let count = 0;
    dataList.forEach(info => {
        if (reg.test(info[subName])) {
            count += info.ks;
            data.push({
                key:info.kcmc || "待开发", 
                value:info.ks || ""
            });
        }
    });

    return {data, count};
}























