/**
 * 学生画像（对外）
 */

import { xshxWENUM } from "../../config/interficeEnum";
import { getReqApiData } from "../../data/interface/url";
import { xshxTableData } from "../../data/table/duiwai";
import { keyValuePackage, tablePackage } from "../../dataPackage/inFrontOut";
import { GRADEENUM } from "../../config/enum";
import { changeEnumValue } from "../../tools/eccEnum";
import { systemConfig } from "../../config/serverConfig";
import { xshxnjzTableData } from "../../data/table/duinei";

const Grade = {
    1:"一年级组",
    2:"二年级组",
    3:"三年级组",
    4:"四年级组",
    5:"五年级组",
    6:"六年级组",
    7:"七年级组",
    8:"八年级组",
    9:"九年级组",
    10:"高中组"
}

export async function getData(req, res) {
    let ret:any = {};
    let excelData = xshxTableData();

    let xsbjrsData = await getReqApiData(xshxWENUM.学校学生数班级数, {});
    let bjsl = xsbjrsData.classNum;
    let xsrsData = xsbjrsData.studentNum;
    
    let xsrs = 0;

    let nanshen = {
        key:"男生人数",
        value:0,
        rate:""
    };
    let nvshen = {
        key:"女生人数",
        value:0,
        rate:""
    };
    xsrsData.forEach( info=> {
        let {code, name, value} = info;
        xsrs += value;
        let codeToInt = parseInt(code);
        if (codeToInt == 0) {
            nvshen.value = value;
        } else {
            nanshen.value = value;
        }
    })

    let xsbjDate = [
        {
            key:"学校学生数",
            value: xsrs || 0
        },
        {
            key:"学校班级数",
            value: bjsl || 0
        }
    ]
    ret["xsbjrs"] = {title:"学校学生班级人数", dataList:xsbjDate};

    nanshen.rate = Math.round(nanshen.value/xsrs*100 ) + "%";
    nvshen.rate = Math.round(nvshen.value/xsrs*100 ) + "%";
    let nannvshen = [nanshen, nvshen];
    ret["xbrszb"] = {title:"男生人数女生人数", dataList:nannvshen};


    let gnjbjxsstjData = [];
    //获取1年级到6年级的数据
    for (let i = 1; i <= 9; i++) {
        /**各年级班级学生数统计 */
        let studentData = await getReqApiData(xshxWENUM.各年级班级学生数统计, {grade:i});
        let gradeData = {
            key:changeEnumValue(GRADEENUM, i),
            value:0 
        };
        studentData.studentNum.forEach( info => {
            gradeData.value += info.value;
        })
        gnjbjxsstjData.push(gradeData);
    }
    ret["gnjbjxsstj"] = {title:"各年级班级学生数统计", dataList:gnjbjxsstjData};


    let xsgbxxbData = tablePackage(excelData["学生干部小学部"].headerList[0], excelData["学生干部小学部"].bodyList);
    let xsgbxxb = {titleList:xsgbxxbData.titleList, dataList:[]};
    xsgbxxbData.dataList.forEach( info => {
        let {A, B, C} = info;
        let img = `${systemConfig.ipUrl}对外/学生画像/学生干部/${C}`;
        xsgbxxb.dataList.push({A, B, C:img});
    });

    ret['xsgbxxb'] = {title: '学生干部小学部', dataList: xsgbxxb};

    let xsgbczbData = tablePackage(excelData["学生干部初中部"].headerList[0], excelData["学生干部初中部"].bodyList);
    let xsgbczb = {titleList:xsgbczbData.titleList, dataList:[]};
    xsgbczbData.dataList.forEach( info => {
        let {A, B, C} = info;
        let img = `${systemConfig.ipUrl}对外/学生画像/学生干部/${C}`;
        xsgbczb.dataList.push({A, B, C:img});
    });
    ret['xsgbczb'] = {title: '学生干部初中部', dataList: xsgbczb};


    // let shsjbtlxkszbData = await getReqApiData(xshxWENUM.社会实践不同类型的课时占比, {}); //todo
    let shsjbtlxkszb = [
        {
            key:"课题1",
            value:69
        },
        {
            key:"课题2",
            value:12
        },
        {
            key:"课题3",
            value:19
        },
        {
            key:"课题4",
            value:37
        },
    ];
    let btnjkszb = [
        {
            key:"六年级",
            value:30,
            rate:"30%"
        },
        {
            key:"七年级",
            value:180,
            rate:"100%"
        },
        {
            key:"八年级",
            value:90,
            rate:"50%"
        },
        {
            key:"九年级",
            value:12,
            rate:"12%"
        },
    ];

    let xx = getPdfzgmsy(1, 7);
    let cz = getPdfzgmsy(7, 9);
    let gz = getPdfzgmsy(10, 11);
    let pdfzygmsy = {
        "小学":{
            shsjbtlxkszb:keyValuePackage(xx.shsjbtlxkszb),
            btnjkszb:xx.btnjkszb
        },
        "初中":{
            shsjbtlxkszb:keyValuePackage(cz.shsjbtlxkszb),
            btnjkszb:cz.btnjkszb
        },
        "高中":{
            shsjbtlxkszb:keyValuePackage(gz.shsjbtlxkszb),
            btnjkszb:gz.btnjkszb
        },
    };
    ret['pdfzygmsy'] = {title: '品德发展与公民素养', dataList: pdfzygmsy};

 
    // let jsrs = await getReqApiData(xshxWENUM.近视人数, {}) || 0; //todo
    let jsl = await getReqApiData(xshxWENUM.近视率, {}); //todo
    // let jstb = await getReqApiData(xshxWENUM.近视同比, {}); //todo
    let tytz = await getReqApiData(xshxWENUM.特异体质, {}); //todo
    // let tytztb = await getReqApiData(xshxWENUM.特异体质同比, {}); //todo

    let jstb:any = 0;
    if (jsl.length != 0) {
        let thisYear = jsl[jsl.length-1].value;
        let lastYear = jsl[jsl.length-2].value;
        jstb = ((thisYear - lastYear) / lastYear * 100 / 100).toFixed(2);
    }
    
    let sxjk = [
        {
            key:"近视率",
            value:`${jsl[jsl.length-1].value}%`,
            yoy:`${jstb}%`
        },
        {
            key:"特异体质",
            value:tytz.num,
            yoy:"0"
        }
    ];
    ret["sxjk"] = {title:"身心健康", dataList:sxjk};

    // let spjjslData = await getReqApiData(xshxWENUM.市平均近视率, {}); //todo
    let spjjsl = {
        key:"市平均近视率",
        value:"50%"
    }
    ret["spjjsl"] = {title:"市平均近视率", dataList:spjjsl};
    let gnjjslData = await getReqApiData(xshxWENUM.各年级近视率, {});
    let gnjjsl = [];
    gnjjslData.forEach( info=> {
        let {code, name, value} = info;
        gnjjsl.push({
            key:name,
            value
        });
    })
    ret["gnjjsl"] = {title:"各年级近视率", dataList:gnjjsl};

    // let gnjtytzData = await getReqApiData(xshxWENUM.各年级特异体质, {}); //todo 接口不对，必填参数学生id，我们需要的是汇总数据
    let gnjtytz = [
        {
            key:"一年级",
            value:"0"
        },
        {
            key:"二年级",
            value:"0"
        },
        {
            key:"三年级",
            value:"0"
        },
        {
            key:"四年级",
            value:"0"
        },
        {
            key:"五年级",
            value:"0"
        },
        {
            key:"六年级",
            value:"0"
        },
    ]
    ret["gnjtytz"] = {title:"各年级特异体质", dataList:gnjtytz};

    // let lnjrsbjsData = await getReqApiData(xshxWENUM.六年级人数, {grade:6});
    // let lnjrs = {
    //     key:"六年级人数",
    //     value:0
    // };
    // let bjs = {
    //     key:"班级数",
    //     value:lnjrsbjsData.classNum || 0
    // }
    // lnjrsbjsData.studentNum.forEach( info => {
    //     lnjrs.value += info.value;
    // })
    // let lnjrsbjs = [lnjrs, bjs];
    // ret["lnjrsbjs"] = {title:"六年级人数班级数", dataList:lnjrsbjs};


    let jxtjData = await getReqApiData(xshxWENUM.奖项统计, {pageNo:1, pageSize:100});
    let jxtjCount = {gjj:0, sj:0, qj:0, zj:0, xj:0};
    switch (jxtjData.list.awardLevel) {
        case "国家级":
            jxtjCount.gjj++;
        break;
        case "市级":
            jxtjCount.sj++;
        break;
        case "区级":
            jxtjCount.qj++;
        break;
        case "校级":
            jxtjCount.xj++;
        break;
    }
    let jxtj = [
        {
            key:"国家级奖项",
            value:jxtjCount.gjj
        },
        {
            key:"市级奖项",
            value:jxtjCount.sj
        },
        {
            key:"区级奖项",
            value:jxtjCount.qj
        },
        {
            key:"校级奖项",
            value:jxtjCount.xj
        },
    ]
    ret["jxtj"] = {title:"奖项统计", dataList:jxtj};

    
    // let xytshdData = await getReqApiData(xshxWENUM.校园特色活动, {}); //todo
    
    let xytshd = [
        { "key":"健康素养", "dataList": excelData["健康素养"].dataList },
        { "key":"科技素养", "dataList": excelData["科技素养"].dataList },
        { "key":"艺术素养", "dataList": excelData["艺术素养"].dataList },
        { "key":"人文素养", "dataList": excelData["人文素养"].dataList },
    ];
    ret["xytshd"] = {title:"校园特色活动", dataList:xytshd};

    // let xytshdhzData = await getReqApiData(xshxWENUM.校园特色活动汇总, {}); //todo
    let xytshdhz = excelData["校园特色活动汇总"].dataList; 
    ret["xytshdhz"] = {title:"校园特色活动汇总", dataList:xytshdhz};

    let xshgbData = tablePackage(excelData["学生会干部"].headerList[0], excelData["学生会干部"].bodyList);
    let xshgb = {titleList:xshgbData.titleList, dataList:[]};
    xshgbData.dataList.forEach( info => {
        let {A, B, C} = info;
        let img = `${systemConfig.ipUrl}对外/学生画像/学生会干部/${C}`;
        xshgb.dataList.push({A, B, C:img});
    });
    ret['xshgb'] = {title: '学生会干部', dataList: xshgb};

    let ycjh = keyValuePackage(excelData["英才计划"].dataList);
    ret["ycjh"] = {title:"英才计划", dataList:ycjh};

    let lqmd = tablePackage(excelData["录取名单"].headerList[0], excelData["录取名单"].bodyList);
    ret['lqmd'] = {title: '录取名单', dataList: lqmd};

    let ryxsData = tablePackage(excelData["荣誉学生"].headerList[0], excelData["荣誉学生"].bodyList);
    let ryxs = {titleList:ryxsData.titleList, dataList:[]};
    ryxsData.dataList.forEach( info => {
        let {A, B, C, D} = info;
        let img = `${systemConfig.ipUrl}对外/学生画像/荣誉学生/${A}`;
        ryxs.dataList.push({A:img, B, C, D});
    });
    ret['ryxs'] = {title: '荣誉学生', dataList: ryxs};

    let tsstjcsj = keyValuePackage(excelData["特色社团基础数据"].dataList);
    ret["tsstjcsj"] = {title:"特色社团基础数据", dataList:tsstjcsj};

    // let tsstzb = tablePackage(excelData["特色社团课程数"].headerList[0], excelData["特色社团课程数"].bodyList);
    let tsstzb = keyValuePackage(excelData["特色社团课程数"].dataList);
    ret['tsstzb'] = {title: '特色社团课程数', dataList: tsstzb};

    let rmstTOP5Data = tablePackage(excelData["热门社团TOP5"].headerList[0], excelData["热门社团TOP5"].bodyList);
    let rmstTOP5 = {titleList:rmstTOP5Data.titleList, dataList:[]};
    rmstTOP5Data.dataList.forEach( info => {
        let {A, B, C} = info;
        let img = `${systemConfig.ipUrl}对外/学生画像/热门社团/${C}`;
        rmstTOP5.dataList.push({A, B, C:img});
    });
    ret['rmstTOP5'] = {title: '热门社团TOP5', dataList: rmstTOP5};

    // let xktjhdData = await getReqApiData(xshxWENUM.学科探究活动, {}); //todo
    // let xmhtjhdData = await getReqApiData(xshxWENUM.项目化探究活动, {}); //todo
    // let kjsyNjktlbData = await getReqApiData(xshxWENUM.年级课题列表明细, {}); //todo
    // let kjsyGnjcxqkData = await getReqApiData(xshxWENUM.各年级创新情况, {}); //todo

    /**探究学习 */
    let kjsyJcsj = excelData["探究学习-基础数据"].dataList;
    ret["kjsyJcsj"] = {title:"探究学习-基础数据", dataList:kjsyJcsj};

    let kjsyNjktlb = keyValuePackage(excelData["探究学习-年级课题列表明细"].dataList);
    ret["kjsyNjktlb"] = {title:"探究学习-年级课题列表明细", dataList:kjsyNjktlb};
    
    let tjxxNjktlbTc = {
        titleList: excelData['探究学习-年级课题列表明细弹窗'].headerList[0], 
        dataList: excelData['探究学习-年级课题列表明细弹窗'].bodyList
    };
    ret["tjxxNjktlbTc"] = {title:"探究学习-年级课题列表明细弹窗", dataList:tjxxNjktlbTc};

    let kjsyGnjcxqk = excelData["探究学习-各年级创新情况"].dataList;
    ret["kjsyGnjcxqk"] = {title:"探究学习-各年级创新情况", dataList:kjsyGnjcxqk};

    /**科学实验 */
    let rwsyJcsj = excelData["科学实验-基础数据"].dataList;
    ret["rwsyJcsj"] = {title:"科学实验-基础数据", dataList:rwsyJcsj};

    let rwsyNjktlb = keyValuePackage(excelData["科学实验-年级课题列表明细"].dataList);
    ret["rwsyNjktlb"] = {title:"科学实验-年级课题列表明细", dataList:rwsyNjktlb};
    
    let kxsyNjktlbTc = {
        titleList: excelData['科学实验-年级课题列表明细弹窗'].headerList[0], 
        dataList: excelData['科学实验-年级课题列表明细弹窗'].bodyList
    };
    ret["kxsyNjktlbTc"] = {title:"科学实验-年级课题列表明细弹窗", dataList:kxsyNjktlbTc};

    let rwsyGnjcxqk = excelData["科学实验-各年级创新情况"].dataList;
    ret["rwsyGnjcxqk"] = {title:"科学实验-各年级创新情况", dataList:rwsyGnjcxqk};

    /**社会考察 */
    let yssyJcsj = excelData["社会考究-基础数据"].dataList;
    ret["yssyJcsj"] = {title:"社会考究-基础数据", dataList:yssyJcsj};

    let yssyNjktlb = keyValuePackage(excelData["社会考究-年级课题列表明细"].dataList);
    ret["yssyNjktlb"] = {title:"社会考究-年级课题列表明细", dataList:yssyNjktlb};
    
    let shkjNjktlbTc = {
        titleList: excelData['社会考究-年级课题列表明细弹窗'].headerList[0], 
        dataList: excelData['社会考究-年级课题列表明细弹窗'].bodyList
    };
    ret["shkjNjktlbTc"] = {title:"社会考究-年级课题列表明细弹窗", dataList:shkjNjktlbTc};

    let yssygnjcxqk = excelData["社会考究-各年级创新情况"].dataList;
    ret["yssyGnjcxqk"] = {title:"社会考究-各年级创新情况", dataList:yssygnjcxqk};

    /**创新作品 */
    let jksyJcsj = excelData["创新作品-基础数据"].dataList;
    ret["jksyJcsj"] = {title:"创新作品-基础数据", dataList:jksyJcsj};

    let jksyNjktlb = keyValuePackage(excelData["创新作品-年级课题列表明细"].dataList);
    ret["jksyNjktlb"] = {title:"创新作品-年级课题列表明细", dataList:jksyNjktlb};
    
    let cxzpNjktlbTc = {
        titleList: excelData['创新作品-年级课题列表明细弹窗'].headerList[0], 
        dataList: excelData['创新作品-年级课题列表明细弹窗'].bodyList
    };
    ret["cxzpNjktlbTc"] = {title:"创新作品-年级课题列表明细弹窗", dataList:cxzpNjktlbTc};

    let jksyGnjcxqk = excelData["创新作品-各年级创新情况"].dataList;
    ret["jksyGnjcxqk"] = {title:"创新作品-各年级创新情况", dataList:jksyGnjcxqk};


    // let shsjhdjlData = await getReqApiData(xshxWENUM.社会实践活动记录, {}); //todo
    let shsjhdjl = excelData["社会实践活动记录"].dataList;
    ret["shsjhdjl"] = {title:"社会实践活动记录", dataList:shsjhdjl};

    // let shkcData = await getReqApiData(xshxWENUM.社会考察, {}); //todo
    let shkc = {
        titleList:excelData["社会考察"].headerList[0],
        dataList:excelData["社会考察"].bodyList
    };
    ret["shkc"] = {title:"社会考察", dataList:shkc};

    // let gyldData = await getReqApiData(xshxWENUM.公益劳动, {}); //todo
    let gyld = {
        titleList:excelData["公益劳动"].headerList[0],
        dataList:excelData["公益劳动"].bodyList
    };
    ret["gyld"] = {title:"公益劳动", dataList:gyld};

    // let zytyData = await getReqApiData(xshxWENUM.职业体验, {}); //todo
    let zyty = {
        titleList:excelData["职业体验"].headerList[0],
        dataList:excelData["职业体验"].bodyList
    };
    ret["zyty"] = {title:"职业体检", dataList:zyty};

    // let aqsxData = await getReqApiData(xshxWENUM.安全实训, {}); //todo
    let aqsx = {
        titleList:excelData["安全实训"].headerList[0],
        dataList:excelData["安全实训"].bodyList
    };
    ret["aqsx"] = {title:"安全实训", dataList:aqsx};

    // let hjcgzsData = await getReqApiData(xshxWENUM.获奖成果展示, {}); //todo
    let hjcgzsData = excelData["获奖成果展示"].dataList;
    let hjcgzs = [];
    hjcgzsData.forEach( info => {
        let {key, value} = info;
        hjcgzs.push({img:`${systemConfig.ipUrl}对外/学生画像/获奖成果展示/${key}`, name:value});
    });
    ret["hjcgzs"] = {title:"获奖成果展示", dataList:hjcgzs};

    res.send(ret);
}


/**
 * 获取品德发展与公民素养
 */
function getPdfzgmsy(start, end) {
    let shsjbtlxkszb = [];
    let btnjkszb = [];
    let shsj = {};
    for(let i = start; i < end; i++) {
        let xsData = xshxnjzTableData(Grade[i]);
        let dataList = xsData["品德发展与公民素养"].dataList;
        let count = 0;
        let zksCount = 0;
        dataList.forEach( info => {
            let {name, wcks, zks} = info;
            if (!shsj[name]) shsj[name] = 0;
            shsj[name] += parseInt(wcks);
            count += parseInt(wcks);
            zksCount += parseInt(zks);
        })
        let rate = 0;
        if (count || zksCount) rate = count / zksCount;
        btnjkszb.push( {key:Grade[i], value:count, rate:`${rate}%`} );
    }

    for (let key in shsj) {
        shsjbtlxkszb.push({key, value:shsj[key]});
    }

    return {shsjbtlxkszb, btnjkszb}
}




