/**
 * 教师画像（对内）-身心健康
 */

import { sxjkWENUM } from "../../config/interficeEnum";
import { getReqApiData } from "../../data/interface/url";
import { getKeyValue, readFileList } from "../outData";
import { jshxTableData } from "../../data/table/duiwai";
import { keyValuePackage, tablePackage } from "../../dataPackage/inFrontOut";
import { systemConfig } from "../../config/serverConfig";

const ImgUrl = "img/对内/学生画像/身心健康/";

const GradeChange = {
    1:"一年级",
    2:"二年级",
    3:"三年级",
    4:"四年级",
    5:"五年级",
    6:"六年级",
    7:"七年级",
    8:"八年级",
    9:"九年级",
    10:"高中",
    // 10:"高一",
    // 11:"高二",
    // 12:"高三",
}


/**体质监测 */
export async function getTzjc(req, res) {
    let grade = req.body.grade || 1; //【一年级：1、二年级：2、三年级：3、四年级：4】
    let className = req.body.className || "一年级2班";
    let ret:any = {};

    let tzjc = [
        {
            key:"优良率",
            value:"0.0%"
        },
        {
            key:"合格率",
            value:"0.0%"
        }
    ];
    let tzjcData = await getReqApiData(sxjkWENUM.班级合格率优良率, {gradeId:grade, className});
	for (let key in tzjcData) {
		if (key == "classFine") {
			tzjc[0].value = tzjcData[key][className] + "%";
		}
		if (key == "classPass") {
			tzjc[1].value = tzjcData[key][className] + "%";
		}
	}
    ret["tzjc"] = {title:"体质监测", dataList:tzjc};

    // let BMIqs = {
    //     正常:[
    //         {
    //             key:"2023",
    //             value:80
    //         },
    //         {
    //             key:"2024",
    //             value:30
    //         },
    //     ],
    //     偏低:[
    //         {
    //             key:"2023",
    //             value:86
    //         },
    //         {
    //             key:"2024",
    //             value:12
    //         },
    //     ],
    //     偏高:[
    //         {
    //             key:"2023",
    //             value:30
    //         },
    //         {
    //             key:"2024",
    //             value:11
    //         },
    //     ],
    // };
    let BMIqs = [];
    let BMIqsData = await getReqApiData(sxjkWENUM.班级BMI趋势, {gradeId:grade, className});
    BMIqsData.forEach( info => {
        BMIqs.push( {key:info.name, value:info.value} );
    })
    ret["BMIqs"] = {title:"BMI趋势", dataList:BMIqs};

    let jcsjInfo = { "视力异常率":"0.0%", "体型异常(超重,肥胖)":0, "龋齿人数":0, "其他人数":0 };
    let classBmiData = await getReqApiData(sxjkWENUM.班级BMI趋势, {gradeId:grade, className});
    classBmiData.forEach( info => {
        if (info.name == "超重" || info.name == "肥胖") {
            jcsjInfo["体型异常(超重,肥胖)"] += info.value;
        }
    })
    let jcsjData = await getReqApiData(sxjkWENUM.视力分析, {gradeId:grade, className});
    jcsjData.forEach( info => {
        if (info.name == className) {
            jcsjInfo.视力异常率 = info.value + "%";
        }
    })

    let jcsj = [];
    for(let key in jcsjInfo) {
        jcsj.push( {key, value:jcsjInfo[key]} );
    }
    ret["jcsj"] = {title:"基础数据", dataList:jcsj};

    let tytz = [
        {
            key:"总人数",
            value:0
        }
    ];
    let tytzData = await getReqApiData(sxjkWENUM.特异体质总人数, {gradeId:grade, className}); //todo
    ret["tytz"] = {title:"特异体质", dataList:tytz};

    let tytzxx = {
        titleList:["姓名", "学号", "异常项"],
        dataList:[
            ["-", "-", "-"],
            ["-", "-", "-"],
            ["-", "-", "-"],
            ["-", "-", "-"],
            ["-", "-", "-"],
        ]
    };
    ret["tytzxx"] = {title:"特异体质表格", dataList:tytzxx};

    let gmda = [
        {
            key:"鸡蛋",
            value:0
        },
        {
            key:"牛奶",
            value:0
        },
        {
            key:"山药",
            value:0
        },
        {
            key:"咖喱",
            value:0
        },
        {
            key:"虾",
            value:0
        },
    ];
    let gmdaData = await getReqApiData(sxjkWENUM.特异体质总人数, {gradeId:grade, className}); //todo
    ret["gmda"] = {title:"过敏档案", dataList:gmda};

    res.send(ret);
}


/**学生出勤情况 */
export async function getXscqqk(req, res) {
    let grade = req.body.grade || 1; //【一年级：1、二年级：2、三年级：3、四年级：4】
    let className = req.body.className || "一年级2班";
    let ret:any = {};
    let classId = "";
    let classStr = `${GradeChange[grade]}${className}`;
    let classData = await getReqApiData(sxjkWENUM.获取班级信息, {className:classStr});

    let jcsj = [
        {
            key:"学生总数",
            value:21
        },
        {
            key:"请假人数",
            value:2
        }
    ];
    let jcsjData = await getReqApiData(sxjkWENUM.学生请假统计, {classId});
    ret["jcsj"] = {title:"基础数据", dataList:jcsj};

    let qjlb = {
        titleList:["姓名", "体温", "请假原因", "请假时长"],
        dataList:[
            ["-", "-", "-", "-"],
            ["-", "-", "-", "-"],
            ["-", "-", "-", "-"],
            ["-", "-", "-", "-"],
            ["-", "-", "-", "-"],
            ["-", "-", "-", "-"],
        ]
    };
    ret["qjlb"] = {title:"请假列表", dataList:qjlb};

    let qjyyfx = [
        {
            key:"病假",
            value:20
        },
        {
            key:"事假",
            value:10
        },
        {
            key:"其他",
            value:60
        },
    ];
    ret["qjyyfl"] = {title:"请假原因分析", dataList:qjyyfx};

    let bjxszztjqk = {
        2023:[
            {
                key:"感冒",
                value:81
            },
            {
                key:"发热",
                value:83
            },
            {
                key:"腹泻",
                value:71
            },
            {
                key:"呕吐",
                value:76
            },
            {
                key:"咳嗽",
                value:60
            },
            {
                key:"头疼",
                value:81
            },
            {
                key:"黄疸",
                value:80
            }
        ],
        2024:[
            {
                key:"感冒",
                value:71
            },
            {
                key:"发热",
                value:60
            },
            {
                key:"腹泻",
                value:77
            },
            {
                key:"呕吐",
                value:73
            },
            {
                key:"咳嗽",
                value:86
            },
            {
                key:"头疼",
                value:82
            },
            {
                key:"黄疸",
                value:81
            }
        ]
    };
    ret["bjxszztjqk"] = {title:"病假学生症状统计情况", dataList:bjxszztjqk};

    let lntsqdbqsfx = {
        2023:[
            {
                key:"感冒",
                value:81
            },
            {
                key:"发热",
                value:83
            },
            {
                key:"腹泻",
                value:71
            },
            {
                key:"呕吐",
                value:76
            },
            {
                key:"咳嗽",
                value:60
            },
            {
                key:"头疼",
                value:81
            },
            {
                key:"黄疸",
                value:80
            }
        ],
        2024:[
            {
                key:"感冒",
                value:71
            },
            {
                key:"发热",
                value:60
            },
            {
                key:"腹泻",
                value:77
            },
            {
                key:"呕吐",
                value:73
            },
            {
                key:"咳嗽",
                value:86
            },
            {
                key:"头疼",
                value:82
            },
            {
                key:"黄疸",
                value:81
            }
        ]
    };
    ret["lntsqdbqsfx"] = {title:"历年同时期对比趋势分析", dataList:lntsqdbqsfx};
    
    res.send(ret);
}


/**体质测试情况 */
export async function getTzcsqk(req, res) {
    let grade = req.body.grade || 1; //【一年级：1、二年级：2、三年级：3、四年级：4】
    let className = req.body.className || "一年级2班";
    let ret:any = {};

    let jcsj = [
        {
            key:"优良率",
            value:"0.0%"
        },
        {
            key:"合格率",
            value:"0.0%"
        },
    ];
    let jcsjData = await getReqApiData(sxjkWENUM.班级合格率优良率, {gradeId:grade, className});
	for (let key in jcsjData) {
		if (key == "classFine") {
			jcsj[0].value = jcsjData[key][className] + "%";
		}
		if (key == "classPass") {
			jcsj[1].value = jcsjData[key][className] + "%";
		}
	}
    ret["jcsj"] = {title:"基础数据", dataList:jcsj};

    let tzcsqk = [
        {
            key:"肺活量",
            yll:0,
            hgl:55
        },
        {
            key:"50米跑",
            yll:35,
            hgl:55
        },
        {
            key:"坐位体前屈",
            yll:50,
            hgl:50
        },
        {
            key:"立定跳远",
            yll:0,
            hgl:0
        },
        {
            key:"一分钟跳绳",
            yll:45,
            hgl:55
        },
        {
            key:"一分钟仰卧起坐",
            yll:55,
            hgl:45
        },
    ];
    ret["tzcsqk"] = {title:"体质测试情况", dataList:tzcsqk};

    let tytc = [
        {
            key:"篮球",
            value:0,
            data:[
                {
                    name:"王XX",
                    skill:"唢呐"
                },
                {
                    name:"王XX",
                    skill:"钢琴"
                }
            ]
        },
        {
            key:"羽毛球",
            value:0,
            data:[
                {
                    name:"王XX",
                    skill:"唢呐"
                },
                {
                    name:"王XX",
                    skill:"钢琴"
                }
            ]
        },
        {
            key:"长跑",
            value:0,
            data:[
                {
                    name:"王XX",
                    skill:"唢呐"
                },
                {
                    name:"王XX",
                    skill:"钢琴"
                }
            ]
        },
        {
            key:"乒乓球",
            value:0,
            data:[
                {
                    name:"王XX",
                    skill:"唢呐"
                },
                {
                    name:"王XX",
                    skill:"钢琴"
                }
            ]
        },
        {
            key:"足球",
            value:0,
            data:[
                {
                    name:"王XX",
                    skill:"唢呐"
                },
                {
                    name:"王XX",
                    skill:"钢琴"
                }
            ]
        }
    ];
    ret["tytc"] = {title:"体育特长", dataList:tytc};

    let ystc = [
        {
            key:"唱歌",
            value:0,
            data:[
                {
                    name:"王XX",
                    skill:"唢呐"
                },
                {
                    name:"王XX",
                    skill:"钢琴"
                }
            ]
        },
        {
            key:"跳舞",
            value:0,
            data:[
                {
                    name:"王XX",
                    skill:"唢呐"
                },
                {
                    name:"王XX",
                    skill:"钢琴"
                }
            ]
        },
        {
            key:"绘画",
            value:0,
            data:[
                {
                    name:"王XX",
                    skill:"唢呐"
                },
                {
                    name:"王XX",
                    skill:"钢琴"
                }
            ]
        },
        {
            key:"书法",
            value:0,
            data:[
                {
                    name:"王XX",
                    skill:"唢呐"
                },
                {
                    name:"王XX",
                    skill:"钢琴"
                }
            ]
        },
        {
            key:"戏剧",
            value:0,
            data:[
                {
                    name:"王XX",
                    skill:"唢呐"
                },
                {
                    name:"王XX",
                    skill:"钢琴"
                }
            ]
        }
    ];
    ret["ystc"] = {title:"艺术特长", dataList:ystc};


    res.send(ret);
}
















