/**
 * 年级组教师画像（对内）
 */

import { njzjshxNENUM } from "../../config/interficeEnum";
import { getReqApiData } from "../../data/interface/url";
import { getKeyValue, readFileList } from "../outData";
import { njzjshxTableData } from "../../data/table/duinei";
import { keyValuePackage, tablePackage } from "../../dataPackage/inFrontOut";
import { systemConfig } from "../../config/serverConfig";

const ImgUrl = "img/对内/年级组教师画像/";

const Grade = {
    1:"一年级组",
    2:"二年级组",
    3:"三年级组",
    4:"四年级组",
    5:"五年级组",
    6:"六年级组",
    7:"七年级组",
    8:"八年级组",
    9:"九年级组",
    10:"高中组",
}

export async function getData(req, res) {
    let grade = req.body.grade; 

    let ret:any = {};
    let excelData = njzjshxTableData(Grade[grade]);

    let jszyData = excelData["教师资源"].dataList;

    let jszy = [
        {
            key:"教师数",
            value:jszyData.length,
            unit:""
        },
        {
            key:"教师资源达标率",
            value:"-",
            unit:""
        }
    ];
    ret["jszy"] = {title:"教师资源", dataList:jszy};

    //性别
    let nanshenNum = 0;
    let nvshenNum = 0;
    //学历
    let xlData = {};
    //年龄
    let nlData = {"0~35岁":0, "36~40岁":0, "41~45岁":0, "46~50岁":0, "51~55岁":0, "55岁以上":0};
    //政治面貌
    let zzmmData = {"共青团员":0, "中共团员":0, "群众":0, "民主党派":0};
    //职称分布
    let zcfbData = {"高级教师":0, "中教一级":0, "中教二级":0, "未评级":0};
    //教龄分布
    let jlData = {"10年以上教龄":0, "6-10年教龄":0, "3-5年教龄":0, "3年以下教龄":0}
    //学科教师人数
    let xkjcsjData = {"语文":0, "数学":0, "英语":0, "综理":0, "综文":0, "体育":0, "艺术":0};

    jszyData.forEach( info => {
        let {njzcy, nl, xb, xl, zc, zzmm, jl, jyz} = info;
        if(xb == "女") nvshenNum += 1;
        else nanshenNum += 1;
        if(xl) {
            if (!xlData[xl]) xlData[xl] = 1;
            else xlData[xl] += 1;
        }
        
        if(nl>=0 || nl<35) nlData["0~35岁"] += 1;
        else if(nl>=36 || nl<40) nlData["36~40岁"] += 1;
        else if(nl>=41 || nl<45) nlData["41~45岁"] += 1;
        else if(nl>=46 || nl<50) nlData["46~50岁"] += 1;
        else if(nl>=51 || nl<55) nlData["51~55岁"] += 1;
        else if(nl>=55) nlData["55岁以上"] += 1;

        for(let key in zzmmData) {
            if (key == zzmm) zzmmData[key] += 1;
        }

        for(let key in zcfbData) {
            if (key == zc) zcfbData[key] += 1;
        }

        if(jl>=10) jlData["10年以上教龄"] += 1;
        else if(jl>=6 || jl<10) jlData["6-10年教龄"] += 1;
        else if(jl>=3 || jl<5) jlData["3-5年教龄"] += 1;
        else if(jl<3) jlData["3年以下教龄"] += 1;

        for(let key in xkjcsjData) {
            if (key == jyz) xkjcsjData[key] += 1;
        }
    })

    let nanshen = {
        key:"男生人数",
        value:nanshenNum,
        rate:""
    };
    let nvshen = {
        key:"女生人数",
        value:nvshenNum,
        rate:""
    };

    if(nanshen.value) nanshen.rate = Math.round(nanshen.value/jszyData.length*100 ) + "%";
    if(nvshen.value) nvshen.rate = Math.round(nvshen.value/jszyData.length*100 ) + "%";
    let nannvshen = [nanshen, nvshen];
    ret["jszyfb"] = {title:"男生人数女生人数", dataList:nannvshen};

    // let xlfbData = await getReqApiData(njzjshxNENUM.学历分布, {type:"education"});
    let xlfbData = [];
    for (let key in xlData) {
        xlfbData.push({type:key, count:xlData[key]});
    }
    let xlfbConf = {"大学专科毕业":"大专", "大学本科毕业":"本科", "硕士研究生毕业":"硕士", "博士研究生毕业":"博士"};
    let xlfbList = {};
    if (xlfbData) {
        xlfbData.forEach( info => {
            let count = parseInt(info.count) || 0;
            let type = info.type || "";
            for(let key in xlfbConf) {
                switch (type) {
                    case key:
                        xlfbList[xlfbConf[key]] = count;
                    break;
                    default:
                        if (!xlfbList["其他"]) xlfbList["其他"] = count;
                        else xlfbList["其他"] += count;
                    break;
                }
            }
        });
    }
    
    let xlfb = [];
    for (let key in xlfbList) {
        xlfb.push({key, value:xlfbList[key]});
    };

    ret["xlfb"] = {title:"学历分布", dataList:xlfb};

    // let jlfbData = await getReqApiData(njzjshxNENUM.教龄分布, {type:"teachAge"});
    // let jlfb = [];
    // if(jlfbData) {
    //     jlfbData.forEach( info => {
    //         let type = info.type || "";
    //         if(!type) type = "其他";
    //         jlfb.push({key:type, value:info.count});
    //     });
    // };
    let jlfb = [];
    for (let key in jlData) {
        jlfb.push({key, value:jlData[key]});
    };
    ret["jlfb"] = {title:"教龄分布", dataList:jlfb};
    
    let nlfbData = [];
    for(let key in nlData) {
        nlfbData.push({type:key, count:nlData[key]});
    }
    let nlfb = getKeyValue(nlfbData);
    ret["nlfb"] = {title:"年龄分布", dataList:nlfb};

    let zzmmList = [];
    for(let key in zzmmData) {
        zzmmList.push({key, value:zzmmData[key]});
    }
    ret["zzmm"] = {title:"政治面貌", dataList:zzmmList};

    // let zcfbData = await getReqApiData(njzjshxNENUM.职称分布, {type:title});
    let zcfb = [];
    for(let key in zcfbData) {
        zcfb.push({key, value:zcfbData[key]});
    }
    ret["zcfb"] = {title:"职称分布", dataList:zcfb};

    let njznds = [
        {
            key:"导师数量",
            value:0
        }
    ];
    ret["dssl"] = {title:"年级组内导师", dataList:njznds};

    let yxbzrds = {
        titleList:excelData['优秀班主任导师'].headerList[0], 
        dataList:excelData['优秀班主任导师'].bodyList
    };
    ret["yxbzrds"] = {title:"优秀班主任导师", dataList:yxbzrds};

    let xkdszb = excelData["学科导师占比"].dataList;
    ret["xkdszb"] = {title:"学科导师占比", dataList:xkdszb};

    // let xkjcsj = excelData["学科导师占比"].dataList;
    let xkjcsj = [];
    for(let key in xkjcsjData) {
        xkjcsj.push({key, value:xkjcsjData[key]});
    }
    ret["xkjcsj"] = {title:"学科基础数据", dataList:xkjcsj};

    let njjsImg = readFileList(`${ImgUrl}${grade}/`, [], "png");
    ret["njjsImg"] = {title:"年级组教师画像", dataList:njjsImg};

    let jxtjData = await getReqApiData(njzjshxNENUM.获奖统计, {type:1}, null, "data", "jsfz");
    // let jxtjCount = {gjj:0, sj:0, qj:0, xj:0};
    let jxtjDataList = {gjj:[], sj:[], qj:[], xj:[]};
    if (jxtjData) {
        jxtjData.list.data.forEach( info => {
            //todo 对应标准发给我之后修改
            if (info.level == "国家级及以上") jxtjDataList.gjj.push(info);
            if (info.level == "省/市级") jxtjDataList.sj.push(info);
            if (info.level == "区/县级") jxtjDataList.qj.push(info);
            if (info.level == "校级") jxtjDataList.xj.push(info);
        })

    }
    
    let jxtj = [
        {
            key:"国家级奖项",
            value:jxtjDataList.gjj.length || 0
        },
        {
            key:"市级奖项",
            value:jxtjDataList.sj.length || 0
        },
        {
            key:"区级奖项",
            value:jxtjDataList.qj.length || 0
        },
        {
            key:"校级奖项",
            value:jxtjDataList.xj.length || 0
        },
    ]
    ret["jshj"] = {title:"获奖统计", dataList:jxtj};

    let jsgzlfx = {
        满工作量的人数:excelData['满工作量的人数'].dataList,
        不满工作量的人数:excelData['不满工作量的人数'].dataList,
        超工作量的人数:excelData['超工作量的人数'].dataList,
    };
    ret["jsgzlfx"] = {title:"教师工作量分析", dataList:jsgzlfx};
    
    let tkqkData = {};
    excelData["听评课情况"].dataList.forEach(info => {
        tkqkData[info.key] = info.value;
    })
    
    let tkqk = [
        {
            key:"推门听课情况",
            value:tkqkData["推门听课情况"]
        },
        {
            key:"任务听评课情况",
            xn:tkqkData["校内"],
            xw:tkqkData["校外"]
        }
    ];
    ret["tkqk"] = {title:"听课情况", dataList:tkqk};

    let cqkh = {
        ri:{
            rate: excelData["整体出勤率-日"].dataList[0].value,
            dataList: excelData["出勤考核-日"].dataList,
            meeting: excelData["会议出勤情况-日"].dataList
        },
        zhou:{
            rate: excelData["整体出勤率-周"].dataList[0].value,
            dataList: excelData["出勤考核-周"].dataList,
            meeting:excelData["会议出勤情况-周"].dataList
        },
        yue:{
            rate: excelData["整体出勤率-月"].dataList[0].value,
            dataList: excelData["出勤考核-月"].dataList,
            meeting: excelData["会议出勤情况-月"].dataList
        },
    };
    ret["cqkh"] = {title:"出勤考核", dataList:cqkh};

    let qjqk = {
        ri:{
            baseData: excelData["请假情况-日"].dataList,
            chartData: excelData["请假原因占比分析-日"].dataList
        },
        zhou:{
            baseData: excelData["请假情况-周"].dataList,
            chartData: excelData["请假原因占比分析-周"].dataList
        },
        yue:{
            baseData: excelData["请假情况-月"].dataList,
            chartData: excelData["请假原因占比分析-月"].dataList
        },
    };
    ret["qjqk"] = {title:"请假情况", dataList:qjqk};

    let jyhdjcsj = excelData["教研活动"].dataList;
    ret["jyhdjcsj"] = {title:"教研活动", dataList:jyhdjcsj};

    let jyhd =  excelData["教研活动详细"].dataList;
    ret["jyhd"] = {title:"教研活动详细", dataList:jyhd};

    let ktcycs = excelData['课题参与次数'].dataList;
    ret["ktcycs"] = {title:"课题参与次数", dataList:ktcycs};

    let ktcy = {
        titleList:excelData['课题参与'].headerList[0], 
        dataList:excelData['课题参与'].bodyList
    };
    ret["ktcy"] = {title:"课题参与", dataList:ktcy};

    let gkkcycs = excelData['公开课参与次数'].dataList;
    ret["gkkcycs"] = {title:"公开课参与次数", dataList:gkkcycs};

    let gkkcy = {
        titleList:excelData['公开课参与'].headerList[0], 
        dataList:excelData['公开课参与'].bodyList
    };
    ret["gkkcy"] = {title:"公开课参与", dataList:gkkcy};

    let jsjxpxqk = excelData['教师进修培训情况'].dataList;
    ret["jsjxpxqk"] = {title:"教师进修培训情况", dataList:jsjxpxqk};

    let glscycs = {
        大学听课: excelData['大学听课'].dataList,
        名师工作室: excelData['名师工作室'].dataList,
        基地学习: excelData['基地学习'].dataList,
        校本研修: excelData['校本研修'].dataList
    };
    ret["glscycs"] = {title:"各老师参与次数", dataList:glscycs};

    let jxsl = excelData['奖项数量'].dataList;
    ret["jxsl"] = {title:"奖项数量", dataList:jxsl};

    let jxbscyqk = excelData['教学比赛参与情况'].dataList;
    ret["jxbscyqk"] = {title:"教学比赛参与情况", dataList:jxbscyqk};

    let bsxxlb = excelData['教学比赛参与情况详细'].bodyList;
    ret["bsxxlb"] = {title:"教学比赛参与情况详情", dataList:bsxxlb};

    let jxmydfk = {
        一至四: excelData['教学满意度反馈一至四'].dataList,
        五至九: excelData['教学满意度反馈五至九'].dataList,
        高中: excelData['教学满意度反馈高中'].dataList,
    };
    ret["jxmydfk"] = {title:"教学满意度反馈", dataList:jxmydfk};

    let hdcyqk = excelData['工作坊活动参与情况'].dataList;
    ret["hdcyqk"] = {title:"工作坊活动参与情况", dataList:hdcyqk};

    res.send(ret);
}

 
 
 
 
 
 