/**
 * 教研组教师画像（对内）
 */

import { jyzjshxNENUM } from "../../config/interficeEnum";
import { getReqApiData } from "../../data/interface/url";
import { getKeyValue, readFileList } from "../outData";
import { jyzjshxTableData } from "../../data/table/duiwai";
import { keyValuePackage, tablePackage } from "../../dataPackage/inFrontOut";
import { systemConfig } from "../../config/serverConfig";

const ImgUrl = "img/对内/教研组教师画像/";

export async function getData(req, res) {
    let subject = req.body.subject || "语文组";
    let ret:any = {};
    let excelData = jyzjshxTableData(subject);

    let jszyTableData = excelData["教师资源"].dataList;

    // let jszyData = await getReqApiData(jyzjshxNENUM.教师资源, {}); //todo
    let jszy = [
        {
            key:"教师数",
            value:jszyTableData.length,
            unit:""
        },
        {
            key:"教师资源达标率",
            value:"-",
            unit:""
        }
    ];
    ret["jszy"] = {title:"教师资源", dataList:jszy};

    //性别
    let nanshenNum = 0;
    let nvshenNum = 0;
    //学历
    let xlData = {};
    //年龄
    let nlData = {"0~35岁":0, "36~40岁":0, "41~45岁":0, "46~50岁":0, "51~55岁":0, "55岁以上":0};
    //政治面貌
    let zzmmData = {"共青团员":0, "中共团员":0, "群众":0, "民主党派":0};
    //职称分布
    let zcfbData = {"高级教师":0, "中教一级":0, "中教二级":0, "未评级":0};
    //教龄分布
    let jlData = {"10年以上教龄":0, "6-10年教龄":0, "3-5年教龄":0, "3年以下教龄":0}

    jszyTableData.forEach( info => {
        let {xb, zzmm, nl, zc, xl, jl} = info;
        if(xb == "女") nvshenNum += 1;
        else nanshenNum += 1;
        if(xl) {
            if (!xlData[xl]) xlData[xl] = 1;
            else xlData[xl] += 1;
        }
        
        if(nl>=0 || nl<35) nlData["0~35岁"] += 1;
        else if(nl>=36 || nl<40) nlData["36~40岁"] += 1;
        else if(nl>=41 || nl<45) nlData["41~45岁"] += 1;
        else if(nl>=46 || nl<50) nlData["46~50岁"] += 1;
        else if(nl>=51 || nl<55) nlData["51~55岁"] += 1;
        else if(nl>=55) nlData["55岁以上"] += 1;

        for(let key in zzmmData) {
            if (key == zzmm) zzmmData[key] += 1;
        }

        for(let key in zcfbData) {
            if (key == zc) zcfbData[key] += 1;
        }

        if(jl>=10) jlData["10年以上教龄"] += 1;
        else if(jl>=6 || jl<10) jlData["6-10年教龄"] += 1;
        else if(jl>=3 || jl<5) jlData["3-5年教龄"] += 1;
        else if(jl<3) jlData["3年以下教龄"] += 1;
    })


    let nanshen = {
        key:"男生人数",
        value:nanshenNum,
        rate:""
    };
    let nvshen = {
        key:"女生人数",
        value:nvshenNum,
        rate:""
    };

    nanshen.rate = Math.round(nanshen.value/jszyTableData.length*100 ) + "%";
    nvshen.rate = Math.round(nvshen.value/jszyTableData.length*100 ) + "%";
    let nannvshen = [nanshen, nvshen];
    ret["jszyfb"] = {title:"男生人数女生人数", dataList:nannvshen};

    let xlfbData = [];
    for (let key in xlData) {
        xlfbData.push({type:key, count:xlData[key]});
    }
    let xlfbConf = {"大学专科":"大专", "大学本科":"本科", "硕士":"硕士", "硕士研究生":"研究生"};
    let xlfbList = {};
    xlfbData.forEach( info => {
        let count = parseInt(info.count) || 0;
        let type = info.type || "";
        for(let key in xlfbConf) {
            switch (type) {
                case key:
                    xlfbList[xlfbConf[key]] = count;
                break;
                default:
                    if (!xlfbList["其他"]) xlfbList["其他"] = count;
                    else xlfbList["其他"] += count;
                break;
            }
        }
    });

    let xlfb = [];
    for (let key in xlfbList) {
        xlfb.push({key, value:xlfbList[key]});
    };

    ret["xlfb"] = {title:"学历分布", dataList:xlfb};

    // let jlfbData = await getReqApiData(jyzjshxNENUM.教龄分布, {type:"teachAge"});
    // let jlfb = [];
    // if(jlfbData) {
    //     jlfbData.forEach( info => {
    //         let type = info.type || "";
    //         if(!type) type = "其他";
    //         jlfb.push({key:type, value:info.count});
    //     });
    // }
    
    let jlfb = [];
    for (let key in jlData) {
        jlfb.push({key, value:jlData[key]});
    };
    ret["jlfb"] = {title:"教龄分布", dataList:jlfb};
    ret["jlfb"] = {title:"教龄分布", dataList:jlfb};

    let nlfbData = [];
    for(let key in nlData) {
        nlfbData.push({type:key, count:nlData[key]});
    }
    let nlfb = getKeyValue(nlfbData);
    ret["nlfb"] = {title:"年龄分布", dataList:nlfb};

    // let zzmmData = await getReqApiData(jyzjshxNENUM.教师政治面貌, {type:"political"});
    let zzmmList = [];
    for(let key in zzmmData) {
        zzmmList.push({key, value:zzmmData[key]});
    }
    // let zzmm = getKeyValue(zzmmList);
    ret["zzmm"] = {title:"政治面貌", dataList:zzmmList};

    // let zcfbData = await getReqApiData(jyzjshxNENUM.职称分布, {type:title});
    let zcfb = [];
    for(let key in zcfbData) {
        zcfb.push({key, value:zcfbData[key]});
    }
    if (!zcfb.length) {
        zcfb = [
            {key:"高级", value:3},
            {key:"一级", value:7},
            {key:"二级", value:22},
            {key:"未评级", value:5},
        ]
    }
    ret["zcfb"] = {title:"职称分布", dataList:zcfb};


    // let nanshenData = await getReqApiData(jyzjshxNENUM.教师男女比例, {sex:1});
    // let nvshenData = await getReqApiData(jyzjshxNENUM.教师男女比例, {sex:0});
    // let jsrs = nanshenData.length+nvshenData.length;

    // let nanshen = {
    //     key:"男生人数",
    //     value:nanshenData.length,
    //     rate:""
    // };
    // let nvshen = {
    //     key:"女生人数",
    //     value:nvshenData.length,
    //     rate:""
    // };

    // nanshen.rate = Math.round(nanshen.value/jszyTableData.length*100 ) + "%";
    // nvshen.rate = Math.round(nvshen.value/jszyTableData.length*100 ) + "%";
    // let nannvshen = [nanshen, nvshen];
    // ret["jszyfb"] = {title:"男生人数女生人数", dataList:nannvshen};

    // let xlfbData = await getReqApiData(jyzjshxNENUM.学历分布, {type:"education"});
    // let xlfbConf = {"大学专科毕业":"大专", "大学本科毕业":"本科", "硕士研究生毕业":"硕士", "博士研究生毕业":"博士"};
    // let xlfbList = {};
    // xlfbData.forEach( info => {
    //     let count = parseInt(info.count) || 0;
    //     let type = info.type || "";
    //     for(let key in xlfbConf) {
    //         switch (type) {
    //             case key:
    //                 xlfbList[xlfbConf[key]] = count;
    //             break;
    //             default:
    //                 if (!xlfbList["其他"]) xlfbList["其他"] = count;
    //                 else xlfbList["其他"] += count;
    //             break;
    //         }
    //     }
    // });

    // let xlfb = [];
    // for (let key in xlfbList) {
    //     xlfb.push({key, value:xlfbList[key]});
    // };

    // ret["xlfb"] = {title:"学历分布", dataList:xlfb};

    // let jlfbData = await getReqApiData(jyzjshxNENUM.教龄分布, {type:"teachAge"});
    // let jlfb = [];
    // jlfbData.forEach( info => {
    //     let type = info.type || "";
    //     if(!type) type = "其他";
    //     jlfb.push({key:type, value:info.count});
    // });
    // ret["jlfb"] = {title:"教龄分布", dataList:jlfb};

    // let nlfbData = await getReqApiData(jyzjshxNENUM.年龄分布, {type:"age"});
    // let nlfb = getKeyValue(nlfbData);
    // ret["nlfb"] = {title:"年龄分布", dataList:nlfb};

    // let zzmmData = await getReqApiData(jyzjshxNENUM.教师政治面貌, {type:"political"});
    // let zzmm = getKeyValue(zzmmData);
    // ret["zzmm"] = {title:"政治面貌", dataList:zzmm};

    // let zcfbData = await getReqApiData(jyzjshxNENUM.职称分布, {type:title});
    // let zcfb = [];
    // zcfbData.forEach( info => {
    //     let {name, value} = info;
    //     zcfb.push({key:name, value});
    // })
    // if (!zcfb.length) {
    //     zcfb = [
    //         {key:"高级", value:3},
    //         {key:"一级", value:7},
    //         {key:"二级", value:22},
    //         {key:"未评级", value:5},
    //     ]
    // }
    // ret["zcfb"] = {title:"职称分布", dataList:zcfb};

    let ryhds = excelData["荣誉获得数"].dataList;
    ret["ryhds"] = {title:"荣誉获得数", dataList:ryhds};

    let zyry = {
        titleList:excelData['专业荣誉详细'].headerList[0], 
        dataList:excelData['专业荣誉详细'].bodyList
    };
    ret["zyry"] = {title:"专业荣誉", dataList:zyry};

    let jyztp = readFileList(`${ImgUrl}照片墙/${subject}/`, [], "png");
    ret["jyztp"] = {title:"教研组教师画像", dataList:jyztp};
    
    let jshjData = await getReqApiData(jyzjshxNENUM.获奖统计, {pageNo:1, pageSize:100});
    let jshjCount = {gjj:0, sj:0, qj:0, xj:0};
    if (jshjData) {
        switch (jshjData.awardLevel) {
            case "国家级":
                jshjCount.gjj++;
            break;
            case "市级":
                jshjCount.sj++;
            break;
            case "区级":
                jshjCount.qj++;
            break;
            case "校级":
                jshjCount.xj++;
            break;
        }
    }
    let jshj = [
        {
            key:"国家级奖项",
            value:jshjCount.gjj || 6
        },
        {
            key:"市级奖项",
            value:jshjCount.sj || 35
        },
        {
            key:"区级奖项",
            value:jshjCount.qj || 114
        },
        {
            key:"校级奖项",
            value:jshjCount.xj || 0
        },
    ]
    ret["jshj"] = {title:"获奖统计", dataList:jshj};

    let jsgzlfx = {
        "满工作量的人数": excelData["满工作量的人数"].dataList,
        "不满工作量的人数": excelData["不满工作量的人数"].dataList,
        "超工作量的人数": excelData["超工作量的人数"].dataList
    };
    ret["jsgzlfx"] = {title:"教师工作量分析", dataList:jsgzlfx};

    let tkqkData = {};
    excelData["听评课情况"].dataList.forEach(info => {
        tkqkData[info.key] = info.value;
    })
    
    let tkqk = [
        {
            key:"推门听课情况",
            value:tkqkData["推门听课情况"]
        },
        {
            key:"任务听评课情况",
            xn:tkqkData["校内"],
            xw:tkqkData["校外"]
        }
    ];
    ret["tkqk"] = {title:"听课情况", dataList:tkqk};

    let cqkh = {
        ri:{
            rate:"100%",
            dataList:[
                {
                    key:"01",
                    value:"0"
                },
                {
                    key:"02",
                    value:"0"
                },
                {
                    key:"03",
                    value:"0"
                },
                {
                    key:"04",
                    value:"0"
                },
                {
                    key:"05",
                    value:"0"
                },
                {
                    key:"06",
                    value:"0"
                },
                {
                    key:"07",
                    value:"0"
                },
            ],
            meeting:[
                {
                    key:"升旗仪式",
                    value:0
                },
                {
                    key:"教工大会",
                    value:0
                }
            ]
        },
        zhou:{
            rate:"100%",
            dataList:[
                {
                    key:"01",
                    value:"0"
                },
                {
                    key:"02",
                    value:"0"
                },
                {
                    key:"03",
                    value:"0"
                },
                {
                    key:"04",
                    value:"0"
                },
                {
                    key:"05",
                    value:"0"
                },
                {
                    key:"06",
                    value:"0"
                },
                {
                    key:"07",
                    value:"0"
                },
            ],
            meeting:[
                {
                    key:"升旗仪式",
                    value:0
                },
                {
                    key:"教工大会",
                    value:0
                }
            ]
        },
        yue:{
            rate:"100%",
            dataList:[
                {
                    key:"01",
                    value:"0"
                },
                {
                    key:"02",
                    value:"0"
                },
                {
                    key:"03",
                    value:"0"
                },
                {
                    key:"04",
                    value:"0"
                },
                {
                    key:"05",
                    value:"0"
                },
                {
                    key:"06",
                    value:"0"
                },
                {
                    key:"07",
                    value:"0"
                },
            ],
            meeting:[
                {
                    key:"升旗仪式",
                    value:0
                },
                {
                    key:"教工大会",
                    value:0
                }
            ]
        },
    };
    ret["cqkh"] = {title:"出勤考核", dataList:cqkh};

    let qjqk = {
        ri:{
            baseData:[
                {
                    key:"请假",
                    value:0
                },
                {
                    key:"调休",
                    value:0
                },
            ],
            chartData:[
                {
                    key:"事假",
                    value:0
                },
                {
                    key:"病假",
                    value:0
                },
                {
                    key:"婚假",
                    value:0
                },
                {
                    key:"其他",
                    value:0
                },
            ]
        },
        zhou:{
            baseData:[
                {
                    key:"请假",
                    value:0
                },
                {
                    key:"调休",
                    value:0
                },
            ],
            chartData:[
                {
                    key:"事假",
                    value:0
                },
                {
                    key:"病假",
                    value:0
                },
                {
                    key:"婚假",
                    value:0
                },
                {
                    key:"其他",
                    value:0
                },
            ]
        },
        yue:{
            baseData:[
                {
                    key:"请假",
                    value:0
                },
                {
                    key:"调休",
                    value:0
                },
            ],
            chartData:[
                {
                    key:"事假",
                    value:0
                },
                {
                    key:"病假",
                    value:0
                },
                {
                    key:"婚假",
                    value:0
                },
                {
                    key:"其他",
                    value:0
                },
            ]
        },
    };
    ret["qjqk"] = {title:"请假情况", dataList:qjqk};
    
    let jyhdjcsj = excelData["教研活动"].dataList;
    ret["jyhdjcsj"] = {title:"教研活动", dataList:jyhdjcsj};

    let jyhd = excelData["教研活动详细"].dataList;
    ret["jyhd"] = {title:"教研活动详细", dataList:jyhd};

    let kybxq = excelData["科研"].dataList;
    ret["kybxq"] = {title:"科研（本学期）", dataList:kybxq};

    let kybxqxx = {
        titleList:excelData['科研详细'].headerList[0], 
        dataList:excelData['科研详细'].bodyList
    };
    ret["kybxqxx"] = {title:"科研（本学期）表格", dataList:kybxqxx};

    let jybxq = excelData["教研"].dataList;
    ret["jybxq"] = {title:"教研（本学期）", dataList:jybxq};

    let jybxqxx = {
        titleList:excelData['教研详细'].headerList[0], 
        dataList:excelData['教研详细'].bodyList
    };
    ret["jybxqxx"] = {title:"教研（本学期）表格", dataList:jybxqxx};

    let cycjtskc = excelData["参与创建特色课程"].dataList;
    ret["cycjtskc"] = {title:"参与&创建特色课程", dataList:cycjtskc};

    let cycjtskcxx = {
        titleList:excelData['参与创建特色课程详细'].headerList[0], 
        dataList:excelData['参与创建特色课程详细'].bodyList
    };
    ret["cycjtskcxx"] = {title:"参与&创建特色课程表格", dataList:cycjtskcxx};

    let jsyxxfhq = excelData["学分"].dataList;
    ret["jsyxxfhq"] = {title:"教师研修学分获取", dataList:jsyxxfhq};

    let kcxf = excelData["教师研修学分获取"].dataList;
    ret["kcxf"] = {title:"课程学分", dataList:kcxf};

    let jxmydfk = excelData["教学满意度反馈"].dataList;
    ret["jxmydfk"] = {title:"教学满意度反馈", dataList:jxmydfk};

    let jyzjf = excelData["教研组均分"].dataList;
    ret["jyzjf"] = {title:"教研组均分", dataList:jyzjf};

    let gzfhdcyqk = excelData["工作坊活动参与情况"].dataList;
    ret["gzfhdcyqk"] = {title:"工作坊活动参与情况", dataList:gzfhdcyqk};

    res.send(ret);
}


