/**教师信息筛选 */

import { jssxNENUM } from "../../config/interficeEnum";
import { getReqApiData } from "../../data/interface/url";


/**
 * 各年级学科
 */
export async function getGrade(req, res) {
    let grade = req.body.grade; //【一年级：1、二年级：2、三年级：3、四年级：4】
    let ret:any = {};

    let gradeData = await getReqApiData(jssxNENUM.各年级学科, {grade});

    let gradeDefault = {
        "1_98a773c4baa111edb10f020315edea6c": "唱游",
        "1_469be358bbdc11ed9c69020315e0492c": "班会",
        "10_jcsub21": "信息技术",
        "10_jcsub22": "通用技术",
        "1_9379fb60ed4b11eda5e902031571829e": "自习-数",
        "10_2ec954f1fabe49389cf3cacf824b5fdd": "心理健康",
        "10_jcsub03": "英语",
        "10_jcsub01": "语文",
        "10_jcsub02": "数学",
        "10_469be358bbdc11ed9c69020315e0492c": "班会",
        "1_d95c9ea8baa111eda74c020315fa13ab": "乐高",
        "10_jcsub09": "思想政治",
        "1_SUB53": "道德与法治",
        "10_9379fb60ed4b11eda5e902031571829e": "自习-数",
        "1_ce192f1eb67a11eda071020315f9fa0d": "语拓",
        "1_ad9b8ac50b3e45e5b0173fba5bbe7031": "自然",
        "10_SUB27": "体育",
        "1_jcsub01": "语文",
        "1_jcsub02": "数学",
        "1_jcsub03": "英语",
        "1_d37117bcbaa111eda56f020315fa13ab": "英拓",
        "1_bd8c4276b67a11ed868b020315d30c23": "数拓",
        "10_jcsub11": "历史",
        "10_fd77ad2243fa11ee928a02031503ed64": "心理",
        "10_jcsub14": "化学",
        "1_dcff692c43d211eeb56102031503ed64": "口语",
        "10_jcsub15": "生物",
        "10_jcsub12": "地理",
        "10_jcsub13": "物理",
        "1_8c795ffeed4b11edb8da020315720cb2": "自习-语",
        "1_85c89e72ed4b11ed8e1102031525f525": "自习-英",
        "1_d490956843d211ee81d502031503ed64": "橄榄球",
        "10_jcsub17": "艺术",
        "1_SUB27": "体育",
        "1_jcsub18": "美术",
        "10_8c795ffeed4b11edb8da020315720cb2": "自习-语",
        "1_f1e78c9843d211eebb81020315c9287e": "棒球",
        "10_9b5fafca43e811ee9e40020315c9287e": "自习-物",
        "10_85c89e72ed4b11ed8e1102031525f525": "自习-英"
    };

    let gradeScreen = {};
    if (gradeData) gradeScreen = gradeData;
    else gradeScreen = gradeDefault;
    ret["gradeScreen"] = {title:"各年级学科", dataList:gradeScreen};
    
    res.send(ret);
}



/**教师筛选个人 */
export async function getGradeSubjectTea(req, res) {
    let grade = req.body.grade; //【一年级：1、二年级：2、三年级：3、四年级：4】
    let className = req.body.className; //【学科名称：通过各年级学科接口获取对应参数值】
    let name = req.body.name;
    let sex = req.body.sex; //【性别：0：女、1：男】
    let ret:any = {};

    let body = {};
    if(grade) body["gradeId"] = grade;
    if(className) body["subjectName"] = className;
    if(name) body["teacherNames"] = name;
    if(sex) body["sex"] = sex;

    let subjectTeaData = await getReqApiData(jssxNENUM.各年级学科老师, body); //todo
    
    let gradeConf = {"1":"一年级", "2":"二年级", "3":"三年级", "4":"四年级", "5":"五年级", "6":"六年级", "7":"初一", "8":"初二", "9":"初三", "10":"高一", "11":"高二", "12":"高三"}
    let subjectTea = [];
    if (subjectTeaData) {
        subjectTeaData.forEach( info => {
            let subInfo = {
                teacherUserId: info.teacherUserId,
                grade: gradeConf[grade],
                subjectNames: info.subjectNames,
                genderName: info.genderName,
                teacherName: info.teacherName,
            };

            subjectTea.push(subInfo);
        })
        
    }

    ret["subjectTea"] = {title:"各年级学科老师", dataList:subjectTea};

    res.send(ret);
}








