
import * as asyncHandler from 'express-async-handler'
//建设指挥平台
import * as qqglBiz from '../biz/jszhpt/qqgl';
import * as xxjdBiz from '../biz/jszhpt/xxjd';    
import * as lcbjdwcqkBiz from '../biz/jszhpt/lcbjdwcqk';  
import * as zmxfxfbBiz from '../biz/jszhpt/zmxfxfb';  
import * as dqfxjdBiz from '../biz/jszhpt/dqfxjd';   
import * as gcaqztBiz from '../biz/jszhpt/gcaqzt';
import * as xlBiz from '../biz/jszhpt/xl';
import * as jszhptBiz from '../biz/jszhpt/jszhptdt';

import * as nfBiz from '../biz/jszhpt/nf';
//投资管控指标面板
import * as gszsBiz from '../biz/jszhpt/gszs';
import * as tkjsBiz from '../biz/jszhpt/tkjs';
import * as jstjBiz from '../biz/jszhpt/jstj';
//业财融合指标面板
import * as tzwcqkBiz from '../biz/jszhpt/tzwcqk';
import * as htjeyizlBiz from '../biz/jszhpt/htjeyjzl';

//整体建设概览
import * as jsyyBiz from '../biz/ztjsgl/jsyy';
import * as lcbsjBiz from '../biz/ztjsgl/lcbsj';   
import * as jjcyBiz from '../biz/ztjsgl/jjcy';
import * as lscxBiz from '../biz/ztjsgl/lscx'; 
import * as ylghBiz from '../biz/ztjsgl/ylgh';
import * as ztjsglBiz from '../biz/ztjsgl/map';

export function setRouter(httpServer){
    /**
     * 建设指挥平台
     */
    httpServer.get('/lcbjdwcqk', asyncHandler(lcbjdwcqkBiz.getData));//里程碑节点完成情况
    httpServer.get('/xl', asyncHandler(xlBiz.getData));//线路
    httpServer.get('/jszhpt', asyncHandler(jszhptBiz.getData));//地图
    httpServer.get('/qqgl', asyncHandler(qqglBiz.getData));//前期管理
    httpServer.get('/xxjd', asyncHandler(xxjdBiz.getData));//形象进度
    httpServer.get('/zmxfxfb', asyncHandler(zmxfxfbBiz.getData));//致命性风险分布
    httpServer.get('/dqfxjd', asyncHandler(dqfxjdBiz.getData));//当前风险节点
    httpServer.get('/gcaqzt', asyncHandler(gcaqztBiz.getData));//工程安全状态

    httpServer.get('/nf', asyncHandler(nfBiz.getData));//工程安全状态
    //投资管控指标面板
    httpServer.get('/gszs', asyncHandler(gszsBiz.getData)); //概算总数
    httpServer.get('/tkjs', asyncHandler(tkjsBiz.getData)); //投控建设
    httpServer.get('/jstj', asyncHandler(jstjBiz.getData)); //决算统计

    //业财融合指标面板
    httpServer.get('/tzwcqk', asyncHandler(tzwcqkBiz.getData)) //投资完成情况
    httpServer.get('/htjeyjzl', asyncHandler(htjeyizlBiz.getData)) //合同金额预警总览

    /**
     * 整体建设概览
     */
    httpServer.get('/jsyy', asyncHandler(jsyyBiz.getData));//建设运营
    httpServer.get('/lcbsj', asyncHandler(lcbsjBiz.getData));//里程碑事件&荣誉成果
    httpServer.get('/jjcy', asyncHandler(jjcyBiz.getData));//经济产业
    httpServer.get('/lscx', asyncHandler(lscxBiz.getData));//绿色出行
    httpServer.get('/ylgh', asyncHandler(ylghBiz.getData));//引领/规划
    httpServer.get('/map', asyncHandler(ztjsglBiz.getData));//地图

}