//excel 和 接口都可以使用的格式化数据的方法

/**
 * objBecomeOfList  对象变成数组  value不限制类型
 * @param obj 对象 {"key1":"value1", "key2":"value2"}
 * @param keyName 指定key的名称 默认 name
 * @param valueName 指定value的名称  默认 data
 * @returns [{name:"key1", "data":"value1"}, ...]
 */
export function objBecomeOfList(obj, keyName="name", valueName="data") {
    let result = [];
    for (let key in obj) {
        let once:any = {};
        once[keyName] = key;
        once[valueName] = obj[key];
        result.push(once);
    }
    return result;
}

/**
 * objChangeKey  obj改变key
 * @param obj {"key1":"value1", "key2":"value2"}
 * @param checkKeyInfo {"key1":"eKey1", "key2":"eKey2"}
 * @returns  
 */
export function objChangeKey(obj, checkKeyInfo) {
    let result = {};
    for (let key in obj) {
        let newKey = checkKeyInfo[key] || key;
        result[newKey] = obj[key];
    }
    return result;
}


/**
 * objListChangeKey  objList 改变key
 * @param objList 
 * @param checkKeyInfo 
 * @returns 
 */
export function objListChangeKey(objList, checkKeyInfo) {
    return 
}