
import { planarArrDecollateForIndex, planarArrDeconstruct, planarArrForObjectList } from "../../../dataPackage/planaryArrayAnalysis";
import { onceSheetBecomeOfblockData } from "../../../util/analysisExcel";

function packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList) {
    let result = {};

    for (let i = 0; i < blockDataList.length; i++) {
        let {blockData, blockTitle} = blockDataList[i];
        if (keyValueOrTitleList.indexOf(blockTitle) > -1) {
            let titleList = titltListConfig[blockTitle] || [];
            result[blockTitle] = planarArrForObjectList(blockData, 0, titleList);
        }
        else if (barChartList.indexOf(blockTitle) > -1) {
            result[blockTitle] = planarArrDeconstruct(blockData);
        }
        else if (stringList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrForObjectList(blockData);
        else if (decollatePlanarList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrDecollateForIndex(blockData);
    }

    return result;
}

export function jjcyTableData() {
    let blockDataList = onceSheetBecomeOfblockData('整体建设概览.xlsx', '经济产业');

    let keyValueOrTitleList = ["基础数据", "全国GDP", "上海GDP"];//适配 饼图 键值以及需要多个key的
    let barChartList = ["上海地铁投资建设占上海GDP变化趋势", "地铁开通前后区域价格变化趋势"]; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =[];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;

        
}