
import { planarArrDecollateForIndex, planarArrDeconstruct, planarArrForObjectList } from "../../../dataPackage/planaryArrayAnalysis";
import { onceSheetBecomeOfblockData } from "../../../util/analysisExcel";

function packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList) {
    let result = {};

    for (let i = 0; i < blockDataList.length; i++) {
        let {blockData, blockTitle} = blockDataList[i];
        if (keyValueOrTitleList.indexOf(blockTitle) > -1) {
            let titleList = titltListConfig[blockTitle] || [];
            result[blockTitle] = planarArrForObjectList(blockData, 0, titleList);
        }
        else if (barChartList.indexOf(blockTitle) > -1) {
            result[blockTitle] = planarArrDeconstruct(blockData);
        }
        else if (stringList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrForObjectList(blockData);
        else if (decollatePlanarList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrDecollateForIndex(blockData);
    }

    return result;
}

export function gszsTableData() {
    
    let blockDataList = onceSheetBecomeOfblockData('投资管控面板.xlsx', '概算总数');

    let keyValueOrTitleList = ["2021总线路", "2022总线路", "2023总线路", "2021各线路概算金额", "2022各线路概算金额", "2023各线路概算金额"];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =[];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;     
}

export function tkjsTableData() {
    
    let blockDataList = onceSheetBecomeOfblockData('投资管控面板.xlsx', '投控建设');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = ["2021投控建设", "2022投控建设"]; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =[];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}

export function jstjTableData() {
    
    let blockDataList = onceSheetBecomeOfblockData('投资管控面板.xlsx', '决算统计');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = ["2021合同数据", "2022合同数据", "2021合同决算统计", "2022合同决算统计", "2021业务系统数", "2022业务系统数"]; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =[];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
     
}

export function nfTableData() {
    
    let blockDataList = onceSheetBecomeOfblockData('投资管控面板.xlsx', '年份');

    let keyValueOrTitleList = ["下拉年份"];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =[];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
     
}