
import { planarArrDecollateForIndex, planarArrDeconstruct, planarArrForObjectList } from "../../../dataPackage/planaryArrayAnalysis";
import { onceSheetBecomeOfblockData } from "../../../util/analysisExcel";

function packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList) {
    let result = {};

    for (let i = 0; i < blockDataList.length; i++) {
        let {blockData, blockTitle} = blockDataList[i];
        if (keyValueOrTitleList.indexOf(blockTitle) > -1) {
            let titleList = titltListConfig[blockTitle] || [];
            result[blockTitle] = planarArrForObjectList(blockData, 0, titleList);
        }
        else if (barChartList.indexOf(blockTitle) > -1) {
            result[blockTitle] = planarArrDeconstruct(blockData);
        }
        else if (stringList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrForObjectList(blockData);
        else if (decollatePlanarList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrDecollateForIndex(blockData);
    }

    return result;
}

export function zmxfxfbTableData() {
    
    let blockDataList = onceSheetBecomeOfblockData('建设指挥平台.xlsx', '致命性风险分布');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["致命性风险分布"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;   
}

export function dqfxjdTableData() {
    
    let blockDataList = onceSheetBecomeOfblockData('建设指挥平台.xlsx', '当前风险节点');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["当前风险指数","风险节点数据"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result; 
}

export function gcaqztTableData() {
    
    let blockDataList = onceSheetBecomeOfblockData('建设指挥平台.xlsx', '工程安全状态');

    let keyValueOrTitleList = [];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["风险期数量", "工程安全状态详细数据"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;  
}

export function jszhptdtTableData() {
    let blockDataList = onceSheetBecomeOfblockData('建设指挥平台.xlsx', '地图');

    let keyValueOrTitleList = ["基础数据"];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["线路列表", "线路坐标"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
   
}

export function xlTableData() {
    let blockDataList = onceSheetBecomeOfblockData('建设指挥平台.xlsx', '线路');

    let keyValueOrTitleList = ["选择线路"];//适配 饼图 键值以及需要多个key的
    let barChartList = []; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =[];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;

}